/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml;

import com.imsweb.naaccrxml.NaaccrErrorUtils;
import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrObserver;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrValidationError;
import com.imsweb.naaccrxml.NaaccrXmlUtils;
import com.imsweb.naaccrxml.entity.Patient;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class BatchProcessor {
    private static final String _OPTION_INPUT_FOLDER = "input.folder";
    private static final String _OPTION_INPUT_REGEX_INCLUDE = "input.regex-include";
    private static final String _OPTION_INPUT_REGEX_EXCLUDE = "input.regex-exclude";
    private static final String _OPTION_PROCESSING_MODE = "processing.mode";
    private static final String _OPTION_PROCESSING_ERROR_CODES = "processing.error-codes";
    private static final String _OPTION_PROCESSING_NUM_THREADS = "processing.num-threads";
    private static final String _OPTION_PROCESSING_COMPRESSION = "processing.compression";
    private static final String _OPTION_OUTPUT_FOLDER = "output.folder";
    private static final String _OPTION_OUTPUT_CLEAN_CREATED_FILES = "output.clean-created-files";
    private static final String _OPTION_OUTPUT_CREATE_REPORT = "output.create-report";
    private static final String _OPTION_OUTPUT_REPORT_NAME = "output.report-name";
    private static final String _OPTION_OUTPUT_DEIDENTIFY_FILES = "output.de-identify-files";

    public static void main(String[] args) throws IOException, InterruptedException {
        Properties opt = BatchProcessor.readOptions(args);
        if (opt == null) {
            throw new IllegalStateException("Unable to find options file path, it must be provided as an argument to the call.");
        }
        if (opt.getProperty(_OPTION_INPUT_FOLDER) == null || opt.getProperty(_OPTION_INPUT_FOLDER).isEmpty()) {
            throw new IllegalStateException("Option input.folder is required.");
        }
        File inputDir = new File(opt.getProperty(_OPTION_INPUT_FOLDER));
        if (!inputDir.exists()) {
            throw new IllegalStateException("Invalid input folder.");
        }
        Pattern incRegex = opt.getProperty(_OPTION_INPUT_REGEX_INCLUDE) == null ? null : Pattern.compile(opt.getProperty(_OPTION_INPUT_REGEX_INCLUDE));
        Pattern excRegex = opt.getProperty(_OPTION_INPUT_REGEX_EXCLUDE) == null ? null : Pattern.compile(opt.getProperty(_OPTION_INPUT_REGEX_EXCLUDE));
        String mode = opt.getProperty(_OPTION_PROCESSING_MODE);
        if (mode == null) {
            throw new IllegalStateException("Option processing.mode is required.");
        }
        if (!"flat-to-xml".equals(mode) && !"xml-to-flat".equals(mode)) {
            throw new IllegalStateException("Invalid mode (must be flat-to-xml or xml-to-flat).");
        }
        String rawErrorCodes = opt.getProperty(_OPTION_PROCESSING_ERROR_CODES);
        ArrayList<String> errorCodes = null;
        if (rawErrorCodes != null && !rawErrorCodes.isEmpty()) {
            errorCodes = new ArrayList<String>();
            for (String s : StringUtils.split((String)rawErrorCodes, (char)',')) {
                errorCodes.add(s.trim());
            }
        }
        int numThreads = Math.min(Runtime.getRuntime().availableProcessors() + 1, 5);
        if (opt.getProperty(_OPTION_PROCESSING_NUM_THREADS) != null && !opt.getProperty(_OPTION_PROCESSING_NUM_THREADS).isEmpty()) {
            numThreads = Integer.parseInt(opt.getProperty(_OPTION_PROCESSING_NUM_THREADS));
        }
        if (opt.getProperty(_OPTION_OUTPUT_FOLDER) == null || opt.getProperty(_OPTION_OUTPUT_FOLDER).isEmpty()) {
            throw new IllegalStateException("Option output.folder is required.");
        }
        String compression = opt.getProperty(_OPTION_PROCESSING_COMPRESSION);
        if (!(compression == null || compression.equals("gz") || compression.equals("xz") || compression.equals("none") || compression.equals("as-input"))) {
            throw new IllegalStateException("Invalid compression (must be gz, xz, none, or as-input).");
        }
        File outputDir = new File(opt.getProperty(_OPTION_OUTPUT_FOLDER));
        if (!outputDir.exists()) {
            throw new IllegalStateException("Invalid outupt folder.");
        }
        boolean cleanCreatedFiles = opt.getProperty(_OPTION_OUTPUT_CLEAN_CREATED_FILES) != null && Boolean.parseBoolean(opt.getProperty(_OPTION_OUTPUT_CLEAN_CREATED_FILES));
        boolean createReport = opt.getProperty(_OPTION_OUTPUT_CREATE_REPORT) != null && Boolean.parseBoolean(opt.getProperty(_OPTION_OUTPUT_CREATE_REPORT));
        String reportName = opt.getProperty(_OPTION_OUTPUT_REPORT_NAME) == null ? "report.txt" : opt.getProperty(_OPTION_OUTPUT_REPORT_NAME);
        boolean deidentify = opt.getProperty(_OPTION_OUTPUT_DEIDENTIFY_FILES) != null && Boolean.parseBoolean(opt.getProperty(_OPTION_OUTPUT_DEIDENTIFY_FILES));
        ArrayList<File> toProcess = new ArrayList<File>();
        File[] files = inputDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) continue;
                boolean add = true;
                if (incRegex != null || excRegex != null) {
                    if (incRegex != null && !incRegex.matcher(file.getName()).matches()) {
                        add = false;
                    }
                    if (excRegex != null && excRegex.matcher(file.getName()).matches()) {
                        add = false;
                    }
                }
                if (!add) continue;
                toProcess.add(file);
            }
        }
        TreeMap<String, ArrayList<String>> reportData = new TreeMap<String, ArrayList<String>>();
        HashMap<String, AtomicInteger> globalCounts = new HashMap<String, AtomicInteger>();
        HashMap<String, Set<String>> globalDetails = new HashMap<String, Set<String>>();
        AtomicInteger globalTumorCount = new AtomicInteger();
        long start = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        for (File inputFile : toProcess) {
            String outputFilename;
            File file;
            if (inputFile.equals(file = new File(outputDir, outputFilename = BatchProcessor.invertFilename(inputFile, compression)))) {
                throw new IllegalStateException("Was about to write output file into the input file, this can't be good!");
            }
            if (cleanCreatedFiles) {
                file.deleteOnExit();
            }
            ArrayList<String> data = new ArrayList<String>();
            reportData.put(inputFile.getName(), data);
            executor.execute(new FileProcessor(inputFile, file, data, cleanCreatedFiles, "flat-to-xml".equals(mode), globalCounts, globalDetails, globalTumorCount, errorCodes));
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.DAYS);
        if (createReport) {
            try (OutputStreamWriter reportWriter = new OutputStreamWriter(Files.newOutputStream(new File(outputDir, reportName).toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                reportWriter.write("Report created on " + new Date() + "\n\n");
                reportWriter.write("total number of files: " + BatchProcessor.formatNumber(toProcess.size()) + "\n");
                reportWriter.write("total processing time: " + BatchProcessor.formatTime(System.currentTimeMillis() - start) + "\n");
                reportWriter.write("total number of processed tumors: " + BatchProcessor.formatNumber(globalTumorCount.get()) + "\n");
                reportWriter.write("combined warnings:\n");
                int globalCount = 0;
                for (String string : NaaccrErrorUtils.getAllValidationErrors().keySet()) {
                    int count;
                    if (errorCodes != null && !errorCodes.contains(string)) continue;
                    int n = count = globalCounts.containsKey(string) ? ((AtomicInteger)globalCounts.get(string)).get() : 0;
                    if (count > 0) {
                        reportWriter.write("      " + string + ": " + BatchProcessor.formatNumber(count) + " cases\n");
                        if (globalDetails.containsKey(string)) {
                            ArrayList list = new ArrayList((Collection)globalDetails.get(string));
                            Collections.sort(list);
                            reportWriter.write("         involved item(s): " + list.size() + " " + list + "\n");
                        }
                    }
                    globalCount += count;
                }
                if (globalCount == 0) {
                    reportWriter.write("      no warning found\n");
                }
                for (Map.Entry entry : reportData.entrySet()) {
                    reportWriter.write("\n\n");
                    reportWriter.write(deidentify ? "<de-identified file name>" : (String)entry.getKey());
                    reportWriter.write("\n");
                    for (String line : (List)entry.getValue()) {
                        reportWriter.write(line);
                        reportWriter.write("\n");
                    }
                }
            }
        }
    }

    private static Properties readOptions(String[] args) {
        File file;
        Properties opt = null;
        if (args.length != 0 && (file = new File(args[0])).exists()) {
            try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                opt = new Properties();
                opt.load(reader);
            }
            catch (IOException e) {
                opt = null;
            }
        }
        return opt;
    }

    private static String invertFilename(File file, String compression) {
        String[] name = StringUtils.split((String)file.getName(), (char)'.');
        if (name.length < 2) {
            return null;
        }
        String extension = name[name.length - 1];
        boolean compressed = false;
        if (extension.equalsIgnoreCase("gz")) {
            extension = name[name.length - 2];
            compressed = true;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < (compressed ? name.length - 2 : name.length - 1); ++i) {
            result.append(name[i]).append(".");
        }
        result.append(extension.equalsIgnoreCase("xml") ? "txt" : "xml");
        if (compressed) {
            result.append(".gz");
        }
        String newName = result.toString();
        if ("gz".equals(compression)) {
            if (newName.endsWith(".xz")) {
                newName = newName.replace(".xz", "");
            }
            if (!newName.endsWith(".gz")) {
                newName = newName + ".gz";
            }
        } else if ("xz".equals(compression)) {
            if (newName.endsWith(".gz")) {
                newName = newName.replace(".gz", "");
            }
            if (!newName.endsWith(".xz")) {
                newName = newName + ".xz";
            }
        } else if ("none".equals(compression)) {
            if (newName.endsWith(".gz")) {
                newName = newName.replace(".gz", "");
            } else if (newName.endsWith(".xz")) {
                newName = newName.replace(".xz", "");
            }
        }
        return new File(file.getParentFile(), newName).getName();
    }

    public static String formatNumber(int num) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalSeparatorAlwaysShown(false);
        return format.format(num);
    }

    public static String formatTime(long timeInMilli) {
        long hourBasis = 60L;
        StringBuilder formattedTime = new StringBuilder();
        long secTmp = timeInMilli / 1000L;
        long sec = secTmp % hourBasis;
        long minTmp = secTmp / hourBasis;
        long min = minTmp % hourBasis;
        long hour = minTmp / hourBasis;
        if (hour > 0L) {
            formattedTime.append(hour).append(" hour");
            if (hour > 1L) {
                formattedTime.append("s");
            }
        }
        if (min > 0L) {
            if (formattedTime.length() > 0) {
                formattedTime.append(", ");
            }
            formattedTime.append(min).append(" minute");
            if (min > 1L) {
                formattedTime.append("s");
            }
        }
        if (sec > 0L) {
            if (formattedTime.length() > 0) {
                formattedTime.append(", ");
            }
            formattedTime.append(sec).append(" second");
            if (sec > 1L) {
                formattedTime.append("s");
            }
        }
        if (formattedTime.length() > 0) {
            return formattedTime.toString();
        }
        return "< 1 second";
    }

    public static String formatFileSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        if (size < 0x100000L) {
            return new DecimalFormat("#.# KB").format((double)size / 1024.0);
        }
        if (size < 0x40000000L) {
            return new DecimalFormat("#.# MB").format((double)size / 1024.0 / 1024.0);
        }
        return new DecimalFormat("#.# GB").format((double)size / 1024.0 / 1024.0 / 1024.0);
    }

    private static final class FileObserver
    implements NaaccrObserver {
        private final Map<String, AtomicInteger> _warningCounts;
        private final Map<String, AtomicInteger> _globalCounts;
        private final Map<String, Set<String>> _warningDetails;
        private final Map<String, Set<String>> _globalDetails;
        private final AtomicInteger _tumorCount;
        private final AtomicInteger _globalTumorCount;

        public FileObserver(Map<String, AtomicInteger> warningCounts, Map<String, Set<String>> warningDetails, AtomicInteger tumorCount, Map<String, AtomicInteger> globalCounts, Map<String, Set<String>> globalDetails, AtomicInteger globalTumorCount) {
            this._warningCounts = warningCounts;
            this._warningDetails = warningDetails;
            this._tumorCount = tumorCount;
            this._globalCounts = globalCounts;
            this._globalDetails = globalDetails;
            this._globalTumorCount = globalTumorCount;
        }

        @Override
        public void patientRead(Patient patient) {
            this.handlePatient(patient);
        }

        @Override
        public void patientWritten(Patient patient) {
            this.handlePatient(patient);
            this._tumorCount.addAndGet(patient.getTumors().size());
            this._globalTumorCount.addAndGet(patient.getTumors().size());
        }

        private void handlePatient(Patient patient) {
            for (NaaccrValidationError error : patient.getAllValidationErrors()) {
                AtomicInteger count = this._warningCounts.get(error.getCode());
                if (count == null) {
                    this._warningCounts.put(error.getCode(), new AtomicInteger(1));
                } else {
                    count.incrementAndGet();
                }
                AtomicInteger globalCount = this._globalCounts.get(error.getCode());
                if (globalCount == null) {
                    this._globalCounts.put(error.getCode(), new AtomicInteger(1));
                } else {
                    globalCount.incrementAndGet();
                }
                if (error.getNaaccrId() == null) continue;
                this._warningDetails.computeIfAbsent(error.getCode(), k -> new HashSet()).add(error.getNaaccrId());
                this._globalDetails.computeIfAbsent(error.getCode(), k -> new HashSet()).add(error.getNaaccrId());
            }
        }
    }

    private static final class FileProcessor
    implements Runnable {
        private final File _inputFile;
        private final File _outputFile;
        private final List<String> _reportData;
        private final boolean _deleteOutputFiles;
        private final boolean _flatToXml;
        private final Map<String, AtomicInteger> _globalCounts;
        private final Map<String, Set<String>> _globalDetails;
        private final AtomicInteger _globalTumorCount;
        private final List<String> _errorCodes;

        public FileProcessor(File inputFile, File outputFile, List<String> reportData, boolean deleteOutputFiles, boolean flatToXml, Map<String, AtomicInteger> globalCounts, Map<String, Set<String>> globalDetails, AtomicInteger globalTumorCount, List<String> errorCodes) {
            this._inputFile = inputFile;
            this._outputFile = outputFile;
            this._reportData = reportData;
            this._deleteOutputFiles = deleteOutputFiles;
            this._flatToXml = flatToXml;
            this._globalCounts = globalCounts;
            this._globalDetails = globalDetails;
            this._globalTumorCount = globalTumorCount;
            this._errorCodes = errorCodes;
        }

        @Override
        public void run() {
            HashMap<String, AtomicInteger> warningCounts = new HashMap<String, AtomicInteger>();
            HashMap<String, Set<String>> warningDetails = new HashMap<String, Set<String>>();
            AtomicInteger tumorCount = new AtomicInteger();
            NaaccrOptions options = new NaaccrOptions();
            options.setReportLevelMismatch(true);
            FileObserver observer = new FileObserver(warningCounts, warningDetails, tumorCount, this._globalCounts, this._globalDetails, this._globalTumorCount);
            try {
                long start = System.currentTimeMillis();
                if (this._flatToXml) {
                    NaaccrXmlUtils.flatToXml(this._inputFile, this._outputFile, options, null, observer);
                } else {
                    NaaccrXmlUtils.xmlToFlat(this._inputFile, this._outputFile, options, null, observer);
                }
                this._reportData.add("   original size: " + BatchProcessor.formatFileSize(this._inputFile.length()));
                this._reportData.add("   created size: " + BatchProcessor.formatFileSize(this._outputFile.length()));
                this._reportData.add("   processing time: " + BatchProcessor.formatTime(System.currentTimeMillis() - start));
                this._reportData.add("   number of processed tumors: " + BatchProcessor.formatNumber(tumorCount.get()));
                this._reportData.add("   warnings:");
                int globalCount = 0;
                for (String code : NaaccrErrorUtils.getAllValidationErrors().keySet()) {
                    int count;
                    if (this._errorCodes != null && !this._errorCodes.contains(code)) continue;
                    int n = count = warningCounts.containsKey(code) ? ((AtomicInteger)warningCounts.get(code)).get() : 0;
                    if (count > 0) {
                        this._reportData.add("      " + code + ": " + BatchProcessor.formatNumber(count) + " cases");
                        if (warningDetails.containsKey(code)) {
                            ArrayList list = new ArrayList((Collection)warningDetails.get(code));
                            Collections.sort(list);
                            this._reportData.add("         involved item(s): " + list.size() + " " + list);
                        }
                    }
                    globalCount += count;
                }
                if (globalCount == 0) {
                    this._reportData.add("      no warning found");
                }
            }
            catch (NaaccrIOException e) {
                this._reportData.add("   processing error: " + e.getMessage());
            }
            if (this._deleteOutputFiles && !this._outputFile.delete()) {
                this._reportData.add("Unable to delete " + this._outputFile.getPath());
            }
        }
    }
}

