/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml;

import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrValidationError;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.PatientReader;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Item;
import com.imsweb.naaccrxml.entity.NaaccrData;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.runtime.NaaccrStreamConfiguration;
import com.imsweb.naaccrxml.runtime.RuntimeNaaccrDictionary;
import com.imsweb.naaccrxml.runtime.RuntimeNaaccrDictionaryItem;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class PatientFlatReader
implements PatientReader {
    protected LineNumberReader _reader;
    protected NaaccrData _rootData;
    protected NaaccrOptions _options;
    protected RuntimeNaaccrDictionary _dictionary;
    protected List<RuntimeNaaccrDictionaryItem> _groupingItems;
    protected NaaccrFormat _format;
    protected String _previousLine;

    public PatientFlatReader(Reader reader) throws NaaccrIOException {
        this(reader, null, (NaaccrDictionary)null, null);
    }

    public PatientFlatReader(Reader reader, NaaccrOptions options) throws NaaccrIOException {
        this(reader, options, (NaaccrDictionary)null, null);
    }

    public PatientFlatReader(Reader reader, NaaccrOptions options, NaaccrDictionary userDictionary) throws NaaccrIOException {
        this(reader, options, Collections.singletonList(userDictionary), null);
    }

    public PatientFlatReader(Reader reader, NaaccrOptions options, List<NaaccrDictionary> userDictionaries) throws NaaccrIOException {
        this(reader, options, userDictionaries, null);
    }

    public PatientFlatReader(Reader reader, NaaccrOptions options, NaaccrDictionary userDictionary, NaaccrStreamConfiguration conf) throws NaaccrIOException {
        this(reader, options, Collections.singletonList(userDictionary), conf);
    }

    public PatientFlatReader(Reader reader, NaaccrOptions options, List<NaaccrDictionary> userDictionaries, NaaccrStreamConfiguration conf) throws NaaccrIOException {
        String version;
        this._reader = new LineNumberReader(reader);
        this._options = options == null ? new NaaccrOptions() : options;
        try {
            this._previousLine = this._reader.readLine();
        }
        catch (IOException e) {
            throw new NaaccrIOException("unable to read first line");
        }
        if (this._previousLine == null || this._previousLine.isEmpty()) {
            throw new NaaccrIOException("first line is empty");
        }
        String string = version = this._previousLine.length() < 19 ? "" : this._previousLine.substring(16, 19).trim();
        if (version.isEmpty()) {
            throw new NaaccrIOException("unable to get NAACCR version from first record");
        }
        if (!NaaccrFormat.isVersionSupported(version)) {
            throw new NaaccrIOException("invalid/unsupported NAACCR version on first record: " + version);
        }
        String type = this._previousLine.substring(0, 1).trim();
        if (type.isEmpty()) {
            throw new NaaccrIOException("unable to get record type on first record");
        }
        if (!NaaccrFormat.isRecordTypeSupported(type)) {
            throw new NaaccrIOException("invalid/unsupported record type on first record: " + type);
        }
        this._format = NaaccrFormat.getInstance(version, type);
        RuntimeNaaccrDictionary runtimeNaaccrDictionary = this._dictionary = conf == null ? null : conf.getCachedDictionary();
        if (this._dictionary == null) {
            NaaccrDictionary baseDictionary = NaaccrXmlDictionaryUtils.getBaseDictionaryByVersion(this._format.getNaaccrVersion());
            this._dictionary = new RuntimeNaaccrDictionary(this._format.getRecordType(), baseDictionary, userDictionaries);
        }
        this._rootData = new NaaccrData(this._format.toString());
        this._rootData.setSpecificationVersion("1.7");
        if (this._previousLine.length() != this._format.getLineLength()) {
            throw new NaaccrIOException("invalid line length for first record, expected " + this._format.getLineLength() + " but got " + this._previousLine.length());
        }
        for (RuntimeNaaccrDictionaryItem itemDef : this._dictionary.getItems()) {
            if (!"NaaccrData".equals(itemDef.getParentXmlElement())) continue;
            this.addItemFromLine(this._rootData, this._previousLine, this._reader.getLineNumber(), itemDef);
        }
        this._groupingItems = new ArrayList<RuntimeNaaccrDictionaryItem>();
        if (this._options.getTumorGroupingItems() != null) {
            for (String id : this._options.getTumorGroupingItems()) {
                RuntimeNaaccrDictionaryItem item = this._dictionary.getItemByNaaccrId(id);
                if (item == null) continue;
                this._groupingItems.add(item);
            }
        }
    }

    @Override
    public Patient readPatient() throws NaaccrIOException {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<Integer> lineNumbers = new ArrayList<Integer>();
        try {
            if (this._previousLine == null) {
                this._previousLine = this._reader.readLine();
                if (this._previousLine == null) {
                    return null;
                }
            }
            Map<String, String> firstLineGroupingValues = this.extractGroupingValues(this._previousLine, this._reader.getLineNumber(), this._groupingItems);
            lines.add(this._previousLine);
            lineNumbers.add(this._reader.getLineNumber());
            this._previousLine = this._reader.readLine();
            while (this._previousLine != null) {
                boolean samePatient;
                boolean bl = samePatient = !firstLineGroupingValues.isEmpty() && firstLineGroupingValues.equals(this.extractGroupingValues(this._previousLine, this._reader.getLineNumber(), this._groupingItems));
                if (samePatient) {
                    lines.add(this._previousLine);
                    lineNumbers.add(this._reader.getLineNumber());
                    this._previousLine = this._reader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new NaaccrIOException(e.getMessage());
        }
        return lines.isEmpty() ? null : this.createPatientFromLines(lines, lineNumbers);
    }

    @Override
    public NaaccrData getRootData() {
        return this._rootData;
    }

    @Override
    public void closeAndKeepAlive() {
    }

    @Override
    public void close() throws NaaccrIOException {
        this.closeAndKeepAlive();
        try {
            this._reader.close();
        }
        catch (IOException e) {
            throw new NaaccrIOException(e.getMessage());
        }
    }

    protected Map<String, String> extractGroupingValues(String line, Integer linNumber, List<RuntimeNaaccrDictionaryItem> itemDefs) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (RuntimeNaaccrDictionaryItem itemDef : itemDefs) {
            Item item = this.createItemFromLine(null, line, linNumber, itemDef);
            if (item == null) continue;
            values.put(item.getNaaccrId(), item.getValue());
        }
        return values;
    }

    protected Patient createPatientFromLines(List<String> lines, List<Integer> lineNumbers) {
        Patient patient = new Patient();
        patient.setStartLineNumber(lineNumbers.get(0));
        patient.setEndLineNumber(lineNumbers.get(0));
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            Integer lineNumber = lineNumbers.get(i);
            if (line.length() != this._format.getLineLength()) {
                this.reportError(patient, lineNumber, null, null, "Invalid line length", this._format.getLineLength(), line.length());
            }
            Tumor tumor = new Tumor();
            tumor.setStartLineNumber(lineNumber);
            tumor.setEndLineNumber(lineNumber);
            for (RuntimeNaaccrDictionaryItem def : this._dictionary.getItems()) {
                boolean same;
                String tumorValue;
                Item currentTumorItem;
                if ("NaaccrData".equals(def.getParentXmlElement())) {
                    if (!Boolean.TRUE.equals(this._options.getReportLevelMismatch())) continue;
                    currentTumorItem = this.createItemFromLine(null, line, lineNumber, def);
                    String rootValue = this._rootData.getItemValue(def.getNaaccrId());
                    String string = tumorValue = currentTumorItem == null ? null : currentTumorItem.getValue();
                    same = rootValue == null ? tumorValue == null : rootValue.equals(tumorValue);
                    if (same) continue;
                    this.reportError(tumor, lineNumber, def, null, "NaaccrData value not consistent among tumors", def.getNaaccrId());
                    continue;
                }
                if ("Patient".equals(def.getParentXmlElement())) {
                    if (i == 0) {
                        this.addItemFromLine(patient, line, lineNumber, def);
                        continue;
                    }
                    if (!Boolean.TRUE.equals(this._options.getReportLevelMismatch())) continue;
                    currentTumorItem = this.createItemFromLine(null, line, lineNumber, def);
                    String patValue = patient.getItemValue(def.getNaaccrId());
                    String string = tumorValue = currentTumorItem == null ? null : currentTumorItem.getValue();
                    same = patValue == null ? tumorValue == null : patValue.equals(tumorValue);
                    if (same) continue;
                    this.reportError(tumor, lineNumber, def, null, "Patient value not consistent among tumors", def.getNaaccrId());
                    continue;
                }
                if (!"Tumor".equals(def.getParentXmlElement())) continue;
                this.addItemFromLine(tumor, line, lineNumber, def);
            }
            patient.addTumor(tumor);
        }
        return patient;
    }

    protected void addItemFromLine(AbstractEntity entity, String line, Integer lineNumber, RuntimeNaaccrDictionaryItem def) {
        if (def.getStartColumn() == null) {
            return;
        }
        Item item = this.createItemFromLine(entity, line, lineNumber, def);
        if (item != null && NaaccrOptions.processItem(this._options, def.getNaaccrId())) {
            entity.addItem(item);
        }
    }

    protected Item createItemFromLine(AbstractEntity entity, String line, Integer lineNumber, RuntimeNaaccrDictionaryItem def) {
        Item item = null;
        int start = def.getStartColumn() - 1;
        int end = start + def.getLength();
        if (end <= line.length()) {
            String value = line.substring(start, end);
            String trimmedValue = value.trim();
            if (trimmedValue.isEmpty() || def.getTrim() == null || "all".equals(def.getTrim())) {
                value = trimmedValue;
            }
            if (!value.isEmpty()) {
                item = new Item(def.getNaaccrId(), def.getNaaccrNum(), value, lineNumber);
                if (entity != null) {
                    if (item.getValue().length() > def.getLength()) {
                        this.reportError(entity, lineNumber, def, item.getValue(), "Value too long", def.getLength(), item.getValue().length());
                    }
                    if (Boolean.TRUE.equals(this._options.getValidateReadValues())) {
                        Pattern pattern;
                        if (NaaccrXmlDictionaryUtils.isFullLengthRequiredForType(def.getDataType()) && item.getValue().length() < def.getLength()) {
                            this.reportError(entity, lineNumber, def, item.getValue(), "Value too short", def.getLength(), item.getValue().length());
                        } else if (def.getDataType() != null && (pattern = NaaccrXmlDictionaryUtils.getDataTypePattern(def.getDataType())) != null && !pattern.matcher(item.getValue()).matches()) {
                            this.reportError(entity, lineNumber, def, item.getValue(), "Value invalid for data type", def.getDataType());
                        }
                    }
                }
            }
        }
        return item;
    }

    protected void reportError(AbstractEntity entity, int line, RuntimeNaaccrDictionaryItem def, String value, String code, Object ... msgValues) {
        NaaccrValidationError error = new NaaccrValidationError(code, msgValues);
        error.setLineNumber(line);
        if (def != null) {
            error.setNaaccrId(def.getNaaccrId());
            error.setNaaccrNum(def.getNaaccrNum());
        }
        if (value != null && !value.isEmpty()) {
            error.setValue(value);
        }
        entity.addValidationError(error);
    }
}

