/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.runtime;

import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryItem;
import com.imsweb.naaccrxml.runtime.RuntimeNaaccrDictionaryItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RuntimeNaaccrDictionary {
    private final String _id;
    private final NaaccrFormat _format;
    private List<RuntimeNaaccrDictionaryItem> _items;
    private Map<String, RuntimeNaaccrDictionaryItem> _cachedById;

    public RuntimeNaaccrDictionary(String recordType, NaaccrDictionary baseDictionary, Collection<NaaccrDictionary> userDictionaries) throws NaaccrIOException {
        Object defaultUserDictionary;
        if (recordType == null) {
            throw new NaaccrIOException("Record type is required to create a runtime dictionary");
        }
        if (baseDictionary == null) {
            throw new NaaccrIOException("Base dictionary is required to create a runtime dictionary");
        }
        ArrayList<NaaccrDictionary> dictionaries = new ArrayList<NaaccrDictionary>();
        if (userDictionaries != null) {
            for (NaaccrDictionary userDictionary : userDictionaries) {
                if (userDictionary == null) continue;
                dictionaries.add(userDictionary);
            }
        }
        this._id = RuntimeNaaccrDictionary.computeId(recordType, baseDictionary, dictionaries);
        List<String> errors = NaaccrXmlDictionaryUtils.validateDictionaries(baseDictionary, dictionaries);
        if (!errors.isEmpty()) {
            throw new NaaccrIOException(StringUtils.capitalize((String)errors.get(0)));
        }
        if (dictionaries.isEmpty() && (defaultUserDictionary = NaaccrXmlDictionaryUtils.getDefaultUserDictionaryByVersion(baseDictionary.getNaaccrVersion())) != null) {
            dictionaries.add((NaaccrDictionary)defaultUserDictionary);
        }
        this._format = NaaccrFormat.getInstance(baseDictionary.getNaaccrVersion(), recordType);
        this._items = new ArrayList<RuntimeNaaccrDictionaryItem>();
        for (NaaccrDictionaryItem item : baseDictionary.getItems()) {
            if (item.getRecordTypes() != null && !StringUtils.contains((CharSequence)item.getRecordTypes(), (CharSequence)recordType)) continue;
            this._items.add(new RuntimeNaaccrDictionaryItem(item));
        }
        HashSet<String> processedIds = new HashSet<String>();
        for (NaaccrDictionary userDictionary : dictionaries) {
            for (NaaccrDictionaryItem item : userDictionary.getItems()) {
                if (item.getRecordTypes() != null && (!StringUtils.contains((CharSequence)item.getRecordTypes(), (CharSequence)recordType) || processedIds.contains(item.getNaaccrId()))) continue;
                this._items.add(new RuntimeNaaccrDictionaryItem(item));
                processedIds.add(item.getNaaccrId());
            }
        }
        if (Integer.parseInt(this._format.getNaaccrVersion()) <= 180) {
            this._items.sort((o1, o2) -> {
                if (o1.getStartColumn() == null) {
                    return 1;
                }
                if (o2.getStartColumn() == null) {
                    return -1;
                }
                return o1.getStartColumn().compareTo(o2.getStartColumn());
            });
        } else {
            this._items.sort(Comparator.comparing(RuntimeNaaccrDictionaryItem::getNaaccrId));
        }
    }

    public String getId() {
        return this._id;
    }

    public String getNaaccrVersion() {
        return this._format.getNaaccrVersion();
    }

    public String getRecordType() {
        return this._format.getRecordType();
    }

    public Integer getLineLength() {
        return this._format.getLineLength();
    }

    public List<RuntimeNaaccrDictionaryItem> getItems() {
        if (this._items == null) {
            this._items = new ArrayList<RuntimeNaaccrDictionaryItem>();
        }
        return this._items;
    }

    public RuntimeNaaccrDictionaryItem getItemByNaaccrId(String id) {
        if (this._cachedById == null) {
            HashMap<String, RuntimeNaaccrDictionaryItem> cache = new HashMap<String, RuntimeNaaccrDictionaryItem>();
            for (RuntimeNaaccrDictionaryItem item : this._items) {
                if (item.getNaaccrId() == null) continue;
                cache.put(item.getNaaccrId(), item);
            }
            this._cachedById = cache;
        }
        return this._cachedById.get(id);
    }

    public static String computeId(String recordType, NaaccrDictionary baseDictionary, Collection<NaaccrDictionary> userDictionaries) {
        if (baseDictionary == null) {
            return recordType;
        }
        StringBuilder buf = new StringBuilder(recordType);
        buf.append(";").append(baseDictionary.getDictionaryUri());
        if (userDictionaries != null) {
            for (NaaccrDictionary userDictionary : userDictionaries) {
                if (userDictionary == null) continue;
                buf.append(";").append(userDictionary.getDictionaryUri());
            }
        }
        return buf.toString();
    }
}

