/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.sas;

import com.imsweb.naaccrxml.sas.SasFieldInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class SasUtils {
    private static final Map<String, String> _TO_ESCAPE = new LinkedHashMap<String, String>();

    private SasUtils() {
    }

    public static void logInfo(String msg) {
        System.out.println("[JAVA SAS LIBRARY] " + msg);
    }

    public static void logError(String msg) {
        System.err.println("[JAVA SAS LIBRARY] !!! ERROR !!! " + msg);
    }

    public static String computeCsvPathFromXmlPath(String xmlPath) {
        return SasUtils.computePathFromXmlPath(xmlPath, ".csv");
    }

    public static String computeFlatPathFromXmlPath(String xmlPath) {
        return SasUtils.computePathFromXmlPath(xmlPath, ".tmp.txt");
    }

    public static String computeInputPathFromXmlPath(String xmlPath) {
        return SasUtils.computePathFromXmlPath(xmlPath, ".tmp.input.sas");
    }

    public static String computeOutputPathFromXmlPath(String xmlPath) {
        return SasUtils.computePathFromXmlPath(xmlPath, ".tmp.output.sas");
    }

    static String computePathFromXmlPath(String xmlPath, String newExtension) {
        if (xmlPath == null || xmlPath.trim().isEmpty()) {
            return null;
        }
        String tempPath = Pattern.compile("(\\.xml|\\.xml\\.gz|\\.gz|.zip)$", 2).matcher(xmlPath).replaceAll(newExtension);
        if (tempPath.equalsIgnoreCase(xmlPath)) {
            tempPath = xmlPath + newExtension;
        }
        return tempPath;
    }

    public static BufferedReader createReader(File file) throws IOException {
        InputStream is = new FileInputStream(file);
        if (file.getName().toLowerCase().endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static BufferedReader createReader(InputStream is, String name) throws IOException {
        if (name.toLowerCase().endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static BufferedWriter createWriter(File file) throws IOException {
        OutputStream os = new FileOutputStream(file);
        if (file.getName().toLowerCase().endsWith(".gz")) {
            os = new GZIPOutputStream(os);
        }
        return new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
    }

    public static List<SasFieldInfo> getFields(String version, String recordType, List<File> dictionaries) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("naaccr-xml-items-" + version + ".csv");
        if (is == null) {
            throw new IllegalStateException("Unable to get standard CSV dictionary for version " + version);
        }
        return SasUtils.getFields(recordType, is, dictionaries);
    }

    public static List<SasFieldInfo> getFields(String recordType, InputStream is, List<File> dictionaries) {
        HashMap<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
        List<SasFieldInfo> result = SasUtils.readCsvDictionary(recordType, is, counters);
        if (dictionaries != null) {
            for (File dictionary : dictionaries) {
                FileInputStream dictIs = null;
                try {
                    dictIs = new FileInputStream(dictionary);
                    result.addAll(SasUtils.readCsvDictionary(recordType, dictIs, counters));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                finally {
                    if (dictIs == null) continue;
                    try {
                        ((InputStream)dictIs).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    public static List<SasFieldInfo> getGroupedFields(String version, String recordType) {
        if (version.compareTo("230") >= 0) {
            return new ArrayList<SasFieldInfo>();
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("naaccr-xml-grouped-items-" + version + ".csv");
        if (is == null) {
            throw new IllegalStateException("Unable to get grouped items CSV file for version " + version);
        }
        return SasUtils.getGroupedFields(recordType, is);
    }

    public static List<SasFieldInfo> getGroupedFields(String recordType, InputStream is) {
        return SasUtils.readCsvGroupedItems(recordType, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateCsvDictionary(File file) throws IOException {
        if (!file.getName().toLowerCase().endsWith(".csv")) {
            throw new IOException(file.getName() + "is supposed to be a CSV dictionary but doesn't end with a '.csv' file extension");
        }
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.US_ASCII));
            String line = ((LineNumberReader)reader).readLine();
            while (line != null) {
                List<String> values = SasUtils.parseCsvLine(((LineNumberReader)reader).getLineNumber(), line);
                if (values.size() < 7) {
                    throw new IOException("Expected CSV dictionary file to have at least 7 columns, got " + values.size() + " at line " + ((LineNumberReader)reader).getLineNumber() + " in " + file.getName());
                }
                line = ((LineNumberReader)reader).readLine();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static List<SasFieldInfo> readCsvDictionary(String recordType, InputStream is, Map<String, AtomicInteger> counters) {
        ArrayList<SasFieldInfo> result = new ArrayList<SasFieldInfo>();
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new InputStreamReader(is, StandardCharsets.US_ASCII));
            ((LineNumberReader)reader).readLine();
            String line = ((LineNumberReader)reader).readLine();
            while (line != null) {
                List<String> values = SasUtils.parseCsvLine(((LineNumberReader)reader).getLineNumber(), line);
                String id = values.get(0);
                Integer num = values.get(1).isEmpty() ? null : Integer.valueOf(values.get(1));
                String name = values.get(2);
                Integer start = values.get(3).isEmpty() ? null : Integer.valueOf(values.get(3));
                Integer length = values.get(4).isEmpty() ? null : Integer.valueOf(values.get(4));
                String recTypes = values.get(5);
                String parentTag = values.get(6);
                String truncatedId = id;
                if (truncatedId.length() > 32) {
                    String prefix = truncatedId.substring(0, 30);
                    AtomicInteger counter = counters.get(prefix);
                    if (counter == null) {
                        counter = new AtomicInteger();
                        counters.put(prefix, counter);
                    }
                    truncatedId = prefix + "_" + counter.getAndIncrement();
                }
                if (recTypes.contains(recordType)) {
                    result.add(new SasFieldInfo(id, truncatedId, parentTag, length, num, name, start));
                }
                line = ((LineNumberReader)reader).readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private static List<SasFieldInfo> readCsvGroupedItems(String recordType, InputStream is) {
        ArrayList<SasFieldInfo> result = new ArrayList<SasFieldInfo>();
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new InputStreamReader(is, StandardCharsets.US_ASCII));
            ((LineNumberReader)reader).readLine();
            String line = ((LineNumberReader)reader).readLine();
            while (line != null) {
                List<String> values = SasUtils.parseCsvLine(((LineNumberReader)reader).getLineNumber(), line);
                String id = values.get(0);
                Integer num = Integer.valueOf(values.get(1));
                String name = values.get(2);
                Integer length = Integer.valueOf(values.get(3));
                String recTypes = values.get(4);
                String parentTag = values.get(5);
                String contains = values.get(6);
                if (recTypes.contains(recordType)) {
                    result.add(new SasFieldInfo(id, num, name, parentTag, length, contains));
                }
                line = ((LineNumberReader)reader).readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static List<String> parseCsvLine(int lineNumber, String line) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        char cQuote = '\"';
        char cDelimiter = ',';
        int curIndex = 0;
        StringBuilder buf = new StringBuilder();
        buf.append(cQuote);
        String singleQuotes = buf.toString();
        buf.append(cQuote);
        String doubleQuotes = buf.toString();
        while (curIndex < line.length()) {
            if (line.charAt(curIndex) == cQuote) {
                int nextQuote = SasUtils.getNextSingleQuote(line, cQuote, curIndex);
                if (nextQuote < 0) {
                    throw new IOException("Line " + lineNumber + ": found an unmatched quote");
                }
                result.add(line.substring(curIndex + 1, nextQuote).replace(doubleQuotes, singleQuotes));
                curIndex = nextQuote;
                if (curIndex + 1 < line.length()) {
                    if (line.charAt(curIndex + 1) == cDelimiter) {
                        if ((curIndex += 2) != line.length()) continue;
                        result.add("");
                        continue;
                    }
                    throw new IOException("Line " + lineNumber + ": expected a delimiter after the quote");
                }
                ++curIndex;
                continue;
            }
            int nextDelimiter = SasUtils.getNextDelimiter(line, cDelimiter, curIndex);
            String value = line.substring(curIndex, nextDelimiter).replace(doubleQuotes, singleQuotes);
            if (value.contains(singleQuotes)) {
                throw new IOException("Line " + lineNumber + ": value contains some quotes but does not start with a quote");
            }
            result.add(value);
            curIndex = nextDelimiter + 1;
            if (curIndex != line.length()) continue;
            result.add("");
        }
        return result;
    }

    private static int getNextSingleQuote(String line, char quote, int from) {
        if (from >= line.length()) {
            return -1;
        }
        int index = from + 1;
        boolean found = false;
        while (index < line.length() && !found) {
            if (line.charAt(index) != quote) {
                ++index;
                continue;
            }
            if (index + 1 == line.length() || line.charAt(index + 1) != quote) {
                found = true;
                continue;
            }
            index += 2;
        }
        index = index == line.length() ? -1 : index;
        return index;
    }

    private static int getNextDelimiter(String line, char delimiter, int from) {
        int index;
        if (from >= line.length()) {
            return line.length();
        }
        for (index = from; index < line.length() && line.charAt(index) != delimiter; ++index) {
        }
        return index;
    }

    public static String cleanUpValueToWriteAsXml(String value) {
        for (Map.Entry<String, String> entry : _TO_ESCAPE.entrySet()) {
            value = value.replace(entry.getKey(), entry.getValue());
        }
        return value;
    }

    public static Set<String> extractRequestedFields(String fields, List<SasFieldInfo> allFields) {
        if (fields == null || fields.trim().isEmpty()) {
            return null;
        }
        HashSet<String> allowedIds = new HashSet<String>();
        for (SasFieldInfo info : allFields) {
            allowedIds.add(info.getNaaccrId());
        }
        HashSet<String> requestedFields = new HashSet<String>();
        if (fields.contains(".")) {
            File file = new File(fields);
            if (!file.exists()) {
                SasUtils.logError("Invalid file for included items: " + fields);
                return null;
            }
            if (!file.getName().toLowerCase().endsWith(".csv")) {
                SasUtils.logError("Invalid file for included items, file must have the '.csv' extension: " + fields);
                return null;
            }
            BufferedReader reader = null;
            try {
                reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.US_ASCII));
                ((LineNumberReader)reader).readLine();
                String line = ((LineNumberReader)reader).readLine();
                while (line != null) {
                    List<String> values = SasUtils.parseCsvLine(((LineNumberReader)reader).getLineNumber(), line);
                    if (!values.isEmpty()) {
                        String xmlId = values.get(0).trim();
                        if (allowedIds.contains(xmlId)) {
                            requestedFields.add(xmlId);
                        } else {
                            SasUtils.logError("Invalid NAACCR XML ID requested: " + xmlId);
                        }
                    }
                    line = ((LineNumberReader)reader).readLine();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        for (String xmlId : fields.replace(" ", "").replace("\t", "").split(",", -1)) {
            if (allowedIds.contains(xmlId)) {
                requestedFields.add(xmlId);
                continue;
            }
            SasUtils.logError("Invalid NAACCR XML ID requested: " + xmlId);
        }
        return requestedFields;
    }

    public static String rightPadWithSpaces(String value, int length) {
        if (value == null || value.length() == length) {
            return value;
        }
        if (value.length() > length) {
            return value.substring(0, length);
        }
        StringBuilder buf = new StringBuilder(value);
        for (int i = value.length(); i < length; ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }

    static {
        _TO_ESCAPE.put("&", "&amp;");
        _TO_ESCAPE.put("<", "&lt;");
        _TO_ESCAPE.put(">", "&gt;");
        _TO_ESCAPE.put("\"", "&quot;");
        _TO_ESCAPE.put("'", "&apos;");
        _TO_ESCAPE.put("::", "\n");
    }
}

