/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.sas;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SasXmlReader {
    private static final Map<String, String> _TO_ESCAPE = new HashMap<String, String>();
    private final BufferedReader _reader;
    private boolean _inPatient;
    private boolean _inTumor;
    private boolean _inCdata;
    private final Map<String, String> _naaccrDataValues = new HashMap<String, String>();
    private final Map<String, String> _patientValues = new HashMap<String, String>();
    private final Map<String, String> _tumorValues = new HashMap<String, String>();

    public SasXmlReader(BufferedReader reader) {
        this._reader = reader;
    }

    public int nextRecord() throws IOException {
        this._tumorValues.clear();
        String currentKey = null;
        StringBuilder currentVal = null;
        String line = this._reader.readLine();
        while (line != null) {
            int itemIdx = line.indexOf("<Item");
            if (itemIdx > -1) {
                int naaccrIdStart = line.indexOf("naaccrId=\"", itemIdx + 1);
                if (naaccrIdStart > -1) {
                    naaccrIdStart += 9;
                } else {
                    naaccrIdStart = line.indexOf("naaccrId='", itemIdx + 1);
                    if (naaccrIdStart > -1) {
                        naaccrIdStart += 9;
                    } else {
                        throw new IOException("Unable to find start of NAACCR ID attribute for: " + line);
                    }
                }
                int naaccrIdEnd = line.indexOf(34, naaccrIdStart + 1);
                if (naaccrIdEnd == -1) {
                    naaccrIdEnd = line.indexOf(39, naaccrIdStart + 1);
                }
                if (naaccrIdEnd == -1) {
                    throw new IOException("Unable to find end of NAACCR ID attribute for: " + line);
                }
                String key = line.substring(naaccrIdStart + 1, naaccrIdEnd);
                int valueStart = line.indexOf(62, naaccrIdEnd + 1);
                if (valueStart == -1) {
                    throw new IOException("Unable to find start of value for: " + line);
                }
                int valueEnd = line.indexOf(60, valueStart + 1);
                if (valueEnd == -1) {
                    currentKey = key;
                    currentVal = new StringBuilder(line.substring(valueStart + 1));
                }
                if (valueEnd == valueStart + 1 && line.charAt(valueEnd + 1) == '!' && line.charAt(valueEnd + 2) == '[') {
                    this._inCdata = true;
                    if ((valueStart = line.indexOf(91, valueStart + 4)) == -1) {
                        throw new IOException("Unable to find start of value for: " + line);
                    }
                    valueEnd = line.indexOf("]]>", valueStart + 1);
                    if (valueEnd == -1) {
                        currentKey = key;
                        currentVal = new StringBuilder(line.substring(valueStart + 1));
                    }
                }
                if (currentVal == null) {
                    String val;
                    String string = val = this._inCdata ? line.substring(valueStart + 1, valueEnd) : this.cleanUpValue(new StringBuilder(line.substring(valueStart + 1, valueEnd)));
                    if (this._inPatient) {
                        this._patientValues.put(key, val);
                    } else if (this._inTumor) {
                        this._tumorValues.put(key, val);
                    } else {
                        this._naaccrDataValues.put(key, val);
                    }
                    this._inCdata = false;
                }
            } else if (line.contains("<Patient>")) {
                if (currentVal != null) {
                    throw new IOException("Unable to find end of value for " + currentKey);
                }
                this._inPatient = true;
                this._inTumor = false;
            } else if (line.contains("<Tumor>")) {
                if (currentVal != null) {
                    throw new IOException("Unable to find end of value for " + currentKey);
                }
                this._inPatient = false;
                this._inTumor = true;
            } else {
                int endIdx = line.indexOf("</");
                if (endIdx > -1) {
                    if (line.indexOf("Patient>", endIdx) > -1) {
                        if (currentVal != null) {
                            throw new IOException("Unable to find end of value for " + currentKey);
                        }
                        this._inPatient = false;
                        this._patientValues.clear();
                    } else {
                        if (line.indexOf("Tumor>", endIdx) > -1) {
                            if (currentVal != null) {
                                throw new IOException("Unable to find end of value for " + currentKey);
                            }
                            this._tumorValues.putAll(this._naaccrDataValues);
                            this._tumorValues.putAll(this._patientValues);
                            break;
                        }
                        if (line.indexOf("Item>", endIdx) > -1) {
                            if (currentVal != null) {
                                String val;
                                if (endIdx > 3 && line.charAt(endIdx - 1) == '>' && line.charAt(endIdx - 2) == ']' && line.charAt(endIdx - 3) == ']') {
                                    endIdx -= 3;
                                }
                                currentVal.append("::").append(line, 0, endIdx);
                                String string = val = this._inCdata ? currentVal.toString() : this.cleanUpValue(currentVal);
                                if (this._inPatient) {
                                    this._patientValues.put(currentKey, val);
                                } else if (this._inTumor) {
                                    this._tumorValues.put(currentKey, val);
                                } else {
                                    this._naaccrDataValues.put(currentKey, val);
                                }
                                this._inCdata = false;
                                currentKey = null;
                                currentVal = null;
                            }
                        } else if (line.indexOf("NaaccrData>", endIdx) > -1) {
                            if (currentVal != null) {
                                throw new IOException("Unable to find end of value for " + currentKey);
                            }
                            return 0;
                        }
                    }
                } else if (currentVal != null) {
                    currentVal.append("::").append(line);
                }
            }
            line = this._reader.readLine();
        }
        return 1;
    }

    public String getValue(String naaccrId) {
        return Objects.toString(this._tumorValues.get(naaccrId), "");
    }

    public void close() {
        try {
            if (this._reader != null) {
                this._reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String cleanUpValue(StringBuilder buf) {
        for (Map.Entry<String, String> entry : _TO_ESCAPE.entrySet()) {
            int idx = buf.indexOf(entry.getKey());
            while (idx != -1) {
                buf.replace(idx, idx + entry.getKey().length(), entry.getValue());
                idx = buf.indexOf(entry.getKey(), idx + 1);
            }
        }
        return buf.toString();
    }

    static {
        _TO_ESCAPE.put("&amp;", "&");
        _TO_ESCAPE.put("&lt;", "<");
        _TO_ESCAPE.put("&gt;", ">");
        _TO_ESCAPE.put("&quot;", "\"");
        _TO_ESCAPE.put("&apos;", "'");
    }
}

