/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml;

import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.SpecificationVersion;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryGroupedItem;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryItem;
import com.imsweb.naaccrxml.runtime.NaaccrDictionaryConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class NaaccrXmlDictionaryUtils {
    public static final String NAACCR_DATA_TYPE_ALPHA = "alpha";
    public static final String NAACCR_DATA_TYPE_DIGITS = "digits";
    public static final String NAACCR_DATA_TYPE_MIXED = "mixed";
    public static final String NAACCR_DATA_TYPE_NUMERIC = "numeric";
    public static final String NAACCR_DATA_TYPE_TEXT = "text";
    public static final String NAACCR_DATA_TYPE_DATE = "date";
    private static final Map<String, Pattern> _NAACCR_DATA_TYPES_REGEX = new HashMap<String, Pattern>();
    public static final String NAACCR_TRIM_ALL = "all";
    public static final String NAACCR_TRIM_NONE = "none";
    public static final String NAACCR_PADDING_RIGHT_BLANK = "rightBlank";
    public static final String NAACCR_PADDING_LEFT_BLANK = "leftBlank";
    public static final String NAACCR_PADDING_RIGHT_ZERO = "rightZero";
    public static final String NAACCR_PADDING_LEFT_ZERO = "leftZero";
    public static final String NAACCR_PADDING_NONE = "none";
    public static final Pattern BASE_DICTIONARY_URI_PATTERN;
    public static final Pattern DEFAULT_USER_DICTIONARY_URI_PATTERN;
    private static final Map<String, NaaccrDictionary> _INTERNAL_DICTIONARIES;
    private static final Map<String, String> _RENAMED_LONG_NAACCR_18_IDS;
    private static final List<String> _PAT_TO_TUM_CHANGED_18_21_IDS;

    private NaaccrXmlDictionaryUtils() {
    }

    public static Map<String, String> getRenamedLongNaaccr18Ids() {
        return Collections.unmodifiableMap(_RENAMED_LONG_NAACCR_18_IDS);
    }

    public static List<String> getPatToTumorChangedNaaccr18And21Ids() {
        return Collections.unmodifiableList(_PAT_TO_TUM_CHANGED_18_21_IDS);
    }

    public static Pattern getDataTypePattern(String dataType) {
        return _NAACCR_DATA_TYPES_REGEX.get(dataType);
    }

    public static boolean isFullLengthRequiredForType(String type) {
        boolean result = NAACCR_DATA_TYPE_ALPHA.equals(type);
        result |= NAACCR_DATA_TYPE_DIGITS.equals(type);
        return result |= NAACCR_DATA_TYPE_MIXED.equals(type);
    }

    public static String extractVersionFromUri(String uri) {
        if (uri == null) {
            return null;
        }
        Matcher matcher = BASE_DICTIONARY_URI_PATTERN.matcher(uri);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = DEFAULT_USER_DICTIONARY_URI_PATTERN.matcher(uri);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String createUriFromVersion(String version, boolean isBase) {
        if (isBase) {
            return "http://naaccr.org/naaccrxml/naaccr-dictionary-" + version + ".xml";
        }
        return "http://naaccr.org/naaccrxml/user-defined-naaccr-dictionary-" + version + ".xml";
    }

    public static NaaccrDictionary getBaseDictionaryByUri(String uri) {
        if (uri == null) {
            throw new IllegalStateException("URI is required for getting the base dictionary.");
        }
        return NaaccrXmlDictionaryUtils.getBaseDictionaryByVersion(NaaccrXmlDictionaryUtils.extractVersionFromUri(uri));
    }

    public static NaaccrDictionary getBaseDictionaryByVersion(String naaccrVersion) {
        if (naaccrVersion == null) {
            throw new IllegalStateException("Version is required for getting the base dictionary.");
        }
        if (!NaaccrFormat.isVersionSupported(naaccrVersion)) {
            throw new IllegalStateException("Unsupported base dictionary version: " + naaccrVersion);
        }
        NaaccrDictionary result = _INTERNAL_DICTIONARIES.get("base_" + naaccrVersion);
        if (result == null) {
            String resName = "naaccr-dictionary-" + naaccrVersion + ".xml";
            try (InputStreamReader reader = new InputStreamReader(Thread.currentThread().getContextClassLoader().getResource(resName).openStream(), StandardCharsets.UTF_8);){
                result = NaaccrXmlDictionaryUtils.readDictionary(reader);
                _INTERNAL_DICTIONARIES.put("base_" + naaccrVersion, result);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to load base dictionary for version " + naaccrVersion, e);
            }
        }
        return result;
    }

    public static NaaccrDictionary getDefaultUserDictionaryByUri(String uri) {
        if (uri == null) {
            throw new IllegalStateException("URI is required for getting the default user dictionary.");
        }
        return NaaccrXmlDictionaryUtils.getDefaultUserDictionaryByVersion(NaaccrXmlDictionaryUtils.extractVersionFromUri(uri));
    }

    public static NaaccrDictionary getDefaultUserDictionaryByVersion(String naaccrVersion) {
        if (naaccrVersion == null) {
            throw new IllegalStateException("Version is required for getting the default user dictionary.");
        }
        if (!NaaccrFormat.isVersionSupported(naaccrVersion)) {
            throw new IllegalStateException("Unsupported default user dictionary version: " + naaccrVersion);
        }
        if (Integer.parseInt(naaccrVersion) >= 220) {
            return null;
        }
        NaaccrDictionary result = _INTERNAL_DICTIONARIES.get("user_" + naaccrVersion);
        if (result == null) {
            String resName = "user-defined-naaccr-dictionary-" + naaccrVersion + ".xml";
            try (InputStreamReader reader = new InputStreamReader(Thread.currentThread().getContextClassLoader().getResource(resName).openStream(), StandardCharsets.UTF_8);){
                result = NaaccrXmlDictionaryUtils.readDictionary(reader);
                _INTERNAL_DICTIONARIES.put("user_" + naaccrVersion, result);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to get base dictionary for version " + naaccrVersion, e);
            }
        }
        return result;
    }

    public static boolean isBaseDictionary(NaaccrDictionary dictionary) {
        return BASE_DICTIONARY_URI_PATTERN.matcher(dictionary.getDictionaryUri()).matches();
    }

    public static boolean isDefaultUserDictionary(NaaccrDictionary dictionary) {
        String version = dictionary.getNaaccrVersion();
        return DEFAULT_USER_DICTIONARY_URI_PATTERN.matcher(dictionary.getDictionaryUri()).matches() && (version == null || version.compareTo("210") <= 0);
    }

    public static void clearCachedDictionaries() {
        _INTERNAL_DICTIONARIES.clear();
    }

    public static NaaccrDictionary readDictionary(File file) throws IOException {
        if (file == null) {
            throw new IOException("File is required to load dictionary.");
        }
        if (!file.exists()) {
            throw new IOException("File must exist to load dictionary.");
        }
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            NaaccrDictionary naaccrDictionary = NaaccrXmlDictionaryUtils.readDictionary(reader);
            return naaccrDictionary;
        }
    }

    public static NaaccrDictionary readDictionary(Reader reader) throws IOException {
        try {
            List<String> errors;
            String uri;
            NaaccrDictionary dictionary = (NaaccrDictionary)NaaccrXmlDictionaryUtils.instanciateXStream().fromXML(reader);
            if (dictionary.getSpecificationVersion() == null) {
                dictionary.setSpecificationVersion("1.0");
            }
            if (dictionary.getItems() != null) {
                for (NaaccrDictionaryItem item : dictionary.getItems()) {
                    if (StringUtils.isBlank((CharSequence)item.getRecordTypes())) {
                        item.setRecordTypes("A,M,C,I");
                    }
                    if (StringUtils.isBlank((CharSequence)item.getDataType())) {
                        item.setDataType(NAACCR_DATA_TYPE_TEXT);
                    }
                    if (StringUtils.isBlank((CharSequence)item.getPadding())) {
                        item.setPadding("none");
                    }
                    if (!StringUtils.isBlank((CharSequence)item.getTrim()) || SpecificationVersion.compareSpecifications(dictionary.getSpecificationVersion(), "1.7") >= 0) continue;
                    item.setTrim(NAACCR_TRIM_ALL);
                }
            }
            if ((uri = dictionary.getDictionaryUri()) == null || uri.trim().isEmpty()) {
                throw new IOException("'dictionaryUri' attribute is required");
            }
            if (!(BASE_DICTIONARY_URI_PATTERN.matcher(uri).matches() || DEFAULT_USER_DICTIONARY_URI_PATTERN.matcher(uri).matches() || (errors = NaaccrXmlDictionaryUtils.validateUserDictionary(dictionary)).isEmpty())) {
                throw new IOException(errors.get(0));
            }
            return dictionary;
        }
        catch (XStreamException ex) {
            throw new IOException("Unable to read dictionary", ex);
        }
    }

    public static void writeDictionary(NaaccrDictionary dictionary, File file) throws IOException {
        NaaccrXmlDictionaryUtils.writeDictionary(dictionary, file, null);
    }

    public static void writeDictionary(NaaccrDictionary dictionary, File file, List<String> comment) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            NaaccrXmlDictionaryUtils.writeDictionary(dictionary, writer, comment);
        }
    }

    public static void writeDictionary(NaaccrDictionary dictionary, Writer writer) throws IOException {
        NaaccrXmlDictionaryUtils.writeDictionary(dictionary, writer, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeDictionary(NaaccrDictionary dictionary, Writer writer, List<String> comment) throws IOException {
        block18: {
            if (dictionary == null) {
                throw new IllegalStateException("Provided dictionary cannot be null");
            }
            if (NaaccrXmlDictionaryUtils.isBaseDictionary(dictionary)) {
                if (comment != null) {
                    throw new IllegalStateException("Comment cannot be provided when writing a base dictionary!");
                }
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("changelog/changelog-naaccr-dictionary-" + dictionary.getNaaccrVersion() + ".txt");){
                    if (is == null) break block18;
                    comment = new ArrayList<String>();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                        String line = reader.readLine();
                        while (line != null) {
                            comment.add(line);
                            line = reader.readLine();
                        }
                        break block18;
                    }
                }
            }
            if (!NaaccrXmlDictionaryUtils.isDefaultUserDictionary(dictionary)) {
                dictionary.setDateLastModified(new Date());
            }
        }
        try {
            NaaccrXmlDictionaryUtils.instanciateXStream().marshal((Object)dictionary, (HierarchicalStreamWriter)new NaaccrPrettyPrintWriter(dictionary, writer, comment));
            return;
        }
        catch (XStreamException ex) {
            throw new IOException("Unable to write dictionary", ex);
        }
    }

    public static List<String> validateBaseDictionary(NaaccrDictionary dictionary) {
        return NaaccrXmlDictionaryUtils.validateDictionary(dictionary, true, null);
    }

    public static List<String> validateUserDictionary(NaaccrDictionary dictionary) {
        return NaaccrXmlDictionaryUtils.validateDictionary(dictionary, false, null);
    }

    public static List<String> validateUserDictionary(NaaccrDictionary dictionary, String naaccrVersion) {
        return NaaccrXmlDictionaryUtils.validateDictionary(dictionary, false, naaccrVersion);
    }

    private static List<String> validateDictionary(NaaccrDictionary dictionary, boolean isBaseDictionary, String naaccrVersion) {
        NaaccrDictionary defaultUserDictionary;
        boolean versionSupportsStartColumns;
        boolean allowBlankNaaccrVersion;
        String specVersion;
        ArrayList<String> errors = new ArrayList<String>();
        String string = specVersion = dictionary.getSpecificationVersion() == null ? "1.0" : dictionary.getSpecificationVersion();
        if (!SpecificationVersion.isSpecificationSupported(specVersion)) {
            errors.add("'specificationVersion' attribute is not supported: " + specVersion);
        }
        if (dictionary.getDictionaryUri() == null || dictionary.getDictionaryUri().trim().isEmpty()) {
            errors.add("'dictionaryUri' attribute is required");
        }
        boolean bl = allowBlankNaaccrVersion = !isBaseDictionary && SpecificationVersion.compareSpecifications(specVersion, "1.1") >= 0;
        if (!allowBlankNaaccrVersion && (dictionary.getNaaccrVersion() == null || dictionary.getNaaccrVersion().trim().isEmpty())) {
            errors.add("'naaccrVersion' attribute is required");
        }
        if (dictionary.getNaaccrVersion() != null && !NaaccrFormat.isVersionSupported(dictionary.getNaaccrVersion())) {
            errors.add("'naaccrVersion' attribute is not valid: " + dictionary.getNaaccrVersion());
        }
        String naaccrVersionToUse = dictionary.getNaaccrVersion() == null ? naaccrVersion : dictionary.getNaaccrVersion();
        boolean bl2 = versionSupportsStartColumns = !NumberUtils.isDigits((String)naaccrVersionToUse) || Integer.parseInt(naaccrVersionToUse) <= 180;
        if (dictionary.getItems().isEmpty()) {
            errors.add("a dictionary must contain at least one item definition");
        }
        Pattern idPattern = Pattern.compile("^[a-z][a-zA-Z0-9]+$");
        HashSet<String> naaccrIds = new HashSet<String>();
        HashSet<Integer> naaccrNums = new HashSet<Integer>();
        for (NaaccrDictionaryItem item : dictionary.getItems()) {
            String type;
            if (item.getNaaccrId() == null || item.getNaaccrId().trim().isEmpty()) {
                errors.add("'naaccrId' attribute is required");
            } else if (!idPattern.matcher(item.getNaaccrId()).matches()) {
                errors.add("'naaccrId' attribute has a bad format (needs to start with a lower case letter, followed by letters and digits): " + item.getNaaccrId());
            } else if (item.getNaaccrId().length() > 32) {
                errors.add("'naaccrId' attribute can only be 32 characters long: " + item.getNaaccrId());
            } else if (naaccrIds.contains(item.getNaaccrId())) {
                errors.add("'naaccrId' attribute must be unique, already saw " + item.getNaaccrId());
            }
            naaccrIds.add(item.getNaaccrId());
            if (item.getNaaccrNum() == null) {
                errors.add("'naaccrNum' attribute is required");
            } else if (naaccrNums.contains(item.getNaaccrNum())) {
                errors.add("'naaccrNum' attribute must be unique, already saw " + item.getNaaccrNum());
            }
            naaccrNums.add(item.getNaaccrNum());
            if (item.getNaaccrName() != null && item.getNaaccrName().length() > 50) {
                errors.add("'naaccrName' attribute can only be 50 characters long: " + item.getNaaccrName());
            }
            if (item.getLength() == null) {
                errors.add("'length' attribute is required");
            }
            if (!versionSupportsStartColumns && item.getStartColumn() != null) {
                errors.add("'startColumn' attribute is not allowed");
            }
            if (isBaseDictionary && versionSupportsStartColumns && item.getStartColumn() == null) {
                errors.add("'startColumn' attribute is required");
            }
            if (!isBaseDictionary && SpecificationVersion.compareSpecifications(specVersion, "1.1") < 0 && item.getStartColumn() == null) {
                errors.add("'startColumn' attribute is required");
            }
            if (item.getParentXmlElement() == null || item.getParentXmlElement().trim().isEmpty()) {
                errors.add("'parentXmlElement' attribute is required");
            } else if (!("NaaccrData".equals(item.getParentXmlElement()) || "Patient".equals(item.getParentXmlElement()) || "Tumor".equals(item.getParentXmlElement()))) {
                errors.add("invalid value for 'parentXmlElement' attribute: " + item.getParentXmlElement());
            }
            if (item.getRecordTypes() != null && !item.getRecordTypes().matches("[AMCI](,[AMCI])*")) {
                errors.add("invalid value for 'recordTypes' attribute: " + item.getRecordTypes());
            }
            if (!((type = item.getDataType()) == null || NAACCR_DATA_TYPE_ALPHA.equals(type) || NAACCR_DATA_TYPE_DIGITS.equals(type) || NAACCR_DATA_TYPE_MIXED.equals(type) || NAACCR_DATA_TYPE_NUMERIC.equals(type) || NAACCR_DATA_TYPE_TEXT.equals(type) || NAACCR_DATA_TYPE_DATE.equals(type))) {
                errors.add("invalid value for 'dataType' attribute: " + item.getDataType());
            }
            if (item.getAllowUnlimitedText() != null && SpecificationVersion.compareSpecifications(specVersion, "1.6") >= 0) {
                errors.add("invalid attribute 'allowUnlimitedText'");
            } else if (Boolean.TRUE.equals(item.getAllowUnlimitedText()) && !NAACCR_DATA_TYPE_TEXT.equals(type)) {
                errors.add("allowUnlimitedText attribute can only be used with text data type");
            }
            if (item.getPadding() != null) {
                if (!(NAACCR_PADDING_LEFT_BLANK.equals(item.getPadding()) || NAACCR_PADDING_LEFT_ZERO.equals(item.getPadding()) || NAACCR_PADDING_RIGHT_BLANK.equals(item.getPadding()) || NAACCR_PADDING_RIGHT_ZERO.equals(item.getPadding()) || "none".equals(item.getPadding()))) {
                    errors.add("invalid value for 'padding' attribute: " + item.getPadding());
                }
                if (SpecificationVersion.compareSpecifications(specVersion, "1.7") >= 0 && !NAACCR_PADDING_LEFT_ZERO.equals(item.getPadding()) && !"none".equals(item.getPadding())) {
                    errors.add("invalid value for 'padding' attribute: " + item.getPadding() + " (valid values are '" + NAACCR_PADDING_LEFT_ZERO + "' and '" + "none" + "')");
                }
            }
            if (item.getTrim() != null) {
                if (!NAACCR_TRIM_ALL.equals(item.getTrim()) && !"none".equals(item.getTrim())) {
                    errors.add("invalid value for 'trim' attribute: " + item.getTrim());
                }
                if (SpecificationVersion.compareSpecifications(specVersion, "1.7") >= 0 && !"none".equals(item.getPadding())) {
                    errors.add("attribute 'trim' has been retired as of specifications 1.7");
                }
            }
            if (item.getRegexValidation() == null) continue;
            if (SpecificationVersion.compareSpecifications(specVersion, "1.2") >= 0) {
                errors.add("invalid attribute 'regexValidation'");
                continue;
            }
            try {
                Pattern.compile(item.getRegexValidation());
            }
            catch (PatternSyntaxException e) {
                errors.add("invalid value for 'regexValidation' attribute: " + item.getRegexValidation());
            }
        }
        if (isBaseDictionary) {
            if (!dictionary.getGroupedItems().isEmpty() && SpecificationVersion.compareSpecifications(specVersion, "1.6") >= 0) {
                errors.add("grouped items are not supported anymore");
            } else {
                for (NaaccrDictionaryGroupedItem groupedItem : dictionary.getGroupedItems()) {
                    if (groupedItem.getNaaccrId() == null || groupedItem.getNaaccrId().trim().isEmpty()) {
                        errors.add("'naaccrId' attribute is required");
                    } else if (!idPattern.matcher(groupedItem.getNaaccrId()).matches()) {
                        errors.add("'naaccrId' attribute has a bad format (needs to start with a lower case letter, followed by letters and digits): " + groupedItem.getNaaccrId());
                    } else if (naaccrIds.contains(groupedItem.getNaaccrId())) {
                        errors.add("'naaccrId' attribute for grouped item " + groupedItem.getNaaccrId() + " is not unique");
                    }
                    naaccrIds.add(groupedItem.getNaaccrId());
                    if (groupedItem.getNaaccrNum() == null) {
                        errors.add("'naaccrNum' attribute for grouped item " + groupedItem.getNaaccrId() + " is missing");
                    } else if (naaccrNums.contains(groupedItem.getNaaccrNum())) {
                        errors.add("'naaccrNum' attribute for grouped item " + groupedItem.getNaaccrId() + " must be unique, already saw " + groupedItem.getNaaccrNum());
                    }
                    naaccrNums.add(groupedItem.getNaaccrNum());
                    if (groupedItem.getStartColumn() == null) continue;
                    for (int idx = 0; idx < groupedItem.getContainedItemId().size(); ++idx) {
                        NaaccrDictionaryItem containedItem = dictionary.getItemByNaaccrId(groupedItem.getContainedItemId().get(idx));
                        if (containedItem == null) {
                            errors.add("grouped item " + groupedItem.getNaaccrId() + " references unknown item " + groupedItem.getContainedItemId().get(idx));
                            continue;
                        }
                        if (idx != 0 || groupedItem.getStartColumn().equals(containedItem.getStartColumn())) continue;
                        errors.add("'startColumn' attribute for grouped item " + groupedItem.getNaaccrId() + " is not consistent with first contained item");
                    }
                }
            }
        } else if (!dictionary.getGroupedItems().isEmpty()) {
            errors.add("user-defined dictionaries cannot defined grouped items");
        }
        if (!isBaseDictionary && naaccrVersionToUse != null && (defaultUserDictionary = NaaccrXmlDictionaryUtils.getDefaultUserDictionaryByVersion(naaccrVersionToUse)) != null) {
            NaaccrDictionary baseDictionary = NaaccrXmlDictionaryUtils.getBaseDictionaryByVersion(naaccrVersionToUse);
            List baseNumbers = baseDictionary.getItems().stream().map(NaaccrDictionaryItem::getNaaccrNum).collect(Collectors.toList());
            for (NaaccrDictionaryItem item : dictionary.getItems()) {
                boolean preVersion21;
                NaaccrDictionaryItem defaultUserItem;
                if (baseDictionary.getItemByNaaccrId(item.getNaaccrId()) != null) {
                    errors.add("invalid value for 'naaccrId' attribute: " + item.getNaaccrId() + "; this ID is used in the standard dictionary");
                }
                if ((defaultUserItem = defaultUserDictionary.getItemByNaaccrId(item.getNaaccrId())) != null) {
                    String itemType;
                    String defaultUserItemType;
                    if (!Objects.equals(defaultUserItem.getNaaccrNum(), item.getNaaccrNum())) {
                        errors.add("invalid value for 'naaccrNum' attribute of item '" + item.getNaaccrId() + "'; should be set to " + defaultUserItem.getNaaccrNum());
                    }
                    if (!Objects.equals(defaultUserItem.getNaaccrName(), item.getNaaccrName())) {
                        errors.add("invalid value for 'naaccrName' attribute of item '" + item.getNaaccrId() + "'; should be set to " + defaultUserItem.getNaaccrName());
                    }
                    if (item.getStartColumn() != null && defaultUserItem.getStartColumn() != null && !Objects.equals(defaultUserItem.getStartColumn(), item.getStartColumn())) {
                        errors.add("invalid value for 'startColumn' attribute of item '" + item.getNaaccrId() + "'; should be set to " + defaultUserItem.getStartColumn());
                    }
                    if (!Objects.equals(defaultUserItem.getLength(), item.getLength())) {
                        errors.add("invalid value for 'length' attribute of item '" + item.getNaaccrId() + "'; should be set to " + defaultUserItem.getLength());
                    }
                    if (!Objects.equals(defaultUserItem.getRecordTypes(), item.getRecordTypes())) {
                        errors.add("invalid value for 'recordTypes' attribute of item '" + item.getNaaccrId() + "'; should be set to " + defaultUserItem.getRecordTypes());
                    }
                    if (!Objects.equals(defaultUserItem.getParentXmlElement(), item.getParentXmlElement())) {
                        errors.add("invalid value for 'parentXmlElement' attribute of item '" + item.getNaaccrId() + "'; should be set to " + defaultUserItem.getParentXmlElement());
                    }
                    if (Objects.equals(defaultUserItemType = defaultUserItem.getDataType() == null ? NAACCR_DATA_TYPE_TEXT : defaultUserItem.getDataType(), itemType = item.getDataType() == null ? NAACCR_DATA_TYPE_TEXT : item.getDataType())) continue;
                    errors.add("invalid value for 'dataType' attribute of item '" + item.getNaaccrId() + "'; should be set to " + defaultUserItemType);
                    continue;
                }
                if (baseNumbers.contains(item.getNaaccrNum())) {
                    errors.add("invalid value for 'naaccrNum' attribute: " + item.getNaaccrNum() + "; number is already defined in corresponding base dictionary");
                }
                if (SpecificationVersion.compareSpecifications(specVersion, "1.3") < 0 && (item.getNaaccrNum() < 9500 || item.getNaaccrNum() > 99999)) {
                    errors.add("invalid value for 'naaccrNum' attribute: " + item.getNaaccrNum() + "; allowed range is 9500-99999");
                }
                if (!(preVersion21 = NumberUtils.isDigits((String)naaccrVersionToUse) && Integer.parseInt(naaccrVersionToUse) < 210) || item.getStartColumn() == null) continue;
                boolean fallInAllowedRange = false;
                for (NaaccrDictionaryItem defaultItem : defaultUserDictionary.getItems()) {
                    if (item.getStartColumn() < defaultItem.getStartColumn() || item.getStartColumn() + item.getLength() > defaultItem.getStartColumn() + defaultItem.getLength()) continue;
                    fallInAllowedRange = true;
                    break;
                }
                if (fallInAllowedRange) continue;
                errors.add("invalid value for 'startColumn' and/or 'length' attributes; user-defined items can only override state requestor item, NPCR item, or reserved gaps");
            }
            if (versionSupportsStartColumns) {
                List sortedItems = dictionary.getItems().stream().filter(i -> i.getStartColumn() != null).sorted(Comparator.comparing(NaaccrDictionaryItem::getStartColumn)).collect(Collectors.toList());
                for (int i2 = 0; i2 < sortedItems.size() - 1; ++i2) {
                    NaaccrDictionaryItem item1 = (NaaccrDictionaryItem)sortedItems.get(i2);
                    NaaccrDictionaryItem item2 = (NaaccrDictionaryItem)sortedItems.get(i2 + 1);
                    if (item1.getStartColumn() + item1.getLength() - 1 < item2.getStartColumn()) continue;
                    errors.add("Item " + item1.getNaaccrId() + " and " + item2.getNaaccrId() + " are overlapping");
                }
            }
        }
        return errors;
    }

    public static List<String> validateDictionaries(NaaccrDictionary baseDictionary, Collection<NaaccrDictionary> userDictionaries) {
        ArrayList<String> errors = new ArrayList<String>(NaaccrXmlDictionaryUtils.validateBaseDictionary(baseDictionary));
        HashMap<String, NaaccrDictionary> cachedUserDictionaries = new HashMap<String, NaaccrDictionary>();
        for (NaaccrDictionary userDictionary : userDictionaries) {
            if (cachedUserDictionaries.containsKey(userDictionary.getDictionaryUri())) {
                errors.add("user-defined dictionaries must be unique; found multiple URI '" + userDictionary.getDictionaryUri() + "'");
            }
            cachedUserDictionaries.put(userDictionary.getDictionaryUri(), userDictionary);
        }
        HashMap<String, String> idsDejaVu = new HashMap<String, String>();
        HashMap<Integer, String> numbersDejaVue = new HashMap<Integer, String>();
        for (NaaccrDictionary userDictionary : userDictionaries) {
            errors.addAll(NaaccrXmlDictionaryUtils.validateUserDictionary(userDictionary, baseDictionary.getNaaccrVersion()));
            if (userDictionary.getNaaccrVersion() != null && !baseDictionary.getNaaccrVersion().equals(userDictionary.getNaaccrVersion())) {
                errors.add("user-defined dictionary '" + userDictionary.getDictionaryUri() + "' doesn't define the same version as the base dictionary");
            }
            String dictId = userDictionary.getDictionaryUri();
            for (NaaccrDictionaryItem item : userDictionary.getItems()) {
                if (baseDictionary.getItemByNaaccrId(item.getNaaccrId()) != null) {
                    errors.add("user-defined dictionary '" + dictId + "' cannot use same NAACCR ID as a base item: " + item.getNaaccrId());
                }
                if (baseDictionary.getItemByNaaccrNum(item.getNaaccrNum()) != null) {
                    errors.add("user-defined dictionary '" + dictId + "' cannot use same NAACCR Number as a base item: " + item.getNaaccrNum());
                }
                if (idsDejaVu.containsKey(item.getNaaccrId())) {
                    String existingItemDictId = (String)idsDejaVu.get(item.getNaaccrId());
                    NaaccrDictionaryItem existingItem = ((NaaccrDictionary)cachedUserDictionaries.get(existingItemDictId)).getItemByNaaccrId(item.getNaaccrId());
                    boolean sameAttributes = Objects.equals(item.getNaaccrName(), existingItem.getNaaccrName());
                    sameAttributes &= Objects.equals(item.getNaaccrNum(), existingItem.getNaaccrNum());
                    sameAttributes &= Objects.equals(item.getDataType(), existingItem.getDataType());
                    sameAttributes &= Objects.equals(item.getLength(), existingItem.getLength());
                    sameAttributes &= Objects.equals(item.getRecordTypes(), existingItem.getRecordTypes());
                    sameAttributes &= Objects.equals(item.getParentXmlElement(), existingItem.getParentXmlElement());
                    sameAttributes &= Objects.equals(item.getStartColumn(), existingItem.getStartColumn());
                    sameAttributes &= Objects.equals(item.getPadding(), existingItem.getPadding());
                    if (sameAttributes &= Objects.equals(item.getTrim(), existingItem.getTrim())) continue;
                    errors.add("user-defined dictionary '" + dictId + "' and '" + existingItemDictId + "' both  define NAACCR ID '" + item.getNaaccrId() + "'");
                    continue;
                }
                idsDejaVu.put(item.getNaaccrId(), dictId);
                if (numbersDejaVue.containsKey(item.getNaaccrNum())) {
                    errors.add("user-defined dictionary '" + dictId + "' and '" + (String)numbersDejaVue.get(item.getNaaccrNum()) + "' both  define NAACCR ID '" + item.getNaaccrNum() + "'");
                }
                numbersDejaVue.put(item.getNaaccrNum(), dictId);
            }
        }
        List items = NaaccrXmlDictionaryUtils.mergeDictionaries(baseDictionary, userDictionaries.toArray(new NaaccrDictionary[0])).getItems().stream().filter(i -> i.getStartColumn() != null).sorted(Comparator.comparing(NaaccrDictionaryItem::getStartColumn)).collect(Collectors.toList());
        NaaccrDictionaryItem currentItem = null;
        for (NaaccrDictionaryItem item : items) {
            if (currentItem != null && item.getStartColumn() <= currentItem.getStartColumn() + currentItem.getLength() - 1) {
                errors.add("user-defined dictionaries define overlapping columns for items '" + currentItem.getNaaccrId() + "' and '" + item.getNaaccrId() + "'");
            }
            currentItem = item;
        }
        return errors;
    }

    public static String createNaaccrIdFromItemName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        HashMap<String, String> romanNumerals = new HashMap<String, String>();
        romanNumerals.put("I", "1");
        romanNumerals.put("II", "2");
        romanNumerals.put("III", "3");
        romanNumerals.put("IV", "4");
        romanNumerals.put("V", "5");
        romanNumerals.put("VI", "6");
        romanNumerals.put("VII", "7");
        romanNumerals.put("VIII", "8");
        romanNumerals.put("IX", "9");
        String[] parts = StringUtils.split((String)name.replaceAll("\\s+|-+|/|_|\\.|&", " ").replaceAll("\\(.+\\)|[\\W&&[^\\s]]", ""), (char)' ');
        if (parts.length > 2 && romanNumerals.containsKey(parts[parts.length - 1]) && romanNumerals.containsKey(parts[parts.length - 2])) {
            String[] tmp = new String[parts.length + 1];
            System.arraycopy(parts, 0, tmp, 0, parts.length - 1);
            tmp[tmp.length - 2] = "to";
            tmp[tmp.length - 1] = parts[parts.length - 1];
            parts = tmp;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtils.uncapitalize((String)parts[0].toLowerCase()));
        for (int i = 1; i < parts.length; ++i) {
            if (romanNumerals.containsKey(parts[i])) {
                buf.append((String)romanNumerals.get(parts[i]));
                continue;
            }
            buf.append(StringUtils.capitalize((String)parts[i].toLowerCase()));
        }
        return buf.toString();
    }

    public static NaaccrDictionary getMergedDictionaries(String naaccrVersion) {
        NaaccrDictionary userDictionary = NaaccrXmlDictionaryUtils.getDefaultUserDictionaryByVersion(naaccrVersion);
        return userDictionary == null ? NaaccrXmlDictionaryUtils.mergeDictionaries(NaaccrXmlDictionaryUtils.getBaseDictionaryByVersion(naaccrVersion), new NaaccrDictionary[0]) : NaaccrXmlDictionaryUtils.mergeDictionaries(NaaccrXmlDictionaryUtils.getBaseDictionaryByVersion(naaccrVersion), userDictionary);
    }

    public static NaaccrDictionary mergeDictionaries(NaaccrDictionary baseDictionary, NaaccrDictionary ... userDictionaries) {
        if (baseDictionary == null) {
            throw new IllegalStateException("Base dictionary is required");
        }
        NaaccrDictionary result = new NaaccrDictionary();
        result.setNaaccrVersion(baseDictionary.getNaaccrVersion());
        result.setDictionaryUri(baseDictionary.getDictionaryUri() + "[merged]");
        result.setSpecificationVersion(baseDictionary.getSpecificationVersion());
        result.setDescription(baseDictionary.getDescription());
        ArrayList<NaaccrDictionaryItem> items = new ArrayList<NaaccrDictionaryItem>(baseDictionary.getItems());
        HashSet<String> processedIds = new HashSet<String>();
        for (NaaccrDictionary userDictionary : userDictionaries) {
            for (NaaccrDictionaryItem item : userDictionary.getItems()) {
                if (processedIds.contains(item.getNaaccrId())) continue;
                items.add(item);
                processedIds.add(item.getNaaccrId());
            }
        }
        items.sort(Comparator.comparing(NaaccrDictionaryItem::getNaaccrId));
        result.setItems(items);
        ArrayList<NaaccrDictionaryGroupedItem> groupedItems = new ArrayList<NaaccrDictionaryGroupedItem>(baseDictionary.getGroupedItems());
        for (NaaccrDictionary userDictionary : userDictionaries) {
            groupedItems.addAll(userDictionary.getGroupedItems());
        }
        groupedItems.sort(Comparator.comparing(NaaccrDictionaryItem::getNaaccrId));
        result.setGroupedItems(groupedItems);
        return result;
    }

    public static void writeDictionaryToCsv(NaaccrDictionary dictionary, File file) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.US_ASCII));){
            NaaccrXmlDictionaryUtils.writeDictionaryToCsv(dictionary, writer);
        }
    }

    public static void writeDictionaryToCsv(NaaccrDictionary dictionary, Writer writer) throws IOException {
        try {
            writer.write("NAACCR XML ID,NAACCR Number,Name,Start Column,Length,Record Types,Parent XML Element,Data Type");
            writer.write(System.lineSeparator());
            dictionary.getItems().stream().sorted(Comparator.comparing(NaaccrDictionaryItem::getNaaccrId)).forEach(item -> {
                try {
                    writer.write(item.getNaaccrId());
                    writer.write(",");
                    writer.write(item.getNaaccrNum() == null ? "" : item.getNaaccrNum().toString());
                    writer.write(",\"");
                    writer.write(item.getNaaccrName() == null ? "" : item.getNaaccrName());
                    writer.write("\",");
                    writer.write(item.getStartColumn() == null ? "" : item.getStartColumn().toString());
                    writer.write(",");
                    writer.write(item.getLength().toString());
                    writer.write(",\"");
                    writer.write(item.getRecordTypes() == null ? "" : item.getRecordTypes());
                    writer.write("\",");
                    writer.write(item.getParentXmlElement() == null ? "" : item.getParentXmlElement());
                    writer.write(",");
                    writer.write(item.getDataType() == null ? "" : item.getDataType());
                    writer.write(System.lineSeparator());
                }
                catch (IOException | RuntimeException ex1) {
                    throw new IllegalStateException(ex1);
                }
            });
        }
        catch (RuntimeException ex2) {
            throw new IOException(ex2);
        }
    }

    private static XStream instanciateXStream() {
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider()){

            protected void setupConverters() {
                this.registerConverter(new NaaccrDictionaryConverter());
            }
        };
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"com.imsweb.naaccrxml.**"}));
        xstream.alias("NaaccrDictionary", NaaccrDictionary.class);
        return xstream;
    }

    static {
        _NAACCR_DATA_TYPES_REGEX.put(NAACCR_DATA_TYPE_ALPHA, Pattern.compile("^[A-Z]+$"));
        _NAACCR_DATA_TYPES_REGEX.put(NAACCR_DATA_TYPE_DIGITS, Pattern.compile("^\\d+$"));
        _NAACCR_DATA_TYPES_REGEX.put(NAACCR_DATA_TYPE_MIXED, Pattern.compile("^[A-Z\\d]+$"));
        _NAACCR_DATA_TYPES_REGEX.put(NAACCR_DATA_TYPE_NUMERIC, Pattern.compile("^\\d+(\\.\\d+)?$"));
        _NAACCR_DATA_TYPES_REGEX.put(NAACCR_DATA_TYPE_DATE, Pattern.compile("^(18|19|20)\\d\\d((0[1-9]|1[012])(0[1-9]|[12]\\d|3[01])?)?$"));
        BASE_DICTIONARY_URI_PATTERN = Pattern.compile("http://naaccr\\.org/naaccrxml/naaccr-dictionary-(.+?)\\.xml");
        DEFAULT_USER_DICTIONARY_URI_PATTERN = Pattern.compile("http://naaccr\\.org/naaccrxml/user-defined-naaccr-dictionary-(.+?)\\.xml");
        _INTERNAL_DICTIONARIES = new ConcurrentHashMap<String, NaaccrDictionary>();
        _RENAMED_LONG_NAACCR_18_IDS = new HashMap<String, String>();
        _RENAMED_LONG_NAACCR_18_IDS.put("dateRegionalLymphNodeDissection", "dateRegionalLNDissection");
        _RENAMED_LONG_NAACCR_18_IDS.put("dateRegionalLymphNodeDissectionFlag", "dateRegionalLNDissectionFlag");
        _RENAMED_LONG_NAACCR_18_IDS.put("phase1RadiationExternalBeamPlanningTech", "phase1RadiationExternalBeamTech");
        _RENAMED_LONG_NAACCR_18_IDS.put("phase1RadiationPrimaryTreatmentVolume", "phase1RadiationPrimaryTxVolume");
        _RENAMED_LONG_NAACCR_18_IDS.put("phase1RadiationToDrainingLymphNodes", "phase1RadiationToDrainingLN");
        _RENAMED_LONG_NAACCR_18_IDS.put("phase2RadiationExternalBeamPlanningTech", "phase2RadiationExternalBeamTech");
        _RENAMED_LONG_NAACCR_18_IDS.put("phase2RadiationPrimaryTreatmentVolume", "phase2RadiationPrimaryTxVolume");
        _RENAMED_LONG_NAACCR_18_IDS.put("phase2RadiationToDrainingLymphNodes", "phase2RadiationToDrainingLN");
        _RENAMED_LONG_NAACCR_18_IDS.put("phase3RadiationExternalBeamPlanningTech", "phase3RadiationExternalBeamTech");
        _RENAMED_LONG_NAACCR_18_IDS.put("phase3RadiationPrimaryTreatmentVolume", "phase3RadiationPrimaryTxVolume");
        _RENAMED_LONG_NAACCR_18_IDS.put("phase3RadiationToDrainingLymphNodes", "phase3RadiationToDrainingLN");
        _RENAMED_LONG_NAACCR_18_IDS.put("radiationTreatmentDiscontinuedEarly", "radiationTxDiscontinuedEarly");
        _RENAMED_LONG_NAACCR_18_IDS.put("numberOfPhasesOfRadTreatmentToThisVolume", "numberPhasesOfRadTxToVolume");
        _RENAMED_LONG_NAACCR_18_IDS.put("npcrDerivedAjcc8TnmPostTherapyStgGrp", "npcrDerivedAjcc8TnmPostStgGrp");
        _RENAMED_LONG_NAACCR_18_IDS.put("chromosome1pLossOfHeterozygosity", "chromosome1pLossHeterozygosity");
        _RENAMED_LONG_NAACCR_18_IDS.put("chromosome19qLossOfHeterozygosity", "chromosome19qLossHeterozygosity");
        _RENAMED_LONG_NAACCR_18_IDS.put("bilirubinPretreatmentTotalLabValue", "bilirubinPretxTotalLabValue");
        _RENAMED_LONG_NAACCR_18_IDS.put("bilirubinPretreatmentUnitOfMeasure", "bilirubinPretxUnitOfMeasure");
        _RENAMED_LONG_NAACCR_18_IDS.put("creatininePretreatmentUnitOfMeasure", "creatininePretxUnitOfMeasure");
        _RENAMED_LONG_NAACCR_18_IDS.put("estrogenReceptorPercentPositiveOrRange", "estrogenReceptorPercntPosOrRange");
        _RENAMED_LONG_NAACCR_18_IDS.put("extranodalExtensionHeadAndNeckClinical", "extranodalExtensionHeadNeckClin");
        _RENAMED_LONG_NAACCR_18_IDS.put("extranodalExtensionHeadAndNeckPathological", "extranodalExtensionHeadNeckPath");
        _RENAMED_LONG_NAACCR_18_IDS.put("gestationalTrophoblasticPrognosticScoringIndex", "gestationalTrophoblasticPxIndex");
        _RENAMED_LONG_NAACCR_18_IDS.put("internationalNormalizedRatioForProthrombinTime", "iNRProthrombinTime");
        _RENAMED_LONG_NAACCR_18_IDS.put("ipsilateralAdrenalGlandInvolvement", "ipsilateralAdrenalGlandInvolve");
        _RENAMED_LONG_NAACCR_18_IDS.put("lnAssessmentMethodFemoralInguinal", "lnAssessMethodFemoralInguinal");
        _RENAMED_LONG_NAACCR_18_IDS.put("lnAssessmentMethodParaAortic", "lnAssessMethodParaaortic");
        _RENAMED_LONG_NAACCR_18_IDS.put("lnAssessmentMethodPelvic", "lnAssessMethodPelvic");
        _RENAMED_LONG_NAACCR_18_IDS.put("lnDistantAssessmentMethod", "lnDistantAssessMethod");
        _RENAMED_LONG_NAACCR_18_IDS.put("lnStatusFemoralInguinalParaAorticPelvic", "lnStatusFemorInguinParaaortPelv");
        _RENAMED_LONG_NAACCR_18_IDS.put("methylationOfO6MethylguanineMethyltransferase", "methylationOfO6MGMT");
        _RENAMED_LONG_NAACCR_18_IDS.put("oncotypeDxRecurrenceScoreInvasive", "oncotypeDxRecurrenceScoreInvasiv");
        _RENAMED_LONG_NAACCR_18_IDS.put("progesteroneReceptorPercentPositiveOrRange", "progesteroneRecepPrcntPosOrRange");
        _RENAMED_LONG_NAACCR_18_IDS.put("progesteroneReceptorSummary", "progesteroneRecepSummary");
        _RENAMED_LONG_NAACCR_18_IDS.put("progesteroneReceptorTotalAllredScore", "progesteroneRecepTotalAllredScor");
        _RENAMED_LONG_NAACCR_18_IDS.put("residualTumorVolumePostCytoreduction", "residualTumVolPostCytoreduction");
        _RENAMED_LONG_NAACCR_18_IDS.put("serumBeta2MicroglobulinPretreatmentLevel", "serumBeta2MicroglobulinPretxLvl");
        _RENAMED_LONG_NAACCR_18_IDS.put("visceralAndParietalPleuralInvasion", "visceralParietalPleuralInvasion");
        _RENAMED_LONG_NAACCR_18_IDS.put("dateOfSentinelLymphNodeBiopsy", "dateSentinelLymphNodeBiopsy");
        _PAT_TO_TUM_CHANGED_18_21_IDS = Arrays.asList("dateOfLastCancerStatus", "dateOfLastCancerStatusFlag");
    }

    private static class NaaccrPrettyPrintWriter
    extends PrettyPrintWriter {
        private final NaaccrDictionary _dictionary;
        private QuickWriter _internalWriter;
        private String _currentItemId;

        public NaaccrPrettyPrintWriter(NaaccrDictionary dictionary, Writer writer, List<String> comment) {
            super(writer, new char[]{' ', ' ', ' ', ' '});
            this._dictionary = dictionary;
            this._currentItemId = null;
            try {
                writer.write("<?xml version=\"1.0\"?>\n\n");
                if (NaaccrXmlDictionaryUtils.isBaseDictionary(dictionary) || NaaccrXmlDictionaryUtils.isDefaultUserDictionary(dictionary)) {
                    writer.write("<!-- This dictionary is maintained and provided by the NAACCR organization; it should not be modified.\n");
                    writer.write("     If you need to define additional data items, please create your own user-defined dictionary.\n");
                    writer.write("     Visit https://www.naaccr.org/ for more information about the NAACCR XML Data Exchange Standard. -->\n\n");
                }
                if (NaaccrXmlDictionaryUtils.isBaseDictionary(dictionary) && comment != null && !comment.isEmpty()) {
                    for (String line : comment) {
                        writer.write(line);
                        writer.write("\n");
                    }
                    writer.write("\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void writeAttributeValue(QuickWriter writer, String text) {
            super.writeAttributeValue(writer, text);
            if (this._internalWriter == null) {
                this._internalWriter = writer;
            }
        }

        public void startNode(String name) {
            super.startNode(name);
            this._currentItemId = null;
        }

        public void addAttribute(String key, String value) {
            if ("dataType".equals(key) && NaaccrXmlDictionaryUtils.NAACCR_DATA_TYPE_TEXT.equals(value)) {
                return;
            }
            if ("padding".equals(key) && (NaaccrXmlDictionaryUtils.NAACCR_PADDING_RIGHT_BLANK.equals(value) || "none".equals(value))) {
                return;
            }
            if ("trim".equals(key) && NaaccrXmlDictionaryUtils.NAACCR_TRIM_ALL.equals(value)) {
                return;
            }
            super.addAttribute(key, value);
            if ("naaccrId".equals(key)) {
                this._currentItemId = value;
            }
            if (!this.isLastAttribute(key)) {
                this._internalWriter.write("\n           ");
            }
        }

        private boolean isLastAttribute(String attribute) {
            if ("xmlns".equals(attribute)) {
                return true;
            }
            NaaccrDictionaryItem item = this._dictionary.getItemByNaaccrId(this._currentItemId);
            if (item == null) {
                item = this._dictionary.getGroupedItemByNaaccrId(this._currentItemId);
            }
            if (item == null) {
                return false;
            }
            if (item instanceof NaaccrDictionaryGroupedItem) {
                return "contains".equals(attribute);
            }
            if (item.getTrim() != null && !NaaccrXmlDictionaryUtils.NAACCR_TRIM_ALL.equals(item.getTrim())) {
                return "trim".equals(attribute);
            }
            if (item.getPadding() != null && !NaaccrXmlDictionaryUtils.NAACCR_PADDING_RIGHT_BLANK.equals(item.getPadding()) && !"none".equals(item.getPadding())) {
                return "padding".equals(attribute);
            }
            if (item.getRegexValidation() != null) {
                return "regexValidation".equals(attribute);
            }
            if (item.getDataType() != null && !NaaccrXmlDictionaryUtils.NAACCR_DATA_TYPE_TEXT.equals(item.getDataType())) {
                return "dataType".equals(attribute);
            }
            return item.getParentXmlElement() != null && "parentXmlElement".equals(attribute);
        }
    }
}

