/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.sas;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class SasGzipOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();
    private static final int GZIP_MAGIC = 35615;
    private static final int TRAILER_SIZE = 8;
    private static final byte OS_UNKNOWN = -1;

    public SasGzipOutputStream(OutputStream out) throws IOException {
        super(out, new Deflater(1, true), 65536, false);
        this.writeHeader();
        this.crc.reset();
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.crc.update(buf, off, len);
    }

    @Override
    public void finish() throws IOException {
        if (!this.def.finished()) {
            try {
                this.def.finish();
                while (!this.def.finished()) {
                    int len = this.def.deflate(this.buf, 0, this.buf.length);
                    if (this.def.finished() && len <= this.buf.length - 8) {
                        this.writeTrailer(this.buf, len);
                        this.out.write(this.buf, 0, len += 8);
                        return;
                    }
                    if (len <= 0) continue;
                    this.out.write(this.buf, 0, len);
                }
                byte[] trailer = new byte[8];
                this.writeTrailer(trailer, 0);
                this.out.write(trailer);
            }
            catch (IOException e) {
                this.def.end();
                throw e;
            }
        }
    }

    private void writeHeader() throws IOException {
        this.out.write(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, -1});
    }

    private void writeTrailer(byte[] buf, int offset) {
        this.writeInt((int)this.crc.getValue(), buf, offset);
        this.writeInt(this.def.getTotalIn(), buf, offset + 4);
    }

    private void writeInt(int i, byte[] buf, int offset) {
        this.writeShort(i & 0xFFFF, buf, offset);
        this.writeShort(i >> 16 & 0xFFFF, buf, offset + 2);
    }

    private void writeShort(int s, byte[] buf, int offset) {
        buf[offset] = (byte)(s & 0xFF);
        buf[offset + 1] = (byte)(s >> 8 & 0xFF);
    }
}

