/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.sas;

import com.imsweb.naaccrxml.sas.SasFieldInfo;
import com.imsweb.naaccrxml.sas.SasGzipOutputStream;
import com.imsweb.naaccrxml.sas.SasUtils;
import com.imsweb.naaccrxml.sas.SasXmlReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class SasXmlToFlat {
    private File _xmlFile;
    private File _flatFile;
    private File _formatFile;
    private List<File> _dictionaryFiles;
    private String _naaccrVersion;
    private String _recordType;
    private boolean _compressTempFile;
    private boolean _includeGroupedItems;

    public SasXmlToFlat(String xmlPath) {
        this(xmlPath, "no");
    }

    public SasXmlToFlat(String xmlPath, String gzipOption) {
        this.initFiles(xmlPath, "yes".equalsIgnoreCase(gzipOption), false);
    }

    public SasXmlToFlat(String xmlPath, String naaccrVersion, String recordType) {
        this(xmlPath, naaccrVersion, recordType, "no");
    }

    public SasXmlToFlat(String xmlPath, String naaccrVersion, String recordType, String gzipOption) {
        this.initFiles(xmlPath, "yes".equalsIgnoreCase(gzipOption), true);
        this._dictionaryFiles = new ArrayList<File>();
        this._naaccrVersion = naaccrVersion;
        if (this._naaccrVersion == null || this._naaccrVersion.trim().isEmpty()) {
            SasUtils.logError("NAACCR version needs to be provided");
        }
        if (!("140".equals(naaccrVersion) || "150".equals(naaccrVersion) || "160".equals(naaccrVersion) || "180".equals(naaccrVersion) || "210".equals(naaccrVersion) || "220".equals(naaccrVersion) || "230".equals(naaccrVersion) || "240".equals(naaccrVersion))) {
            SasUtils.logError("NAACCR version must be 140, 150, 160, 180, 210, 220, 230 or 240; got " + this._naaccrVersion);
        }
        this._recordType = recordType;
        if (this._recordType == null || this._recordType.trim().isEmpty()) {
            SasUtils.logError("Record type needs to be provided");
        }
        if (!("A".equals(this._recordType) || "M".equals(this._recordType) || "C".equals(this._recordType) || "I".equals(this._recordType))) {
            SasUtils.logError("Record type must be A, M, C or I; got " + this._recordType);
        }
        this._includeGroupedItems = false;
    }

    private void initFiles(String xmlPath, boolean compress, boolean logInfo) {
        this._compressTempFile = compress;
        if (xmlPath == null || xmlPath.trim().isEmpty()) {
            SasUtils.logError("No source XML path was provided");
        } else {
            this._xmlFile = new File(xmlPath);
            if (!this._xmlFile.exists()) {
                SasUtils.logError("Invalid source XML file: " + xmlPath);
            } else if (logInfo) {
                SasUtils.logInfo("Source XML: " + this._xmlFile.getAbsolutePath());
            }
            this._flatFile = new File(SasUtils.computeFlatPathFromXmlPath(xmlPath, compress));
            if (!new File(this._flatFile.getAbsolutePath()).getParentFile().exists()) {
                SasUtils.logError("Parent directory for target XML file doesn't exist: " + this._flatFile.getParentFile().getAbsolutePath());
            } else if (logInfo) {
                SasUtils.logInfo("Target temp flat: " + this._flatFile.getAbsolutePath());
            }
            this._formatFile = new File(SasUtils.computeInputPathFromXmlPath(xmlPath));
            if (new File(this._formatFile.getAbsolutePath()).getParentFile().exists() && logInfo) {
                SasUtils.logInfo("Target input format: " + this._formatFile.getAbsolutePath());
            }
        }
    }

    public void setDictionary(String dictionaryPath) {
        if (dictionaryPath != null && !dictionaryPath.trim().isEmpty()) {
            for (String path : dictionaryPath.split(";")) {
                File dictionaryFile = new File(path.trim());
                if (!dictionaryFile.exists()) {
                    SasUtils.logError("Invalid CSV dictionary path: " + path);
                    continue;
                }
                try {
                    SasUtils.validateCsvDictionary(dictionaryFile);
                    this._dictionaryFiles.add(dictionaryFile);
                    SasUtils.logInfo("Dictionary: " + dictionaryFile.getAbsolutePath());
                }
                catch (IOException e) {
                    SasUtils.logError("Invalid CSV dictionary: " + e.getMessage());
                }
            }
        }
    }

    public String getXmlPath() {
        return this._xmlFile.getAbsolutePath();
    }

    public String getFlatPath() {
        return this._flatFile.getAbsolutePath();
    }

    public String getFormatPath() {
        return this._formatFile.getAbsolutePath();
    }

    public String getDictionaryPath() {
        StringBuilder buf = new StringBuilder();
        for (File dictionaryFile : this._dictionaryFiles) {
            if (buf.length() > 0) {
                buf.append(";");
            }
            buf.append(dictionaryFile.getAbsolutePath());
        }
        return buf.toString();
    }

    List<File> getUserDictionaryFiles() {
        return this._dictionaryFiles;
    }

    public String getNaaccrVersion() {
        return this._naaccrVersion;
    }

    public String getRecordType() {
        return this._recordType;
    }

    public List<SasFieldInfo> getFields() {
        return SasUtils.getFields(this._naaccrVersion, this._recordType, this._dictionaryFiles);
    }

    public void setIncludeGroupedItems(String option) {
        if ("yes".equalsIgnoreCase(option)) {
            this._includeGroupedItems = true;
        } else if (!"no".equalsIgnoreCase(option)) {
            SasUtils.logError("Invalid includeGroupItems option: " + option);
        }
    }

    public List<SasFieldInfo> getGroupedFields() {
        return SasUtils.getGroupedFields(this._naaccrVersion, this._recordType);
    }

    public void convert() throws IOException {
        this.convert(null);
    }

    public void convert(String fields) throws IOException {
        this.convert(fields, this.getFields());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convert(String fields, List<SasFieldInfo> availableFields) throws IOException {
        try {
            void var7_23;
            HashMap<String, SasFieldInfo> allFields;
            TreeMap<String, SasFieldInfo> fieldsToWrite;
            block27: {
                BufferedWriter bufferedWriter;
                Set<String> requestedFieldIds = SasUtils.extractRequestedFields(fields, availableFields);
                fieldsToWrite = new TreeMap<String, SasFieldInfo>();
                for (SasFieldInfo sasFieldInfo : availableFields) {
                    if (requestedFieldIds != null && !requestedFieldIds.contains(sasFieldInfo.getNaaccrId())) continue;
                    fieldsToWrite.put(sasFieldInfo.getNaaccrId(), sasFieldInfo);
                    if (sasFieldInfo.getNaaccrId().equals(sasFieldInfo.getTruncatedNaaccrId())) continue;
                    SasUtils.logInfo("Truncated '" + sasFieldInfo.getNaaccrId() + "' into '" + sasFieldInfo.getTruncatedNaaccrId() + "'...");
                }
                allFields = null;
                if (this._includeGroupedItems) {
                    for (SasFieldInfo sasFieldInfo : this.getGroupedFields()) {
                        fieldsToWrite.put(sasFieldInfo.getNaaccrId(), sasFieldInfo);
                    }
                    allFields = new HashMap<String, SasFieldInfo>();
                    for (SasFieldInfo sasFieldInfo : availableFields) {
                        allFields.put(sasFieldInfo.getNaaccrId(), sasFieldInfo);
                    }
                }
                boolean bl = false;
                for (SasFieldInfo field : fieldsToWrite.values()) {
                    var6_13 += field.getLength().intValue();
                }
                SasUtils.logInfo("Generating input format file...");
                BufferedWriter bufferedWriter2 = null;
                try {
                    void var6_13;
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._formatFile), StandardCharsets.US_ASCII));
                    bufferedWriter.write("input\n");
                    int counter = 1;
                    for (Map.Entry entry : fieldsToWrite.entrySet()) {
                        bufferedWriter.write("@" + counter + " " + (String)entry.getKey() + " $" + ((SasFieldInfo)entry.getValue()).getLength() + ".\n");
                        counter += ((SasFieldInfo)entry.getValue()).getLength().intValue();
                    }
                    bufferedWriter.write(";");
                    SasUtils.logInfo("Successfully created input format file with " + fieldsToWrite.size() + " fields (variables) with total line length of " + (int)var6_13);
                    if (bufferedWriter == null) break block27;
                }
                catch (Throwable throwable) {
                    if (bufferedWriter2 == null) throw throwable;
                    bufferedWriter2.close();
                    throw throwable;
                }
                bufferedWriter.close();
            }
            SasUtils.logInfo("Starting converting XML to flat...");
            BufferedWriter bufferedWriter = null;
            try {
                if (this._compressTempFile) {
                    BufferedWriter bufferedWriter3 = new BufferedWriter(new OutputStreamWriter((OutputStream)new SasGzipOutputStream(new FileOutputStream(this._flatFile)), StandardCharsets.UTF_8));
                } else {
                    BufferedWriter bufferedWriter4 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._flatFile), StandardCharsets.UTF_8));
                }
                int count = 0;
                if (this._xmlFile.getName().toLowerCase().endsWith(".zip")) {
                    ZipFile zipFile = null;
                    ZipInputStream zipIs = null;
                    try {
                        int zipCount = 0;
                        zipFile = new ZipFile(this._xmlFile);
                        zipIs = new ZipInputStream(new FileInputStream(this._xmlFile));
                        ZipEntry entry = zipIs.getNextEntry();
                        while (entry != null) {
                            SasXmlReader reader = new SasXmlReader(SasUtils.createReader(zipFile.getInputStream(entry), entry.getName()));
                            count += this.convertSingleFile(reader, (BufferedWriter)var7_23, fieldsToWrite, allFields);
                            if (++zipCount > 10000) {
                                throw new IllegalStateException("Too many entries in ZIP file!");
                            }
                            entry = zipIs.getNextEntry();
                        }
                    }
                    finally {
                        if (zipIs != null) {
                            zipIs.close();
                        }
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                }
                try (SasXmlReader reader = null;){
                    reader = new SasXmlReader(SasUtils.createReader(this._xmlFile));
                    count += this.convertSingleFile(reader, (BufferedWriter)var7_23, fieldsToWrite, allFields);
                }
                SasUtils.logInfo("Successfully created flat file with " + count + " lines (observations)");
                if (var7_23 == null) return;
            }
            catch (Throwable throwable) {
                if (bufferedWriter == null) throw throwable;
                bufferedWriter.close();
                throw throwable;
            }
            var7_23.close();
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    private int convertSingleFile(SasXmlReader reader, BufferedWriter writer, Map<String, SasFieldInfo> fieldsToWrite, Map<String, SasFieldInfo> allFields) throws IOException {
        int count = 0;
        HashMap<Integer, String> cache1 = new HashMap<Integer, String>();
        for (SasFieldInfo field : fieldsToWrite.values()) {
            if (cache1.containsKey(field.getLength())) continue;
            cache1.put(field.getLength(), SasUtils.rightPadWithSpaces("", field.getLength()));
        }
        LinkedHashMap<Integer, String> cache2 = new LinkedHashMap<Integer, String>(1001, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, String> eldest) {
                return this.size() > 1000;
            }
        };
        StringBuilder buf = new StringBuilder(4000);
        while (reader.nextRecord() > 0) {
            for (Map.Entry<String, SasFieldInfo> entry : fieldsToWrite.entrySet()) {
                String val = null;
                if (entry.getValue().getContains() == null) {
                    val = reader.getValue(entry.getKey());
                } else {
                    StringBuilder childrenValue = new StringBuilder();
                    for (String child : entry.getValue().getContains()) {
                        SasFieldInfo childField = allFields.get(child);
                        if (childField == null) {
                            throw new IOException("Unable to find field definition for '" + child + "'");
                        }
                        String childValue = reader.getValue(child);
                        if (childValue == null) {
                            childValue = "";
                        }
                        childrenValue.append(childValue);
                        for (int i = 0; i < childField.getLength() - childValue.length(); ++i) {
                            childrenValue.append(" ");
                        }
                    }
                    val = childrenValue.toString();
                }
                if (val == null || val.isEmpty()) {
                    String paddedValue = (String)cache1.get(entry.getValue().getLength());
                    if (paddedValue == null) {
                        paddedValue = SasUtils.rightPadWithSpaces("", entry.getValue().getLength());
                    }
                    buf.append(paddedValue);
                    continue;
                }
                int remainingLength = entry.getValue().getLength() - val.length();
                if (remainingLength > 0) {
                    String remainingValue = (String)cache2.get(remainingLength);
                    if (remainingValue == null) {
                        remainingValue = SasUtils.rightPadWithSpaces("", remainingLength);
                        cache2.put(remainingLength, remainingValue);
                    }
                    buf.append(val).append(remainingValue);
                    continue;
                }
                buf.append(val);
            }
            writer.write(buf.toString());
            writer.write("\n");
            buf.setLength(0);
            ++count;
        }
        return count;
    }

    public void cleanup() {
        this.cleanup("yes");
    }

    public void cleanup(String option) {
        if ("no".equalsIgnoreCase(option)) {
            SasUtils.logInfo("Skipping temp files cleanup...");
        } else if (!this._flatFile.delete()) {
            SasUtils.logError("Unable to cleanup " + this._flatFile.getPath() + ", ity will have to be manually deleted...");
        } else if (!this._formatFile.delete()) {
            SasUtils.logError("Unable to cleanup " + this._formatFile.getPath() + ", ity will have to be manually deleted...");
        } else {
            SasUtils.logInfo("Successfully deleted temp files...");
        }
    }
}

