/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml;

import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrValidationError;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.PatientWriter;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.NaaccrData;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.runtime.NaaccrStreamConfiguration;
import com.imsweb.naaccrxml.runtime.RuntimeNaaccrDictionary;
import com.imsweb.naaccrxml.runtime.RuntimeNaaccrDictionaryItem;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PatientFlatWriter
implements PatientWriter {
    protected BufferedWriter _writer;
    protected NaaccrData _rootData;
    protected NaaccrOptions _options;
    protected RuntimeNaaccrDictionary _dictionary;
    protected RuntimeNaaccrDictionaryItem _naaccrVersionItem;
    protected RuntimeNaaccrDictionaryItem _recordTypeItem;
    protected String _newLine;
    private static final Pattern _NEW_LINES_PATTERN = Pattern.compile("(\r\n|\n|\r)");

    public PatientFlatWriter(Writer writer, NaaccrData data) throws NaaccrIOException {
        this(writer, data, null, (NaaccrDictionary)null, null);
    }

    public PatientFlatWriter(Writer writer, NaaccrData data, NaaccrOptions options) throws NaaccrIOException {
        this(writer, data, options, (NaaccrDictionary)null, null);
    }

    public PatientFlatWriter(Writer writer, NaaccrData data, NaaccrOptions options, NaaccrDictionary userDictionary) throws NaaccrIOException {
        this(writer, data, options, Collections.singletonList(userDictionary), null);
    }

    public PatientFlatWriter(Writer writer, NaaccrData data, NaaccrOptions options, List<NaaccrDictionary> userDictionaries) throws NaaccrIOException {
        this(writer, data, options, userDictionaries, null);
    }

    public PatientFlatWriter(Writer writer, NaaccrData data, NaaccrOptions options, NaaccrDictionary userDictionary, NaaccrStreamConfiguration conf) throws NaaccrIOException {
        this(writer, data, options, Collections.singletonList(userDictionary), conf);
    }

    public PatientFlatWriter(Writer writer, NaaccrData data, NaaccrOptions options, List<NaaccrDictionary> userDictionaries, NaaccrStreamConfiguration conf) throws NaaccrIOException {
        this._writer = new BufferedWriter(writer);
        this._rootData = data;
        NaaccrOptions naaccrOptions = this._options = options == null ? new NaaccrOptions() : options;
        this._newLine = "LF".equals(this._options.getNewLine()) ? "\n" : ("CRLF".equals(this._options.getNewLine()) ? "\r\n" : System.getProperty("line.separator"));
        RuntimeNaaccrDictionary runtimeNaaccrDictionary = this._dictionary = conf == null ? null : conf.getCachedDictionary();
        if (this._dictionary == null) {
            NaaccrDictionary baseDictionary = NaaccrXmlDictionaryUtils.getBaseDictionaryByUri(data.getBaseDictionaryUri());
            this._dictionary = new RuntimeNaaccrDictionary(data.getRecordType(), baseDictionary, userDictionaries);
        }
        if (this._dictionary.getLineLength() == null || this._dictionary.getLineLength() == -1) {
            throw new NaaccrIOException("version " + this._dictionary.getNaaccrVersion() + " does not support start columns and cannot be used with this flat writer");
        }
        for (RuntimeNaaccrDictionaryItem item : this._dictionary.getItems()) {
            if (item.getNaaccrId().equals("recordType")) {
                this._recordTypeItem = item;
            }
            if (item.getNaaccrId().equals("naaccrRecordVersion")) {
                this._naaccrVersionItem = item;
            }
            if (this._recordTypeItem == null || this._naaccrVersionItem == null) continue;
            break;
        }
    }

    @Override
    public void writePatient(Patient patient) throws NaaccrIOException {
        for (String line : this.createLinesFromPatient(this._rootData, patient)) {
            try {
                this._writer.write(line);
                this._writer.write(this._newLine);
            }
            catch (IOException e) {
                throw new NaaccrIOException(e.getMessage());
            }
        }
    }

    @Override
    public void closeAndKeepAlive() throws NaaccrIOException {
        try {
            this._writer.flush();
        }
        catch (IOException e) {
            throw new NaaccrIOException(e.getMessage());
        }
    }

    @Override
    public void close() throws NaaccrIOException {
        this.closeAndKeepAlive();
        try {
            this._writer.close();
        }
        catch (IOException e) {
            throw new NaaccrIOException(e.getMessage());
        }
    }

    public String getNewLine() {
        return this._newLine;
    }

    protected List<String> createLinesFromPatient(NaaccrData root, Patient patient) throws NaaccrIOException {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<Tumor> tumors = new ArrayList<Tumor>(patient.getTumors());
        if (tumors.isEmpty()) {
            tumors.add(new Tumor());
        }
        for (Tumor tumor : tumors) {
            int currentIndex = 1;
            StringBuilder line = new StringBuilder();
            for (RuntimeNaaccrDictionaryItem itemDef : this._dictionary.getItems()) {
                if (!NaaccrOptions.processItem(this._options, itemDef.getNaaccrId()) || itemDef.getStartColumn() == null || itemDef.getParentXmlElement() == null || itemDef.getStartColumn() == null || itemDef.getLength() == null) continue;
                int start = itemDef.getStartColumn();
                int length = itemDef.getLength();
                int end = start + length - 1;
                if (start > currentIndex) {
                    for (int i = 0; i < start - currentIndex; ++i) {
                        line.append(' ');
                    }
                }
                currentIndex = start;
                String value = this.getValueForItem(itemDef, root, patient, tumor, Boolean.TRUE.equals(this._options.getApplyZeroPaddingRules()));
                if (value != null) {
                    line.append(value);
                    currentIndex = start + value.length();
                }
                if (currentIndex <= end) {
                    for (int i = 0; i < end - currentIndex + 1; ++i) {
                        line.append(' ');
                    }
                }
                currentIndex = end + 1;
            }
            if (currentIndex <= this._dictionary.getLineLength()) {
                for (int i = 0; i < this._dictionary.getLineLength() - currentIndex + 1; ++i) {
                    line.append(' ');
                }
            }
            if (this._dictionary.getRecordType() != null && this._recordTypeItem != null) {
                line.replace(this._recordTypeItem.getStartColumn() - 1, this._recordTypeItem.getStartColumn() + this._recordTypeItem.getLength() - 1, this._dictionary.getRecordType());
            }
            if (this._dictionary.getNaaccrVersion() != null && this._naaccrVersionItem != null) {
                line.replace(this._naaccrVersionItem.getStartColumn() - 1, this._naaccrVersionItem.getStartColumn() + this._naaccrVersionItem.getLength() - 1, this._dictionary.getNaaccrVersion());
            }
            lines.add(line.toString());
        }
        return lines;
    }

    protected String getValueForItem(RuntimeNaaccrDictionaryItem itemDef, NaaccrData root, Patient patient, Tumor tumor, boolean applyZeroPadding) throws NaaccrIOException {
        AbstractEntity entityToUse;
        if ("NaaccrData".equals(itemDef.getParentXmlElement())) {
            entityToUse = root;
        } else if ("Patient".equals(itemDef.getParentXmlElement())) {
            entityToUse = patient;
        } else if ("Tumor".equals(itemDef.getParentXmlElement())) {
            entityToUse = tumor;
        } else {
            throw new NaaccrIOException("unsupported parent element: " + itemDef.getParentXmlElement());
        }
        String value = entityToUse.getItemValue(itemDef.getNaaccrId());
        if (value != null && !value.isEmpty() && itemDef.getLength() != null && itemDef.getPadding() != null && value.length() < itemDef.getLength()) {
            if ("leftBlank".equals(itemDef.getPadding())) {
                value = StringUtils.leftPad((String)value, (int)itemDef.getLength(), (char)' ');
            } else if ("rightBlank".equals(itemDef.getPadding())) {
                value = StringUtils.rightPad((String)value, (int)itemDef.getLength(), (char)' ');
            } else if ("leftZero".equals(itemDef.getPadding())) {
                if (applyZeroPadding) {
                    value = StringUtils.leftPad((String)value, (int)itemDef.getLength(), (char)'0');
                }
            } else if ("rightZero".equals(itemDef.getPadding())) {
                if (applyZeroPadding) {
                    value = StringUtils.rightPad((String)value, (int)itemDef.getLength(), (char)'0');
                }
            } else if (!"none".equals(itemDef.getPadding())) {
                throw new IllegalStateException("Unknown padding option: " + itemDef.getPadding());
            }
        }
        if (value != null && !value.isEmpty()) {
            value = _NEW_LINES_PATTERN.matcher(value).replaceAll(" ");
        }
        if (value != null && value.length() > itemDef.getLength()) {
            if (!Boolean.TRUE.equals(itemDef.getAllowUnlimitedText()) && Boolean.TRUE.equals(this._options.getReportValuesTooLong())) {
                this.reportError(entityToUse, itemDef, value, "Value too long", itemDef.getLength(), value.length());
            }
            value = value.substring(0, itemDef.getLength());
        }
        return value;
    }

    protected void reportError(AbstractEntity entity, RuntimeNaaccrDictionaryItem def, String value, String code, Object ... msgValues) {
        NaaccrValidationError error = new NaaccrValidationError(code, msgValues);
        if (def != null) {
            error.setNaaccrId(def.getNaaccrId());
            error.setNaaccrNum(def.getNaaccrNum());
        }
        if (value != null && !value.isEmpty()) {
            error.setValue(value);
        }
        entity.addValidationError(error);
    }
}

