/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.sas;

import com.imsweb.naaccrxml.sas.SasFieldInfo;
import com.imsweb.naaccrxml.sas.SasUtils;
import com.imsweb.naaccrxml.sas.SasXmlReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class SasXmlToCsv {
    private File _xmlFile;
    private File _csvFile;
    private List<File> _dictionaryFiles;
    private String _naaccrVersion;
    private String _recordType;
    private boolean _includeGroupedItems;

    public SasXmlToCsv(String xmlPath, String naaccrVersion, String recordType) {
        this(xmlPath, null, naaccrVersion, recordType);
    }

    public SasXmlToCsv(String xmlPath, String csvPath, String naaccrVersion, String recordType) {
        if (xmlPath == null || xmlPath.trim().isEmpty()) {
            SasUtils.logError("No source XML path was provided");
        } else {
            this._xmlFile = new File(xmlPath);
            if (!this._xmlFile.exists()) {
                SasUtils.logError("Invalid source XML file: " + xmlPath);
            } else {
                SasUtils.logInfo("Input XML: " + this._xmlFile.getAbsolutePath());
            }
            if (csvPath == null || csvPath.trim().isEmpty()) {
                csvPath = SasUtils.computeCsvPathFromXmlPath(xmlPath);
            }
            if (csvPath.equalsIgnoreCase(xmlPath)) {
                csvPath = xmlPath + ".csv";
            }
            this._csvFile = new File(csvPath);
            if (!new File(this._csvFile.getAbsolutePath()).getParentFile().exists()) {
                SasUtils.logError("Parent directory for CSV path doesn't exist: " + this._csvFile.getParentFile().getAbsolutePath());
            } else {
                SasUtils.logInfo("Target CSV: " + this._csvFile.getAbsolutePath());
            }
        }
        this._dictionaryFiles = new ArrayList<File>();
        this._naaccrVersion = naaccrVersion;
        if (this._naaccrVersion == null || this._naaccrVersion.trim().isEmpty()) {
            SasUtils.logError("NAACCR version needs to be provided");
        }
        if (!("140".equals(naaccrVersion) || "150".equals(naaccrVersion) || "160".equals(naaccrVersion) || "180".equals(naaccrVersion) || "210".equals(naaccrVersion) || "220".equals(naaccrVersion) || "230".equals(naaccrVersion) || "240".equals(naaccrVersion) || "250".equals(naaccrVersion))) {
            SasUtils.logError("NAACCR version must be 140, 150, 160, 180, 210, 220, 230, 240 or 250; got " + this._naaccrVersion);
        }
        this._recordType = recordType;
        if (this._recordType == null || this._recordType.trim().isEmpty()) {
            SasUtils.logError("Record type needs to be provided");
        }
        if (!("A".equals(this._recordType) || "M".equals(this._recordType) || "C".equals(this._recordType) || "I".equals(this._recordType))) {
            SasUtils.logError("Record type must be A, M, C or I; got " + this._recordType);
        }
        this._includeGroupedItems = false;
    }

    public void setDictionary(String dictionaryPath) {
        if (dictionaryPath != null && !dictionaryPath.trim().isEmpty()) {
            for (String path : dictionaryPath.split(";")) {
                File dictionaryFile = new File(path.trim());
                if (!dictionaryFile.exists()) {
                    SasUtils.logError("Invalid CSV dictionary path: " + path);
                    continue;
                }
                try {
                    SasUtils.validateCsvDictionary(dictionaryFile);
                    this._dictionaryFiles.add(dictionaryFile);
                    SasUtils.logInfo("Dictionary: " + dictionaryFile.getAbsolutePath());
                }
                catch (IOException e) {
                    SasUtils.logError("Invalid CSV dictionary: " + e.getMessage());
                }
            }
        }
    }

    public String getXmlPath() {
        return this._xmlFile.getAbsolutePath();
    }

    public String getCsvPath() {
        return this._csvFile.getAbsolutePath();
    }

    public String getDictionaryPath() {
        StringBuilder buf = new StringBuilder();
        for (File dictionaryFile : this._dictionaryFiles) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(dictionaryFile.getAbsolutePath());
        }
        return buf.toString();
    }

    public String getNaaccrVersion() {
        return this._naaccrVersion;
    }

    public String getRecordType() {
        return this._recordType;
    }

    public List<SasFieldInfo> getFields() {
        return SasUtils.getFields(this._naaccrVersion, this._recordType, this._dictionaryFiles);
    }

    public List<SasFieldInfo> getGroupedFields() {
        return SasUtils.getGroupedFields(this._naaccrVersion, this._recordType);
    }

    public void convert() throws IOException {
        this.convert(null);
    }

    public void convert(String fields) throws IOException {
        this.convert(fields, true);
    }

    public void convert(String fields, boolean addExtraCharFields) throws IOException {
        this.convert(fields, addExtraCharFields, this.getFields());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convert(String fields, boolean addExtraCharFields, List<SasFieldInfo> availableFields) throws IOException {
        int numCsvFields;
        block29: {
            SasUtils.logInfo("Starting converting XML to CSV...");
            numCsvFields = -1;
            try {
                BufferedWriter bufferedWriter;
                Set<String> requestedFieldIds = SasUtils.extractRequestedFields(fields, availableFields);
                LinkedHashMap<String, SasFieldInfo> fieldsToWrite = new LinkedHashMap<String, SasFieldInfo>();
                for (SasFieldInfo sasFieldInfo : availableFields) {
                    if (requestedFieldIds != null && !requestedFieldIds.contains(sasFieldInfo.getNaaccrId())) continue;
                    fieldsToWrite.put(sasFieldInfo.getTruncatedNaaccrId(), sasFieldInfo);
                    if (sasFieldInfo.getNaaccrId().equals(sasFieldInfo.getTruncatedNaaccrId())) continue;
                    SasUtils.logInfo("Truncated '" + sasFieldInfo.getNaaccrId() + "' into '" + sasFieldInfo.getTruncatedNaaccrId() + "'...");
                }
                HashMap<String, SasFieldInfo> allFields = null;
                if (this._includeGroupedItems) {
                    for (SasFieldInfo groupedField : this.getGroupedFields()) {
                        fieldsToWrite.put(groupedField.getNaaccrId(), groupedField);
                    }
                    allFields = new HashMap<String, SasFieldInfo>();
                    for (SasFieldInfo field : availableFields) {
                        allFields.put(field.getNaaccrId(), field);
                    }
                }
                numCsvFields = fieldsToWrite.size();
                BufferedWriter bufferedWriter2 = null;
                try {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._csvFile), StandardCharsets.UTF_8));
                    StringBuilder buf = new StringBuilder();
                    for (String string : fieldsToWrite.keySet()) {
                        buf.append(string).append(",");
                    }
                    buf.setLength(buf.length() - 1);
                    bufferedWriter.write(buf.toString());
                    bufferedWriter.write("\n");
                    buf.setLength(0);
                    if (addExtraCharFields) {
                        for (Map.Entry entry : fieldsToWrite.entrySet()) {
                            for (int i = 0; i < ((SasFieldInfo)entry.getValue()).getLength(); ++i) {
                                buf.append("-");
                            }
                            buf.append(",");
                        }
                        buf.setLength(buf.length() - 1);
                        bufferedWriter.write(buf.toString());
                        bufferedWriter.write("\n");
                        buf.setLength(0);
                    }
                    if (this._xmlFile.getName().toLowerCase().endsWith(".zip")) {
                        ZipFile zipFile;
                        block27: {
                            ZipInputStream zipInputStream;
                            zipFile = null;
                            ZipInputStream zipInputStream2 = null;
                            try {
                                int zipCount = 0;
                                zipFile = new ZipFile(this._xmlFile);
                                zipInputStream = new ZipInputStream(new FileInputStream(this._xmlFile));
                                ZipEntry entry = zipInputStream.getNextEntry();
                                while (entry != null) {
                                    SasXmlReader reader = new SasXmlReader(SasUtils.createReader(zipFile.getInputStream(entry), entry.getName()));
                                    this.convertSingleFile(reader, bufferedWriter, fieldsToWrite, allFields);
                                    if (++zipCount > 10000) {
                                        throw new IllegalStateException("Too many entries in ZIP file!");
                                    }
                                    entry = zipInputStream.getNextEntry();
                                }
                                if (zipInputStream == null) break block27;
                            }
                            catch (Throwable throwable) {
                                if (zipInputStream2 != null) {
                                    zipInputStream2.close();
                                }
                                if (zipFile != null) {
                                    zipFile.close();
                                }
                                throw throwable;
                            }
                            zipInputStream.close();
                        }
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    } else {
                        try (SasXmlReader reader = null;){
                            reader = new SasXmlReader(SasUtils.createReader(this._xmlFile));
                            this.convertSingleFile(reader, bufferedWriter, fieldsToWrite, allFields);
                        }
                    }
                    if (bufferedWriter == null) break block29;
                }
                catch (Throwable throwable) {
                    if (bufferedWriter2 != null) {
                        bufferedWriter2.close();
                    }
                    throw throwable;
                }
                bufferedWriter.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new IOException(e);
            }
        }
        SasUtils.logInfo("Successfully created target CSV with " + numCsvFields + " column" + (numCsvFields > 1 ? "s" : ""));
    }

    private void convertSingleFile(SasXmlReader reader, BufferedWriter writer, Map<String, SasFieldInfo> fieldsToWrite, Map<String, SasFieldInfo> allFields) throws IOException {
        Pattern quotePattern = Pattern.compile("\"", 16);
        StringBuilder buf = new StringBuilder();
        while (reader.nextRecord() > 0) {
            for (Map.Entry<String, SasFieldInfo> entry : fieldsToWrite.entrySet()) {
                String val = null;
                if (entry.getValue().getContains() == null) {
                    val = reader.getValue(entry.getKey());
                } else {
                    StringBuilder childrenValue = new StringBuilder();
                    for (String child : entry.getValue().getContains()) {
                        SasFieldInfo childField = allFields.get(child);
                        if (childField == null) {
                            throw new IOException("Unable to find field definition for '" + child + "'");
                        }
                        String childValue = reader.getValue(child);
                        if (childValue == null) {
                            childValue = "";
                        }
                        childrenValue.append(childValue);
                        for (int i = 0; i < childField.getLength() - childValue.length(); ++i) {
                            childrenValue.append(" ");
                        }
                    }
                    val = childrenValue.toString();
                }
                if (val != null && val.contains(",")) {
                    val = "\"" + quotePattern.matcher(val).replaceAll("\"\"") + "\"";
                }
                buf.append(val == null ? "" : val).append(",");
            }
            buf.setLength(buf.length() - 1);
            writer.write(buf.toString());
            writer.write("\n");
            buf.setLength(0);
        }
    }

    public void cleanup() {
        this.cleanup("yes");
    }

    public void cleanup(String option) {
        if ("no".equalsIgnoreCase(option)) {
            SasUtils.logInfo("Skipping CSV file cleanup...");
        } else if (!this._csvFile.delete()) {
            SasUtils.logError("Unable to cleanup tmp CSV file, it will have to be manually deleted...");
        }
    }

    List<File> getUserDictionaryFiles() {
        return this._dictionaryFiles;
    }

    public void setIncludeGroupedItems(String option) {
        if ("yes".equalsIgnoreCase(option)) {
            this._includeGroupedItems = true;
        } else if (!"no".equalsIgnoreCase(option)) {
            SasUtils.logError("Invalid includeGroupItems option: " + option);
        }
    }
}

