/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml;

import com.imsweb.naaccrxml.NaaccrContext;
import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrObserver;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrPatientProcessor;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.PatientFlatReader;
import com.imsweb.naaccrxml.PatientFlatWriter;
import com.imsweb.naaccrxml.PatientXmlReader;
import com.imsweb.naaccrxml.PatientXmlWriter;
import com.imsweb.naaccrxml.entity.NaaccrData;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.runtime.NaaccrStreamConfiguration;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang3.StringUtils;

public final class NaaccrXmlUtils {
    public static final String CURRENT_SPECIFICATION_VERSION = "1.7";
    public static final String NAACCR_XML_TAG_ROOT = "NaaccrData";
    public static final String NAACCR_XML_TAG_PATIENT = "Patient";
    public static final String NAACCR_XML_TAG_TUMOR = "Tumor";
    public static final String NAACCR_XML_TAG_ITEM = "Item";
    public static final String NAACCR_XML_ROOT_ATT_BASE_DICT = "baseDictionaryUri";
    public static final String NAACCR_XML_ROOT_ATT_USER_DICT = "userDictionaryUri";
    public static final String NAACCR_XML_ROOT_ATT_REC_TYPE = "recordType";
    public static final String NAACCR_XML_ROOT_ATT_TIME_GENERATED = "timeGenerated";
    public static final String NAACCR_XML_ROOT_ATT_SPEC_VERSION = "specificationVersion";
    public static final String NAACCR_XML_ITEM_ATT_ID = "naaccrId";
    public static final String NAACCR_XML_ITEM_ATT_NUM = "naaccrNum";
    public static final String DEFAULT_TUMOR_GROUPING_ITEM = "patientIdNumber";
    public static final String FLAT_FILE_FORMAT_ITEM_REC_TYPE = "recordType";
    public static final String FLAT_FILE_FORMAT_ITEM_NAACCR_VERSION = "naaccrRecordVersion";
    public static final String NAACCR_XML_NAMESPACE = "http://naaccr.org/naaccrxml";

    private NaaccrXmlUtils() {
    }

    public static void xmlToXml(File xmlSource, File xmlTarget, NaaccrPatientProcessor processor, NaaccrOptions options, List<NaaccrDictionary> userDictionaries, NaaccrObserver observer) throws NaaccrIOException {
        if (xmlSource == null) {
            throw new NaaccrIOException("Source XML file is required");
        }
        if (!xmlSource.exists()) {
            throw new NaaccrIOException("Source XML file must exist");
        }
        if (!xmlTarget.getParentFile().exists()) {
            throw new NaaccrIOException("Target folder must exist");
        }
        if (processor == null) {
            throw new NaaccrIOException("A processor must be provided");
        }
        try (PatientXmlReader reader = new PatientXmlReader(NaaccrXmlUtils.createReader(xmlSource), options, userDictionaries);
             PatientXmlWriter writer = new PatientXmlWriter(NaaccrXmlUtils.createWriter(xmlTarget), reader.getRootData(), options, userDictionaries);){
            Patient patient = reader.readPatient();
            while (patient != null && !Thread.currentThread().isInterrupted()) {
                if (observer != null) {
                    observer.patientRead(patient);
                }
                processor.processPatient(patient);
                writer.writePatient(patient);
                if (observer != null) {
                    observer.patientWritten(patient);
                }
                patient = reader.readPatient();
            }
        }
    }

    public static void flatToXml(File flatFile, File xmlFile, NaaccrOptions options, List<NaaccrDictionary> userDictionaries, NaaccrObserver observer) throws NaaccrIOException {
        if (flatFile == null) {
            throw new NaaccrIOException("Source flat file is required");
        }
        if (!flatFile.exists()) {
            throw new NaaccrIOException("Source flat file must exist");
        }
        if (!xmlFile.getParentFile().exists()) {
            throw new NaaccrIOException("Target folder must exist");
        }
        try (PatientFlatReader reader = new PatientFlatReader(NaaccrXmlUtils.createReader(flatFile), options, userDictionaries);
             PatientXmlWriter writer = new PatientXmlWriter(NaaccrXmlUtils.createWriter(xmlFile), reader.getRootData(), options, userDictionaries);){
            Patient patient = reader.readPatient();
            while (patient != null && !Thread.currentThread().isInterrupted()) {
                if (observer != null) {
                    observer.patientRead(patient);
                }
                writer.writePatient(patient);
                if (observer != null) {
                    observer.patientWritten(patient);
                }
                patient = reader.readPatient();
            }
        }
    }

    public static void xmlToFlat(File xmlFile, File flatFile, NaaccrOptions options, List<NaaccrDictionary> userDictionaries, NaaccrObserver observer) throws NaaccrIOException {
        if (xmlFile == null) {
            throw new NaaccrIOException("Source XML file is required");
        }
        if (!xmlFile.exists()) {
            throw new NaaccrIOException("Source XML file must exist");
        }
        if (!flatFile.getParentFile().exists()) {
            throw new NaaccrIOException("Target folder must exist");
        }
        try (PatientXmlReader reader = new PatientXmlReader(NaaccrXmlUtils.createReader(xmlFile), options, userDictionaries);
             PatientFlatWriter writer = new PatientFlatWriter(NaaccrXmlUtils.createWriter(flatFile), reader.getRootData(), options, userDictionaries);){
            Patient patient = reader.readPatient();
            while (patient != null && !Thread.currentThread().isInterrupted()) {
                if (observer != null) {
                    observer.patientRead(patient);
                }
                writer.writePatient(patient);
                if (observer != null) {
                    observer.patientWritten(patient);
                }
                patient = reader.readPatient();
            }
        }
    }

    public static NaaccrData readXmlFile(File xmlFile, NaaccrOptions options, List<NaaccrDictionary> userDictionaries, NaaccrObserver observer) throws NaaccrIOException {
        if (xmlFile == null) {
            throw new NaaccrIOException("Source XML file is required");
        }
        if (!xmlFile.exists()) {
            throw new NaaccrIOException("Source XML file must exist");
        }
        try (PatientXmlReader reader = new PatientXmlReader(NaaccrXmlUtils.createReader(xmlFile), options, userDictionaries);){
            NaaccrData rootData = reader.getRootData();
            Patient patient = reader.readPatient();
            while (patient != null && !Thread.currentThread().isInterrupted()) {
                if (observer != null) {
                    observer.patientRead(patient);
                }
                rootData.addPatient(patient);
                patient = reader.readPatient();
            }
            NaaccrData naaccrData = rootData;
            return naaccrData;
        }
    }

    public static void writeXmlFile(NaaccrData data, File xmlFile, NaaccrOptions options, List<NaaccrDictionary> userDictionaries, NaaccrObserver observer) throws NaaccrIOException {
        if (data == null) {
            throw new NaaccrIOException("Data is required");
        }
        if (!xmlFile.getParentFile().exists()) {
            throw new NaaccrIOException("Target folder must exist");
        }
        try (PatientXmlWriter writer = new PatientXmlWriter(NaaccrXmlUtils.createWriter(xmlFile), data, options, userDictionaries);){
            for (Patient patient : data.getPatients()) {
                writer.writePatient(patient);
                if (observer != null) {
                    observer.patientWritten(patient);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }
    }

    public static NaaccrData readFlatFile(File flatFile, NaaccrOptions options, List<NaaccrDictionary> userDictionaries, NaaccrObserver observer) throws NaaccrIOException {
        if (flatFile == null) {
            throw new NaaccrIOException("Source flat file is required");
        }
        if (!flatFile.exists()) {
            throw new NaaccrIOException("Source flat file must exist");
        }
        try (PatientFlatReader reader = new PatientFlatReader(NaaccrXmlUtils.createReader(flatFile), options, userDictionaries);){
            NaaccrData data = reader.getRootData();
            Patient patient = reader.readPatient();
            while (patient != null && !Thread.currentThread().isInterrupted()) {
                if (observer != null) {
                    observer.patientRead(patient);
                }
                data.addPatient(patient);
                patient = reader.readPatient();
            }
            NaaccrData naaccrData = data;
            return naaccrData;
        }
    }

    public static void writeFlatFile(NaaccrData data, File flatFile, NaaccrOptions options, List<NaaccrDictionary> userDictionaries, NaaccrObserver observer) throws NaaccrIOException {
        if (data == null) {
            throw new NaaccrIOException("Data is required");
        }
        if (!flatFile.getParentFile().exists()) {
            throw new NaaccrIOException("Target folder must exist");
        }
        try (PatientFlatWriter writer = new PatientFlatWriter(NaaccrXmlUtils.createWriter(flatFile), data, options, userDictionaries);){
            for (Patient patient : data.getPatients()) {
                writer.writePatient(patient);
                if (observer != null) {
                    observer.patientWritten(patient);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }
    }

    public static Patient lineToPatient(String line, NaaccrContext context) throws NaaccrIOException {
        boolean updateVersion;
        if (line == null) {
            throw new NaaccrIOException("Line is required");
        }
        if (context == null) {
            throw new NaaccrIOException("Context is required");
        }
        NaaccrFormat format = NaaccrFormat.getInstance(context.getFormat());
        if (line.length() != format.getLineLength()) {
            throw new NaaccrIOException("Expected line length to be " + format.getLineLength() + " but was " + line.length());
        }
        boolean updateType = !format.getRecordType().equals(line.substring(0, 1).trim());
        boolean bl = updateVersion = !format.getNaaccrVersion().equals(line.substring(16, 19).trim());
        if (updateType || updateVersion) {
            StringBuilder buf = new StringBuilder(line);
            buf.replace(0, 1, format.getRecordType());
            buf.replace(16, 19, format.getNaaccrVersion());
            line = buf.toString();
        }
        try (PatientFlatReader reader = new PatientFlatReader((Reader)new StringReader(line), context.getOptions(), context.getUserDictionaries(), context.getStreamConfiguration());){
            Patient patient = reader.readPatient();
            return patient;
        }
    }

    public static String patientToLine(Patient patient, NaaccrContext context) throws NaaccrIOException {
        if (patient == null) {
            throw new NaaccrIOException("Patient is required");
        }
        if (context == null) {
            throw new NaaccrIOException("Context is required");
        }
        if (patient.getTumors().size() > 1) {
            throw new NaaccrIOException("This method requires a patient with 0 or 1 tumor.");
        }
        StringWriter buf = new StringWriter();
        try (PatientFlatWriter writer = new PatientFlatWriter((Writer)buf, new NaaccrData(context.getFormat()), context.getOptions(), context.getUserDictionaries(), context.getStreamConfiguration());){
            writer.writePatient(patient);
            String string = buf.toString();
            return string;
        }
    }

    public static String getFormatFromFlatFile(File flatFile) {
        String string;
        if (flatFile == null || !flatFile.exists()) {
            return null;
        }
        BufferedReader reader = new BufferedReader(NaaccrXmlUtils.createReader(flatFile));
        try {
            string = NaaccrXmlUtils.getFormatFromFlatFileLine(reader.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        reader.close();
        return string;
    }

    public static String getFormatFromFlatFileLine(String line) {
        if (line == null || line.length() < 19) {
            return null;
        }
        String version = line.substring(16, 19).trim();
        String type = line.substring(0, 1).trim();
        if (NaaccrFormat.isVersionSupported(version) && NaaccrFormat.isRecordTypeSupported(type)) {
            return NaaccrFormat.getInstance(version, type).toString();
        }
        return null;
    }

    public static String getFormatFromXmlFile(File xmlFile) {
        String string;
        block9: {
            if (xmlFile == null || !xmlFile.exists()) {
                return null;
            }
            Reader reader = NaaccrXmlUtils.createReader(xmlFile);
            try {
                string = NaaccrXmlUtils.getFormatFromXmlReader(reader);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    return null;
                }
            }
            reader.close();
        }
        return string;
    }

    public static String getFormatFromXmlReader(Reader xmlReader) {
        String version;
        Map<String, String> attributes = NaaccrXmlUtils.getAttributesFromXmlReader(xmlReader);
        String baseDictUri = attributes.get(NAACCR_XML_ROOT_ATT_BASE_DICT);
        String recordType = attributes.get("recordType");
        if (baseDictUri != null && recordType != null && NaaccrFormat.isVersionSupported(version = NaaccrXmlDictionaryUtils.extractVersionFromUri(baseDictUri)) && NaaccrFormat.isRecordTypeSupported(recordType)) {
            return NaaccrFormat.getInstance(version, recordType).toString();
        }
        return null;
    }

    public static Map<String, String> getAttributesFromXmlFile(File xmlFile) {
        Map<String, String> map;
        block9: {
            if (xmlFile == null || !xmlFile.exists()) {
                return Collections.emptyMap();
            }
            Reader reader = NaaccrXmlUtils.createReader(xmlFile);
            try {
                map = NaaccrXmlUtils.getAttributesFromXmlReader(reader);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    return Collections.emptyMap();
                }
            }
            reader.close();
        }
        return map;
    }

    public static Map<String, String> getAttributesFromXmlReader(Reader xmlReader) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (xmlReader == null) {
            return result;
        }
        try {
            HierarchicalStreamReader xstreamReader;
            if (xmlReader.markSupported()) {
                xmlReader.mark(8192);
            }
            if (NaaccrXmlUtils.removeNameSpacePrefix((xstreamReader = new NaaccrStreamConfiguration().getDriver().createReader(xmlReader)).getNodeName()).equals(NAACCR_XML_TAG_ROOT)) {
                for (int i = 0; i < xstreamReader.getAttributeCount(); ++i) {
                    result.put(NaaccrXmlUtils.removeNameSpacePrefix(xstreamReader.getAttributeName(i)), xstreamReader.getAttribute(i));
                }
            }
            if (xmlReader.markSupported()) {
                xmlReader.reset();
            }
        }
        catch (IOException | RuntimeException exception) {
            // empty catch block
        }
        return result;
    }

    private static String removeNameSpacePrefix(String tag) {
        int idx = tag.indexOf(58);
        if (idx != -1) {
            return tag.substring(idx + 1);
        }
        return tag;
    }

    public static Reader createReader(File file) throws NaaccrIOException {
        InputStream is = null;
        try {
            is = new FileInputStream(file);
            if (file.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            return new InputStreamReader(is, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new NaaccrIOException(e.getMessage());
        }
    }

    public static Writer createWriter(File file) throws NaaccrIOException {
        OutputStream os = null;
        try {
            os = new FileOutputStream(file);
            if (file.getName().endsWith(".gz")) {
                os = new GZIPOutputStream(os);
            }
            return new OutputStreamWriter(os, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new NaaccrIOException(e.getMessage());
        }
    }

    public static Date parseIso8601Date(String value) throws IOException {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            return Date.from(ZonedDateTime.parse(value, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant());
        }
        catch (RuntimeException e1) {
            try {
                return Date.from(LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME).toInstant(ZoneOffset.UTC));
            }
            catch (RuntimeException e2) {
                throw new IOException("Unable to parse value as ISO 8601 date: " + value);
            }
        }
    }

    public static String formatIso8601Date(Date date) {
        if (date == null) {
            throw new NullPointerException("Date to write cannot be null!");
        }
        return ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }
}

