/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml;

import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrValidationError;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.NaaccrXmlUtils;
import com.imsweb.naaccrxml.PatientReader;
import com.imsweb.naaccrxml.SpecificationVersion;
import com.imsweb.naaccrxml.entity.NaaccrData;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.runtime.NaaccrStreamConfiguration;
import com.imsweb.naaccrxml.runtime.NaaccrStreamContext;
import com.imsweb.naaccrxml.runtime.RuntimeNaaccrDictionary;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PatientXmlReader
implements PatientReader {
    protected NaaccrData _rootData;
    protected XStream _xstream;
    protected HierarchicalStreamReader _reader;
    protected NaaccrStreamContext _context;
    protected boolean _hasBeenFinalized = false;

    public PatientXmlReader(Reader reader) throws NaaccrIOException {
        this(reader, null, (NaaccrDictionary)null, null);
    }

    public PatientXmlReader(Reader reader, NaaccrOptions options) throws NaaccrIOException {
        this(reader, options, (NaaccrDictionary)null, null);
    }

    public PatientXmlReader(Reader reader, NaaccrOptions options, NaaccrDictionary userDictionary) throws NaaccrIOException {
        this(reader, options, Collections.singletonList(userDictionary), null);
    }

    public PatientXmlReader(Reader reader, NaaccrOptions options, List<NaaccrDictionary> userDictionaries) throws NaaccrIOException {
        this(reader, options, userDictionaries, null);
    }

    public PatientXmlReader(Reader reader, NaaccrOptions options, NaaccrDictionary userDictionary, NaaccrStreamConfiguration conf) throws NaaccrIOException {
        this(reader, options, Collections.singletonList(userDictionary), conf);
    }

    public PatientXmlReader(Reader reader, NaaccrOptions options, List<NaaccrDictionary> userDictionaries, NaaccrStreamConfiguration conf) throws NaaccrIOException {
        try {
            if (options == null) {
                options = NaaccrOptions.getDefault();
            }
            if (conf == null) {
                conf = NaaccrStreamConfiguration.getDefault();
            }
            HashMap<String, NaaccrDictionary> dictionaries = new HashMap<String, NaaccrDictionary>();
            if (userDictionaries != null) {
                for (NaaccrDictionary userDictionary : userDictionaries) {
                    if (userDictionary == null) continue;
                    dictionaries.put(userDictionary.getDictionaryUri(), userDictionary);
                }
            }
            this._context = new NaaccrStreamContext();
            this._context.setOptions(options);
            this._context.setConfiguration(conf);
            this._reader = conf.getDriver().createReader(reader);
            if (!this.isRootTag(this._reader.getNodeName())) {
                throw new NaaccrIOException("was expecting NaaccrData root tag but got " + this._reader.getNodeName(), conf.getParser().getLineNumber());
            }
            this._rootData = this.createRootData();
            this._rootData.setStartLineNumber(conf.getParser().getLineNumber());
            this._rootData.setEndLineNumber(null);
            String specVersion = this._reader.getAttribute("specificationVersion");
            if (specVersion == null) {
                specVersion = "1.0";
            }
            if (!SpecificationVersion.isSpecificationSupported(specVersion)) {
                throw new NaaccrIOException("invalid specification version: " + specVersion);
            }
            this._rootData.setSpecificationVersion(specVersion);
            this._rootData.setBaseDictionaryUri(this._reader.getAttribute("baseDictionaryUri"));
            if (this._rootData.getBaseDictionaryUri() == null) {
                throw new NaaccrIOException("the \"baseDictionaryUri\" attribute is required", conf.getParser().getLineNumber());
            }
            String version = NaaccrXmlDictionaryUtils.extractVersionFromUri(this._rootData.getBaseDictionaryUri());
            if (version == null || version.trim().isEmpty()) {
                throw new NaaccrIOException("unable to extract NAACCR version from base dictionary URI \"" + this._rootData.getBaseDictionaryUri() + "\"", conf.getParser().getLineNumber());
            }
            if (!NaaccrFormat.isVersionSupported(version)) {
                throw new NaaccrIOException("invalid/unsupported NAACCR version: " + version, conf.getParser().getLineNumber());
            }
            NaaccrDictionary baseDictionary = NaaccrXmlDictionaryUtils.getBaseDictionaryByVersion(version);
            if (!StringUtils.isBlank((CharSequence)this._reader.getAttribute("userDictionaryUri"))) {
                ArrayList<String> dataUserDictionaries = Arrays.asList(StringUtils.split((String)this._reader.getAttribute("userDictionaryUri"), (char)' '));
                if (SpecificationVersion.compareSpecifications(specVersion, "1.2") < 0 && dataUserDictionaries.size() > 1) {
                    throw new NaaccrIOException("multiple user dictionaries can only be provided under specification 1.2+", conf.getParser().getLineNumber());
                }
                if (options.getDictionaryIdsToTranslate() != null) {
                    ArrayList<String> translatedUris = new ArrayList<String>(dataUserDictionaries.size());
                    for (String uri2 : dataUserDictionaries) {
                        translatedUris.add(options.getDictionaryIdsToTranslate().getOrDefault(uri2, uri2));
                    }
                    dataUserDictionaries = translatedUris;
                }
                this._rootData.setUserDictionaryUri((List<String>)dataUserDictionaries);
            }
            for (String uri3 : new HashSet(dictionaries.keySet())) {
                if (this._rootData.getUserDictionaryUri().contains(uri3)) continue;
                dictionaries.remove(uri3);
            }
            if (Boolean.FALSE.equals(options.getAllowMissingDictionary())) {
                List missingDictionaries = this._rootData.getUserDictionaryUri().stream().filter(uri -> !dictionaries.containsKey(uri)).collect(Collectors.toList());
                if (missingDictionaries.size() > 1) {
                    throw new NaaccrIOException("missing user dictionaries: " + String.join((CharSequence)" ", missingDictionaries));
                }
                if (missingDictionaries.size() == 1) {
                    throw new NaaccrIOException("missing user dictionary: " + (String)missingDictionaries.get(0));
                }
            }
            this._rootData.setRecordType(this._reader.getAttribute("recordType"));
            if (this._rootData.getRecordType() == null || this._rootData.getRecordType().trim().isEmpty()) {
                throw new NaaccrIOException("the \"recordType\" attribute is required", conf.getParser().getLineNumber());
            }
            if (!NaaccrFormat.isRecordTypeSupported(this._rootData.getRecordType())) {
                throw new NaaccrIOException("invalid record type: " + this._rootData.getRecordType(), conf.getParser().getLineNumber());
            }
            String generatedTime = this._reader.getAttribute("timeGenerated");
            if (!StringUtils.isBlank((CharSequence)generatedTime)) {
                try {
                    this._rootData.setTimeGenerated(NaaccrXmlUtils.parseIso8601Date(this._reader.getAttribute("timeGenerated")));
                }
                catch (IOException e) {
                    this._rootData.addValidationError(new NaaccrValidationError("Invalid Time Generated", generatedTime));
                }
            }
            HashSet<String> standardAttributes = new HashSet<String>();
            standardAttributes.add("baseDictionaryUri");
            standardAttributes.add("userDictionaryUri");
            standardAttributes.add("recordType");
            standardAttributes.add("timeGenerated");
            standardAttributes.add("specificationVersion");
            HashMap<String, String> attributeValues = new HashMap<String, String>();
            HashMap<String, String> namespaces = new HashMap<String, String>();
            for (int i = 0; i < this._reader.getAttributeCount(); ++i) {
                String attrName = this._reader.getAttributeName(i);
                if (standardAttributes.contains(attrName)) continue;
                if (attrName.startsWith("xmlns")) {
                    int idx = attrName.indexOf(58);
                    if (idx != -1) {
                        String namespacePrefix = attrName.substring(idx + 1);
                        if (Boolean.TRUE.equals(options.getUseStrictNamespaces()) && !conf.getRegisterNamespaces().containsKey(namespacePrefix)) {
                            throw new NaaccrIOException("namespace " + this._reader.getAttribute(i) + " (prefix=" + namespacePrefix + ") has not been defined in the configuration");
                        }
                        namespaces.put(namespacePrefix, this._reader.getAttribute(i));
                        continue;
                    }
                    if (!"http://naaccr.org/naaccrxml".equals(this._reader.getAttribute(i))) {
                        throw new NaaccrIOException("default namespace can only be set to http://naaccr.org/naaccrxml");
                    }
                    namespaces.put("", this._reader.getAttribute(i));
                    continue;
                }
                attributeValues.put(attrName, this._reader.getAttribute(i));
            }
            if (Boolean.TRUE.equals(options.getUseStrictNamespaces()) && !namespaces.containsValue("http://naaccr.org/naaccrxml")) {
                throw new NaaccrIOException("namespace http://naaccr.org/naaccrxml must be defined in the root attributes");
            }
            for (Map.Entry entry : attributeValues.entrySet()) {
                String attrName;
                String prefix = null;
                int idx = ((String)entry.getKey()).indexOf(58);
                if (idx != -1) {
                    prefix = ((String)entry.getKey()).substring(0, idx);
                    attrName = ((String)entry.getKey()).substring(idx + 1);
                } else {
                    attrName = (String)entry.getKey();
                }
                if (Boolean.TRUE.equals(options.getUseStrictNamespaces())) {
                    if (prefix == null) {
                        throw new NaaccrIOException("attribute " + attrName + " must use a namespace prefix");
                    }
                    if (!namespaces.containsKey(prefix)) {
                        throw new NaaccrIOException("attribute " + attrName + " uses a prefix " + prefix + " that is not properly defined");
                    }
                }
                this._rootData.addExtraRootParameters(attrName, (String)entry.getValue());
            }
            if (conf.getCachedDictionary() == null || !conf.getCachedDictionary().getId().equals(RuntimeNaaccrDictionary.computeId(this._rootData.getRecordType(), baseDictionary, dictionaries.values()))) {
                conf.setCachedDictionary(new RuntimeNaaccrDictionary(this._rootData.getRecordType(), baseDictionary, dictionaries.values()));
            }
            this._context.setDictionary(conf.getCachedDictionary());
            conf.getPatientConverter().setContext(this._context);
            if (!this._reader.hasMoreChildren()) {
                return;
            }
            this._reader.moveDown();
            HashSet<String> itemsAlreadySeen = new HashSet<String>();
            while (this.isItemTag(this._reader.getNodeName())) {
                String rawId = this._reader.getAttribute("naaccrId");
                String rawNum = this._reader.getAttribute("naaccrNum");
                if (rawId != null && itemsAlreadySeen.contains(rawId)) {
                    throw new NaaccrIOException("item '" + rawId + "' should be unique within the \"NaaccrData\" tags");
                }
                itemsAlreadySeen.add(rawId);
                conf.getPatientConverter().readItem(this._rootData, "/NaaccrData", "NaaccrData", rawId, rawNum, this._reader.getValue());
                this._reader.moveUp();
                if (!this._reader.hasMoreChildren()) continue;
                this._reader.moveDown();
            }
            while (!this.isPatientTag(this._reader.getNodeName()) && !this.isRootTag(this._reader.getNodeName())) {
                if (!Boolean.TRUE.equals(options.getIgnoreExtensions())) {
                    this._rootData.addExtension(conf.getXstream().unmarshal(this._reader));
                }
                this._reader.moveUp();
                if (!this._reader.hasMoreChildren()) continue;
                this._reader.moveDown();
            }
            if (this.isRootTag(this._reader.getNodeName())) {
                return;
            }
            if (!this.isPatientTag(this._reader.getNodeName())) {
                throw new NaaccrIOException("unexpected tag: " + this._context.extractTag(this._reader.getNodeName()), conf.getParser().getLineNumber());
            }
            this._xstream = conf.getXstream();
        }
        catch (ConversionException ex) {
            throw this.convertSyntaxException(ex);
        }
        catch (StreamException ex) {
            throw new NaaccrIOException("invalid XML syntax, unable to find root tag", ex);
        }
        catch (CannotResolveClassException ex) {
            throw new NaaccrIOException("invalid tag: " + ex.getMessage());
        }
        catch (RuntimeException ex) {
            throw new NaaccrIOException("invalid XML syntax", ex);
        }
    }

    private boolean isRootTag(String tag) throws NaaccrIOException {
        return this._context.extractTag(tag).equals("NaaccrData");
    }

    private boolean isPatientTag(String tag) throws NaaccrIOException {
        return this._context.extractTag(tag).equals("Patient");
    }

    private boolean isItemTag(String tag) throws NaaccrIOException {
        return this._context.extractTag(tag).equals("Item");
    }

    @Override
    public Patient readPatient() throws NaaccrIOException {
        Patient patient;
        if (this._context.extractTag(this._reader.getNodeName()).equals("NaaccrData")) {
            return null;
        }
        if (!this._context.extractTag(this._reader.getNodeName()).equals("Patient")) {
            throw new NaaccrIOException("Unexpected tag: " + this._reader.getNodeName(), this._context.getLineNumber());
        }
        try {
            patient = (Patient)this._xstream.unmarshal(this._reader);
            this._reader.moveUp();
            if (this._reader.hasMoreChildren()) {
                this._reader.moveDown();
            }
        }
        catch (ConversionException ex) {
            throw this.convertSyntaxException(ex);
        }
        catch (CannotResolveClassException ex) {
            throw new NaaccrIOException("invalid tag: " + ex.getMessage());
        }
        catch (RuntimeException ex) {
            throw new NaaccrIOException("invalid XML syntax", ex);
        }
        return patient;
    }

    @Override
    public NaaccrData getRootData() {
        return this._rootData;
    }

    @Override
    public void closeAndKeepAlive() {
        if (!this._hasBeenFinalized) {
            this._reader.moveUp();
            this._hasBeenFinalized = true;
        }
    }

    @Override
    public void close() {
        this.closeAndKeepAlive();
        this._reader.close();
    }

    protected NaaccrData createRootData() {
        return new NaaccrData();
    }

    private NaaccrIOException convertSyntaxException(ConversionException ex) {
        Object msg = ex.get("message");
        if (CannotResolveClassException.class.getName().equals(ex.get("cause-exception"))) {
            msg = "invalid tag: " + ex.get("cause-message");
        } else if (StreamException.class.getName().equals(ex.get("cause-exception"))) {
            msg = "invalid XML syntax";
        }
        if (msg == null) {
            msg = ex.getMessage();
        }
        NaaccrIOException e = new NaaccrIOException((String)msg, ex);
        if (ex.get("line number") != null) {
            e.setLineNumber(Integer.valueOf(ex.get("line number")));
        }
        e.setPath(ex.get("path"));
        return e;
    }
}

