/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml;

import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.NaaccrXmlUtils;
import com.imsweb.naaccrxml.PatientWriter;
import com.imsweb.naaccrxml.SpecificationVersion;
import com.imsweb.naaccrxml.entity.Item;
import com.imsweb.naaccrxml.entity.NaaccrData;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.internal.NaaccrXmlPrettyPrintWriter;
import com.imsweb.naaccrxml.runtime.NaaccrStreamConfiguration;
import com.imsweb.naaccrxml.runtime.NaaccrStreamContext;
import com.imsweb.naaccrxml.runtime.RuntimeNaaccrDictionary;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class PatientXmlWriter
implements PatientWriter {
    protected XStream _xstream;
    protected NaaccrXmlPrettyPrintWriter _writer;
    protected String _newLine;
    protected boolean _hasBeenFinalized = false;

    public PatientXmlWriter(Writer writer, NaaccrData rootData) throws NaaccrIOException {
        this(writer, rootData, null, (NaaccrDictionary)null, null);
    }

    public PatientXmlWriter(Writer writer, NaaccrData rootData, NaaccrOptions options) throws NaaccrIOException {
        this(writer, rootData, options, (NaaccrDictionary)null, null);
    }

    public PatientXmlWriter(Writer writer, NaaccrData rootData, NaaccrOptions options, NaaccrDictionary userDictionary) throws NaaccrIOException {
        this(writer, rootData, options, Collections.singletonList(userDictionary), null);
    }

    public PatientXmlWriter(Writer writer, NaaccrData rootData, NaaccrOptions options, List<NaaccrDictionary> userDictionaries) throws NaaccrIOException {
        this(writer, rootData, options, userDictionaries, null);
    }

    public PatientXmlWriter(Writer writer, NaaccrData rootData, NaaccrOptions options, NaaccrDictionary userDictionary, NaaccrStreamConfiguration conf) throws NaaccrIOException {
        this(writer, rootData, options, Collections.singletonList(userDictionary), conf);
    }

    public PatientXmlWriter(Writer writer, NaaccrData rootData, NaaccrOptions options, List<NaaccrDictionary> userDictionaries, NaaccrStreamConfiguration conf) throws NaaccrIOException {
        try {
            if (options == null) {
                options = NaaccrOptions.getDefault();
            }
            if (conf == null) {
                conf = NaaccrStreamConfiguration.getDefault();
            }
            this._newLine = "LF".equals(options.getNewLine()) ? "\n" : ("CRLF".equals(options.getNewLine()) ? "\r\n" : System.getProperty("line.separator"));
            this._xstream = conf.getXstream();
            NaaccrStreamContext context = new NaaccrStreamContext();
            context.setOptions(options);
            context.setConfiguration(conf);
            NaaccrDictionary baseDictionary = NaaccrXmlDictionaryUtils.getBaseDictionaryByUri(rootData.getBaseDictionaryUri());
            HashMap<String, NaaccrDictionary> dictionaries = new HashMap<String, NaaccrDictionary>();
            if (userDictionaries != null) {
                for (NaaccrDictionary userDictionary : userDictionaries) {
                    if (userDictionary == null) continue;
                    dictionaries.put(userDictionary.getDictionaryUri(), userDictionary);
                }
            }
            this._writer = new NaaccrXmlPrettyPrintWriter(writer, this._newLine);
            try {
                writer.write("<?xml version=\"1.0\"?>" + this._newLine + this._newLine);
            }
            catch (IOException e) {
                throw new NaaccrIOException(e.getMessage());
            }
            this._writer.startNode("NaaccrData");
            if (rootData.getBaseDictionaryUri() == null) {
                throw new NaaccrIOException("base dictionary URI is required");
            }
            this._writer.addAttributeWithNewLine("baseDictionaryUri", rootData.getBaseDictionaryUri());
            if (!dictionaries.isEmpty()) {
                if (rootData.getUserDictionaryUri() != null && !rootData.getUserDictionaryUri().isEmpty() && !new HashSet<String>(rootData.getUserDictionaryUri()).equals(dictionaries.keySet())) {
                    throw new NaaccrIOException("Provided dictionaries are not the ones referenced in the rootData");
                }
                this._writer.addAttributeWithNewLine("userDictionaryUri", StringUtils.join(new TreeSet(dictionaries.keySet()), (char)' '));
            }
            if (rootData.getRecordType() == null) {
                throw new NaaccrIOException("record type is required");
            }
            this._writer.addAttributeWithNewLine("recordType", rootData.getRecordType());
            this._writer.addAttributeWithNewLine("timeGenerated", NaaccrXmlUtils.formatIso8601Date(rootData.getTimeGenerated() != null ? rootData.getTimeGenerated() : Calendar.getInstance().getTime()));
            String specVersion = options.getSpecificationVersionWritten();
            if (specVersion == null || !SpecificationVersion.isSpecificationSupported(specVersion)) {
                specVersion = "1.7";
            }
            this._writer.addAttributeWithNewLine("specificationVersion", specVersion);
            HashSet<String> standardAttributes = new HashSet<String>();
            standardAttributes.add("baseDictionaryUri");
            standardAttributes.add("userDictionaryUri");
            standardAttributes.add("recordType");
            standardAttributes.add("timeGenerated");
            standardAttributes.add("specificationVersion");
            for (Map.Entry<String, String> entry : rootData.getExtraRootParameters().entrySet()) {
                if (standardAttributes.contains(entry.getKey()) || entry.getKey().startsWith("xmlns")) continue;
                this._writer.addAttributeWithNewLine(entry.getKey(), entry.getValue());
            }
            conf.getRegisterNamespaces().forEach((key, value) -> this._writer.addAttributeWithNewLine("xmlns:" + key, (String)value));
            this._writer.addAttribute("xmlns", "http://naaccr.org/naaccrxml");
            if (conf.getCachedDictionary() == null || !conf.getCachedDictionary().getId().equals(RuntimeNaaccrDictionary.computeId(rootData.getRecordType(), baseDictionary, dictionaries.values()))) {
                conf.setCachedDictionary(new RuntimeNaaccrDictionary(rootData.getRecordType(), baseDictionary, dictionaries.values()));
            }
            context.setDictionary(conf.getCachedDictionary());
            conf.getPatientConverter().setContext(context);
            for (Item item : rootData.getItems()) {
                conf.getPatientConverter().writeItem(item, (HierarchicalStreamWriter)this._writer);
            }
            if (!Boolean.TRUE.equals(options.getIgnoreExtensions()) && rootData.getExtensions() != null) {
                for (Object extension : rootData.getExtensions()) {
                    this._xstream.marshal(extension, (HierarchicalStreamWriter)this._writer);
                }
            }
        }
        catch (ConversionException ex) {
            throw this.convertSyntaxException(ex);
        }
        catch (RuntimeException ex) {
            throw new NaaccrIOException("unable to write XML", ex);
        }
    }

    @Override
    public void writePatient(Patient patient) throws NaaccrIOException {
        try {
            this._xstream.marshal((Object)patient, (HierarchicalStreamWriter)this._writer);
        }
        catch (ConversionException ex) {
            throw this.convertSyntaxException(ex);
        }
        catch (RuntimeException ex) {
            throw new NaaccrIOException("unable to write XML", ex);
        }
    }

    @Override
    public void closeAndKeepAlive() {
        if (!this._hasBeenFinalized) {
            this._writer.endNode();
            this._hasBeenFinalized = true;
        }
        this._writer.flush();
    }

    @Override
    public void close() {
        this.closeAndKeepAlive();
        this._writer.close();
    }

    public String getNewLine() {
        return this._newLine;
    }

    protected NaaccrIOException convertSyntaxException(ConversionException ex) {
        String msg = ex.get("message");
        if (msg == null) {
            msg = ex.getMessage();
        }
        NaaccrIOException e = new NaaccrIOException(msg, ex);
        if (ex.get("line number") != null) {
            e.setLineNumber(Integer.valueOf(ex.get("line number")));
        }
        e.setPath(ex.get("path"));
        return e;
    }
}

