/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.entity;

import com.imsweb.naaccrxml.DuplicateItemException;
import com.imsweb.naaccrxml.NaaccrValidationError;
import com.imsweb.naaccrxml.entity.Item;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractEntity {
    protected List<Item> _items = new ArrayList<Item>();
    protected List<NaaccrValidationError> _errors = new ArrayList<NaaccrValidationError>();
    protected Integer _startLineNumber;
    protected Integer _endLineNumber;
    protected List<Object> _extensions;
    protected Map<String, Item> _cachedById = new HashMap<String, Item>();

    public List<Item> getItems() {
        return Collections.unmodifiableList(this._items);
    }

    public void addItem(Item item) {
        if (this._cachedById.containsKey(item.getNaaccrId())) {
            throw new DuplicateItemException(item.getNaaccrId(), "Duplicate item ID found for '" + item.getNaaccrId() + "'");
        }
        this._items.add(item);
        this._cachedById.put(item.getNaaccrId(), item);
    }

    public boolean removeItem(String naaccrId) {
        return this.removeItem(this.getItem(naaccrId));
    }

    public boolean removeItem(Item item) {
        if (item == null || item.getNaaccrId() == null) {
            return false;
        }
        int idx = -1;
        for (int i = 0; i < this._items.size(); ++i) {
            if (!this._items.get(i).getNaaccrId().equals(item.getNaaccrId())) continue;
            idx = i;
            break;
        }
        if (idx != -1) {
            this._items.remove(idx);
            this._cachedById.remove(item.getNaaccrId());
            return true;
        }
        return false;
    }

    public Item getItem(String id) {
        return this._cachedById.get(id);
    }

    public String getItemValue(String id) {
        Item item = this.getItem(id);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    public List<NaaccrValidationError> getValidationErrors() {
        return Collections.unmodifiableList(this._errors);
    }

    public void addValidationError(NaaccrValidationError error) {
        this._errors.add(error);
    }

    public Integer getStartLineNumber() {
        return this._startLineNumber;
    }

    public void setStartLineNumber(Integer startLineNumber) {
        this._startLineNumber = startLineNumber;
    }

    public Integer getEndLineNumber() {
        return this._endLineNumber;
    }

    public void setEndLineNumber(Integer endLineNumber) {
        this._endLineNumber = endLineNumber;
    }

    public List<Object> getExtensions() {
        return this._extensions;
    }

    public void setExtensions(List<Object> extensions) {
        this._extensions = extensions;
    }

    public void addExtension(Object extension) {
        if (extension == null) {
            return;
        }
        if (this._extensions == null) {
            this._extensions = new ArrayList<Object>();
        }
        this._extensions.add(extension);
    }
}

