/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.entity;

import com.imsweb.naaccrxml.NaaccrValidationError;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Item;
import com.imsweb.naaccrxml.entity.Tumor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Patient
extends AbstractEntity {
    protected List<Tumor> _tumors = new ArrayList<Tumor>();

    public List<Tumor> getTumors() {
        return Collections.unmodifiableList(this._tumors);
    }

    public Tumor getTumor(int tumorIdx) {
        return this._tumors.get(tumorIdx);
    }

    public List<NaaccrValidationError> getAllValidationErrors() {
        ArrayList<NaaccrValidationError> results = new ArrayList<NaaccrValidationError>(this.getValidationErrors());
        results.addAll(this.getItems().stream().filter(item -> item.getValidationError() != null).map(Item::getValidationError).collect(Collectors.toList()));
        for (Tumor tumor : this.getTumors()) {
            results.addAll(tumor.getAllValidationErrors());
        }
        return results;
    }

    public void addTumor(Tumor tumor) {
        this._tumors.add(tumor);
    }

    public void removeTumor(int tumorIdx) {
        this._tumors.remove(tumorIdx);
    }

    public void setTumors(List<Tumor> tumors) {
        this._tumors.clear();
        if (tumors != null) {
            this._tumors.addAll(tumors);
        }
    }
}

