/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.sas;

import com.imsweb.naaccrxml.sas.SasFieldInfo;
import com.imsweb.naaccrxml.sas.SasUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SasCsvToXml {
    private File _csvFile;
    private File _xmlFile;
    private List<File> _dictionaryFiles;
    private String _naaccrVersion;
    private String _recordType;
    private String _dictionaryUris;
    private boolean _writeNumbers;
    private boolean _groupTumors;
    private String _specificationsVersion;

    public SasCsvToXml(String xmlPath, String naaccrVersion, String recordType) {
        this(SasUtils.computeCsvPathFromXmlPath(xmlPath), xmlPath, naaccrVersion, recordType);
    }

    public SasCsvToXml(String csvPath, String xmlPath, String naaccrVersion, String recordType) {
        if (csvPath == null || csvPath.trim().isEmpty()) {
            SasUtils.logError("No source CSV path was provided");
        } else {
            this._csvFile = new File(csvPath);
            SasUtils.logInfo("Source CSV: " + this._csvFile.getAbsolutePath());
            if (xmlPath == null || ((String)xmlPath).trim().isEmpty()) {
                SasUtils.logError("No target XML path was provided");
            } else {
                if (((String)xmlPath).equalsIgnoreCase(csvPath)) {
                    xmlPath = csvPath + ".xml";
                }
                this._xmlFile = new File((String)xmlPath);
                if (!new File(this._xmlFile.getAbsolutePath()).getParentFile().exists()) {
                    SasUtils.logError("Parent directory for target XML path doesn't exist: " + this._xmlFile.getParentFile().getAbsolutePath());
                } else {
                    SasUtils.logInfo("Target XML: " + this._xmlFile.getAbsolutePath());
                }
            }
        }
        this._dictionaryFiles = new ArrayList<File>();
        this._naaccrVersion = naaccrVersion;
        if (this._naaccrVersion == null || this._naaccrVersion.trim().isEmpty()) {
            SasUtils.logError("NAACCR version needs to be provided");
        }
        if (!("140".equals(naaccrVersion) || "150".equals(naaccrVersion) || "160".equals(naaccrVersion) || "180".equals(naaccrVersion) || "210".equals(naaccrVersion) || "220".equals(naaccrVersion) || "230".equals(naaccrVersion) || "240".equals(naaccrVersion) || "250".equals(naaccrVersion))) {
            SasUtils.logError("NAACCR version must be 140, 150, 160, 180, 210, 220, 230, 240 or 20; got " + this._naaccrVersion);
        }
        this._recordType = recordType;
        if (this._recordType == null || this._recordType.trim().isEmpty()) {
            SasUtils.logError("Record type needs to be provided");
        }
        if (!("A".equals(this._recordType) || "M".equals(this._recordType) || "C".equals(this._recordType) || "I".equals(this._recordType))) {
            SasUtils.logError("Record type must be A, M, C or I; got " + this._recordType);
        }
        this._writeNumbers = false;
        this._groupTumors = true;
    }

    public void setDictionary(String dictionaryPath, String dictionaryUri) {
        if (dictionaryPath != null && !dictionaryPath.trim().isEmpty()) {
            for (String path : dictionaryPath.split(";")) {
                File dictionaryFile = new File(path.trim());
                if (!dictionaryFile.exists()) {
                    SasUtils.logError("Invalid CSV dictionary path: " + path);
                    continue;
                }
                try {
                    SasUtils.validateCsvDictionary(dictionaryFile);
                    this._dictionaryFiles.add(dictionaryFile);
                    SasUtils.logInfo("Dictionary: " + dictionaryFile.getAbsolutePath());
                }
                catch (IOException e) {
                    SasUtils.logError("Invalid CSV dictionary: " + e.getMessage());
                }
            }
        }
        if (dictionaryUri != null) {
            StringBuilder buf = new StringBuilder();
            for (String uri : dictionaryUri.split(";")) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(uri.trim());
            }
            this._dictionaryUris = buf.toString();
        }
    }

    public void setSpecificationsVersion(String specificationsVersion) {
        if (specificationsVersion != null && !specificationsVersion.trim().isEmpty()) {
            this._specificationsVersion = specificationsVersion;
        }
    }

    public String getCsvPath() {
        return this._csvFile.getAbsolutePath();
    }

    public String getXmlPath() {
        return this._xmlFile.getAbsolutePath();
    }

    public String getNaaccrVersion() {
        return this._naaccrVersion;
    }

    public String getRecordType() {
        return this._recordType;
    }

    public void setWriteNumbers(String value) {
        this._writeNumbers = value != null && ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value));
    }

    public String getWriteNumbers() {
        return this._writeNumbers ? "Yes" : "No";
    }

    public void setGroupTumors(String value) {
        this._groupTumors = value == null || !"false".equalsIgnoreCase(value) && !"no".equalsIgnoreCase(value);
    }

    public String getGroupTumors() {
        return this._groupTumors ? "Yes" : "No";
    }

    public List<SasFieldInfo> getFields() {
        return SasUtils.getFields(this._naaccrVersion, this._recordType, this._dictionaryFiles);
    }

    public void convert() throws IOException {
        this.convert(null);
    }

    public void convert(String fields) throws IOException {
        this.convert(fields, this.getFields());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(String fields, List<SasFieldInfo> availableFields) throws IOException {
        SasUtils.logInfo("Starting converting CSV to XML" + (!this._groupTumors ? " (tumor grouping disabled) " : "") + "...");
        int numXmlFields = -1;
        int numCsvFields = -1;
        ArrayList<String> unusedCsvField = null;
        try {
            Set<String> requestedFieldIds = SasUtils.extractRequestedFields(fields, availableFields);
            HashMap<String, String> itemNumbers = new HashMap<String, String>();
            for (SasFieldInfo info : availableFields) {
                itemNumbers.put(info.getNaaccrId(), info.getNum().toString());
            }
            HashMap<String, String> rootFields = new HashMap<String, String>();
            HashMap<String, String> patientFields = new HashMap<String, String>();
            HashMap<String, String> tumorFields = new HashMap<String, String>();
            for (SasFieldInfo field : availableFields) {
                if (requestedFieldIds != null && !requestedFieldIds.contains(field.getNaaccrId())) continue;
                if ("NaaccrData".equals(field.getParentTag())) {
                    rootFields.put(field.getTruncatedNaaccrId(), field.getNaaccrId());
                    continue;
                }
                if ("Patient".equals(field.getParentTag())) {
                    patientFields.put(field.getTruncatedNaaccrId(), field.getNaaccrId());
                    continue;
                }
                if (!"Tumor".equals(field.getParentTag())) continue;
                tumorFields.put(field.getTruncatedNaaccrId(), field.getNaaccrId());
            }
            numXmlFields = rootFields.size() + patientFields.size() + tumorFields.size();
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this._csvFile), StandardCharsets.UTF_8));
                writer = SasUtils.createWriter(this._xmlFile);
                ArrayList<String> headers = new ArrayList<String>();
                String line = ((LineNumberReader)reader).readLine();
                if (line == null) {
                    throw new IOException("Was expecting to find column headers, didn't find them!");
                }
                headers.addAll(Arrays.asList(line.split(",", -1)));
                numCsvFields = headers.size();
                unusedCsvField = new ArrayList<String>();
                for (String header : headers) {
                    if (rootFields.containsKey(header) || patientFields.containsKey(header) || tumorFields.containsKey(header)) continue;
                    unusedCsvField.add(header);
                }
                String currentPatNum = null;
                line = ((LineNumberReader)reader).readLine();
                boolean wroteRoot = false;
                int numPatientWritten = 0;
                while (line != null) {
                    String val;
                    List<String> valList = SasUtils.parseCsvLine(((LineNumberReader)reader).getLineNumber(), line);
                    if (headers.size() != valList.size()) {
                        throw new IOException("Line " + ((LineNumberReader)reader).getLineNumber() + ": expected " + headers.size() + " values but got " + valList.size());
                    }
                    HashMap<String, String> values = new HashMap<String, String>();
                    for (int i = 0; i < valList.size(); ++i) {
                        values.put((String)headers.get(i), valList.get(i));
                    }
                    String patNum = (String)values.get("patientIdNumber");
                    if (patNum != null && patNum.trim().isEmpty()) {
                        patNum = null;
                    }
                    if (!wroteRoot) {
                        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                        writer.write("\n");
                        writer.write("<NaaccrData");
                        writer.write(" baseDictionaryUri=\"http://naaccr.org/naaccrxml/naaccr-dictionary-" + this._naaccrVersion + ".xml\"");
                        if (!this._dictionaryFiles.isEmpty() && this._dictionaryUris != null && !this._dictionaryUris.trim().isEmpty()) {
                            writer.write("\n            userDictionaryUri=\"" + this._dictionaryUris + "\"");
                        }
                        writer.write("\n            recordType=\"" + this._recordType + "\"");
                        if (this._specificationsVersion != null) {
                            writer.write("\n            specificationVersion=\"" + this._specificationsVersion + "\"");
                        } else {
                            writer.write("\n            specificationVersion=\"1.7\"");
                        }
                        writer.write("\n            xmlns=\"http://naaccr.org/naaccrxml\"");
                        writer.write(">\n");
                        for (Map.Entry entry : rootFields.entrySet()) {
                            val = (String)values.get(entry.getKey());
                            if (val == null || val.trim().isEmpty()) continue;
                            writer.write(this.createItemLine("    ", (String)entry.getKey(), (String)itemNumbers.get(entry.getKey()), val));
                        }
                        wroteRoot = true;
                    }
                    if (!this._groupTumors || patNum == null || currentPatNum == null || !currentPatNum.equals(patNum)) {
                        if (numPatientWritten > 0) {
                            writer.write("    </Patient>\n");
                        }
                        ++numPatientWritten;
                        writer.write("    <Patient>\n");
                        for (Map.Entry entry : patientFields.entrySet()) {
                            val = (String)values.get(entry.getKey());
                            if (val == null || val.trim().isEmpty()) continue;
                            writer.write(this.createItemLine("        ", (String)entry.getKey(), (String)itemNumbers.get(entry.getKey()), val));
                        }
                    }
                    writer.write("        <Tumor>\n");
                    for (Map.Entry entry : tumorFields.entrySet()) {
                        val = (String)values.get(entry.getKey());
                        if (val == null || val.trim().isEmpty()) continue;
                        writer.write(this.createItemLine("            ", (String)entry.getKey(), (String)itemNumbers.get(entry.getKey()), val));
                    }
                    writer.write("        </Tumor>\n");
                    currentPatNum = patNum;
                    line = ((LineNumberReader)reader).readLine();
                }
                writer.write("    </Patient>\n");
                writer.write("</NaaccrData>");
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
        SasUtils.logInfo("Successfully created target XML with " + numXmlFields + " field" + (numXmlFields > 1 ? "s" : "") + " defined in the dictionaries");
        if (unusedCsvField != null) {
            String prefix = "CSV file created from data set contained " + numCsvFields + " field" + (numCsvFields > 1 ? "s" : "");
            if (unusedCsvField.isEmpty()) {
                SasUtils.logInfo(prefix + "; all of them were used as NAACCR XML fields");
            } else {
                int usedCsvFields = numCsvFields - unusedCsvField.size();
                String usedText = usedCsvFields > 1 ? " of them were used as NAACCR XML fields and " : " of them was used as NAACCR XML field and ";
                String unusedText = unusedCsvField.size() > 1 ? " were ignored" : " was ignored";
                SasUtils.logInfo(prefix + "; " + usedCsvFields + usedText + unusedCsvField.size() + unusedText);
                StringBuilder buf = new StringBuilder("Ignored field" + (unusedCsvField.size() > 1 ? "s" : "") + ": ");
                for (int i = 0; i < unusedCsvField.size() && i < 5; ++i) {
                    buf.append((String)unusedCsvField.get(i)).append(", ");
                }
                buf.setLength(buf.length() - 2);
                if (unusedCsvField.size() > 5) {
                    buf.append("...");
                }
                SasUtils.logInfo(buf.toString());
            }
        }
    }

    private String createItemLine(String indentation, String itemId, String itemNumber, String value) {
        StringBuilder buf = new StringBuilder(indentation);
        buf.append("<Item naaccrId=\"").append(itemId).append("\"");
        if (itemNumber != null && this._writeNumbers) {
            buf.append(" naaccrNum=\"").append(itemNumber).append("\"");
        }
        buf.append(">").append(SasUtils.cleanUpValueToWriteAsXml(value)).append("</Item>\n");
        return buf.toString();
    }

    public void cleanup() {
        this.cleanup("yes");
    }

    public void cleanup(String option) {
        if ("no".equalsIgnoreCase(option)) {
            SasUtils.logInfo("Skipping CSV file cleanup...");
        } else if (!this._csvFile.delete()) {
            SasUtils.logError("Unable to cleanup tmp CSV file, it will have to be manually deleted...");
        }
    }

    List<File> getUserDictionaryFiles() {
        return this._dictionaryFiles;
    }
}

