/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.sas;

import com.imsweb.naaccrxml.sas.SasFieldInfo;
import com.imsweb.naaccrxml.sas.SasUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;

public class SasFlatToXml {
    private File _flatFile;
    private File _xmlFile;
    private File _formatFile;
    private String _naaccrVersion;
    private String _recordType;
    private boolean _compressTempFile;
    private String _dictionaryUris;
    private List<File> _dictionaryFiles;
    private boolean _writeNumbers;
    private boolean _groupTumors;
    private String _dataSetFields;
    private String _specificationsVersion;

    public SasFlatToXml(String xmlPath) {
        this(xmlPath, "no");
    }

    public SasFlatToXml(String xmlPath, String gzipOption) {
        this.initFiles(xmlPath, "yes".equalsIgnoreCase(gzipOption), false);
    }

    public SasFlatToXml(String xmlPath, String naaccrVersion, String recordType, String logOption) {
        this(xmlPath, naaccrVersion, recordType, logOption, "no");
    }

    public SasFlatToXml(String xmlPath, String naaccrVersion, String recordType, String logOption, String gzipOption) {
        this.initFiles(xmlPath, "yes".equalsIgnoreCase(gzipOption), "yes".equalsIgnoreCase(logOption));
        this._dictionaryFiles = new ArrayList<File>();
        this._naaccrVersion = naaccrVersion;
        if (this._naaccrVersion == null || this._naaccrVersion.trim().isEmpty()) {
            SasUtils.logError("NAACCR version needs to be provided");
        }
        if (!("140".equals(naaccrVersion) || "150".equals(naaccrVersion) || "160".equals(naaccrVersion) || "180".equals(naaccrVersion) || "210".equals(naaccrVersion) || "220".equals(naaccrVersion) || "230".equals(naaccrVersion) || "240".equals(naaccrVersion) || "250".equals(naaccrVersion))) {
            SasUtils.logError("NAACCR version must be 140, 150, 160, 180, 210, 220, 230, 240 or 250; got " + this._naaccrVersion);
        }
        this._recordType = recordType;
        if (this._recordType == null || this._recordType.trim().isEmpty()) {
            SasUtils.logError("Record type needs to be provided");
        }
        if (!("A".equals(this._recordType) || "M".equals(this._recordType) || "C".equals(this._recordType) || "I".equals(this._recordType))) {
            SasUtils.logError("Record type must be A, M, C or I; got " + this._recordType);
        }
        this._writeNumbers = false;
        this._groupTumors = true;
    }

    private void initFiles(String xmlPath, boolean compress, boolean logInfo) {
        this._compressTempFile = compress;
        if (xmlPath == null || xmlPath.trim().isEmpty()) {
            SasUtils.logError("No target XML path was provided");
        } else {
            this._flatFile = new File(SasUtils.computeFlatPathFromXmlPath(xmlPath, compress));
            if (logInfo) {
                SasUtils.logInfo("Source flat: " + this._flatFile.getAbsolutePath());
            }
            this._xmlFile = new File(xmlPath);
            if (!new File(this._xmlFile.getAbsolutePath()).getParentFile().exists()) {
                SasUtils.logError("Parent directory for target XML path doesn't exist: " + this._xmlFile.getParentFile().getAbsolutePath());
            } else if (logInfo) {
                SasUtils.logInfo("Target XML: " + this._xmlFile.getAbsolutePath());
            }
            this._formatFile = new File(SasUtils.computeOutputPathFromXmlPath(xmlPath));
            if (new File(this._formatFile.getAbsolutePath()).getParentFile().exists() && logInfo) {
                SasUtils.logInfo("Target output format: " + this._formatFile.getAbsolutePath());
            }
        }
    }

    public void setDictionary(String dictionaryPath, String dictionaryUri) {
        if (dictionaryPath != null && !dictionaryPath.trim().isEmpty()) {
            for (String path : dictionaryPath.split(";")) {
                File dictionaryFile = new File(path.trim());
                if (!dictionaryFile.exists()) {
                    SasUtils.logError("Invalid CSV dictionary path: " + path);
                    continue;
                }
                try {
                    SasUtils.validateCsvDictionary(dictionaryFile);
                    this._dictionaryFiles.add(dictionaryFile);
                    SasUtils.logInfo("Dictionary: " + dictionaryFile.getAbsolutePath());
                }
                catch (IOException e) {
                    SasUtils.logError("Invalid CSV dictionary: " + e.getMessage());
                }
            }
        }
        if (dictionaryUri != null) {
            StringBuilder buf = new StringBuilder();
            for (String uri : dictionaryUri.split(";")) {
                if (buf.length() > 0) {
                    buf.append(" ");
                }
                buf.append(uri.trim());
            }
            this._dictionaryUris = buf.toString();
        }
    }

    public void setSpecificationsVersion(String specificationsVersion) {
        if (specificationsVersion != null && !specificationsVersion.trim().isEmpty()) {
            this._specificationsVersion = specificationsVersion;
        }
    }

    List<File> getUserDictionaryFiles() {
        return this._dictionaryFiles;
    }

    public void setDataSetFields(String dataSetFields) {
        this._dataSetFields = dataSetFields;
    }

    public String getFlatPath() {
        return this._flatFile.getAbsolutePath();
    }

    public String getXmlPath() {
        return this._xmlFile.getAbsolutePath();
    }

    public String getFormatPath() {
        return this._formatFile.getAbsolutePath();
    }

    public String getNaaccrVersion() {
        return this._naaccrVersion;
    }

    public String getRecordType() {
        return this._recordType;
    }

    public void setWriteNumbers(String value) {
        this._writeNumbers = value != null && ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value));
    }

    public String getWriteNumbers() {
        return this._writeNumbers ? "Yes" : "No";
    }

    public void setGroupTumors(String value) {
        this._groupTumors = value == null || !"false".equalsIgnoreCase(value) && !"no".equalsIgnoreCase(value);
    }

    public String getGroupTumors() {
        return this._groupTumors ? "Yes" : "No";
    }

    public List<SasFieldInfo> getFields() {
        return SasUtils.getFields(this._naaccrVersion, this._recordType, this._dictionaryFiles);
    }

    public void createOutputFormat() throws IOException {
        this.createOutputFormat(null);
    }

    public void createOutputFormat(String fields) throws IOException {
        this.createOutputFormat(fields, this.getFields());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createOutputFormat(String fields, List<SasFieldInfo> availableFields) throws IOException {
        try {
            TreeMap<String, SasFieldInfo> fieldsToWrite;
            block12: {
                BufferedWriter bufferedWriter;
                Set<String> requestedFieldIds = SasUtils.extractRequestedFields(fields, availableFields);
                fieldsToWrite = new TreeMap<String, SasFieldInfo>();
                for (SasFieldInfo sasFieldInfo : availableFields) {
                    if (requestedFieldIds != null && !requestedFieldIds.contains(sasFieldInfo.getNaaccrId())) continue;
                    fieldsToWrite.put(sasFieldInfo.getTruncatedNaaccrId(), sasFieldInfo);
                }
                int expectedLineLength = 0;
                for (SasFieldInfo field : fieldsToWrite.values()) {
                    expectedLineLength += field.getLength().intValue();
                }
                SasUtils.logInfo("Generating output format file...");
                BufferedWriter bufferedWriter2 = null;
                try {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._formatFile), StandardCharsets.US_ASCII));
                    bufferedWriter.write("put\n");
                    int counter = 1;
                    for (Map.Entry entry : fieldsToWrite.entrySet()) {
                        bufferedWriter.write("@" + counter + " " + (String)entry.getKey() + " $" + ((SasFieldInfo)entry.getValue()).getLength() + ".\n");
                        counter += ((SasFieldInfo)entry.getValue()).getLength().intValue();
                    }
                    bufferedWriter.write(";");
                    SasUtils.logInfo("Successfully created output format file with " + fieldsToWrite.size() + " fields (variables) with total line length of " + expectedLineLength);
                    if (bufferedWriter == null) break block12;
                }
                catch (Throwable throwable) {
                    if (bufferedWriter2 == null) throw throwable;
                    bufferedWriter2.close();
                    throw throwable;
                }
                bufferedWriter.close();
            }
            if (this._dataSetFields == null) return;
            List<String> dataSetFields = Arrays.asList(this._dataSetFields.trim().split(","));
            ArrayList<String> extraFields = new ArrayList<String>(dataSetFields);
            extraFields.removeAll(fieldsToWrite.keySet());
            if (extraFields.isEmpty()) {
                SasUtils.logInfo("All variables from the data set will be written...");
                return;
            }
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((String)extraFields.get(i));
            }
            if (extraFields.size() > 5) {
                buf.append(", ...");
            }
            SasUtils.logInfo("The following " + extraFields.size() + " variable(s) from the data set won't be written: " + buf);
            return;
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    public void convert() throws IOException {
        this.convert(null);
    }

    public void convert(String fields) throws IOException {
        this.convert(fields, this.getFields());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void convert(String fields, List<SasFieldInfo> availableFields) throws IOException {
        try {
            void var10_18;
            block31: {
                Set<String> requestedFieldIds = SasUtils.extractRequestedFields(fields, availableFields);
                HashMap<String, String> itemNumbers = new HashMap<String, String>();
                for (SasFieldInfo info : availableFields) {
                    itemNumbers.put(info.getNaaccrId(), info.getNum().toString());
                }
                TreeMap<String, SasFieldInfo> rootFields = new TreeMap<String, SasFieldInfo>();
                TreeMap<String, SasFieldInfo> patientFields = new TreeMap<String, SasFieldInfo>();
                TreeMap<String, SasFieldInfo> tumorFields = new TreeMap<String, SasFieldInfo>();
                TreeMap<String, SasFieldInfo> fieldsToWrite = new TreeMap<String, SasFieldInfo>();
                for (SasFieldInfo sasFieldInfo : availableFields) {
                    if (requestedFieldIds != null && !requestedFieldIds.contains(sasFieldInfo.getNaaccrId())) continue;
                    fieldsToWrite.put(sasFieldInfo.getTruncatedNaaccrId(), sasFieldInfo);
                    if ("NaaccrData".equals(sasFieldInfo.getParentTag())) {
                        rootFields.put(sasFieldInfo.getTruncatedNaaccrId(), sasFieldInfo);
                        continue;
                    }
                    if ("Patient".equals(sasFieldInfo.getParentTag())) {
                        patientFields.put(sasFieldInfo.getTruncatedNaaccrId(), sasFieldInfo);
                        continue;
                    }
                    if (!"Tumor".equals(sasFieldInfo.getParentTag())) continue;
                    tumorFields.put(sasFieldInfo.getTruncatedNaaccrId(), sasFieldInfo);
                }
                int expectedLineLength = 0;
                for (SasFieldInfo field : fieldsToWrite.values()) {
                    expectedLineLength += field.getLength().intValue();
                }
                SasUtils.logInfo("Starting converting flat to XML" + (!this._groupTumors ? " (tumor grouping disabled) " : "") + "...");
                BufferedReader bufferedReader = null;
                BufferedWriter writer = null;
                try {
                    if (this._compressTempFile) {
                        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(this._flatFile)), StandardCharsets.UTF_8));
                    } else {
                        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this._flatFile), StandardCharsets.UTF_8));
                    }
                    writer = SasUtils.createWriter(this._xmlFile);
                    int numPat = 0;
                    int numTum = 0;
                    String currentPatNum = null;
                    String line = var10_18.readLine();
                    boolean wroteRoot = false;
                    int numPatientWritten = 0;
                    while (line != null) {
                        String val;
                        if (line.length() > expectedLineLength) {
                            SasUtils.logError("Expected line length of " + expectedLineLength + " but line #" + var10_18.getLineNumber() + " is " + line.length() + "; truncated it...");
                            line = line.substring(0, expectedLineLength);
                        } else if (line.length() < expectedLineLength) {
                            SasUtils.logError("Expected line length of " + expectedLineLength + " but line #" + var10_18.getLineNumber() + " is " + line.length() + "; padded it...");
                            line = SasUtils.rightPadWithSpaces(line, expectedLineLength);
                        }
                        HashMap<String, String> values = new HashMap<String, String>();
                        int start = 0;
                        for (SasFieldInfo field : fieldsToWrite.values()) {
                            String value = new String(line.substring(start, start + field.getLength()).trim());
                            if (!value.isEmpty()) {
                                values.put(field.getTruncatedNaaccrId(), value);
                            }
                            start += field.getLength().intValue();
                        }
                        String patNum = (String)values.get("patientIdNumber");
                        if (patNum != null && patNum.trim().isEmpty()) {
                            patNum = null;
                        }
                        if (!wroteRoot) {
                            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                            writer.write("\n");
                            writer.write("<NaaccrData");
                            writer.write(" baseDictionaryUri=\"http://naaccr.org/naaccrxml/naaccr-dictionary-" + this._naaccrVersion + ".xml\"");
                            if (!this._dictionaryFiles.isEmpty() && this._dictionaryUris != null && !this._dictionaryUris.trim().isEmpty()) {
                                writer.write("\n            userDictionaryUri=\"" + this._dictionaryUris + "\"");
                            }
                            writer.write("\n            recordType=\"" + this._recordType + "\"");
                            if (this._specificationsVersion != null) {
                                writer.write("\n            specificationVersion=\"" + this._specificationsVersion + "\"");
                            } else {
                                writer.write("\n            specificationVersion=\"1.7\"");
                            }
                            writer.write("\n            xmlns=\"http://naaccr.org/naaccrxml\"");
                            writer.write(">\n");
                            for (Map.Entry entry : rootFields.entrySet()) {
                                val = (String)values.get(entry.getKey());
                                if (val == null || val.trim().isEmpty()) continue;
                                writer.write(this.createItemLine("    ", (String)entry.getKey(), (String)itemNumbers.get(entry.getKey()), val));
                            }
                            wroteRoot = true;
                        }
                        if (!this._groupTumors || patNum == null || currentPatNum == null || !currentPatNum.equals(patNum)) {
                            if (numPatientWritten > 0) {
                                writer.write("    </Patient>\n");
                            }
                            ++numPatientWritten;
                            writer.write("    <Patient>\n");
                            ++numPat;
                            for (Map.Entry entry : patientFields.entrySet()) {
                                val = (String)values.get(entry.getKey());
                                if (val == null || val.trim().isEmpty()) continue;
                                writer.write(this.createItemLine("        ", (String)entry.getKey(), (String)itemNumbers.get(entry.getKey()), val));
                            }
                        }
                        writer.write("        <Tumor>\n");
                        ++numTum;
                        for (Map.Entry entry : tumorFields.entrySet()) {
                            val = (String)values.get(entry.getKey());
                            if (val == null || val.trim().isEmpty()) continue;
                            writer.write(this.createItemLine("            ", (String)entry.getKey(), (String)itemNumbers.get(entry.getKey()), val));
                        }
                        writer.write("        </Tumor>\n");
                        currentPatNum = patNum;
                        line = var10_18.readLine();
                    }
                    writer.write("    </Patient>\n");
                    writer.write("</NaaccrData>");
                    SasUtils.logInfo("Successfully created target XML with " + numPat + " Patient" + (numPat > 1 ? "s" : "") + " and " + numTum + " Tumor" + (numTum > 1 ? "?" : ""));
                    if (writer == null) break block31;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        writer.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    throw throwable;
                }
                writer.close();
            }
            if (var10_18 != null) {
                var10_18.close();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    private String createItemLine(String indentation, String itemId, String itemNumber, String value) {
        StringBuilder buf = new StringBuilder(indentation);
        buf.append("<Item naaccrId=\"").append(itemId).append("\"");
        if (itemNumber != null && this._writeNumbers) {
            buf.append(" naaccrNum=\"").append(itemNumber).append("\"");
        }
        buf.append(">").append(SasUtils.cleanUpValueToWriteAsXml(value)).append("</Item>\n");
        return buf.toString();
    }

    public void cleanup() {
        this.cleanup("yes");
    }

    public void cleanup(String option) {
        if ("no".equalsIgnoreCase(option)) {
            SasUtils.logInfo("Skipping temp files cleanup...");
        } else if (!this._flatFile.delete()) {
            SasUtils.logError("Unable to cleanup " + this._flatFile.getPath() + ", ity will have to be manually deleted...");
        } else if (!this._formatFile.delete()) {
            SasUtils.logError("Unable to cleanup " + this._formatFile.getPath() + ", ity will have to be manually deleted...");
        } else {
            SasUtils.logInfo("Successfully deleted temp files...");
        }
    }
}

