/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class NaaccrErrorUtils {
    public static final String CODE_BAD_LINE_LENGTH = "Invalid line length";
    public static final String CODE_BAD_NAACCR_ID = "Unknown NAACCR ID";
    public static final String CODE_BAD_NAACCR_NUM = "Wrong NAACCR Number";
    public static final String CODE_BAD_DATA_LEVEL = "Invalid data level";
    public static final String CODE_VAL_TOO_LONG = "Value too long";
    public static final String CODE_VAL_TOO_SHORT = "Value too short";
    public static final String CODE_VAL_DATA_TYPE = "Value invalid for data type";
    public static final String CODE_VAL_START_SPACE = "Value starts with a space";
    public static final String CODE_VAL_END_SPACE = "Value ends with a space";
    public static final String CODE_VAL_PAT_VS_TUM = "Patient value not consistent among tumors";
    public static final String CODE_VAL_ROOT_VS_TUM = "NaaccrData value not consistent among tumors";
    public static final String CODE_BAD_TIME_GENERATED = "Invalid Time Generated";
    private static final Map<String, String> _MESSAGES = new LinkedHashMap<String, String>();

    private NaaccrErrorUtils() {
    }

    public static String getValidationError(String code, Object ... msgValues) {
        if (!_MESSAGES.containsKey(code)) {
            throw new IllegalStateException("Unknown code: " + code);
        }
        return NaaccrErrorUtils.fillMessage(_MESSAGES.get(code), msgValues);
    }

    public static Map<String, String> getAllValidationErrors() {
        return Collections.unmodifiableMap(_MESSAGES);
    }

    private static String fillMessage(String msg, Object ... values) {
        String result = msg;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                result = result.replace("${" + i + "}", values[i] == null ? "{blank}" : values[i].toString());
            }
        }
        return result;
    }

    static {
        _MESSAGES.put(CODE_BAD_LINE_LENGTH, "invalid line length, expected ${0} but got ${1}");
        _MESSAGES.put(CODE_BAD_NAACCR_ID, "unknown NAACCR ID: ${0}");
        _MESSAGES.put(CODE_BAD_NAACCR_NUM, "NAACCR Number '${0}' does not correspond to NAACCR ID '${1}'");
        _MESSAGES.put(CODE_BAD_DATA_LEVEL, "invalid data level, expected ${0} but got ${1}");
        _MESSAGES.put(CODE_VAL_TOO_LONG, "value too long, expected at most ${0} character(s) but got ${1}");
        _MESSAGES.put(CODE_VAL_TOO_SHORT, "value too short, expected exactly ${0} character(s) but got ${1}");
        _MESSAGES.put(CODE_VAL_DATA_TYPE, "invalid value according to data type '${0}'");
        _MESSAGES.put(CODE_VAL_START_SPACE, "value starts with one or several spaces");
        _MESSAGES.put(CODE_VAL_END_SPACE, "value ends with one or several spaces");
        _MESSAGES.put(CODE_VAL_PAT_VS_TUM, "item '${0}' is a patient-level and should have the same value for all the records of the patient");
        _MESSAGES.put(CODE_VAL_ROOT_VS_TUM, "item '${0}' is a root-level item and should have the same value for all the records of the transmitted data");
        _MESSAGES.put(CODE_BAD_TIME_GENERATED, "invalid value for 'timeGenerated' attribute: ${0}");
    }
}

