/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.entity.dictionary;

import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryGroupedItem;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NaaccrDictionary {
    private String _dictionaryUri;
    private String _naaccrVersion;
    private String _specificationVersion;
    private Date _dateLastModified;
    private String _description;
    private String _defaultXmlNamespace;
    private List<NaaccrDictionaryItem> _items = new ArrayList<NaaccrDictionaryItem>();
    private List<NaaccrDictionaryGroupedItem> _groupedItems;
    private final Map<String, NaaccrDictionaryItem> _cachedById = new HashMap<String, NaaccrDictionaryItem>();
    private final Map<Integer, NaaccrDictionaryItem> _cachedByNumber = new HashMap<Integer, NaaccrDictionaryItem>();
    private static final Object _CACHED_LOCK = new Object();

    public String getDictionaryUri() {
        return this._dictionaryUri;
    }

    public void setDictionaryUri(String dictionaryUri) {
        this._dictionaryUri = dictionaryUri;
    }

    public String getNaaccrVersion() {
        return this._naaccrVersion;
    }

    public void setNaaccrVersion(String naaccrVersion) {
        this._naaccrVersion = naaccrVersion;
    }

    public String getSpecificationVersion() {
        return this._specificationVersion;
    }

    public void setSpecificationVersion(String specificationVersion) {
        this._specificationVersion = specificationVersion;
    }

    public Date getDateLastModified() {
        return this._dateLastModified;
    }

    public void setDateLastModified(Date dateLastModified) {
        this._dateLastModified = dateLastModified;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDefaultXmlNamespace() {
        return this._defaultXmlNamespace;
    }

    public void setDefaultXmlNamespace(String defaultXmlNamespace) {
        this._defaultXmlNamespace = defaultXmlNamespace;
    }

    public List<NaaccrDictionaryItem> getItems() {
        return Collections.unmodifiableList(this._items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItems(List<NaaccrDictionaryItem> items) {
        if (items != null) {
            this._items = items;
            Object object = _CACHED_LOCK;
            synchronized (object) {
                for (NaaccrDictionaryItem item : items) {
                    this._cachedById.put(item.getNaaccrId(), item);
                    this._cachedByNumber.put(item.getNaaccrNum(), item);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(NaaccrDictionaryItem item) {
        this._items.add(item);
        Object object = _CACHED_LOCK;
        synchronized (object) {
            if (item.getNaaccrId() != null) {
                this._cachedById.put(item.getNaaccrId(), item);
            }
            if (item.getNaaccrNum() != null) {
                this._cachedByNumber.put(item.getNaaccrNum(), item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NaaccrDictionaryItem getItemByNaaccrId(String id) {
        Object object = _CACHED_LOCK;
        synchronized (object) {
            if (this._cachedById.isEmpty()) {
                for (NaaccrDictionaryItem item : this._items) {
                    this._cachedById.put(item.getNaaccrId(), item);
                }
            }
            return this._cachedById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NaaccrDictionaryItem getItemByNaaccrNum(Integer number) {
        Object object = _CACHED_LOCK;
        synchronized (object) {
            if (this._cachedByNumber.isEmpty()) {
                for (NaaccrDictionaryItem item : this._items) {
                    this._cachedByNumber.put(item.getNaaccrNum(), item);
                }
            }
            return this._cachedByNumber.get(number);
        }
    }

    public List<NaaccrDictionaryGroupedItem> getGroupedItems() {
        if (this._groupedItems == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._groupedItems);
    }

    public void setGroupedItems(List<NaaccrDictionaryGroupedItem> items) {
        this._groupedItems = items;
    }

    public void addGroupedItem(NaaccrDictionaryGroupedItem item) {
        if (this._groupedItems == null) {
            this._groupedItems = new ArrayList<NaaccrDictionaryGroupedItem>();
        }
        this._groupedItems.add(item);
    }

    public NaaccrDictionaryGroupedItem getGroupedItemByNaaccrId(String id) {
        if (this._groupedItems == null) {
            return null;
        }
        for (NaaccrDictionaryGroupedItem groupedItem : this._groupedItems) {
            if (!groupedItem.getNaaccrId().equals(id)) continue;
            return groupedItem;
        }
        return null;
    }

    public NaaccrDictionaryGroupedItem getGroupedItemByNaaccrNum(Integer number) {
        if (this._groupedItems == null) {
            return null;
        }
        for (NaaccrDictionaryGroupedItem groupedItem : this._groupedItems) {
            if (!groupedItem.getNaaccrNum().equals(number)) continue;
            return groupedItem;
        }
        return null;
    }
}

