/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml;

import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.runtime.NaaccrStreamConfiguration;
import com.imsweb.naaccrxml.runtime.RuntimeNaaccrDictionary;
import java.util.List;

public class NaaccrContext {
    private String _format;
    private NaaccrOptions _options;
    private List<NaaccrDictionary> _userDictionaries;
    private NaaccrStreamConfiguration _streamConfiguration;

    public NaaccrContext(String format) {
        this(format, null, null);
    }

    public NaaccrContext(String format, List<NaaccrDictionary> userDictionaries) {
        this(format, userDictionaries, null);
    }

    public NaaccrContext(String format, List<NaaccrDictionary> userDictionaries, NaaccrOptions options) {
        if (format == null) {
            throw new RuntimeException("Format cannot be null; see constants in NaaccrFormat class");
        }
        this._format = format;
        this._userDictionaries = userDictionaries;
        this._options = options;
        this._streamConfiguration = NaaccrStreamConfiguration.getDefault();
        NaaccrFormat nf = NaaccrFormat.getInstance(format);
        NaaccrDictionary baseDictionary = NaaccrXmlDictionaryUtils.getBaseDictionaryByVersion(nf.getNaaccrVersion());
        try {
            this._streamConfiguration.setCachedDictionary(new RuntimeNaaccrDictionary(nf.getRecordType(), baseDictionary, userDictionaries));
        }
        catch (NaaccrIOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFormat() {
        return this._format;
    }

    public NaaccrOptions getOptions() {
        return this._options;
    }

    public List<NaaccrDictionary> getUserDictionaries() {
        return this._userDictionaries;
    }

    public NaaccrStreamConfiguration getStreamConfiguration() {
        return this._streamConfiguration;
    }
}

