/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NaaccrOptions {
    public static final String ITEM_HANDLING_ERROR = "error";
    public static final String ITEM_HANDLING_IGNORE = "ignore";
    public static final String ITEM_HANDLING_PROCESS = "process";
    public static final String NEW_LINE_OS = "OS";
    public static final String NEW_LINE_LF = "LF";
    public static final String NEW_LINE_CRLF = "CRLF";
    private Boolean _validateReadValues = true;
    private String _unknownItemHandling = "error";
    private List<String> _itemsToInclude;
    private List<String> _itemsToExclude;
    private List<String> _tumorGroupingItems = new ArrayList<String>();
    private Boolean _reportLevelMismatch;
    private Boolean _writeItemNumber;
    private Boolean _applyZeroPaddingRules;
    private Boolean _reportValuesTooLong;
    private Boolean _useStrictNamespaces;
    private Boolean _ignoreControlCharacters;
    private String _newLine;
    private Boolean _ignoreExtensions;
    private Boolean _translateRenamedStandardItemIds;
    private Map<String, String> _itemIdsToTranslate;
    private Map<String, String> _dictionaryIdsToTranslate;
    private Boolean _allowMissingDictionary;
    private String _specificationVersionWritten;

    public static NaaccrOptions getDefault() {
        return new NaaccrOptions();
    }

    public NaaccrOptions() {
        this._tumorGroupingItems.add("patientIdNumber");
        this._reportLevelMismatch = false;
        this._writeItemNumber = false;
        this._applyZeroPaddingRules = false;
        this._reportValuesTooLong = false;
        this._useStrictNamespaces = true;
        this._ignoreControlCharacters = true;
        this._ignoreExtensions = false;
        this._translateRenamedStandardItemIds = false;
        this._itemIdsToTranslate = null;
        this._dictionaryIdsToTranslate = null;
        this._newLine = NEW_LINE_OS;
        this._allowMissingDictionary = true;
        this._specificationVersionWritten = "1.6";
    }

    public Boolean getValidateReadValues() {
        return this._validateReadValues;
    }

    public void setValidateReadValues(Boolean validateReadValues) {
        this._validateReadValues = validateReadValues;
    }

    public String getUnknownItemHandling() {
        return this._unknownItemHandling;
    }

    public void setUnknownItemHandling(String unknownItemHandling) {
        this._unknownItemHandling = unknownItemHandling;
    }

    public List<String> getItemsToExclude() {
        return this._itemsToExclude;
    }

    public void setItemsToExclude(List<String> itemsToExclude) {
        this._itemsToExclude = itemsToExclude;
    }

    public List<String> getItemsToInclude() {
        return this._itemsToInclude;
    }

    public void setItemsToInclude(List<String> itemsToInclude) {
        this._itemsToInclude = itemsToInclude;
    }

    public List<String> getTumorGroupingItems() {
        return this._tumorGroupingItems;
    }

    public void setTumorGroupingItems(List<String> tumorGroupingItems) {
        this._tumorGroupingItems = tumorGroupingItems;
    }

    public Boolean getReportLevelMismatch() {
        return this._reportLevelMismatch;
    }

    public void setReportLevelMismatch(Boolean reportLevelMismatch) {
        this._reportLevelMismatch = reportLevelMismatch;
    }

    public Boolean getWriteItemNumber() {
        return this._writeItemNumber;
    }

    public void setWriteItemNumber(Boolean writeItemNumber) {
        this._writeItemNumber = writeItemNumber;
    }

    public Boolean getApplyZeroPaddingRules() {
        return this._applyZeroPaddingRules;
    }

    public void setApplyZeroPaddingRules(Boolean applyZeroPaddingRules) {
        this._applyZeroPaddingRules = applyZeroPaddingRules;
    }

    public Boolean getReportValuesTooLong() {
        return this._reportValuesTooLong;
    }

    public void setReportValuesTooLong(Boolean reportValuesTooLong) {
        this._reportValuesTooLong = reportValuesTooLong;
    }

    public Boolean getUseStrictNamespaces() {
        return this._useStrictNamespaces;
    }

    public void setUseStrictNamespaces(Boolean useStrictNamespaces) {
        this._useStrictNamespaces = useStrictNamespaces;
    }

    public Boolean getIgnoreControlCharacters() {
        return this._ignoreControlCharacters;
    }

    public void setIgnoreControlCharacters(Boolean ignoreControlCharacters) {
        this._ignoreControlCharacters = ignoreControlCharacters;
    }

    public String getNewLine() {
        return this._newLine;
    }

    public void setNewLine(String newLine) {
        this._newLine = newLine;
    }

    public Boolean getIgnoreExtensions() {
        return this._ignoreExtensions;
    }

    public void setIgnoreExtensions(Boolean ignoreExtensions) {
        this._ignoreExtensions = ignoreExtensions;
    }

    public Boolean getTranslateRenamedStandardItemIds() {
        return this._translateRenamedStandardItemIds;
    }

    public void setTranslateRenamedStandardItemIds(Boolean translateRenamedStandardItemIds) {
        this._translateRenamedStandardItemIds = translateRenamedStandardItemIds;
    }

    public Map<String, String> getItemIdsToTranslate() {
        return this._itemIdsToTranslate;
    }

    public void setItemIdsToTranslate(Map<String, String> itemIdsToTranslate) {
        this._itemIdsToTranslate = itemIdsToTranslate;
    }

    public Map<String, String> getDictionaryIdsToTranslate() {
        return this._dictionaryIdsToTranslate;
    }

    public void setDictionaryIdsToTranslate(Map<String, String> dictionaryIdsToTranslate) {
        this._dictionaryIdsToTranslate = dictionaryIdsToTranslate;
    }

    public Boolean getAllowMissingDictionary() {
        return this._allowMissingDictionary;
    }

    public void setAllowMissingDictionary(Boolean allowMissingDictionary) {
        this._allowMissingDictionary = allowMissingDictionary;
    }

    public String getSpecificationVersionWritten() {
        return this._specificationVersionWritten;
    }

    public void setSpecificationVersionWritten(String specificationVersionWritten) {
        this._specificationVersionWritten = specificationVersionWritten;
    }

    public static boolean processItem(NaaccrOptions options, String naaccrId) {
        if (options.getItemsToInclude() != null) {
            return options.getItemsToInclude().contains(naaccrId);
        }
        if (options.getItemsToExclude() != null) {
            return !options.getItemsToExclude().contains(naaccrId);
        }
        return true;
    }
}

