/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.entity;

import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Patient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NaaccrData
extends AbstractEntity {
    private String _baseDictionaryUri;
    private List<String> _userDictionaryUri = new ArrayList<String>();
    private String _recordType;
    private Date _timeGenerated;
    private String _specificationVersion;
    private final Map<String, String> _extraRootParameters = new HashMap<String, String>();
    private final List<Patient> _patients = new ArrayList<Patient>();

    public NaaccrData() {
    }

    public NaaccrData(String format) {
        this();
        NaaccrFormat naaccrFormat = NaaccrFormat.getInstance(format);
        this._baseDictionaryUri = NaaccrXmlDictionaryUtils.createUriFromVersion(naaccrFormat.getNaaccrVersion(), true);
        this._recordType = naaccrFormat.getRecordType();
        this._timeGenerated = new Date();
    }

    public String getBaseDictionaryUri() {
        return this._baseDictionaryUri;
    }

    public void setBaseDictionaryUri(String baseDictionaryUri) {
        this._baseDictionaryUri = baseDictionaryUri;
    }

    public List<String> getUserDictionaryUri() {
        return this._userDictionaryUri;
    }

    public void setUserDictionaryUri(List<String> userDictionaryUri) {
        this._userDictionaryUri = userDictionaryUri;
    }

    public String getRecordType() {
        return this._recordType;
    }

    public void setRecordType(String recordType) {
        this._recordType = recordType;
    }

    public Date getTimeGenerated() {
        return this._timeGenerated;
    }

    public void setTimeGenerated(Date timeGenerated) {
        this._timeGenerated = timeGenerated;
    }

    public String getSpecificationVersion() {
        return this._specificationVersion;
    }

    public void setSpecificationVersion(String specificationVersion) {
        this._specificationVersion = specificationVersion;
    }

    public Map<String, String> getExtraRootParameters() {
        return Collections.unmodifiableMap(this._extraRootParameters);
    }

    public void addExtraRootParameters(String key, String value) {
        this._extraRootParameters.put(key, value);
    }

    public List<Patient> getPatients() {
        return Collections.unmodifiableList(this._patients);
    }

    public void addPatient(Patient patient) {
        this._patients.add(patient);
    }

    public void removePatient(int patientIdx) {
        this._patients.remove(patientIdx);
    }

    public void setPatients(List<Patient> patients) {
        this._patients.clear();
        if (patients != null) {
            this._patients.addAll(patients);
        }
    }
}

