/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.gui;

import com.imsweb.naaccrxml.gui.AboutDialog;
import com.imsweb.naaccrxml.gui.pages.DictionariesPage;
import com.imsweb.naaccrxml.gui.pages.DictionaryEditorPage;
import com.imsweb.naaccrxml.gui.pages.FlatToXmlPage;
import com.imsweb.naaccrxml.gui.pages.XmlToFlatPage;
import com.imsweb.naaccrxml.gui.pages.XmlToXmlPage;
import com.imsweb.naaccrxml.gui.pages.XmlValidationPage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.apache.commons.io.IOUtils;

public class Standalone
extends JFrame
implements ActionListener {
    public static final String VERSION = Standalone.getVersion();
    private final CardLayout _layout;
    private final JPanel _centerPnl;
    private final JLabel _currentPageIdLbl;
    private final JLabel _currentPageDescLbl;
    private final List<JButton> _buttons = new ArrayList<JButton>();

    public Standalone() {
        this.setTitle("NAACCR XML Utility " + VERSION);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        ArrayList<Image> appIcons = new ArrayList<Image>();
        appIcons.add(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("gui/icons/app_64.png")));
        appIcons.add(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("gui/icons/app_32.png")));
        appIcons.add(Toolkit.getDefaultToolkit().getImage(Thread.currentThread().getContextClassLoader().getResource("gui/icons/app_16.png")));
        this.setIconImages(appIcons);
        JMenuBar bar = new JMenuBar();
        JMenu fileMenu = new JMenu(" File ");
        fileMenu.setMnemonic(70);
        bar.add(fileMenu);
        JMenuItem exitItem = new JMenuItem("Exit       ");
        exitItem.setActionCommand("menu-exit");
        exitItem.addActionListener(this);
        fileMenu.add(exitItem);
        JMenu helpMenu = new JMenu(" Help ");
        helpMenu.setMnemonic(72);
        JMenuItem helpItem = new JMenuItem("View Help       ");
        helpItem.setActionCommand("menu-help");
        helpItem.addActionListener(this);
        helpMenu.add(helpItem);
        helpMenu.addSeparator();
        JMenuItem aboutItem = new JMenuItem("About");
        aboutItem.setActionCommand("menu-about");
        aboutItem.addActionListener(this);
        helpMenu.add(aboutItem);
        bar.add(helpMenu);
        this.setJMenuBar(bar);
        JPanel northPnl = new JPanel(new FlowLayout(3));
        northPnl.setBackground(new Color(133, 180, 205));
        northPnl.setBorder(new CompoundBorder(new MatteBorder(1, 1, 1, 1, Color.GRAY), new EmptyBorder(0, 5, 0, 5)));
        this._currentPageIdLbl = new JLabel();
        this._currentPageIdLbl.setFont(this._currentPageIdLbl.getFont().deriveFont(1));
        northPnl.add(this._currentPageIdLbl);
        this._currentPageDescLbl = new JLabel();
        northPnl.add(this._currentPageDescLbl);
        this.add((Component)northPnl, "North");
        JToolBar toolbar = new JToolBar();
        toolbar.setOpaque(true);
        toolbar.setBackground(new Color(167, 191, 205));
        toolbar.setFloatable(false);
        toolbar.setBorder(new CompoundBorder(new MatteBorder(0, 1, 1, 1, Color.GRAY), new EmptyBorder(5, 10, 5, 10)));
        toolbar.setLayout(new BoxLayout(toolbar, 1));
        toolbar.add(this.createToolbarButton("Flat to XML", "flat_to_xml", "transform a given NAACCR Flat file (fixed-columns) into the corresponding NAACCR XML file"));
        toolbar.add(Box.createVerticalStrut(15));
        toolbar.add(this.createToolbarButton("XML to Flat", "xml_to_flat", "transform a given NAACCR XML file into the corresponding Flat file (fixed-columns)"));
        toolbar.add(Box.createVerticalStrut(15));
        toolbar.add(this.createToolbarButton("XML to XML", "xml_to_xml", "re-create a given NAACCR XML file using different options"));
        toolbar.add(Box.createVerticalStrut(15));
        toolbar.add(this.createToolbarButton("XML Validation", "validate", "validate a given NAACCR XML file"));
        toolbar.add(Box.createVerticalStrut(15));
        toolbar.add(this.createToolbarButton("Standard<br/>Dictionaries", "dictionaries", "view the standard NAACCR dictionaries used to process NAACCR XML data"));
        toolbar.add(Box.createVerticalStrut(15));
        toolbar.add(this.createToolbarButton("Dictionary<br/>Editor", "edit", "create your own user-defined dictionary"));
        this.getContentPane().add((Component)toolbar, "West");
        this._centerPnl = new JPanel();
        this._centerPnl.setBorder(null);
        this._layout = new CardLayout();
        this._centerPnl.setLayout(this._layout);
        this._centerPnl.add("flat_to_xml", new FlatToXmlPage());
        this._centerPnl.add("xml_to_flat", new XmlToFlatPage());
        this._centerPnl.add("xml_to_xml", new XmlToXmlPage());
        this._centerPnl.add("validate", new XmlValidationPage());
        this._centerPnl.add("dictionaries", new DictionariesPage());
        this._centerPnl.add("edit", new DictionaryEditorPage());
        this.getContentPane().add((Component)this._centerPnl, "Center");
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> SwingUtilities.invokeLater(() -> {
            boolean isLocationException = e instanceof IllegalComponentStateException;
            if (!isLocationException) {
                String msg = "An unexpected error happened, it is recommended to close the application.\n\n   Error: " + (e.getMessage() == null ? "null access" : e.getMessage());
                JOptionPane.showMessageDialog(this, msg, "Error", 0);
            }
        }));
        SwingUtilities.invokeLater(() -> this._buttons.get(0).doClick());
    }

    public static String getVersion() {
        InputStream is;
        String version = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("NAACCR-XML-VERSION");
            try {
                if (is != null) {
                    version = (String)IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.US_ASCII).get(0);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            version = null;
        }
        if (version == null) {
            try {
                is = new FileInputStream(System.getProperty("user.dir") + File.separator + "VERSION");
                try {
                    version = (String)IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.US_ASCII).get(0);
                }
                finally {
                    ((FileInputStream)is).close();
                }
            }
            catch (IOException e) {
                version = null;
            }
        }
        if (version == null) {
            version = "??";
        }
        return "v" + version;
    }

    private JButton createToolbarButton(String text, String pageId, String description) {
        JButton btn = new JButton();
        btn.setIcon(new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("gui/icons/" + pageId + "_inactive.png")));
        btn.setOpaque(false);
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setBorder(new EmptyBorder(10, 5, 5, 5));
        btn.setText("<html><center><b>" + text + "<b></center></html>");
        btn.setForeground(Color.GRAY);
        btn.setVerticalTextPosition(3);
        btn.setHorizontalTextPosition(0);
        btn.setActionCommand(pageId);
        btn.addActionListener(e -> {
            this._currentPageIdLbl.setText(text.replace("<br/>", " ") + " : ");
            this._currentPageDescLbl.setText(description);
            this._layout.show(this._centerPnl, pageId);
            for (JButton btn1 : this._buttons) {
                if (btn1.getActionCommand().equals(pageId)) {
                    btn1.setIcon(new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("gui/icons/" + btn1.getActionCommand() + "_active.png")));
                    btn1.setForeground(Color.BLACK);
                    continue;
                }
                btn1.setIcon(new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("gui/icons/" + btn1.getActionCommand() + "_inactive.png")));
                btn1.setForeground(Color.GRAY);
            }
        });
        this._buttons.add(btn);
        return btn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("menu-exit".equals(cmd)) {
            System.exit(0);
        } else if ("menu-help".equals(cmd)) {
            try {
                File targetFile;
                block18: {
                    targetFile = File.createTempFile("naaccr-xml-help", ".html");
                    targetFile.deleteOnExit();
                    try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("gui/help/help.html");){
                        if (is == null) break block18;
                        try (FileOutputStream os = new FileOutputStream(targetFile);){
                            IOUtils.copy((InputStream)is, (OutputStream)os);
                        }
                    }
                }
                Desktop.getDesktop().open(targetFile);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Unable to display help.", "Error", 0);
            }
        } else if ("menu-about".equals(cmd)) {
            AboutDialog dlg = new AboutDialog((Window)this);
            dlg.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Point center = new Point(screenSize.width / 2, screenSize.height / 2);
            dlg.setLocation(center.x - dlg.getWidth() / 2, center.y - dlg.getHeight() / 2);
            SwingUtilities.invokeLater(() -> dlg.setVisible(true));
        }
    }

    public static JLabel createItalicLabel(String text) {
        JLabel lbl = new JLabel(text);
        lbl.setFont(lbl.getFont().deriveFont(2));
        return lbl;
    }

    public static JLabel createBoldLabel(String text) {
        JLabel lbl = new JLabel(text);
        lbl.setFont(lbl.getFont().deriveFont(1));
        return lbl;
    }

    public static String formatNumber(int num) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalSeparatorAlwaysShown(false);
        return format.format(num);
    }

    public static String formatTime(long timeInMilli) {
        long hourBasis = 60L;
        StringBuilder formattedTime = new StringBuilder();
        long secTmp = timeInMilli / 1000L;
        long sec = secTmp % hourBasis;
        long minTmp = secTmp / hourBasis;
        long min = minTmp % hourBasis;
        long hour = minTmp / hourBasis;
        if (hour > 0L) {
            formattedTime.append(hour).append(" hour");
            if (hour > 1L) {
                formattedTime.append("s");
            }
        }
        if (min > 0L) {
            if (formattedTime.length() > 0) {
                formattedTime.append(", ");
            }
            formattedTime.append(min).append(" minute");
            if (min > 1L) {
                formattedTime.append("s");
            }
        }
        if (sec > 0L) {
            if (formattedTime.length() > 0) {
                formattedTime.append(", ");
            }
            formattedTime.append(sec).append(" second");
            if (sec > 1L) {
                formattedTime.append("s");
            }
        }
        if (formattedTime.length() > 0) {
            return formattedTime.toString();
        }
        return "< 1 second";
    }

    public static String formatFileSize(long size) {
        if (size < 1024L) {
            return size + " B";
        }
        if (size < 0x100000L) {
            return new DecimalFormat("#.# KB").format((double)size / 1024.0);
        }
        if (size < 0x40000000L) {
            return new DecimalFormat("#.# MB").format((double)size / 1024.0 / 1024.0);
        }
        return new DecimalFormat("#.# GB").format((double)size / 1024.0 / 1024.0 / 1024.0);
    }

    public static void main(String[] args) {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                // empty catch block
            }
            UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
            Insets insets = UIManager.getInsets("TabbedPane.tabAreaInsets");
            insets.bottom = 0;
            UIManager.put("TabbedPane.tabAreaInsets", insets);
        }
        Standalone frame = new Standalone();
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point center = new Point(screenSize.width / 2, screenSize.height / 2);
        frame.setLocation(center.x - frame.getWidth() / 2, center.y - frame.getHeight() / 2);
        SwingUtilities.invokeLater(() -> frame.setVisible(true));
    }
}

