/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.gui;

import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryItem;
import com.imsweb.naaccrxml.gui.Standalone;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang3.StringUtils;

public class StandaloneOptions
extends JPanel {
    private final boolean _readFlat;
    private final boolean _writeFlat;
    private final boolean _readXml;
    private final boolean _writeXml;
    private JCheckBox _groupTumorBox;
    private JCheckBox _reportMismatchBox;
    private JCheckBox _validateValuesBox;
    private JCheckBox _ignoreUnkItemsBox;
    private JCheckBox _writeNumBox;
    private JCheckBox _applyPaddingBox;
    private JCheckBox _reportValTooLongBox;
    private JCheckBox _strictNameSpacesBox;
    private JCheckBox _autoTranslateIdsBox;
    private JTextField _itemListFld;
    private JRadioButton _itemsIncludeBtn;
    private JRadioButton _itemsExcludeBtn;

    public StandaloneOptions(boolean readFlat, boolean writeFlat, boolean readXml, boolean writeXml) {
        JPanel pnl;
        this._readFlat = readFlat;
        this._writeFlat = writeFlat;
        this._readXml = readXml;
        this._writeXml = writeXml;
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.setOpaque(false);
        JPanel contentPnl = new JPanel();
        contentPnl.setLayout(new BoxLayout(contentPnl, 1));
        this.add((Component)contentPnl, "North");
        if (readFlat) {
            pnl = new JPanel(new FlowLayout(3, 0, 0));
            this._groupTumorBox = new JCheckBox(" When reading the tumors, group them by Patient ID Number (Item #20).");
            this._groupTumorBox.setSelected(true);
            pnl.add(this._groupTumorBox);
            contentPnl.add(pnl);
            contentPnl.add(Box.createVerticalStrut(2));
            contentPnl.add(this.addHelpRow("If this option is checked, the tumors will be grouped together, resulting in several tumors per patient."));
            contentPnl.add(this.addHelpRow("Otherwise the tumors won't be grouped and every patient will contain exactly one tumor."));
            contentPnl.add(this.addHelpRow("If this option is selected, the lines in the flat file belonging to the same patient are assumed to appear next to each other.", new Color(150, 0, 0)));
            contentPnl.add(Box.createVerticalStrut(10));
        }
        if (readFlat) {
            pnl = new JPanel(new FlowLayout(3, 0, 0));
            this._reportMismatchBox = new JCheckBox(" When grouping the tumors, report value mismatch.");
            this._reportMismatchBox.setSelected(false);
            pnl.add(this._reportMismatchBox);
            contentPnl.add(pnl);
            contentPnl.add(Box.createVerticalStrut(2));
            contentPnl.add(this.addHelpRow("If this option is checked, the items of the tumors grouped together, but having different values will be reported as warnings."));
            contentPnl.add(this.addHelpRow("The few items defined as root-items (like registry ID) but having different values for different patients will also be reported."));
            contentPnl.add(Box.createVerticalStrut(10));
        }
        if (readFlat || readXml) {
            pnl = new JPanel(new FlowLayout(3, 0, 0));
            this._validateValuesBox = new JCheckBox(" When reading the items, validate their value.");
            this._validateValuesBox.setSelected(false);
            pnl.add(this._validateValuesBox);
            contentPnl.add(pnl);
            contentPnl.add(Box.createVerticalStrut(2));
            contentPnl.add(this.addHelpRow("If this option is checked, each value will be validated against the item's data type defined in the dictionary."));
            contentPnl.add(Box.createVerticalStrut(10));
        }
        if (readXml) {
            pnl = new JPanel(new FlowLayout(3, 0, 0));
            this._ignoreUnkItemsBox = new JCheckBox(" When reading the file, ignore unknown items.");
            pnl.add(this._ignoreUnkItemsBox);
            contentPnl.add(pnl);
            contentPnl.add(Box.createVerticalStrut(2));
            contentPnl.add(this.addHelpRow("If this option is checked, unknown items will be ignored. Otherwise a warning will be reported."));
            contentPnl.add(Box.createVerticalStrut(10));
        }
        if (writeXml) {
            pnl = new JPanel(new FlowLayout(3, 0, 0));
            this._writeNumBox = new JCheckBox(" When writing the items in the XML file, also include the NAACCR Number.");
            this._writeNumBox.setSelected(false);
            pnl.add(this._writeNumBox);
            contentPnl.add(pnl);
            contentPnl.add(Box.createVerticalStrut(2));
            contentPnl.add(this.addHelpRow("If this option is checked, the NAACCR Numbers will be written to the file in addition to the NAACCR IDs."));
            contentPnl.add(this.addHelpRow("Otherwise only the NAACCR ID (which ia required) is written as an attribute."));
            contentPnl.add(Box.createVerticalStrut(10));
        }
        if (writeFlat || writeXml) {
            pnl = new JPanel(new FlowLayout(3, 0, 0));
            this._applyPaddingBox = new JCheckBox(" When writing the items, apply zero-padding rules (this might change the actual values being written).");
            this._applyPaddingBox.setSelected(false);
            pnl.add(this._applyPaddingBox);
            contentPnl.add(pnl);
            contentPnl.add(Box.createVerticalStrut(2));
            contentPnl.add(this.addHelpRow("If this option is checked, items defining a padding rule (usually left 0-padded) will have their value modified to honor the definition."));
            contentPnl.add(Box.createVerticalStrut(10));
        }
        if (writeFlat) {
            pnl = new JPanel(new FlowLayout(3, 0, 0));
            this._reportValTooLongBox = new JCheckBox(" When writing the items, report an error if a value is too long.");
            this._reportValTooLongBox.setSelected(false);
            pnl.add(this._reportValTooLongBox);
            contentPnl.add(pnl);
            contentPnl.add(Box.createVerticalStrut(2));
            contentPnl.add(this.addHelpRow("If this option is checked, a warning will be reported if an item in the XML has a value that is too long for the flat file."));
            contentPnl.add(this.addHelpRow("Otherwise the value will be silently cut-off to the maximum length allowed."));
            contentPnl.add(this.addHelpRow("Note that this option doesn't affect items that allow unlimited-text; those will be silently cut-off regardless."));
            contentPnl.add(Box.createVerticalStrut(10));
        }
        if (readXml) {
            pnl = new JPanel(new FlowLayout(3, 0, 0));
            this._autoTranslateIdsBox = new JCheckBox("When reading the file, automatically translate renamed NAACCR XML IDs.");
            this._autoTranslateIdsBox.setSelected(true);
            pnl.add(this._autoTranslateIdsBox);
            contentPnl.add(pnl);
            contentPnl.add(Box.createVerticalStrut(2));
            contentPnl.add(this.addHelpRow("If this option is checked, the application will automatically translate the IDs that were shortened in NAACCR 18."));
            contentPnl.add(this.addHelpRow("You can use this option to read an XML file with the old IDs and re-create it with the new ones."));
            contentPnl.add(Box.createVerticalStrut(10));
            pnl = new JPanel(new FlowLayout(3, 0, 0));
            this._strictNameSpacesBox = new JCheckBox("When reading the file, use strict rules for the XML namespaces.");
            this._strictNameSpacesBox.setSelected(true);
            pnl.add(this._strictNameSpacesBox);
            contentPnl.add(pnl);
            contentPnl.add(Box.createVerticalStrut(2));
            contentPnl.add(this.addHelpRow("If this option is checked, non-standard XML tags/attributes will need to be defined in a proper namespace using a namespace prefix."));
            contentPnl.add(Box.createVerticalStrut(10));
        }
        if (readFlat || readXml || writeFlat || writeXml) {
            pnl = new JPanel(new FlowLayout(3, 0, 0));
            pnl.add(new JLabel("Exclude/Include following items: "));
            this._itemListFld = new JTextField(55);
            pnl.add(this._itemListFld);
            pnl.add(Box.createHorizontalStrut(15));
            this._itemsExcludeBtn = new JRadioButton("Exclusion list");
            pnl.add(this._itemsExcludeBtn);
            pnl.add(Box.createHorizontalStrut(5));
            this._itemsIncludeBtn = new JRadioButton("Inclusion list");
            pnl.add(this._itemsIncludeBtn);
            ButtonGroup group = new ButtonGroup();
            group.add(this._itemsExcludeBtn);
            group.add(this._itemsIncludeBtn);
            this._itemsExcludeBtn.setSelected(true);
            contentPnl.add(pnl);
            contentPnl.add(Box.createVerticalStrut(2));
            contentPnl.add(this.addHelpRow("Comma-separated list of items (NAACCR ID or NAACCR Number) to exclude/include when reading or writing the file."));
            contentPnl.add(Box.createVerticalStrut(10));
        }
    }

    private JPanel addHelpRow(String text) {
        return this.addHelpRow(text, Color.BLACK);
    }

    private JPanel addHelpRow(String text, Color color) {
        JPanel helpPnl = new JPanel(new FlowLayout(3, 0, 0));
        helpPnl.setBorder(new EmptyBorder(0, 50, 0, 0));
        JLabel lbl = Standalone.createItalicLabel(text);
        lbl.setForeground(color);
        helpPnl.add(lbl);
        return helpPnl;
    }

    public NaaccrOptions getOptions(NaaccrDictionary baseDictionary, List<NaaccrDictionary> userDictionaries) {
        String itemsStr;
        NaaccrOptions options = new NaaccrOptions();
        options.setIgnoreExtensions(true);
        if (this._readFlat) {
            if (this._groupTumorBox.isSelected()) {
                options.setTumorGroupingItems(Collections.singletonList("patientIdNumber"));
            } else {
                options.setTumorGroupingItems(Collections.emptyList());
            }
        }
        if (this._readFlat) {
            options.setReportLevelMismatch(this._reportMismatchBox.isSelected());
        }
        if (this._readFlat || this._readXml) {
            options.setValidateReadValues(this._validateValuesBox.isSelected());
        }
        if (this._readXml) {
            if (this._ignoreUnkItemsBox.isSelected()) {
                options.setUnknownItemHandling("ignore");
            } else {
                options.setUnknownItemHandling("error");
            }
        }
        if (this._writeXml) {
            options.setWriteItemNumber(this._writeNumBox.isSelected());
        }
        if (this._writeFlat || this._writeXml) {
            options.setApplyZeroPaddingRules(this._applyPaddingBox.isSelected());
        }
        if (this._writeFlat) {
            options.setReportValuesTooLong(this._reportValTooLongBox.isSelected());
        }
        if ((this._readFlat || this._readXml || this._writeFlat || this._writeXml) && !(itemsStr = this._itemListFld.getText().replace(" ", "")).isEmpty()) {
            HashMap<String, String> itemNumToItemId = new HashMap<String, String>();
            if (baseDictionary != null) {
                for (NaaccrDictionaryItem item : baseDictionary.getItems()) {
                    if (item.getNaaccrNum() == null) continue;
                    itemNumToItemId.put(item.getNaaccrNum().toString(), item.getNaaccrId());
                }
            }
            for (NaaccrDictionary userDictionary : userDictionaries) {
                for (NaaccrDictionaryItem item : userDictionary.getItems()) {
                    if (item.getNaaccrNum() == null) continue;
                    itemNumToItemId.put(item.getNaaccrNum().toString(), item.getNaaccrId());
                }
            }
            ArrayList<String> naaccrIds = new ArrayList<String>();
            for (String s : StringUtils.split((String)itemsStr, (char)',')) {
                naaccrIds.add(itemNumToItemId.getOrDefault(s, s));
            }
            if (this._itemsExcludeBtn.isSelected()) {
                options.setItemsToExclude(naaccrIds);
            } else if (this._itemsIncludeBtn.isSelected()) {
                options.setItemsToInclude(naaccrIds);
            }
        }
        if (this._readXml) {
            options.setTranslateRenamedStandardItemIds(this._autoTranslateIdsBox.isSelected());
            options.setUseStrictNamespaces(this._strictNameSpacesBox.isSelected());
        }
        return options;
    }
}

