/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.gui.components;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.JLabel;

public class SeerClickableLabel
extends JLabel
implements MouseListener {
    private SeerClickableLabelAction _action;
    private boolean _underlined;

    public SeerClickableLabel(String label) {
        this(label, null);
    }

    public SeerClickableLabel(String label, SeerClickableLabelAction action) {
        super(label);
        this._action = action;
        this._underlined = false;
        this.setForeground(Color.BLUE);
        this.addMouseListener(this);
    }

    public void setAction(SeerClickableLabelAction action) {
        this._action = action;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isEnabled() && this._action != null) {
            this._action.execute();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this._underlined = true;
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isEnabled()) {
            this._underlined = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isEnabled()) {
            g.setColor(this.getForeground());
            if (this._underlined) {
                g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            }
        }
    }

    public static SeerClickableLabelAction createBrowseToUrlAction(String url) {
        return () -> {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(URI.create(url));
                }
                catch (IOException | RuntimeException exception) {
                    // empty catch block
                }
            }
        };
    }

    public static SeerClickableLabelAction createOpenFileAction(String path) {
        return () -> {
            File file = new File(path);
            try {
                Desktop desktop;
                Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                if (desktop != null && desktop.isSupported(Desktop.Action.OPEN)) {
                    Desktop.getDesktop().open(file);
                }
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
        };
    }

    public static SeerClickableLabelAction createOpenParentFolderAction(String path) {
        return () -> {
            File file = new File(path);
            try {
                if (file.exists() && System.getProperty("os.name").startsWith("Windows")) {
                    Runtime.getRuntime().exec("Explorer /select," + file.getParentFile().getAbsolutePath() + "\\" + file.getName());
                } else {
                    Desktop desktop;
                    Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                    if (desktop != null && desktop.isSupported(Desktop.Action.OPEN)) {
                        Desktop.getDesktop().open(file.getParentFile());
                    }
                }
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
        };
    }

    public static interface SeerClickableLabelAction {
        public void execute();
    }
}

