/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.gui.pages;

import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import java.awt.BorderLayout;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPage
extends JPanel {
    public AbstractPage() {
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 1, Color.GRAY), new EmptyBorder(10, 10, 10, 25)));
    }

    protected String invertFilename(File file) {
        String[] name = StringUtils.split((String)file.getName(), (char)'.');
        if (name.length < 2) {
            return null;
        }
        String extension = name[name.length - 1];
        boolean compressed = false;
        if (extension.equalsIgnoreCase("gz")) {
            extension = name[name.length - 2];
            compressed = true;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < (compressed ? name.length - 2 : name.length - 1); ++i) {
            result.append(name[i]).append(".");
        }
        result.append(extension.equalsIgnoreCase("xml") ? "txt" : "xml");
        if (compressed) {
            result.append(".gz");
        }
        return new File(file.getParentFile(), result.toString()).getAbsolutePath();
    }

    protected void performExtractToCsv(NaaccrDictionary dictionary, File dir, String filename) {
        JFileChooser fileChooser = new JFileChooser();
        if (dir != null) {
            fileChooser.setCurrentDirectory(dir);
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle("Select Target File");
        fileChooser.setApproveButtonToolTipText("Create CSV");
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setSelectedFile(new File(fileChooser.getCurrentDirectory(), filename));
        if (fileChooser.showDialog(this, "Create CSV") == 0) {
            int result;
            File targetFile = fileChooser.getSelectedFile();
            if (targetFile.exists() && (result = JOptionPane.showConfirmDialog(this, "Target file already exists, are you sure you want to replace it?", "Confirmation", 0)) != 0) {
                return;
            }
            try {
                NaaccrXmlDictionaryUtils.writeDictionaryToCsv(dictionary, targetFile);
                JOptionPane.showMessageDialog(this, "Extract successfully created!", "Success", 1);
            }
            catch (IOException | RuntimeException e) {
                String msg = "Unexpected error creating CSV file\n\n" + e.getMessage();
                JOptionPane.showMessageDialog(this, msg, "Error", 0);
            }
        }
    }
}

