/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.gui.pages;

import com.imsweb.naaccrxml.NaaccrErrorUtils;
import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrObserver;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrValidationError;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.NaaccrXmlUtils;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.gui.Standalone;
import com.imsweb.naaccrxml.gui.StandaloneOptions;
import com.imsweb.naaccrxml.gui.pages.AbstractPage;
import com.imsweb.naaccrxml.gui.pages.FlatToXmlPage;
import com.imsweb.naaccrxml.gui.pages.XmlToFlatPage;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractProcessingPage
extends AbstractPage {
    protected static final String _COMPRESSION_NONE = "None";
    protected static final String _COMPRESSION_GZIP = "GZip";
    protected static final String _COMPRESSION_XZ = "XZ (LZMA)";
    protected static final String _NORTH_PANEL_ID_NO_FILE = "no-file";
    protected static final String _NORTH_PANEL_ID_ERROR = "pre-analysis-error";
    protected static final String _NORTH_PANEL_ID_ANALYSIS_RESULTS = "pre-analysis-results";
    protected static final String _CENTER_PANEL_ID_HELP = "help";
    protected static final String _CENTER_PANEL_ID_OPTIONS = "options";
    protected static final String _CENTER_PANEL_ID_PROCESSING = "processing";
    protected static final String _NORTH_PROCESSING_PANEL_ID_ANALYSIS = "processing-analysis";
    protected static final String _NORTH_PROCESSING_PANEL_ID_PROGRESS = "processing-progress";
    protected static final String _NORTH_PROCESSING_PANEL_ID_RESULTS = "processing-results";
    protected static final String _NORTH_PROCESSING_PANEL_ID_INTERRUPTED = "processing-interrupted";
    protected static final String _NORTH_PROCESSING_PANEL_ID_ERROR = "processing-error";
    private static final String _TXT_DICT_FIXED_COLUMNS = "You can select one or several dictionaries to process the fixed-column data file.";
    private static final String _TXT_DICT_NOT_NEEDED = "The data file does not reference user-defined dictionaries.";
    private static final String _TXT_DICT_NEEDED = "The following user-defined dictionaries need to be provided (use the Browse button to select them):";
    private static final String _TXT_DICT_PROVIDED = "All the user-defined dictionaries have been provided";
    protected JFileChooser _fileChooser;
    protected JFileChooser _dictionaryFileChooser;
    protected CardLayout _northLayout;
    protected CardLayout _centerLayout;
    protected CardLayout _northProcessingLayout;
    protected JPanel _northPnl;
    protected JPanel _centerPnl;
    protected JPanel _northProcessingPnl;
    protected JPanel _dictionaryPnl;
    protected JTextField _sourceFld;
    protected JTextField _targetFld;
    protected JComboBox<String> _compressionBox;
    protected JProgressBar _analysisBar;
    protected JProgressBar _processingBar;
    protected JLabel _analysisErrorLbl;
    protected JLabel _processingErrorLbl;
    protected JLabel _processingResult1Lbl;
    protected JLabel _processingResult2Lbl;
    protected JLabel _formatLbl;
    protected JLabel _numLinesLbl;
    protected JLabel _fileSizeLbl;
    protected JLabel _numPatLbl;
    protected JLabel _numTumLbl;
    protected JLabel _dictionaryLbl;
    protected JLabel _dictionaryDisclaimerLbl;
    protected JTextArea _warningsTextArea;
    protected JTextArea _warningsSummaryTextArea;
    protected JTabbedPane _warningsPane;
    protected StandaloneOptions _guiOptions;
    protected transient SwingWorker<Void, Void> _analysisWorker;
    protected transient SwingWorker<Void, Patient> _processingWorker;
    protected Map<String, NaaccrDictionary> _userDictionaries = new HashMap<String, NaaccrDictionary>();
    protected boolean _maxWarningsReached = false;
    protected boolean _maxWarningsDiscAdded = false;
    protected Map<String, AtomicInteger> _warningStats = new HashMap<String, AtomicInteger>();
    protected Map<String, Set<String>> _warningStatsDetails = new HashMap<String, Set<String>>();

    public AbstractProcessingPage(boolean isSourceXml) {
        this._fileChooser = new JFileChooser();
        this._fileChooser.setFileSelectionMode(0);
        this._fileChooser.setDialogTitle("Select File");
        this._fileChooser.setApproveButtonToolTipText("Select file");
        this._fileChooser.setMultiSelectionEnabled(false);
        this._dictionaryFileChooser = new JFileChooser();
        this._dictionaryFileChooser.setFileSelectionMode(0);
        this._dictionaryFileChooser.setDialogTitle("Select File");
        this._dictionaryFileChooser.setApproveButtonToolTipText("Select file");
        this._dictionaryFileChooser.setMultiSelectionEnabled(false);
        this._dictionaryFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML files (*.xml)";
            }

            @Override
            public boolean accept(File f) {
                return f != null && (f.isDirectory() || f.getName().toLowerCase().endsWith(".xml"));
            }
        });
        JPanel inputFilePnl = new JPanel(new BorderLayout());
        JPanel sourceFilePnl = new JPanel();
        sourceFilePnl.setOpaque(false);
        sourceFilePnl.setBorder(null);
        sourceFilePnl.setLayout(new FlowLayout(3, 0, 0));
        sourceFilePnl.add(Standalone.createBoldLabel(this.getSourceLabelText()));
        sourceFilePnl.add(Box.createHorizontalStrut(5));
        this._sourceFld = new JTextField(60);
        this._sourceFld.setBackground(Color.WHITE);
        sourceFilePnl.add(this._sourceFld);
        sourceFilePnl.add(Box.createHorizontalStrut(5));
        JButton browseBtn = new JButton("Browse...");
        browseBtn.addActionListener(e -> {
            if (this._fileChooser.showDialog(this, "Select") == 0) {
                this._sourceFld.setText(this._fileChooser.getSelectedFile().getAbsolutePath());
                this.performPreAnalysis(isSourceXml);
            }
        });
        sourceFilePnl.add(browseBtn);
        inputFilePnl.add((Component)sourceFilePnl, "North");
        this._northPnl = new JPanel();
        this._northLayout = new CardLayout();
        this._northPnl.setLayout(this._northLayout);
        this._northPnl.add(_NORTH_PANEL_ID_NO_FILE, this.buildNoFileSelectedPanel());
        this._northPnl.add(_NORTH_PANEL_ID_ANALYSIS_RESULTS, this.buildAnalysisResultsPanel(isSourceXml));
        this._northPnl.add(_NORTH_PANEL_ID_ERROR, this.buildAnalysisErrorPanel());
        inputFilePnl.add((Component)this._northPnl, "South");
        this.add((Component)inputFilePnl, "North");
        this._centerPnl = new JPanel();
        this._centerLayout = new CardLayout();
        this._centerPnl.setLayout(this._centerLayout);
        this._centerPnl.add(_CENTER_PANEL_ID_HELP, this.buildHelpPanel());
        this._centerPnl.add(_CENTER_PANEL_ID_OPTIONS, this.buildOptionsPanel(isSourceXml));
        this._centerPnl.add(_CENTER_PANEL_ID_PROCESSING, this.buildProcessingPanel());
        this.add((Component)this._centerPnl, "Center");
    }

    protected abstract String getSourceLabelText();

    protected abstract String getTargetLabelText();

    private JPanel buildTextPnl(String text) {
        JPanel pnl = new JPanel(new FlowLayout(3, 0, 2));
        pnl.add(new JLabel(text));
        return pnl;
    }

    private JPanel buildNoFileSelectedPanel() {
        JPanel pnl = new JPanel(new FlowLayout(3, 0, 0));
        pnl.setBorder(new EmptyBorder(10, 10, 20, 0));
        pnl.add(this.buildTextPnl("No file selected; please use the Browse button to select one."));
        return pnl;
    }

    private JPanel buildHelpPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(new EmptyBorder(10, 10, 0, 0));
        pnl.setLayout(new BoxLayout(pnl, 1));
        boolean conversionPage = this instanceof FlatToXmlPage || this instanceof XmlToFlatPage;
        pnl.add(this.buildTextPnl("The following NAACCR versions are supported:"));
        if (!conversionPage) {
            pnl.add(this.buildTextPnl("             NAACCR 23"));
            pnl.add(this.buildTextPnl("             NAACCR 22"));
            pnl.add(this.buildTextPnl("             NAACCR 21"));
        }
        pnl.add(this.buildTextPnl("             NAACCR 18"));
        pnl.add(this.buildTextPnl("             NAACCR 16"));
        pnl.add(this.buildTextPnl("             NAACCR 15"));
        pnl.add(this.buildTextPnl("             NAACCR 14"));
        pnl.add(this.buildTextPnl("The Abstract, Modified, Confidential and Incidence flavors are supported for those versions."));
        pnl.add(Box.createVerticalStrut(25));
        pnl.add(this.buildTextPnl("The following compressions are supported:"));
        pnl.add(this.buildTextPnl("             GZip (\".gz\" extension)"));
        pnl.add(this.buildTextPnl("             Uncompressed (anything not ending in .gz or .xz will be treated as uncompressed)"));
        if (conversionPage) {
            pnl.add(Box.createVerticalStrut(25));
            pnl.add(this.buildTextPnl("Note that this utility is not a data conversion tool, it simply translates one format into another."));
            pnl.add(this.buildTextPnl("That means the created file (Flat or XML) will always have the same NAACCR version (and same data) as its source."));
        }
        JPanel wrapperPnl = new JPanel(new BorderLayout());
        wrapperPnl.add((Component)pnl, "North");
        return wrapperPnl;
    }

    private JPanel buildAnalysisResultsPanel(boolean isSourceXml) {
        JPanel pnl = new JPanel();
        pnl.setBorder(new EmptyBorder(15, 25, 10, 0));
        pnl.setLayout(new FlowLayout(3, 0, 0));
        pnl.add(Standalone.createBoldLabel("Source File format: "));
        pnl.add(Box.createHorizontalStrut(5));
        this._formatLbl = new JLabel(" ");
        pnl.add(this._formatLbl);
        pnl.add(Box.createHorizontalStrut(25));
        pnl.add(Standalone.createBoldLabel("Num lines: "));
        pnl.add(Box.createHorizontalStrut(5));
        this._numLinesLbl = new JLabel(" ");
        pnl.add(this._numLinesLbl);
        pnl.add(Box.createHorizontalStrut(25));
        if (isSourceXml) {
            pnl.add(Standalone.createBoldLabel("Num patients: "));
            pnl.add(Box.createHorizontalStrut(5));
            this._numPatLbl = new JLabel(" ");
            pnl.add(this._numPatLbl);
            pnl.add(Box.createHorizontalStrut(25));
            pnl.add(Standalone.createBoldLabel("Num tumors: "));
            pnl.add(Box.createHorizontalStrut(5));
            this._numTumLbl = new JLabel(" ");
            pnl.add(this._numTumLbl);
            pnl.add(Box.createHorizontalStrut(25));
        }
        pnl.add(Standalone.createBoldLabel("File size: "));
        pnl.add(Box.createHorizontalStrut(5));
        this._fileSizeLbl = new JLabel(" ");
        pnl.add(this._fileSizeLbl);
        return pnl;
    }

    private JPanel buildAnalysisErrorPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(new EmptyBorder(10, 10, 0, 0));
        pnl.setLayout(new FlowLayout(3, 0, 0));
        JLabel lbl = Standalone.createBoldLabel("Error analysing file: ");
        lbl.setForeground(Color.RED);
        pnl.add(lbl);
        this._analysisErrorLbl = new JLabel(" ");
        this._analysisErrorLbl.setForeground(Color.RED);
        pnl.add(this._analysisErrorLbl);
        return pnl;
    }

    private JPanel buildOptionsPanel(boolean isSourceXml) {
        JPanel pnl = new JPanel(new BorderLayout());
        JPanel headerPnl = new JPanel(new FlowLayout(3, 0, 0));
        headerPnl.setBorder(new EmptyBorder(10, 0, 15, 0));
        JLabel headerLbl = Standalone.createBoldLabel("Please review and/or change the following options. Once you are ready, click the process button at the bottom of the page.");
        headerLbl.setForeground(new Color(150, 0, 0));
        headerPnl.add(headerLbl);
        pnl.add((Component)headerPnl, "North");
        JPanel allOptionsPnl = new JPanel();
        allOptionsPnl.setBorder(new EmptyBorder(0, 15, 0, 0));
        allOptionsPnl.setLayout(new BoxLayout(allOptionsPnl, 1));
        pnl.add((Component)allOptionsPnl, "Center");
        if (this.showTargetInput()) {
            JPanel targetFieldPnl = new JPanel();
            targetFieldPnl.setOpaque(false);
            targetFieldPnl.setBorder(null);
            targetFieldPnl.setLayout(new FlowLayout(3, 0, 0));
            targetFieldPnl.add(Standalone.createBoldLabel(this.getTargetLabelText()));
            targetFieldPnl.add(Box.createHorizontalStrut(5));
            this._targetFld = new JTextField(60);
            targetFieldPnl.add(this._targetFld);
            targetFieldPnl.add(Box.createHorizontalStrut(5));
            JButton browseBtn = new JButton("Browse...");
            browseBtn.addActionListener(e -> {
                if (this._fileChooser.showDialog(this, "Select") == 0) {
                    this._targetFld.setText(this._fileChooser.getSelectedFile().getAbsolutePath());
                }
            });
            targetFieldPnl.add(browseBtn);
            targetFieldPnl.add(Box.createHorizontalStrut(10));
            targetFieldPnl.add(Standalone.createBoldLabel("Compression:"));
            targetFieldPnl.add(Box.createHorizontalStrut(5));
            this._compressionBox = new JComboBox<String>(new String[]{_COMPRESSION_NONE, _COMPRESSION_GZIP, _COMPRESSION_XZ});
            this._compressionBox.addActionListener(e -> {
                if (!this._targetFld.getText().isEmpty()) {
                    this._targetFld.setText(this.fixFileExtension(this._targetFld.getText(), (String)this._compressionBox.getSelectedItem()));
                }
            });
            targetFieldPnl.add(this._compressionBox);
            allOptionsPnl.add(targetFieldPnl);
            allOptionsPnl.add(Box.createVerticalStrut(15));
        }
        JPanel optionsPnl = new JPanel(new BorderLayout());
        Font font = new JLabel().getFont();
        optionsPnl.setBorder(new TitledBorder(null, "Processing Options", 4, 0, font.deriveFont(1), Color.BLACK));
        this._guiOptions = this.createOptions();
        this._guiOptions.setBorder(new EmptyBorder(10, 20, 10, 10));
        optionsPnl.add(this._guiOptions);
        allOptionsPnl.add(optionsPnl);
        JPanel dictionaryDisclaimerPnl = new JPanel(new FlowLayout(3, 0, 0));
        dictionaryDisclaimerPnl.setBorder(new EmptyBorder(15, 0, 0, 0));
        this._dictionaryDisclaimerLbl = Standalone.createBoldLabel(isSourceXml ? _TXT_DICT_NOT_NEEDED : _TXT_DICT_FIXED_COLUMNS);
        dictionaryDisclaimerPnl.add(this._dictionaryDisclaimerLbl);
        allOptionsPnl.add(dictionaryDisclaimerPnl);
        this._dictionaryPnl = new JPanel();
        this._dictionaryPnl.setLayout(new BoxLayout(this._dictionaryPnl, 1));
        JPanel dictionarySelectionPnl = new JPanel();
        dictionarySelectionPnl.setBorder(new EmptyBorder(15, 0, 0, 0));
        dictionarySelectionPnl.setLayout(new FlowLayout(3, 0, 0));
        dictionarySelectionPnl.add(Box.createHorizontalStrut(25));
        this._dictionaryLbl = new JLabel(" ");
        dictionarySelectionPnl.add(this._dictionaryLbl);
        dictionarySelectionPnl.add(Box.createHorizontalStrut(10));
        JButton dictionaryBrowseBtn = new JButton("Browse...");
        dictionaryBrowseBtn.addActionListener(e -> {
            if (this._targetFld != null) {
                this._dictionaryFileChooser.setCurrentDirectory(new File(this._targetFld.getText()));
            }
            if (this._dictionaryFileChooser.showDialog(this, "Select") == 0) {
                try {
                    NaaccrDictionary dictionary = NaaccrXmlDictionaryUtils.readDictionary(this._dictionaryFileChooser.getSelectedFile());
                    this._userDictionaries.put(dictionary.getDictionaryUri(), dictionary);
                    if (isSourceXml) {
                        ArrayList<String> neededDictionaries = new ArrayList<String>(this.getRequiredUserDefinedDictionaries(new File(this._sourceFld.getText())));
                        neededDictionaries.removeAll(this._userDictionaries.keySet());
                        if (neededDictionaries.isEmpty()) {
                            this._dictionaryDisclaimerLbl.setText(_TXT_DICT_PROVIDED);
                            this._dictionaryDisclaimerLbl.setForeground(Color.BLACK);
                            this._dictionaryLbl.setText("");
                            this._dictionaryPnl.setVisible(false);
                        } else {
                            this._dictionaryLbl.setText(String.join((CharSequence)"     ", neededDictionaries));
                        }
                    } else {
                        this._dictionaryLbl.setText(String.join((CharSequence)"     ", this._userDictionaries.keySet()));
                    }
                }
                catch (IOException ex) {
                    String msg = "Unexpected error reading dictionary\n\n" + ex.getMessage();
                    JOptionPane.showMessageDialog(this, msg, "Error", 0);
                }
            }
        });
        dictionarySelectionPnl.add(dictionaryBrowseBtn);
        this._dictionaryPnl.add(dictionarySelectionPnl);
        allOptionsPnl.add(this._dictionaryPnl);
        JPanel controlsPnl = new JPanel(new FlowLayout(3, 0, 0));
        controlsPnl.setBorder(new EmptyBorder(25, 300, 10, 0));
        JButton processBtn = new JButton("Process Source File");
        processBtn.addActionListener(e -> this.performAnalysis());
        controlsPnl.add(processBtn);
        allOptionsPnl.add(controlsPnl);
        pnl.add((Component)new JLabel(" "), "South");
        JPanel wrapperPnl = new JPanel(new BorderLayout());
        wrapperPnl.add((Component)pnl, "North");
        return wrapperPnl;
    }

    protected boolean showTargetInput() {
        return true;
    }

    protected List<String> getRequiredUserDefinedDictionaries(File file) {
        return Collections.emptyList();
    }

    protected abstract StandaloneOptions createOptions();

    private JPanel buildProcessingPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        this._northProcessingPnl = new JPanel();
        this._northProcessingLayout = new CardLayout();
        this._northProcessingPnl.setLayout(this._northProcessingLayout);
        this._northProcessingPnl.add(_NORTH_PROCESSING_PANEL_ID_ANALYSIS, this.buildProcessingAnalysisPanel());
        this._northProcessingPnl.add(_NORTH_PROCESSING_PANEL_ID_PROGRESS, this.buildProcessingProgressPanel());
        this._northProcessingPnl.add(_NORTH_PROCESSING_PANEL_ID_RESULTS, this.buildProcessingResultsPanel());
        this._northProcessingPnl.add(_NORTH_PROCESSING_PANEL_ID_INTERRUPTED, this.buildProcessingInterruptedPanel());
        this._northProcessingPnl.add(_NORTH_PROCESSING_PANEL_ID_ERROR, this.buildProcessingErrorPanel());
        pnl.add((Component)this._northProcessingPnl, "North");
        JPanel centerPnl = new JPanel(new BorderLayout());
        this._warningsPane = new JTabbedPane();
        centerPnl.add((Component)this._warningsPane, "Center");
        JPanel warningsPnl = new JPanel(new BorderLayout());
        warningsPnl.setBorder(null);
        this._warningsTextArea = new JTextArea("Processing not starting...");
        this._warningsTextArea.setForeground(Color.GRAY);
        this._warningsTextArea.setEditable(false);
        this._warningsTextArea.setBorder(new EmptyBorder(2, 3, 2, 3));
        JScrollPane warningsPane = new JScrollPane(this._warningsTextArea);
        warningsPane.setBorder(new LineBorder(Color.LIGHT_GRAY));
        warningsPnl.add((Component)warningsPane, "Center");
        this._warningsPane.add("Warnings", warningsPnl);
        JPanel summaryPnl = new JPanel(new BorderLayout());
        summaryPnl.setBorder(null);
        this._warningsSummaryTextArea = new JTextArea("Processing not starting...");
        this._warningsSummaryTextArea.setForeground(Color.GRAY);
        this._warningsSummaryTextArea.setEditable(false);
        this._warningsSummaryTextArea.setBorder(new EmptyBorder(2, 3, 2, 3));
        JScrollPane summaryPane = new JScrollPane(this._warningsSummaryTextArea);
        summaryPane.setBorder(new LineBorder(Color.LIGHT_GRAY));
        summaryPnl.add((Component)summaryPane, "Center");
        this._warningsPane.add("Summary", summaryPnl);
        pnl.add((Component)centerPnl, "Center");
        return pnl;
    }

    private JPanel buildProcessingAnalysisPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.setBorder(new EmptyBorder(0, 0, 10, 0));
        JPanel lblPnl = new JPanel();
        lblPnl.setLayout(new FlowLayout(3, 0, 0));
        lblPnl.setBorder(null);
        lblPnl.add(Standalone.createItalicLabel("Analyzing file (this can take a while, especially when reading network resources)..."));
        pnl.add((Component)lblPnl, "North");
        JPanel contentPnl = new JPanel(new BorderLayout());
        JPanel progressPnl = new JPanel(new BorderLayout());
        progressPnl.setBorder(new EmptyBorder(5, 0, 5, 0));
        this._analysisBar = new JProgressBar();
        progressPnl.add((Component)this._analysisBar, "Center");
        contentPnl.add((Component)progressPnl, "Center");
        JPanel controlsPnl = new JPanel();
        controlsPnl.setLayout(new FlowLayout(3, 0, 0));
        controlsPnl.setBorder(new EmptyBorder(0, 10, 0, 0));
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(e -> {
            if (this._analysisWorker != null) {
                this._analysisWorker.cancel(true);
            }
            this._analysisWorker = null;
            this._analysisBar.setMinimum(0);
            this._analysisBar.setIndeterminate(true);
            this._sourceFld.setText(null);
            this._northLayout.show(this._northPnl, _NORTH_PANEL_ID_NO_FILE);
            this._centerLayout.show(this._centerPnl, _CENTER_PANEL_ID_HELP);
        });
        controlsPnl.add(cancelBtn);
        contentPnl.add((Component)controlsPnl, "East");
        pnl.add((Component)contentPnl, "Center");
        return pnl;
    }

    private JPanel buildProcessingProgressPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.setBorder(new EmptyBorder(0, 0, 10, 0));
        JPanel lblPnl = new JPanel();
        lblPnl.setLayout(new FlowLayout(3, 0, 0));
        lblPnl.setBorder(null);
        lblPnl.add(Standalone.createItalicLabel("Processing file..."));
        pnl.add((Component)lblPnl, "North");
        JPanel contentPnl = new JPanel(new BorderLayout());
        JPanel progressPnl = new JPanel(new BorderLayout());
        progressPnl.setBorder(new EmptyBorder(5, 0, 5, 0));
        this._processingBar = new JProgressBar();
        progressPnl.add((Component)this._processingBar, "Center");
        contentPnl.add((Component)progressPnl, "Center");
        JPanel controlsPnl = new JPanel();
        controlsPnl.setLayout(new FlowLayout(3, 0, 0));
        controlsPnl.setBorder(new EmptyBorder(0, 10, 0, 0));
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(e -> {
            if (this._processingWorker != null) {
                this._processingWorker.cancel(true);
            }
            this._processingWorker = null;
            this._sourceFld.setText(null);
            this._northLayout.show(this._northPnl, _NORTH_PANEL_ID_NO_FILE);
            this._centerLayout.show(this._centerPnl, _CENTER_PANEL_ID_HELP);
        });
        controlsPnl.add(cancelBtn);
        contentPnl.add((Component)controlsPnl, "East");
        pnl.add((Component)contentPnl, "Center");
        return pnl;
    }

    private JPanel buildProcessingResultsPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(new EmptyBorder(10, 0, 10, 0));
        pnl.setLayout(new BoxLayout(pnl, 1));
        JPanel row1Pnl = new JPanel();
        row1Pnl.setLayout(new FlowLayout(3, 0, 0));
        this._processingResult1Lbl = new JLabel(" ");
        row1Pnl.add(this._processingResult1Lbl);
        pnl.add(row1Pnl);
        JPanel row2Pnl = new JPanel();
        row2Pnl.setLayout(new FlowLayout(3, 0, 0));
        this._processingResult2Lbl = new JLabel();
        row2Pnl.add(this._processingResult2Lbl);
        pnl.add(row2Pnl);
        return pnl;
    }

    private JPanel buildProcessingInterruptedPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(3, 0, 0));
        JLabel lbl = Standalone.createBoldLabel("Processing was interrupted.");
        pnl.add(lbl);
        return pnl;
    }

    private JPanel buildProcessingErrorPanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(new EmptyBorder(10, 10, 0, 0));
        pnl.setLayout(new FlowLayout(3, 0, 0));
        JLabel lbl = Standalone.createBoldLabel("Error processing file: ");
        lbl.setForeground(Color.RED);
        pnl.add(lbl);
        this._processingErrorLbl = new JLabel(" ");
        this._processingErrorLbl.setForeground(Color.RED);
        pnl.add(this._processingErrorLbl);
        return pnl;
    }

    private void performPreAnalysis(boolean isSourceXml) {
        this._centerPnl.setVisible(false);
        File file = new File(this._sourceFld.getText());
        NaaccrFormat format = this.getFormatForInputFile(file);
        if (format != null) {
            if (file.getName().toLowerCase().endsWith(".gz") || file.getName().toLowerCase().endsWith(".xz")) {
                this._formatLbl.setText("Compressed " + format.getDisplayName());
            } else {
                this._formatLbl.setText(format.getDisplayName());
            }
            this._numLinesLbl.setText("<?>");
            if (this._numPatLbl != null) {
                this._numPatLbl.setText("<?>");
            }
            if (this._numTumLbl != null) {
                this._numTumLbl.setText("<?>");
            }
            this._fileSizeLbl.setText(Standalone.formatFileSize(file.length()));
            this._northLayout.show(this._northPnl, _NORTH_PANEL_ID_ANALYSIS_RESULTS);
            this._centerPnl.setVisible(true);
            this._userDictionaries.clear();
            if (isSourceXml) {
                List<String> requiredDictionaries = this.getRequiredUserDefinedDictionaries(file);
                if (!requiredDictionaries.isEmpty()) {
                    this._dictionaryDisclaimerLbl.setText(_TXT_DICT_NEEDED);
                    this._dictionaryDisclaimerLbl.setForeground(new Color(150, 0, 0));
                    this._dictionaryLbl.setText(String.join((CharSequence)"     ", requiredDictionaries));
                    this._dictionaryPnl.setVisible(true);
                } else {
                    this._dictionaryDisclaimerLbl.setText(_TXT_DICT_NOT_NEEDED);
                    this._dictionaryDisclaimerLbl.setForeground(Color.BLACK);
                    this._dictionaryLbl.setText("");
                    this._dictionaryPnl.setVisible(false);
                }
            } else {
                this._dictionaryDisclaimerLbl.setText(_TXT_DICT_FIXED_COLUMNS);
                this._dictionaryDisclaimerLbl.setForeground(Color.BLACK);
                this._dictionaryLbl.setText("              < no dictionary selected >  ");
                this._dictionaryPnl.setVisible(true);
            }
            this._centerLayout.show(this._centerPnl, _CENTER_PANEL_ID_OPTIONS);
            if (this._targetFld != null) {
                this._targetFld.setText(this.invertFilename(file));
                if (this._targetFld.getText().endsWith(".gz")) {
                    this._compressionBox.setSelectedItem(_COMPRESSION_GZIP);
                } else if (this._targetFld.getText().endsWith(".xz")) {
                    this._compressionBox.setSelectedItem(_COMPRESSION_XZ);
                } else {
                    this._compressionBox.setSelectedItem(_COMPRESSION_NONE);
                }
            }
        }
    }

    protected abstract NaaccrFormat getFormatForInputFile(File var1);

    private void performAnalysis() {
        int result;
        ArrayList<String> requiredDictionaries = new ArrayList<String>(this.getRequiredUserDefinedDictionaries(new File(this._sourceFld.getText())));
        requiredDictionaries.removeAll(this._userDictionaries.keySet());
        if (!requiredDictionaries.isEmpty()) {
            StringBuilder message = new StringBuilder("The data file requires the following user-defined dictionaries:\n");
            for (String requiredDictionary : requiredDictionaries) {
                message.append("\n   - ").append(requiredDictionary);
            }
            message.append("\n\nWithout those dictionaries, some data items might not be properly recognized and will be ignored.");
            message.append("\n\nAre you sure you want to continue without providing the dictionaries?");
            int result2 = JOptionPane.showConfirmDialog(this, message, "Confirmation", 0);
            if (result2 != 0) {
                return;
            }
        }
        if (this._targetFld != null && new File(this._targetFld.getText()).exists() && (result = JOptionPane.showConfirmDialog(this, "Target file already exists, are you sure you want to replace it?", "Confirmation", 0)) != 0) {
            return;
        }
        this._centerPnl.setVisible(true);
        this._centerLayout.show(this._centerPnl, _CENTER_PANEL_ID_PROCESSING);
        this._processingResult1Lbl.setText(null);
        this._processingResult2Lbl.setText(null);
        this._northProcessingPnl.setVisible(true);
        this._northProcessingLayout.show(this._northProcessingPnl, _NORTH_PROCESSING_PANEL_ID_ANALYSIS);
        this._warningsTextArea.setText(null);
        this._warningsTextArea.setForeground(new Color(150, 0, 0));
        this._warningsSummaryTextArea.setText("Processing not done...");
        this._warningsSummaryTextArea.setForeground(Color.GRAY);
        this._analysisBar.setMinimum(0);
        this._analysisBar.setIndeterminate(true);
        final File srcFile = new File(this._sourceFld.getText());
        final long start = System.currentTimeMillis();
        this._analysisWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                int numLines = 0;
                int numPat = 0;
                int numTum = 0;
                try (LineNumberReader reader = new LineNumberReader(NaaccrXmlUtils.createReader(srcFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        ++numLines;
                        if (AbstractProcessingPage.this._numPatLbl != null) {
                            numPat += StringUtils.countMatches((CharSequence)line, (CharSequence)"<Patient");
                        }
                        if (AbstractProcessingPage.this._numTumLbl != null) {
                            numTum += StringUtils.countMatches((CharSequence)line, (CharSequence)"<Tumor");
                        }
                        line = reader.readLine();
                    }
                    AbstractProcessingPage.this._numLinesLbl.setText(Standalone.formatNumber(numLines));
                    if (AbstractProcessingPage.this._numPatLbl != null) {
                        AbstractProcessingPage.this._numPatLbl.setText(Standalone.formatNumber(numPat));
                    }
                    if (AbstractProcessingPage.this._numTumLbl != null) {
                        AbstractProcessingPage.this._numTumLbl.setText(Standalone.formatNumber(numTum));
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    AbstractProcessingPage.this._analysisBar.setMinimum(0);
                    AbstractProcessingPage.this._analysisBar.setIndeterminate(true);
                    AbstractProcessingPage.this.performProcessing(srcFile, System.currentTimeMillis() - start);
                }
                catch (InterruptedException | CancellationException exception) {
                }
                catch (ExecutionException e) {
                    AbstractProcessingPage.this.reportAnalysisError(e.getCause());
                }
                finally {
                    AbstractProcessingPage.this._analysisWorker = null;
                }
            }
        };
        this._analysisWorker.execute();
    }

    private void performProcessing(final File srcFile, final long analysisTime) {
        this._northProcessingLayout.show(this._northProcessingPnl, _NORTH_PROCESSING_PANEL_ID_PROGRESS);
        this._processingBar.setMinimum(0);
        this._processingBar.setMaximum(Integer.parseInt(this._numLinesLbl.getText().replaceAll(",", "")));
        this._processingBar.setValue(0);
        this._maxWarningsDiscAdded = false;
        this._maxWarningsReached = false;
        this._warningStats.clear();
        this._warningStatsDetails.clear();
        this._processingWorker = new SwingWorker<Void, Patient>(){

            @Override
            protected Void doInBackground() throws Exception {
                File targetFile = AbstractProcessingPage.this._targetFld == null ? null : new File(AbstractProcessingPage.this.fixFileExtension(AbstractProcessingPage.this._targetFld.getText(), (String)AbstractProcessingPage.this._compressionBox.getSelectedItem()));
                ArrayList<NaaccrDictionary> userDictionaries = new ArrayList<NaaccrDictionary>(AbstractProcessingPage.this._userDictionaries.values());
                long start = System.currentTimeMillis();
                final AtomicInteger numPatients = new AtomicInteger();
                final AtomicInteger numTumors = new AtomicInteger();
                NaaccrFormat format = AbstractProcessingPage.this.getFormatForInputFile(srcFile);
                NaaccrDictionary baseDictionary = format == null ? null : NaaccrXmlDictionaryUtils.getBaseDictionaryByVersion(format.getNaaccrVersion());
                AbstractProcessingPage.this.runProcessing(srcFile, targetFile, AbstractProcessingPage.this._guiOptions.getOptions(baseDictionary, userDictionaries), userDictionaries, new NaaccrObserver(){

                    @Override
                    public void patientRead(Patient patient) {
                        this.publish(new Patient[]{patient});
                    }

                    @Override
                    public void patientWritten(Patient patient) {
                        numPatients.getAndIncrement();
                        numTumors.getAndAdd(patient.getTumors().size());
                    }
                });
                SwingUtilities.invokeLater(() -> {
                    long processingTime = System.currentTimeMillis() - start;
                    String size = targetFile == null ? null : Standalone.formatFileSize(targetFile.length());
                    String path = targetFile == null ? null : targetFile.getPath();
                    AbstractProcessingPage.this._processingResult1Lbl.setText(AbstractProcessingPage.this.getProcessingResultRow1Text(path, analysisTime, processingTime, size));
                    String row2Text = AbstractProcessingPage.this.getProcessingResultRow2Text(numPatients.get(), numTumors.get());
                    if (row2Text != null) {
                        AbstractProcessingPage.this._processingResult2Lbl.setText(row2Text);
                    }
                    AbstractProcessingPage.this._northProcessingLayout.show(AbstractProcessingPage.this._northProcessingPnl, AbstractProcessingPage._NORTH_PROCESSING_PANEL_ID_RESULTS);
                });
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    SwingUtilities.invokeLater(() -> {
                        if (AbstractProcessingPage.this._warningsTextArea.getText().isEmpty()) {
                            AbstractProcessingPage.this._warningsTextArea.setForeground(Color.GRAY);
                            AbstractProcessingPage.this._warningsTextArea.setText("Found no warning, well done!");
                        }
                        if (AbstractProcessingPage.this._warningStats.isEmpty()) {
                            AbstractProcessingPage.this._warningsTextArea.setForeground(Color.GRAY);
                            AbstractProcessingPage.this._warningsSummaryTextArea.setText("Found no warning, well done!");
                        } else {
                            AbstractProcessingPage.this._warningsSummaryTextArea.setForeground(Color.BLACK);
                            StringBuilder buf = new StringBuilder("Validation warning counts (0 counts not displayed):\n\n");
                            for (String code : NaaccrErrorUtils.getAllValidationErrors().keySet()) {
                                int count = AbstractProcessingPage.this._warningStats.containsKey(code) ? AbstractProcessingPage.this._warningStats.get(code).get() : 0;
                                if (count <= 0) continue;
                                buf.append("   ").append(code).append(": ").append(Standalone.formatNumber(count)).append("\n");
                                if (!AbstractProcessingPage.this._warningStatsDetails.containsKey(code)) continue;
                                ArrayList list = new ArrayList(AbstractProcessingPage.this._warningStatsDetails.get(code));
                                Collections.sort(list);
                                buf.append("      ").append(list).append("\n");
                            }
                            AbstractProcessingPage.this._warningsSummaryTextArea.setText(buf.toString());
                        }
                    });
                }
                catch (InterruptedException | CancellationException e) {
                    AbstractProcessingPage.this._warningsSummaryTextArea.setText("Processing interrupted...");
                }
                catch (ExecutionException e) {
                    AbstractProcessingPage.this.reportProcessingError(e.getCause());
                    AbstractProcessingPage.this._warningsSummaryTextArea.setText("Processing error...");
                }
                finally {
                    AbstractProcessingPage.this._processingWorker = null;
                }
            }

            @Override
            protected void process(List<Patient> patients) {
                StringBuilder buf = new StringBuilder();
                for (Patient patient : patients) {
                    for (NaaccrValidationError error : patient.getAllValidationErrors()) {
                        buf.append("Line ").append(error.getLineNumber() == null ? "N/A" : error.getLineNumber());
                        if (error.getNaaccrId() != null) {
                            buf.append(", item '").append(error.getNaaccrId()).append("'");
                            if (error.getNaaccrNum() != null) {
                                buf.append(" (#").append(error.getNaaccrNum()).append(")");
                            }
                        }
                        buf.append(": ").append(error.getMessage());
                        if (error.getValue() != null && !error.getValue().isEmpty()) {
                            buf.append(" [").append(error.getValue().length() > 250 ? error.getValue().substring(0, 250) + "..." : error.getValue()).append("]");
                        }
                        buf.append("\n");
                        AtomicInteger count = AbstractProcessingPage.this._warningStats.get(error.getCode());
                        if (count == null) {
                            AbstractProcessingPage.this._warningStats.put(error.getCode(), new AtomicInteger(1));
                        } else {
                            count.incrementAndGet();
                        }
                        if (error.getNaaccrId() == null) continue;
                        AbstractProcessingPage.this._warningStatsDetails.computeIfAbsent(error.getCode(), k -> new HashSet()).add(error.getNaaccrId());
                    }
                }
                SwingUtilities.invokeLater(() -> {
                    int processedLineNumber = 0;
                    for (Patient patient : patients) {
                        processedLineNumber = Math.max(processedLineNumber, patient.getStartLineNumber());
                    }
                    AbstractProcessingPage.this._processingBar.setValue(processedLineNumber);
                    if (!AbstractProcessingPage.this._maxWarningsReached) {
                        AbstractProcessingPage.this._warningsTextArea.append(buf.toString());
                        if (AbstractProcessingPage.this._warningsTextArea.getLineCount() > 5000) {
                            AbstractProcessingPage.this._maxWarningsReached = true;
                        }
                    } else if (!AbstractProcessingPage.this._maxWarningsDiscAdded) {
                        AbstractProcessingPage.this._warningsTextArea.append("Reached maximum number of warnings that can be displayed; use the summary instead (available once the processing is done)...");
                        AbstractProcessingPage.this._maxWarningsDiscAdded = true;
                    }
                });
            }
        };
        this._processingWorker.execute();
    }

    protected abstract void runProcessing(File var1, File var2, NaaccrOptions var3, List<NaaccrDictionary> var4, NaaccrObserver var5) throws NaaccrIOException;

    protected String getProcessingResultRow1Text(String path, long analysisTime, long processingTime, String size) {
        String analysis = Standalone.formatTime(analysisTime);
        String processing = Standalone.formatTime(processingTime);
        String total = Standalone.formatTime(analysisTime + processingTime);
        return "Successfully created \"" + path + "\" (" + size + ") in " + total + " (analysis: " + analysis + ", processing: " + processing + ")";
    }

    protected String getProcessingResultRow2Text(int numPatients, int numTumors) {
        return null;
    }

    protected void reportAnalysisError(Throwable e) {
        this._centerPnl.setVisible(false);
        this._analysisBar.setIndeterminate(false);
        this._analysisErrorLbl.setText(this.extractMessageFromException(e));
        this._northLayout.show(this._northPnl, _NORTH_PANEL_ID_ERROR);
    }

    protected void reportProcessingError(Throwable e) {
        this._processingErrorLbl.setText(this.extractMessageFromException(e));
        this._northProcessingLayout.show(this._northProcessingPnl, _NORTH_PROCESSING_PANEL_ID_ERROR);
    }

    private String extractMessageFromException(Throwable e) {
        String result = null;
        if (e != null) {
            NaaccrIOException ioe;
            if (e instanceof NaaccrIOException && (ioe = (NaaccrIOException)e).getMessage() != null) {
                result = ioe.getLineNumber() != null ? e.getMessage() + " at line " + ioe.getLineNumber() : e.getMessage();
            }
            if (result == null) {
                result = e.getMessage();
            }
        }
        if (result == null) {
            result = "unexpected error";
        }
        return result;
    }

    private String fixFileExtension(String filename, String compression) {
        String result = filename;
        if (_COMPRESSION_GZIP.equals(compression)) {
            if (result.endsWith(".xz")) {
                result = result.replace(".xz", "");
            }
            if (!result.endsWith(".gz")) {
                result = result + ".gz";
            }
        } else if (_COMPRESSION_XZ.equals(compression)) {
            if (result.endsWith(".gz")) {
                result = result.replace(".gz", "");
            }
            if (!result.endsWith(".xz")) {
                result = result + ".xz";
            }
        } else if (_COMPRESSION_NONE.equals(compression)) {
            if (result.endsWith(".gz")) {
                result = result.replace(".gz", "");
            } else if (result.endsWith(".xz")) {
                result = filename.replace(".xz", "");
            }
        }
        return result;
    }
}

