/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.gui.pages;

import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryItem;
import com.imsweb.naaccrxml.gui.Standalone;
import com.imsweb.naaccrxml.gui.pages.AbstractPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.io.IOUtils;

public class DictionariesPage
extends AbstractPage {
    private final JLabel _dictionaryUriFld;
    private final JLabel _versionFld;
    private final JLabel _descFld;
    private final JTextArea _xmlArea;
    private final JTextField _filterFld;
    private final JTable _itemsTbl;
    private final DefaultTableModel _itemsModel;
    private final TableRowSorter<TableModel> _itemsSorter;

    public DictionariesPage() {
        this.setBorder(new MatteBorder(0, 0, 1, 1, Color.GRAY));
        this.setPreferredSize(new Dimension(500, 300));
        Vector<NaaccrDictionaryWrapper> standardDictionaries = new Vector<NaaccrDictionaryWrapper>();
        for (String version : NaaccrFormat.getSupportedVersions()) {
            standardDictionaries.add(new NaaccrDictionaryWrapper(NaaccrXmlDictionaryUtils.getBaseDictionaryByVersion(version), true));
            NaaccrDictionary defaultUserDictionary = NaaccrXmlDictionaryUtils.getDefaultUserDictionaryByVersion(version);
            if (defaultUserDictionary == null) continue;
            standardDictionaries.add(new NaaccrDictionaryWrapper(defaultUserDictionary, false));
        }
        standardDictionaries.sort((o1, o2) -> o2.getDictionary().getNaaccrVersion().compareTo(o1.getDictionary().getNaaccrVersion()));
        JPanel controlsPnl = new JPanel(new FlowLayout(3, 0, 0));
        this.add((Component)controlsPnl, "North");
        controlsPnl.setBackground(new Color(206, 220, 227));
        controlsPnl.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), new EmptyBorder(5, 10, 5, 0)));
        controlsPnl.add(Standalone.createBoldLabel("Dictionary:"));
        controlsPnl.add(Box.createHorizontalStrut(10));
        JComboBox selectionBox = new JComboBox(standardDictionaries);
        controlsPnl.add(selectionBox);
        controlsPnl.add(Box.createHorizontalStrut(25));
        JButton extractBtn = new JButton("Extract to CSV...");
        extractBtn.setOpaque(false);
        extractBtn.addActionListener(e -> {
            NaaccrDictionaryWrapper wrapper = (NaaccrDictionaryWrapper)selectionBox.getSelectedItem();
            String targetFilename = (wrapper.isBase() ? "base-naaccr-dictionary-" : "base-user-defined-naaccr-dictionary-") + wrapper.getDictionary().getNaaccrVersion() + ".csv";
            this.performExtractToCsv(wrapper.getDictionary(), null, targetFilename);
        });
        controlsPnl.add(extractBtn);
        controlsPnl.add(Box.createHorizontalStrut(25));
        JPanel centerPnl = new JPanel(new BorderLayout());
        this.add((Component)centerPnl, "Center");
        JPanel dictAttributesPnl = new JPanel(new FlowLayout(3, 0, 0));
        dictAttributesPnl.setBorder(new EmptyBorder(10, 10, 0, 10));
        dictAttributesPnl.add(Standalone.createBoldLabel("URI:"));
        dictAttributesPnl.add(Box.createHorizontalStrut(5));
        this._dictionaryUriFld = new JLabel(" ");
        dictAttributesPnl.add(this._dictionaryUriFld);
        dictAttributesPnl.add(Box.createHorizontalStrut(20));
        dictAttributesPnl.add(Standalone.createBoldLabel("Version:"));
        dictAttributesPnl.add(Box.createHorizontalStrut(5));
        this._versionFld = new JLabel(" ");
        dictAttributesPnl.add(this._versionFld);
        dictAttributesPnl.add(Box.createHorizontalStrut(20));
        dictAttributesPnl.add(Standalone.createBoldLabel("Description:"));
        dictAttributesPnl.add(Box.createHorizontalStrut(5));
        this._descFld = new JLabel(" ");
        dictAttributesPnl.add(this._descFld);
        centerPnl.add((Component)dictAttributesPnl, "North");
        JPanel fieldsPnl = new JPanel(new BorderLayout());
        centerPnl.add((Component)fieldsPnl, "Center");
        fieldsPnl.setBorder(new EmptyBorder(10, 10, 10, 10));
        JTabbedPane pane = new JTabbedPane();
        fieldsPnl.add((Component)pane, "Center");
        JPanel xmlPnl = new JPanel(new BorderLayout());
        pane.addTab("View items in XML", xmlPnl);
        this._xmlArea = new JTextArea();
        this._xmlArea.setEditable(false);
        this._xmlArea.setRows(25);
        this._xmlArea.setOpaque(true);
        JScrollPane xmlScrollPane = new JScrollPane(this._xmlArea);
        xmlScrollPane.setBorder(new MatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
        xmlPnl.add((Component)xmlScrollPane, "Center");
        JPanel tablePnl = new JPanel(new BorderLayout());
        tablePnl.setBorder(new LineBorder(Color.LIGHT_GRAY));
        pane.addTab("View items in a table", tablePnl);
        JPanel tableContentPnl = new JPanel(new BorderLayout());
        tablePnl.add((Component)tableContentPnl, "Center");
        this._itemsModel = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 1 || columnIndex == 3 || columnIndex == 4) {
                    return Integer.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this._itemsTbl = new JTable(this._itemsModel);
        this._itemsTbl.setDragEnabled(false);
        this._itemsSorter = new TableRowSorter<DefaultTableModel>(this._itemsModel);
        this._itemsTbl.setRowSorter(this._itemsSorter);
        DefaultTableCellRenderer itemsRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                comp.setBorder(new CompoundBorder(new EmptyBorder(new Insets(1, 1, 1, 1)), this.getBorder()));
                return comp;
            }
        };
        itemsRenderer.setHorizontalAlignment(2);
        this._itemsTbl.setDefaultRenderer(String.class, itemsRenderer);
        this._itemsTbl.setDefaultRenderer(Integer.class, itemsRenderer);
        JScrollPane tableScrollPane = new JScrollPane(this._itemsTbl);
        tableScrollPane.setBorder(null);
        tableContentPnl.add((Component)tableScrollPane, "Center");
        JPanel tableControlsPnl = new JPanel(new FlowLayout(3, 0, 0));
        tableControlsPnl.setBorder(new EmptyBorder(10, 10, 10, 10));
        tablePnl.add((Component)tableControlsPnl, "South");
        tableControlsPnl.add(new JLabel("Filter Items:"));
        tableControlsPnl.add(Box.createHorizontalStrut(5));
        this._filterFld = new JTextField(25);
        this._filterFld.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    DictionariesPage.this._itemsSorter.setRowFilter(RowFilter.regexFilter("(?i)" + DictionariesPage.this._filterFld.getText(), 0, 1, 2));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                try {
                    DictionariesPage.this._itemsSorter.setRowFilter(RowFilter.regexFilter("(?i)" + DictionariesPage.this._filterFld.getText(), 0, 1, 2));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        tableControlsPnl.add(this._filterFld);
        tableControlsPnl.add(Box.createHorizontalStrut(10));
        tableControlsPnl.add(new JLabel("(only the ID, Num and Name columns are searched)"));
        selectionBox.addItemListener(e -> this.setDictionary((NaaccrDictionaryWrapper)selectionBox.getSelectedItem()));
        this.setDictionary((NaaccrDictionaryWrapper)selectionBox.getSelectedItem());
    }

    private void setDictionary(NaaccrDictionaryWrapper dictionaryWrapper) {
        NaaccrDictionary dictionary = dictionaryWrapper.getDictionary();
        this._dictionaryUriFld.setText(dictionary.getDictionaryUri());
        this._versionFld.setText(dictionary.getNaaccrVersion());
        this._descFld.setText(dictionary.getDescription());
        this._itemsModel.setRowCount(0);
        Vector<String> columns = new Vector<String>();
        columns.add("ID");
        columns.add("Num");
        columns.add("Name");
        columns.add("Start Col");
        columns.add("Length");
        columns.add("Record Types");
        columns.add("Parent XML Element");
        columns.add("Data Type");
        columns.add("Padding");
        columns.add("Trimming");
        Vector rows = new Vector();
        for (NaaccrDictionaryItem item : dictionary.getItems()) {
            Vector<Object> row = new Vector<Object>();
            row.add(item.getNaaccrId());
            row.add(item.getNaaccrNum());
            row.add(item.getNaaccrName());
            row.add(item.getStartColumn());
            row.add(item.getLength());
            row.add(item.getRecordTypes());
            row.add(item.getParentXmlElement());
            row.add(item.getDataType() == null ? "text" : item.getDataType());
            row.add(item.getPadding() == null ? "rightBlank" : item.getPadding());
            row.add(item.getTrim() == null ? "all" : item.getTrim());
            rows.add(row);
        }
        this._itemsModel.setDataVector(rows, columns);
        this._itemsSorter.setRowFilter(null);
        this._filterFld.setText("");
        this._itemsTbl.getColumnModel().getColumn(1).setPreferredWidth(45);
        this._itemsTbl.getColumnModel().getColumn(3).setPreferredWidth(45);
        this._itemsTbl.getColumnModel().getColumn(4).setPreferredWidth(30);
        this._itemsTbl.getColumnModel().getColumn(7).setPreferredWidth(40);
        this._itemsTbl.getColumnModel().getColumn(9).setPreferredWidth(40);
        String dictionaryUrl = (dictionaryWrapper.isBase() ? "naaccr-dictionary-" : "\"user-defined-naaccr-dictionary-") + dictionary.getNaaccrVersion() + ".xml";
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(dictionaryUrl);){
            if (is != null) {
                this._xmlArea.setText(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
            } else {
                this._xmlArea.setText("Unable to read internal dictionary...");
            }
        }
        catch (IOException ex) {
            this._xmlArea.setText("Unable to read dictionary...");
        }
        this._xmlArea.setCaretPosition(0);
    }

    private static class NaaccrDictionaryWrapper {
        private final NaaccrDictionary _dictionary;
        private final boolean _isBase;

        public NaaccrDictionaryWrapper(NaaccrDictionary dictionary, boolean isBase) {
            this._dictionary = dictionary;
            this._isBase = isBase;
        }

        public NaaccrDictionary getDictionary() {
            return this._dictionary;
        }

        public boolean isBase() {
            return this._isBase;
        }

        public String toString() {
            return this._dictionary.getDescription();
        }
    }
}

