/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.gui.pages;

import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryItem;
import com.imsweb.naaccrxml.gui.Standalone;
import com.imsweb.naaccrxml.gui.components.SeerClickableLabel;
import com.imsweb.naaccrxml.gui.pages.AbstractPage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

public class DictionaryEditorPage
extends AbstractPage
implements ActionListener {
    private static final String _BLANK_VERSION = "<Any>";
    private static final String _NO_FILE_TEXT = "< no current file, use the load button to load an existing dictionary, or the save-as button to save the current dictionary >";
    private JLabel _currentFileLbl;
    private JLabel _currentFilePreLbl;
    private JLabel _currentFileMiddleLbl;
    private JLabel _currentFilePostLbl;
    private SeerClickableLabel _openCurrentFileLbl;
    private SeerClickableLabel _openParentFolderLbl;
    private final JTextField _dictionaryUriFld;
    private final JTextField _descFld;
    private final JComboBox<String> _versionBox;
    private final JTable _itemsTbl;
    private final DefaultTableModel _itemsModel;
    private final JFileChooser _dictionaryFileChooser;
    private final JFileChooser _outputFileChooser;
    private File _currentFile;

    public DictionaryEditorPage() {
        this.setBorder(new MatteBorder(0, 0, 1, 1, Color.GRAY));
        JPanel controlsPnl = new JPanel(new BorderLayout());
        this.add((Component)controlsPnl, "North");
        controlsPnl.add((Component)this.createToolBar(), "North");
        controlsPnl.add((Component)this.createFilePanel(), "South");
        JPanel centerPnl = new JPanel(new BorderLayout());
        this.add((Component)centerPnl, "Center");
        JPanel dictAttributesPnl = new JPanel(new FlowLayout(3, 0, 0));
        centerPnl.add((Component)dictAttributesPnl, "North");
        dictAttributesPnl.setBorder(new EmptyBorder(10, 10, 0, 10));
        dictAttributesPnl.add(Standalone.createBoldLabel("URI:"));
        dictAttributesPnl.add(Box.createHorizontalStrut(5));
        this._dictionaryUriFld = new JTextField(45);
        dictAttributesPnl.add(this._dictionaryUriFld);
        dictAttributesPnl.add(Box.createHorizontalStrut(20));
        dictAttributesPnl.add(Standalone.createBoldLabel("Version:"));
        dictAttributesPnl.add(Box.createHorizontalStrut(5));
        Vector<String> versions = new Vector<String>();
        versions.add(_BLANK_VERSION);
        NaaccrFormat.getSupportedVersions().stream().sorted(Collections.reverseOrder()).forEach(versions::add);
        this._versionBox = new JComboBox(versions);
        dictAttributesPnl.add(this._versionBox);
        dictAttributesPnl.add(Box.createHorizontalStrut(20));
        dictAttributesPnl.add(Standalone.createBoldLabel("Description:"));
        dictAttributesPnl.add(Box.createHorizontalStrut(5));
        this._descFld = new JTextField(40);
        dictAttributesPnl.add(this._descFld);
        JPanel tablePnl = new JPanel(new BorderLayout());
        centerPnl.add((Component)tablePnl, "Center");
        tablePnl.setBorder(new EmptyBorder(10, 10, 5, 10));
        JPanel tableContentPnl = new JPanel(new BorderLayout());
        tablePnl.add((Component)tableContentPnl, "Center");
        this._itemsModel = new DefaultTableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 1 || columnIndex == 3 || columnIndex == 4) {
                    return Integer.class;
                }
                return String.class;
            }
        };
        this._itemsTbl = new JTable(this._itemsModel);
        this._itemsTbl.setDragEnabled(false);
        this._itemsTbl.setSelectionMode(0);
        this._itemsTbl.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "edit");
        this._itemsTbl.getActionMap().put("edit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = DictionaryEditorPage.this._itemsTbl.getSelectedRow();
                int col = DictionaryEditorPage.this._itemsTbl.getSelectedColumn();
                DictionaryEditorPage.this._itemsTbl.editCellAt(row, col);
                Component comp = DictionaryEditorPage.this._itemsTbl.getEditorComponent();
                comp.requestFocusInWindow();
                if (comp instanceof JTextComponent) {
                    ((JTextComponent)comp).selectAll();
                }
            }
        });
        DefaultTableCellRenderer itemsRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                comp.setBorder(new CompoundBorder(new EmptyBorder(new Insets(1, 1, 1, 1)), this.getBorder()));
                return comp;
            }
        };
        itemsRenderer.setHorizontalAlignment(2);
        this._itemsTbl.setDefaultRenderer(String.class, itemsRenderer);
        this._itemsTbl.setDefaultRenderer(Integer.class, itemsRenderer);
        this._itemsTbl.setSelectionBackground(new Color(210, 227, 236));
        this._itemsTbl.setSelectionForeground(Color.BLACK);
        this._itemsTbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu popup = new JPopupMenu("Table Popup");
                    popup.setBorder(new BevelBorder(0));
                    boolean rowSelected = DictionaryEditorPage.this._itemsTbl.getSelectedRow() != -1;
                    JMenuItem addRowFirstItem = new JMenuItem("Insert row first");
                    addRowFirstItem.setActionCommand("table-add-row-first");
                    addRowFirstItem.addActionListener(DictionaryEditorPage.this);
                    popup.add(addRowFirstItem);
                    JMenuItem addRowLastItem = new JMenuItem("Insert row last");
                    addRowLastItem.setActionCommand("table-add-row-last");
                    addRowLastItem.addActionListener(DictionaryEditorPage.this);
                    popup.add(addRowLastItem);
                    popup.addSeparator();
                    JMenuItem addRowBeforeItem = new JMenuItem("Insert row before");
                    addRowBeforeItem.setActionCommand("table-add-row-before");
                    addRowBeforeItem.addActionListener(DictionaryEditorPage.this);
                    if (!rowSelected) {
                        addRowBeforeItem.setEnabled(false);
                    }
                    popup.add(addRowBeforeItem);
                    JMenuItem addRowAfterItem = new JMenuItem("Insert row after");
                    addRowAfterItem.setActionCommand("table-add-row-after");
                    addRowAfterItem.addActionListener(DictionaryEditorPage.this);
                    if (!rowSelected) {
                        addRowAfterItem.setEnabled(false);
                    }
                    popup.add(addRowAfterItem);
                    popup.addSeparator();
                    JMenuItem removeSelectedRowItem = new JMenuItem("Remove row");
                    removeSelectedRowItem.setActionCommand("table-remove-row");
                    removeSelectedRowItem.addActionListener(DictionaryEditorPage.this);
                    if (!rowSelected) {
                        removeSelectedRowItem.setEnabled(false);
                    }
                    popup.add(removeSelectedRowItem);
                    JMenuItem removeAllRowsExceptSelectedItem = new JMenuItem("Remove all other rows");
                    removeAllRowsExceptSelectedItem.setActionCommand("table-remove-all-other-rows");
                    removeAllRowsExceptSelectedItem.addActionListener(DictionaryEditorPage.this);
                    if (!rowSelected) {
                        removeAllRowsExceptSelectedItem.setEnabled(false);
                    }
                    popup.add(removeAllRowsExceptSelectedItem);
                    JMenuItem removeAllRowsItem = new JMenuItem("Remove all rows");
                    removeAllRowsItem.setActionCommand("table-remove-all-rows");
                    removeAllRowsItem.addActionListener(DictionaryEditorPage.this);
                    popup.add(removeAllRowsItem);
                    popup.addSeparator();
                    JMenuItem generateIdFromNameItem = new JMenuItem("Generate ID from Name");
                    generateIdFromNameItem.setActionCommand("table-generate-id-from-name");
                    generateIdFromNameItem.addActionListener(DictionaryEditorPage.this);
                    if (!rowSelected) {
                        generateIdFromNameItem.setEnabled(false);
                    }
                    popup.add(generateIdFromNameItem);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.populateGuiFromDictionary(this.createEmptyDictionary());
        this._itemsTbl.getColumnModel().getColumn(1).setPreferredWidth(45);
        this._itemsTbl.getColumnModel().getColumn(3).setPreferredWidth(45);
        this._itemsTbl.getColumnModel().getColumn(4).setPreferredWidth(30);
        this._itemsTbl.getColumnModel().getColumn(7).setPreferredWidth(40);
        this._itemsTbl.getColumnModel().getColumn(9).setPreferredWidth(40);
        JComboBox<String> recordTypeBox = new JComboBox<String>();
        recordTypeBox.addItem("A,M,C,I");
        recordTypeBox.addItem("A,M,C");
        recordTypeBox.addItem("A,M");
        this._itemsTbl.getColumnModel().getColumn(5).setCellEditor(new DefaultCellEditor(recordTypeBox));
        JComboBox<String> parentElementBox = new JComboBox<String>();
        parentElementBox.addItem("NaaccrData");
        parentElementBox.addItem("Patient");
        parentElementBox.addItem("Tumor");
        this._itemsTbl.getColumnModel().getColumn(6).setCellEditor(new DefaultCellEditor(parentElementBox));
        JComboBox<String> dataTypeBox = new JComboBox<String>();
        dataTypeBox.addItem("text");
        dataTypeBox.addItem("digits");
        dataTypeBox.addItem("alpha");
        dataTypeBox.addItem("mixed");
        dataTypeBox.addItem("numeric");
        dataTypeBox.addItem("date");
        this._itemsTbl.getColumnModel().getColumn(7).setCellEditor(new DefaultCellEditor(dataTypeBox));
        JComboBox<String> paddingBox = new JComboBox<String>();
        paddingBox.addItem("none");
        paddingBox.addItem("leftZero");
        paddingBox.addItem("rightZero");
        this._itemsTbl.getColumnModel().getColumn(8).setCellEditor(new DefaultCellEditor(paddingBox));
        JComboBox<String> trimmingBox = new JComboBox<String>();
        trimmingBox.addItem("all");
        trimmingBox.addItem("none");
        this._itemsTbl.getColumnModel().getColumn(9).setCellEditor(new DefaultCellEditor(trimmingBox));
        this._itemsTbl.getSelectionModel().setSelectionInterval(0, 0);
        SwingUtilities.invokeLater(this._itemsTbl::requestFocusInWindow);
        JScrollPane tableScrollPane = new JScrollPane(this._itemsTbl);
        tableScrollPane.setBorder(null);
        tableContentPnl.add((Component)tableScrollPane, "Center");
        JPanel disclaimerPnl = new JPanel();
        disclaimerPnl.setBorder(new EmptyBorder(0, 10, 5, 0));
        disclaimerPnl.setLayout(new BoxLayout(disclaimerPnl, 1));
        JPanel line1Pnl = new JPanel(new FlowLayout(3, 0, 2));
        line1Pnl.add(new JLabel("Double click a cell or select it and hit Enter to modify its content; hit Enter once you are done editing it (or Escape to cancel). Right click on the table to add or remove rows."));
        disclaimerPnl.add(line1Pnl);
        JPanel line2Pnl = new JPanel(new FlowLayout(3, 0, 2));
        line2Pnl.add(new JLabel("You can generate an ID from the name using a standard algorithm: double click the name cell, type the name and hit Enter, right click on the row and select \"Generate ID from Name\"."));
        disclaimerPnl.add(line2Pnl);
        centerPnl.add((Component)disclaimerPnl, "South");
        this._dictionaryFileChooser = new JFileChooser();
        this._dictionaryFileChooser.setFileSelectionMode(0);
        this._dictionaryFileChooser.setDialogTitle("Select File");
        this._dictionaryFileChooser.setApproveButtonToolTipText("Select file");
        this._dictionaryFileChooser.setMultiSelectionEnabled(false);
        this._dictionaryFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML files (*.xml)";
            }

            @Override
            public boolean accept(File f) {
                return f != null && (f.isDirectory() || f.getName().toLowerCase().endsWith(".xml"));
            }
        });
        this._outputFileChooser = new JFileChooser();
        this._outputFileChooser.setFileSelectionMode(0);
        this._outputFileChooser.setDialogTitle("Select File");
        this._outputFileChooser.setApproveButtonToolTipText("Select file");
        this._outputFileChooser.setMultiSelectionEnabled(false);
        this._outputFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "XML files (*.xml)";
            }

            @Override
            public boolean accept(File f) {
                return f != null && (f.isDirectory() || f.getName().toLowerCase().endsWith(".xml"));
            }
        });
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setBackground(new Color(206, 220, 227));
        toolbar.setLayout(new FlowLayout(3, 0, 0));
        toolbar.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), new EmptyBorder(5, 10, 5, 0)));
        toolbar.setFloatable(false);
        toolbar.add(this.createToolbarButton("load", "toolbar-load", "Load dictionary"));
        toolbar.add(Box.createHorizontalStrut(10));
        toolbar.add(this.createToolbarSeparation());
        toolbar.add(Box.createHorizontalStrut(10));
        toolbar.add(this.createToolbarButton("save", "toolbar-save", "Save dictionary"));
        toolbar.add(Box.createHorizontalStrut(2));
        toolbar.add(this.createToolbarButton("save-as", "toolbar-save-as", "Save dictionary into new file"));
        toolbar.add(Box.createHorizontalStrut(10));
        toolbar.add(this.createToolbarSeparation());
        toolbar.add(Box.createHorizontalStrut(10));
        toolbar.add(this.createToolbarButton("validate", "toolbar-validate", "Validate dictionary"));
        toolbar.add(this.createToolbarSeparation());
        toolbar.add(Box.createHorizontalStrut(10));
        toolbar.add(this.createToolbarButton("csv", "toolbar-csv", "Extract to CSV"));
        return toolbar;
    }

    private JButton createToolbarButton(String icon, String action, String tooltip) {
        JButton btn = new JButton();
        btn.setFocusPainted(false);
        btn.setOpaque(false);
        btn.setActionCommand(action);
        btn.setToolTipText(tooltip);
        btn.addActionListener(this);
        btn.setIcon(new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("gui/icons/toolbar/editor-" + icon + ".png")));
        btn.setDisabledIcon(new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("gui/icons/toolbar/editor-" + icon + "-disable.png")));
        btn.setBorder(new EmptyBorder(3, 3, 3, 3));
        return btn;
    }

    private JPanel createToolbarSeparation() {
        return new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                Graphics2D g = (Graphics2D)graphics;
                Rectangle bounds = this.getBounds();
                g.setColor(Color.GRAY);
                g.drawLine(bounds.width / 2, 0, bounds.width / 2, bounds.height);
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(bounds.width / 2 + 1, 0, bounds.width / 2 + 1, bounds.height);
            }
        };
    }

    private void updateFileInfo() {
        if (this._currentFile == null) {
            this._currentFileLbl.setText(_NO_FILE_TEXT);
            this._openCurrentFileLbl.setAction(null);
            this._openParentFolderLbl.setAction(null);
            this._currentFilePreLbl.setVisible(false);
            this._openCurrentFileLbl.setVisible(false);
            this._currentFileMiddleLbl.setVisible(false);
            this._openParentFolderLbl.setVisible(false);
            this._currentFilePostLbl.setVisible(false);
        } else {
            this._currentFileLbl.setText(this._currentFile.getPath());
            this._currentFilePreLbl.setVisible(true);
            this._openCurrentFileLbl.setVisible(true);
            this._openCurrentFileLbl.setAction(SeerClickableLabel.createOpenFileAction(this._currentFile.getPath()));
            this._currentFileMiddleLbl.setVisible(true);
            this._openParentFolderLbl.setVisible(true);
            this._openParentFolderLbl.setAction(SeerClickableLabel.createOpenParentFolderAction(this._currentFile.getPath()));
            this._currentFilePostLbl.setVisible(true);
        }
    }

    private JPanel createFilePanel() {
        JPanel pnl = new JPanel();
        pnl.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), new EmptyBorder(5, 10, 5, 0)));
        pnl.setLayout(new BorderLayout());
        pnl.setBackground(new Color(222, 232, 237));
        JPanel filePnl = new JPanel();
        filePnl.setOpaque(false);
        pnl.add((Component)filePnl, "West");
        filePnl.setBorder(new EmptyBorder(0, 0, 0, 0));
        filePnl.setLayout(new FlowLayout(3, 0, 0));
        filePnl.add(Standalone.createBoldLabel("Current File:  "));
        this._currentFileLbl = new JLabel(_NO_FILE_TEXT);
        filePnl.add(this._currentFileLbl);
        filePnl.add(Box.createHorizontalStrut(15));
        this._currentFilePreLbl = new JLabel("[ ");
        this._currentFilePreLbl.setVisible(false);
        filePnl.add(this._currentFilePreLbl);
        this._openCurrentFileLbl = new SeerClickableLabel("open file");
        this._openCurrentFileLbl.setVisible(false);
        filePnl.add(this._openCurrentFileLbl);
        this._currentFileMiddleLbl = new JLabel(" | ");
        this._currentFileMiddleLbl.setVisible(false);
        filePnl.add(this._currentFileMiddleLbl);
        this._openParentFolderLbl = new SeerClickableLabel("open folder");
        this._openParentFolderLbl.setVisible(false);
        filePnl.add(this._openParentFolderLbl);
        this._currentFilePostLbl = new JLabel(" ]");
        this._currentFilePostLbl.setVisible(false);
        filePnl.add(this._currentFilePostLbl);
        return pnl;
    }

    private NaaccrDictionary createEmptyDictionary() {
        NaaccrDictionary dictionary = new NaaccrDictionary();
        dictionary.setDictionaryUri("http://mycompany.com/naaccrxml/my-naaccr-dictionary.xml");
        dictionary.setNaaccrVersion(null);
        dictionary.setDescription("My NAACCR dictionary");
        return dictionary;
    }

    private void populateGuiFromDictionary(NaaccrDictionary dictionary) {
        this._dictionaryUriFld.setText(dictionary.getDictionaryUri());
        if (dictionary.getNaaccrVersion() != null) {
            this._versionBox.setSelectedItem(dictionary.getNaaccrVersion());
        } else {
            this._versionBox.setSelectedItem(_BLANK_VERSION);
        }
        if (dictionary.getDescription() != null) {
            this._descFld.setText(dictionary.getDescription());
        }
        Vector<String> columns = new Vector<String>();
        columns.add("ID");
        columns.add("Number");
        columns.add("Name");
        columns.add("Start Col");
        columns.add("Length");
        columns.add("Record Types");
        columns.add("Data Level");
        columns.add("Data Type");
        columns.add("Padding");
        columns.add("Trimming");
        Vector rows = new Vector();
        if (dictionary.getItems().isEmpty()) {
            Vector<Object> row = new Vector<Object>();
            row.add("myVariable");
            row.add(10000);
            row.add("My Variable");
            row.add(null);
            row.add(1);
            row.add("A,M,C,I");
            row.add("Tumor");
            row.add("text");
            row.add("none");
            row.add("all");
            rows.add(row);
        } else {
            for (NaaccrDictionaryItem item : dictionary.getItems()) {
                Vector<Object> row = new Vector<Object>();
                row.add(item.getNaaccrId());
                row.add(item.getNaaccrNum());
                row.add(item.getNaaccrName());
                row.add(item.getStartColumn());
                row.add(item.getLength());
                row.add(item.getRecordTypes());
                row.add(item.getParentXmlElement());
                String type = "text";
                if (item.getDataType() != null) {
                    type = item.getDataType();
                }
                row.add(type);
                row.add(item.getPadding() == null ? "none" : item.getPadding());
                row.add(item.getTrim() == null ? "all" : item.getTrim());
                rows.add(row);
            }
        }
        this._itemsModel.setDataVector(rows, columns);
    }

    private NaaccrDictionary createDictionaryFromGui() {
        NaaccrDictionary dictionary = new NaaccrDictionary();
        dictionary.setDictionaryUri(this._dictionaryUriFld.getText().trim());
        dictionary.setSpecificationVersion("1.6");
        if (!_BLANK_VERSION.equals(this._versionBox.getSelectedItem())) {
            dictionary.setNaaccrVersion((String)this._versionBox.getSelectedItem());
        }
        dictionary.setDescription(this._descFld.getText().trim().isEmpty() ? null : this._descFld.getText().trim());
        for (int i = 0; i < this._itemsModel.getRowCount(); ++i) {
            NaaccrDictionaryItem item = new NaaccrDictionaryItem();
            item.setNaaccrId((String)this._itemsModel.getValueAt(i, 0));
            item.setNaaccrNum((Integer)this._itemsModel.getValueAt(i, 1));
            item.setNaaccrName((String)this._itemsModel.getValueAt(i, 2));
            item.setStartColumn((Integer)this._itemsModel.getValueAt(i, 3));
            item.setLength((Integer)this._itemsModel.getValueAt(i, 4));
            item.setRecordTypes((String)this._itemsModel.getValueAt(i, 5));
            item.setParentXmlElement((String)this._itemsModel.getValueAt(i, 6));
            item.setDataType((String)this._itemsModel.getValueAt(i, 7));
            item.setPadding((String)this._itemsModel.getValueAt(i, 8));
            item.setTrim((String)this._itemsModel.getValueAt(i, 9));
            dictionary.addItem(item);
        }
        return dictionary;
    }

    private void performLoad() {
        this.forceStopCellEditing();
        if (this._dictionaryFileChooser.showDialog(this, "Select") == 0) {
            try {
                NaaccrDictionary dictionary = NaaccrXmlDictionaryUtils.readDictionary(this._dictionaryFileChooser.getSelectedFile());
                if (!"http://naaccr.org/naaccrxml".equals(dictionary.getDefaultXmlNamespace())) {
                    String msg = "The dictionary is valid but is missing a default XML namespace.\n\nNAACCR XML specifications require the default namespace to always be \"http://naaccr.org/naaccrxml\".\n\nYou can save the dictionary (without making any changes) and the proper namespace will be added.";
                    JOptionPane.showMessageDialog(this, msg, "Error", 2);
                }
                this.populateGuiFromDictionary(dictionary);
                this._currentFile = this._dictionaryFileChooser.getSelectedFile();
                this.updateFileInfo();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Unable to load dictionary.\r\n\r\n" + e.getMessage(), "Error", 0);
            }
            SwingUtilities.invokeLater(this._itemsTbl::requestFocusInWindow);
        }
    }

    private void performSave() {
        if (this._currentFile == null) {
            this.performSaveAs();
            return;
        }
        this.forceStopCellEditing();
        NaaccrDictionary dictionary = this.performValidate(false);
        if (dictionary == null) {
            return;
        }
        try {
            NaaccrXmlDictionaryUtils.writeDictionary(dictionary, this._currentFile);
            this.updateFileInfo();
            JOptionPane.showMessageDialog(this, "Dictionary saved.", "Success", 1);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Unable to save dictionary.\r\n\r\nError:\r\n" + e.getMessage(), "Error", 0);
        }
        SwingUtilities.invokeLater(this._itemsTbl::requestFocusInWindow);
    }

    private void performSaveAs() {
        this.forceStopCellEditing();
        NaaccrDictionary dictionary = this.performValidate(false);
        if (dictionary == null) {
            return;
        }
        int idx = this._dictionaryUriFld.getText().lastIndexOf(47);
        if (idx > -1) {
            this._outputFileChooser.setSelectedFile(new File(this._outputFileChooser.getCurrentDirectory(), this._dictionaryUriFld.getText().substring(idx + 1)));
        }
        if (this._outputFileChooser.showDialog(this, "Select") == 0) {
            try {
                int i;
                File file = this._outputFileChooser.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getParentFile(), file.getName() + ".xml");
                }
                if (file.exists() && (i = JOptionPane.showConfirmDialog(this, "The target file already exist and will be overridden. Are you sure?", "Confirmation", 0)) != 0) {
                    return;
                }
                NaaccrXmlDictionaryUtils.writeDictionary(dictionary, file);
                this._currentFile = file;
                this.updateFileInfo();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Unable to save dictionary.\r\n\r\nError:\r\n" + e.getMessage(), "Error", 0);
            }
            SwingUtilities.invokeLater(this._itemsTbl::requestFocusInWindow);
        }
    }

    private NaaccrDictionary performValidate(boolean showSuccessDlg) {
        List<String> errors;
        this.forceStopCellEditing();
        NaaccrDictionary dictionary = this.createDictionaryFromGui();
        String naaccrVersion = (String)this._versionBox.getSelectedItem();
        if (_BLANK_VERSION.equals(naaccrVersion)) {
            naaccrVersion = NaaccrFormat.getSupportedVersions().stream().max(String.CASE_INSENSITIVE_ORDER).orElse(null);
        }
        if (!(errors = NaaccrXmlDictionaryUtils.validateUserDictionary(dictionary, naaccrVersion)).isEmpty()) {
            StringBuilder msg = new StringBuilder("Dictionary is not valid:");
            for (String error : errors) {
                msg.append("\r\n   - ").append(error);
            }
            JOptionPane.showMessageDialog(this, msg.toString(), "Error", 0);
            return null;
        }
        if (showSuccessDlg) {
            JOptionPane.showMessageDialog(this, "Dictionary is valid.", "Valid", 1);
        }
        return dictionary;
    }

    private void performExtractToCsv() {
        this.forceStopCellEditing();
        NaaccrDictionary dictionary = this.performValidate(false);
        if (dictionary != null) {
            int idx = dictionary.getDictionaryUri().lastIndexOf(47);
            String filename = idx > -1 ? dictionary.getDictionaryUri().substring(idx + 1).replace(".xml", "").replace(".XML", "") + ".csv" : (dictionary.getNaaccrVersion() != null ? "my-naaccr-" + dictionary.getNaaccrVersion() + "-dictionary.csv" : "my-naaccr-dictionary.csv");
            File dir = this._currentFile != null ? this._currentFile.getParentFile() : null;
            this.performExtractToCsv(dictionary, dir, filename);
        } else {
            JOptionPane.showMessageDialog(this, "Only a valid dictionary can be extracted.", "Error", 0);
        }
    }

    private void performAddRow(boolean relativeToSelected, boolean insertBefore) {
        int rowToEdit;
        this.forceStopCellEditing();
        Vector<String> row = new Vector<String>();
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add("A,M,C,I");
        row.add("Tumor");
        row.add("text");
        row.add("rightBlank");
        row.add("all");
        if (relativeToSelected) {
            int selected = this._itemsTbl.getSelectedRow();
            if (selected == -1) {
                return;
            }
            if (insertBefore) {
                this._itemsModel.insertRow(selected, row);
                rowToEdit = selected;
            } else {
                this._itemsModel.insertRow(selected + 1, row);
                rowToEdit = selected + 1;
            }
        } else if (insertBefore) {
            this._itemsModel.insertRow(0, row);
            rowToEdit = 0;
        } else {
            this._itemsModel.addRow(row);
            rowToEdit = this._itemsModel.getRowCount() - 1;
        }
        this._itemsTbl.getSelectionModel().setSelectionInterval(rowToEdit, rowToEdit);
        this._itemsTbl.editCellAt(rowToEdit, 0);
        Component comp = this._itemsTbl.getEditorComponent();
        comp.requestFocusInWindow();
    }

    private void performRemoveRow(boolean removeAllRows, boolean keepSelected) {
        this.forceStopCellEditing();
        int selected = this._itemsTbl.getSelectedRow();
        if (removeAllRows) {
            for (int i = this._itemsModel.getRowCount() - 1; i >= 0; --i) {
                if (keepSelected && i == selected) continue;
                this._itemsModel.removeRow(i);
            }
        } else if (selected != -1) {
            this._itemsModel.removeRow(selected);
        }
    }

    private void performGenerateIdFromName() {
        this.forceStopCellEditing();
        String name = (String)this._itemsTbl.getValueAt(this._itemsTbl.getSelectedRow(), 2);
        if (name != null) {
            this._itemsTbl.setValueAt(NaaccrXmlDictionaryUtils.createNaaccrIdFromItemName(name), this._itemsTbl.getSelectedRow(), 0);
        }
    }

    private void forceStopCellEditing() {
        TableCellEditor cellEditor = this._itemsTbl.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "toolbar-load": {
                this.performLoad();
                break;
            }
            case "toolbar-save": {
                this.performSave();
                break;
            }
            case "toolbar-save-as": {
                this.performSaveAs();
                break;
            }
            case "toolbar-validate": {
                this.performValidate(true);
                break;
            }
            case "toolbar-csv": {
                this.performExtractToCsv();
                break;
            }
            case "table-add-row-before": {
                this.performAddRow(true, true);
                break;
            }
            case "table-add-row-after": {
                this.performAddRow(true, false);
                break;
            }
            case "table-add-row-first": {
                this.performAddRow(false, true);
                break;
            }
            case "table-add-row-last": {
                this.performAddRow(false, false);
                break;
            }
            case "table-remove-row": {
                this.performRemoveRow(false, false);
                break;
            }
            case "table-remove-all-rows": {
                this.performRemoveRow(true, false);
                break;
            }
            case "table-remove-all-other-rows": {
                this.performRemoveRow(true, true);
                break;
            }
            case "table-generate-id-from-name": {
                this.performGenerateIdFromName();
                break;
            }
            default: {
                throw new RuntimeException("Unknown action: " + e.getActionCommand());
            }
        }
    }
}

