/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.gui.pages;

import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrObserver;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrXmlUtils;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.gui.Standalone;
import com.imsweb.naaccrxml.gui.StandaloneOptions;
import com.imsweb.naaccrxml.gui.pages.AbstractProcessingPage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class FlatToXmlPage
extends AbstractProcessingPage {
    public FlatToXmlPage() {
        super(false);
    }

    @Override
    protected String getSourceLabelText() {
        return "Source Flat File:";
    }

    @Override
    protected String getTargetLabelText() {
        return "Target XML File:";
    }

    @Override
    protected StandaloneOptions createOptions() {
        return new StandaloneOptions(true, false, false, true);
    }

    @Override
    protected void runProcessing(File source, File target, NaaccrOptions options, List<NaaccrDictionary> dictionaries, NaaccrObserver observer) throws NaaccrIOException {
        NaaccrXmlUtils.flatToXml(source, target, options, dictionaries, observer);
    }

    @Override
    protected NaaccrFormat getFormatForInputFile(File file) {
        NaaccrFormat format;
        String version;
        if (file == null || !file.exists()) {
            this.reportAnalysisError(new Exception("unable to find selected file"));
            return null;
        }
        String firstLine = null;
        try (BufferedReader reader2 = new BufferedReader(NaaccrXmlUtils.createReader(file));){
            firstLine = reader2.readLine();
        }
        catch (IOException reader2) {
            // empty catch block
        }
        if (firstLine == null || firstLine.isEmpty()) {
            this.reportAnalysisError(new Exception("selected file is empty"));
            return null;
        }
        String string = version = firstLine.length() < 19 ? "" : firstLine.substring(16, 19).trim();
        if (version.isEmpty()) {
            this.reportAnalysisError(new Exception("unable to get NAACCR version from first record"));
            return null;
        }
        if (!NaaccrFormat.isVersionSupported(version)) {
            this.reportAnalysisError(new Exception("invalid/unsupported NAACCR version on first record: " + version));
            return null;
        }
        String type = firstLine.substring(0, 1).trim();
        if (type.isEmpty()) {
            this.reportAnalysisError(new Exception("unable to get record type from first record"));
            return null;
        }
        if (!NaaccrFormat.isRecordTypeSupported(type)) {
            this.reportAnalysisError(new Exception("invalid/unsupported record type on first record: " + type));
            return null;
        }
        try {
            format = NaaccrFormat.getInstance(version, type);
        }
        catch (RuntimeException ex) {
            this.reportAnalysisError(ex);
            return null;
        }
        if (firstLine.length() != format.getLineLength()) {
            this.reportAnalysisError(new Exception("invalid line length for first record, expected " + format.getLineLength() + " but got " + firstLine.length()));
            return null;
        }
        return format;
    }

    @Override
    protected String getProcessingResultRow2Text(int numPatients, int numTumors) {
        StringBuilder buf = new StringBuilder("Wrote ");
        buf.append(Standalone.formatNumber(numPatients)).append(" patient");
        if (numPatients > 1) {
            buf.append("s");
        }
        buf.append(" and ").append(Standalone.formatNumber(numTumors)).append(" tumor");
        if (numTumors > 1) {
            buf.append("s");
        }
        buf.append("...");
        return buf.toString();
    }
}

