/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.gui.pages;

import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrObserver;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrXmlUtils;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.gui.StandaloneOptions;
import com.imsweb.naaccrxml.gui.pages.AbstractProcessingPage;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class XmlToFlatPage
extends AbstractProcessingPage {
    public XmlToFlatPage() {
        super(true);
    }

    @Override
    protected String getSourceLabelText() {
        return "Source XML File:";
    }

    @Override
    protected String getTargetLabelText() {
        return "Target Flat File:";
    }

    @Override
    protected List<String> getRequiredUserDefinedDictionaries(File file) {
        if (file == null || !file.exists()) {
            return Collections.emptyList();
        }
        String rawDictionaries = NaaccrXmlUtils.getAttributesFromXmlFile(file).get("userDictionaryUri");
        if (StringUtils.isEmpty((CharSequence)rawDictionaries)) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split((String)rawDictionaries, (char)' '));
    }

    @Override
    protected StandaloneOptions createOptions() {
        return new StandaloneOptions(false, true, true, false);
    }

    @Override
    protected void runProcessing(File source, File target, NaaccrOptions options, List<NaaccrDictionary> dictionaries, NaaccrObserver observer) throws NaaccrIOException {
        NaaccrXmlUtils.xmlToFlat(source, target, options, dictionaries, observer);
    }

    @Override
    protected NaaccrFormat getFormatForInputFile(File file) {
        if (file == null || !file.exists()) {
            this.reportAnalysisError(new Exception("unable to find selected file"));
            return null;
        }
        try {
            NaaccrFormat format = NaaccrFormat.getInstance(NaaccrXmlUtils.getFormatFromXmlFile(file));
            if ("210".compareTo(format.getNaaccrVersion()) <= 0) {
                this.reportAnalysisError(new Exception("NAACCR version " + format.getNaaccrVersion() + " does not support the flat file format!"));
                return null;
            }
            return format;
        }
        catch (RuntimeException e) {
            this.reportAnalysisError(new Exception("unable to identify file format"));
            return null;
        }
    }
}

