/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.gui.pages;

import com.imsweb.naaccrxml.NaaccrFormat;
import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrObserver;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrXmlUtils;
import com.imsweb.naaccrxml.PatientXmlReader;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.gui.StandaloneOptions;
import com.imsweb.naaccrxml.gui.pages.AbstractProcessingPage;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class XmlValidationPage
extends AbstractProcessingPage {
    public XmlValidationPage() {
        super(true);
    }

    @Override
    protected String getSourceLabelText() {
        return "Source XML File:";
    }

    @Override
    protected String getTargetLabelText() {
        return "N/A";
    }

    @Override
    protected boolean showTargetInput() {
        return false;
    }

    @Override
    protected List<String> getRequiredUserDefinedDictionaries(File file) {
        if (file == null || !file.exists()) {
            return Collections.emptyList();
        }
        String rawDictionaries = NaaccrXmlUtils.getAttributesFromXmlFile(file).get("userDictionaryUri");
        if (StringUtils.isEmpty((CharSequence)rawDictionaries)) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split((String)rawDictionaries, (char)' '));
    }

    @Override
    protected StandaloneOptions createOptions() {
        return new StandaloneOptions(false, false, true, false);
    }

    @Override
    protected void runProcessing(File source, File target, NaaccrOptions options, List<NaaccrDictionary> dictionaries, NaaccrObserver observer) throws NaaccrIOException {
        try (PatientXmlReader reader = new PatientXmlReader(NaaccrXmlUtils.createReader(source), options, dictionaries);){
            Patient patient = reader.readPatient();
            while (patient != null && !Thread.currentThread().isInterrupted()) {
                observer.patientRead(patient);
                patient = reader.readPatient();
            }
        }
    }

    @Override
    protected NaaccrFormat getFormatForInputFile(File file) {
        if (file == null || !file.exists()) {
            this.reportAnalysisError(new Exception("unable to find selected file"));
            return null;
        }
        try {
            return NaaccrFormat.getInstance(NaaccrXmlUtils.getFormatFromXmlFile(file));
        }
        catch (RuntimeException e) {
            this.reportAnalysisError(new Exception("unable to identify file format"));
            return null;
        }
    }

    @Override
    protected String getProcessingResultRow1Text(String path, long analysisTime, long processingTime, String size) {
        return "Done validating source XML file.";
    }
}

