/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.runtime;

import com.imsweb.naaccrxml.NaaccrXmlUtils;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionary;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryGroupedItem;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryItem;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class NaaccrDictionaryConverter
implements Converter {
    public boolean canConvert(Class type) {
        return NaaccrDictionary.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        NaaccrDictionary dictionary = (NaaccrDictionary)source;
        if (dictionary.getDictionaryUri() != null) {
            writer.addAttribute("dictionaryUri", dictionary.getDictionaryUri());
        }
        if (dictionary.getNaaccrVersion() != null) {
            writer.addAttribute("naaccrVersion", dictionary.getNaaccrVersion());
        }
        if (dictionary.getSpecificationVersion() != null) {
            writer.addAttribute("specificationVersion", dictionary.getSpecificationVersion());
        }
        if (dictionary.getDateLastModified() != null) {
            writer.addAttribute("dateLastModified", NaaccrXmlUtils.formatIso8601Date(dictionary.getDateLastModified()));
        }
        if (!StringUtils.isBlank((CharSequence)dictionary.getDescription())) {
            writer.addAttribute("description", dictionary.getDescription());
        }
        writer.addAttribute("xmlns", "http://naaccr.org/naaccrxml");
        writer.startNode("ItemDefs");
        for (NaaccrDictionaryItem item : dictionary.getItems()) {
            writer.startNode("ItemDef");
            this.writeItem(writer, item);
            writer.endNode();
        }
        writer.endNode();
        if (!dictionary.getGroupedItems().isEmpty()) {
            writer.startNode("GroupedItemDefs");
            for (NaaccrDictionaryGroupedItem groupedItem : dictionary.getGroupedItems()) {
                writer.startNode("GroupedItemDef");
                this.writeItem(writer, groupedItem);
                writer.endNode();
            }
            writer.endNode();
        }
    }

    private void writeItem(HierarchicalStreamWriter writer, NaaccrDictionaryItem item) {
        if (item.getNaaccrId() != null) {
            writer.addAttribute("naaccrId", item.getNaaccrId());
        }
        if (item.getNaaccrNum() != null) {
            writer.addAttribute("naaccrNum", item.getNaaccrNum().toString());
        }
        if (item.getNaaccrName() != null) {
            writer.addAttribute("naaccrName", item.getNaaccrName());
        }
        if (item.getStartColumn() != null) {
            writer.addAttribute("startColumn", item.getStartColumn().toString());
        }
        if (item.getLength() != null) {
            writer.addAttribute("length", item.getLength().toString());
        }
        if (item.getAllowUnlimitedText() != null) {
            writer.addAttribute("allowUnlimitedText", item.getAllowUnlimitedText().toString().toLowerCase());
        }
        if (item.getRecordTypes() != null) {
            writer.addAttribute("recordTypes", item.getRecordTypes());
        }
        if (item.getSourceOfStandard() != null) {
            writer.addAttribute("sourceOfStandard", item.getSourceOfStandard());
        }
        if (item.getParentXmlElement() != null) {
            writer.addAttribute("parentXmlElement", item.getParentXmlElement());
        }
        if (item.getDataType() != null) {
            writer.addAttribute("dataType", item.getDataType());
        }
        if (item.getRegexValidation() != null) {
            writer.addAttribute("regexValidation", item.getRegexValidation());
        }
        if (item.getPadding() != null) {
            writer.addAttribute("padding", item.getPadding());
        }
        if (item.getTrim() != null) {
            writer.addAttribute("trim", item.getTrim());
        }
        if (item instanceof NaaccrDictionaryGroupedItem && ((NaaccrDictionaryGroupedItem)item).getContains() != null) {
            writer.addAttribute("contains", ((NaaccrDictionaryGroupedItem)item).getContains());
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        NaaccrDictionaryItem item;
        if (!"NaaccrDictionary".equals(reader.getNodeName())) {
            throw new IllegalStateException("Expected 'NaaccrDictionary' element, got " + reader.getNodeName());
        }
        NaaccrDictionary dictionary = new NaaccrDictionary();
        Iterator iter = reader.getAttributeNames();
        block18: while (iter.hasNext()) {
            String name = (String)iter.next();
            String value = reader.getAttribute(name);
            switch (name) {
                case "dictionaryUri": {
                    dictionary.setDictionaryUri(this.stringToString(value));
                    continue block18;
                }
                case "naaccrVersion": {
                    dictionary.setNaaccrVersion(this.stringToString(value));
                    continue block18;
                }
                case "specificationVersion": {
                    dictionary.setSpecificationVersion(this.stringToString(value));
                    continue block18;
                }
                case "dateLastModified": {
                    try {
                        dictionary.setDateLastModified(NaaccrXmlUtils.parseIso8601Date(reader.getAttribute("dateLastModified")));
                        continue block18;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Invalid ISO 8601 date: " + reader.getAttribute("dateLastModified"));
                    }
                }
                case "description": {
                    dictionary.setDescription(this.stringToString(value));
                    continue block18;
                }
                case "xmlns": {
                    dictionary.setDefaultXmlNamespace(this.stringToString(value));
                    continue block18;
                }
            }
            throw new IllegalStateException("Invalid root attribute: " + name);
        }
        reader.moveDown();
        if (!"ItemDefs".equals(reader.getNodeName())) {
            throw new IllegalStateException("Expected 'ItemDefs' element, got " + reader.getNodeName());
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (!"ItemDef".equals(reader.getNodeName())) {
                throw new IllegalStateException("Expected 'ItemDef' element, got " + reader.getNodeName());
            }
            item = new NaaccrDictionaryItem();
            this.readItem(reader, item);
            dictionary.addItem(item);
            reader.moveUp();
        }
        reader.moveUp();
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("GroupedItemDefs".equals(reader.getNodeName())) {
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if (!"GroupedItemDef".equals(reader.getNodeName())) {
                        throw new RuntimeException("Expected 'GroupedItemDef' element, got " + reader.getNodeName());
                    }
                    item = new NaaccrDictionaryGroupedItem();
                    this.readItem(reader, item);
                    dictionary.addGroupedItem((NaaccrDictionaryGroupedItem)item);
                    reader.moveUp();
                }
            }
            reader.moveUp();
        }
        if (!"NaaccrDictionary".equals(reader.getNodeName())) {
            throw new IllegalStateException("Expected 'NaaccrDictionary' end element, got " + reader.getNodeName());
        }
        return dictionary;
    }

    protected void readItem(HierarchicalStreamReader reader, NaaccrDictionaryItem item) {
        Iterator iter = reader.getAttributeNames();
        block32: while (iter.hasNext()) {
            String name = (String)iter.next();
            String value = reader.getAttribute(name);
            switch (name) {
                case "naaccrId": {
                    item.setNaaccrId(this.stringToString(value));
                    continue block32;
                }
                case "naaccrNum": {
                    item.setNaaccrNum(this.stringToInt(value, name));
                    continue block32;
                }
                case "naaccrName": {
                    item.setNaaccrName(this.stringToString(value));
                    continue block32;
                }
                case "startColumn": {
                    item.setStartColumn(this.stringToInt(value, name));
                    continue block32;
                }
                case "length": {
                    item.setLength(this.stringToInt(value, name));
                    continue block32;
                }
                case "recordTypes": {
                    item.setRecordTypes(this.stringToString(value));
                    continue block32;
                }
                case "sourceOfStandard": {
                    item.setSourceOfStandard(this.stringToString(value));
                    continue block32;
                }
                case "parentXmlElement": {
                    item.setParentXmlElement(this.stringToString(value));
                    continue block32;
                }
                case "dataType": {
                    item.setDataType(this.stringToString(value));
                    continue block32;
                }
                case "regexValidation": {
                    item.setRegexValidation(this.stringToString(value));
                    continue block32;
                }
                case "padding": {
                    item.setPadding(this.stringToString(value));
                    continue block32;
                }
                case "trim": {
                    item.setTrim(this.stringToString(value));
                    continue block32;
                }
                case "allowUnlimitedText": {
                    item.setAllowUnlimitedText(this.stringToBool(value, name));
                    continue block32;
                }
                case "contains": {
                    if (item instanceof NaaccrDictionaryGroupedItem) {
                        ((NaaccrDictionaryGroupedItem)item).setContains(this.stringToString(value));
                        continue block32;
                    }
                    throw new IllegalStateException("Invalid attribute for 'ItemDef': " + name);
                }
            }
            throw new IllegalStateException("Invalid attribute for 'ItemDef': " + name);
        }
    }

    private String stringToString(String value) {
        return StringUtils.trimToNull((String)value);
    }

    private Integer stringToInt(String value, String attribute) {
        if (NumberUtils.isDigits((String)value)) {
            return Integer.valueOf(value);
        }
        if (!StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalStateException("Invalid value for '" + attribute + "': " + value);
        }
        return null;
    }

    private Boolean stringToBool(String value, String attribute) {
        if ("true".equals(value) || "false".equals(value)) {
            return Boolean.valueOf(value);
        }
        if (!StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalStateException("Invalid value for '" + attribute + "': " + value);
        }
        return null;
    }
}

