/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.runtime;

import com.imsweb.naaccrxml.NaaccrIOException;
import com.imsweb.naaccrxml.NaaccrOptions;
import com.imsweb.naaccrxml.NaaccrValidationError;
import com.imsweb.naaccrxml.NaaccrXmlDictionaryUtils;
import com.imsweb.naaccrxml.entity.AbstractEntity;
import com.imsweb.naaccrxml.entity.Item;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.entity.Tumor;
import com.imsweb.naaccrxml.entity.dictionary.NaaccrDictionaryItem;
import com.imsweb.naaccrxml.runtime.NaaccrStreamContext;
import com.imsweb.naaccrxml.runtime.RuntimeNaaccrDictionaryItem;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class NaaccrPatientConverter
implements Converter {
    protected static final Pattern _CARRIAGE_RETURN_PATTERN = Pattern.compile("\r\n|\r(?!\n)|(?<!\r)\n");
    protected static final Pattern _CONTROL_CHARACTERS_PATTERN = Pattern.compile("[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F]");
    protected NaaccrStreamContext _context;

    public void setContext(NaaccrStreamContext context) {
        this._context = context;
    }

    public boolean canConvert(Class type) {
        return Patient.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (!(source instanceof Patient)) {
            this.reportSyntaxError("Unexpected object type: " + source.getClass().getName());
        } else {
            Patient patient = (Patient)source;
            for (Item item : patient.getItems()) {
                this.writeItem(item, writer);
            }
            if (!Boolean.TRUE.equals(this._context.getOptions().getIgnoreExtensions()) && patient.getExtensions() != null) {
                for (Object extension : patient.getExtensions()) {
                    this._context.getConfiguration().getXstream().marshal(extension, writer);
                }
            }
            for (Tumor tumor : patient.getTumors()) {
                writer.startNode("Tumor");
                for (Item item : tumor.getItems()) {
                    this.writeItem(item, writer);
                }
                if (!Boolean.TRUE.equals(this._context.getOptions().getIgnoreExtensions()) && tumor.getExtensions() != null) {
                    for (Object extension : tumor.getExtensions()) {
                        this._context.getConfiguration().getXstream().marshal(extension, writer);
                    }
                }
                writer.endNode();
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            if (!"Patient".equals(this._context.extractTag(reader.getNodeName()))) {
                this.reportSyntaxError("unexpected tag: " + this._context.extractTag(reader.getNodeName()));
            }
            if (reader.getAttributeCount() > 0) {
                this.reportSyntaxError("unexpected attribute for Patient tag: " + reader.getAttribute(0));
            }
            Patient patient = new Patient();
            patient.setStartLineNumber(this._context.getLineNumber());
            int patItemCount = 0;
            int tumorCount = 0;
            boolean seenPatientExtension = false;
            HashSet<String> itemsAlreadySeen = new HashSet<String>();
            ArrayList<Item> itemsToMoveFromPatToTumor = new ArrayList<Item>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("Item".equals(this._context.extractTag(reader.getNodeName()))) {
                    if (tumorCount > 0 || seenPatientExtension) {
                        this.reportSyntaxError("unexpected tag: " + this._context.extractTag(reader.getNodeName()));
                    }
                    String path = "/Patient/Item[" + ++patItemCount + "]";
                    String rawId = reader.getAttribute("naaccrId");
                    String rawNum = reader.getAttribute("naaccrNum");
                    if (rawId != null && itemsAlreadySeen.contains(rawId)) {
                        this.reportSyntaxError("item '" + rawId + "' should be unique within the " + "Patient" + " tags");
                    } else {
                        itemsAlreadySeen.add(rawId);
                    }
                    Item wrongLevelItem = this.readItem(patient, path, "Patient", rawId, rawNum, reader.getValue());
                    if (wrongLevelItem != null) {
                        itemsToMoveFromPatToTumor.add(wrongLevelItem);
                    }
                } else if ("Tumor".equals(this._context.extractTag(reader.getNodeName()))) {
                    if (reader.getAttributeCount() > 0) {
                        this.reportSyntaxError("unexpected attribute for Tumor tag: " + reader.getAttribute(0));
                    }
                    Tumor tumor = new Tumor();
                    tumor.setStartLineNumber(this._context.getLineNumber());
                    ++tumorCount;
                    int tumorItemCount = 0;
                    boolean seenTumorExtension = false;
                    itemsAlreadySeen.clear();
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if ("Item".equals(this._context.extractTag(reader.getNodeName()))) {
                            if (seenTumorExtension) {
                                this.reportSyntaxError("unexpected tag: " + this._context.extractTag(reader.getNodeName()));
                            }
                            String path = "/Patient/Tumor[" + tumorCount + "]/Item[" + ++tumorItemCount + "]";
                            String rawId = reader.getAttribute("naaccrId");
                            String rawNum = reader.getAttribute("naaccrNum");
                            if (rawId != null && itemsAlreadySeen.contains(rawId)) {
                                this.reportSyntaxError("item '" + rawId + "' should be unique within the " + "Tumor" + " tags");
                            } else {
                                itemsAlreadySeen.add(rawId);
                            }
                            this.readItem(tumor, path, "Tumor", rawId, rawNum, reader.getValue());
                        } else {
                            if (!Boolean.TRUE.equals(this._context.getOptions().getIgnoreExtensions())) {
                                tumor.addExtension(this._context.getConfiguration().getXstream().unmarshal(reader));
                            }
                            seenTumorExtension = true;
                        }
                        reader.moveUp();
                    }
                    tumor.setEndLineNumber(this._context.getLineNumber());
                    for (Item wrongLevelItem : itemsToMoveFromPatToTumor) {
                        tumor.addItem(wrongLevelItem);
                    }
                    patient.addTumor(tumor);
                } else {
                    if (tumorCount > 0) {
                        this.reportSyntaxError("unexpected tag: " + this._context.extractTag(reader.getNodeName()));
                    }
                    if (!Boolean.TRUE.equals(this._context.getOptions().getIgnoreExtensions())) {
                        patient.addExtension(this._context.getConfiguration().getXstream().unmarshal(reader));
                    }
                    seenPatientExtension = true;
                }
                reader.moveUp();
            }
            patient.setEndLineNumber(this._context.getLineNumber());
            return patient;
        }
        catch (NaaccrIOException e) {
            this.reportSyntaxError(e.getMessage());
            return null;
        }
    }

    public void writeItem(Item item, HierarchicalStreamWriter writer) {
        boolean applyZeroPadding;
        String value;
        Matcher matcher;
        if (item.getValue() == null || item.getValue().isEmpty()) {
            return;
        }
        if (item.getNaaccrId() == null) {
            this.reportSyntaxError("NAACCR ID is required when writing an item");
        }
        if (!NaaccrOptions.processItem(this._context.getOptions(), item.getNaaccrId())) {
            return;
        }
        RuntimeNaaccrDictionaryItem itemDef = this._context.getDictionary().getItemByNaaccrId(item.getNaaccrId());
        if (itemDef == null) {
            if ("error".equals(this._context.getOptions().getUnknownItemHandling())) {
                this.reportSyntaxError("unable to find item definition for NAACCR ID " + item.getNaaccrId());
            } else {
                if ("ignore".equals(this._context.getOptions().getUnknownItemHandling())) {
                    return;
                }
                if (!"process".equals(this._context.getOptions().getUnknownItemHandling())) {
                    throw new IllegalStateException("Unknown option: " + this._context.getOptions().getUnknownItemHandling());
                }
            }
        }
        if (itemDef != null && item.getNaaccrNum() != null && !item.getNaaccrNum().equals(itemDef.getNaaccrNum())) {
            this.reportSyntaxError("provided NAACCR Number '" + item.getNaaccrNum() + "' doesn't correspond to the provided NAACCR ID '" + item.getNaaccrId() + "'");
        }
        writer.startNode("Item");
        writer.addAttribute("naaccrId", itemDef != null ? itemDef.getNaaccrId() : item.getNaaccrId());
        if (itemDef != null && itemDef.getNaaccrNum() != null && this._context.getOptions().getWriteItemNumber().booleanValue()) {
            writer.addAttribute("naaccrNum", itemDef.getNaaccrNum().toString());
        }
        if ((matcher = _CONTROL_CHARACTERS_PATTERN.matcher(value = _CARRIAGE_RETURN_PATTERN.matcher(item.getValue()).replaceAll("\n"))).find()) {
            if (Boolean.TRUE.equals(this._context.getOptions().getIgnoreControlCharacters())) {
                value = matcher.replaceAll("");
            } else {
                this.reportSyntaxError("value for item '" + item.getNaaccrId() + "' contains non-printable control characters");
            }
        }
        boolean bl = applyZeroPadding = Boolean.TRUE.equals(this._context.getOptions().getApplyZeroPaddingRules()) && NumberUtils.isDigits((String)value);
        if (itemDef != null && itemDef.getLength() != null && itemDef.getPadding() != null && value.length() < itemDef.getLength()) {
            if ("leftZero".equals(itemDef.getPadding())) {
                if (applyZeroPadding) {
                    value = StringUtils.leftPad((String)value, (int)itemDef.getLength(), (char)'0');
                }
            } else if ("rightZero".equals(itemDef.getPadding())) {
                if (applyZeroPadding) {
                    value = StringUtils.rightPad((String)value, (int)itemDef.getLength(), (char)'0');
                }
            } else if (!("leftBlank".equals(itemDef.getPadding()) || "rightBlank".equals(itemDef.getPadding()) || "none".equals(itemDef.getPadding()))) {
                throw new IllegalStateException("Unknown padding option: " + itemDef.getPadding());
            }
        }
        if (itemDef != null && itemDef.getLength() != null && value.length() > itemDef.getLength() && !Boolean.TRUE.equals(itemDef.getAllowUnlimitedText())) {
            if (this._context.getOptions().getReportValuesTooLong().booleanValue()) {
                this.reportError(item, null, null, itemDef, value, "Value too long", itemDef.getLength(), value.length());
            }
            value = value.substring(0, itemDef.getLength());
        }
        writer.setValue(value);
        writer.endNode();
    }

    public Item readItem(AbstractEntity entity, String currentPath, String parentTag, String rawId, String rawNum, String value) {
        int lineNumber = this._context.getLineNumber();
        if (value == null || value.isEmpty()) {
            return null;
        }
        Item item = new Item();
        item.setValue(value);
        item.setStartLineNumber(lineNumber);
        if (StringUtils.isBlank((CharSequence)rawId)) {
            this.reportSyntaxError("attribute 'naaccrId' is required");
        } else {
            rawId = rawId.trim();
        }
        if (Boolean.TRUE.equals(this._context.getOptions().getTranslateRenamedStandardItemIds()) && "180".equals(this._context.getDictionary().getNaaccrVersion())) {
            rawId = NaaccrXmlDictionaryUtils.getRenamedLongNaaccr18Ids().getOrDefault(rawId, rawId);
        }
        if (this._context.getOptions().getItemIdsToTranslate() != null) {
            rawId = this._context.getOptions().getItemIdsToTranslate().getOrDefault(rawId, rawId);
        }
        if (!NaaccrOptions.processItem(this._context.getOptions(), rawId)) {
            return null;
        }
        RuntimeNaaccrDictionaryItem def = this._context.getDictionary().getItemByNaaccrId(rawId);
        if (def != null) {
            item.setNaaccrId(def.getNaaccrId());
            item.setNaaccrNum(def.getNaaccrNum());
        } else if ("process".equals(this._context.getOptions().getUnknownItemHandling())) {
            item.setNaaccrId(rawId);
        } else {
            if ("error".equals(this._context.getOptions().getUnknownItemHandling())) {
                NaaccrDictionaryItem badItem = new NaaccrDictionaryItem();
                badItem.setNaaccrId(rawId);
                if (StringUtils.isNumeric((CharSequence)rawNum)) {
                    badItem.setNaaccrNum(Integer.parseInt(rawNum));
                }
                this.reportError(entity, lineNumber, currentPath, new RuntimeNaaccrDictionaryItem(badItem), value, "Unknown NAACCR ID", rawId);
                return null;
            }
            if ("ignore".equals(this._context.getOptions().getUnknownItemHandling())) {
                return null;
            }
            throw new IllegalStateException("Unknown option: " + this._context.getOptions().getUnknownItemHandling());
        }
        if (!StringUtils.isBlank((CharSequence)rawNum)) {
            rawNum = rawNum.trim();
            try {
                if (def != null) {
                    if (!Integer.valueOf(rawNum).equals(def.getNaaccrNum())) {
                        this.reportError(item, lineNumber, currentPath, null, null, "Wrong NAACCR Number", rawNum, def.getNaaccrId());
                    }
                } else {
                    item.setNaaccrNum(Integer.valueOf(rawNum));
                }
            }
            catch (NumberFormatException e) {
                this.reportSyntaxError("invalid 'naaccrNum' attribute value: " + rawNum);
            }
        }
        if (def != null) {
            if (item.getValue() != null) {
                if (item.getValue().length() > def.getLength() && !Boolean.TRUE.equals(def.getAllowUnlimitedText())) {
                    this.reportError(item, lineNumber, currentPath, def, item.getValue(), "Value too long", def.getLength(), item.getValue().length());
                }
                if (this._context.getOptions().getValidateReadValues().booleanValue()) {
                    Pattern pattern;
                    if (NaaccrXmlDictionaryUtils.isFullLengthRequiredForType(def.getDataType()) && item.getValue().length() < def.getLength()) {
                        this.reportError(item, lineNumber, currentPath, def, item.getValue(), "Value too short", def.getLength(), item.getValue().length());
                    } else if (def.getDataType() != null && (pattern = NaaccrXmlDictionaryUtils.getDataTypePattern(def.getDataType())) != null && !pattern.matcher(item.getValue()).matches()) {
                        this.reportError(item, lineNumber, currentPath, def, item.getValue(), "Value invalid for data type", def.getDataType());
                    }
                    if (item.getValue().startsWith(" ")) {
                        this.reportError(item, lineNumber, currentPath, def, item.getValue(), "Value starts with a space", new Object[0]);
                    }
                    if (item.getValue().endsWith(" ")) {
                        this.reportError(item, lineNumber, currentPath, def, item.getValue(), "Value ends with a space", new Object[0]);
                    }
                }
            }
            if (!parentTag.equals(def.getParentXmlElement())) {
                if (Boolean.TRUE.equals(this._context.getOptions().getTranslateRenamedStandardItemIds()) && ("180".equals(this._context.getDictionary().getNaaccrVersion()) || "210".equals(this._context.getDictionary().getNaaccrVersion())) && "Patient".equals(parentTag) && NaaccrXmlDictionaryUtils.getPatToTumorChangedNaaccr18And21Ids().contains(rawId)) {
                    return item;
                }
                this.reportSyntaxError("invalid parent XML tag for '" + def.getNaaccrId() + "'; was expecting '" + def.getParentXmlElement() + "' but got '" + parentTag + "'");
            }
        }
        entity.addItem(item);
        return null;
    }

    protected void reportError(Object obj, Integer line, String path, RuntimeNaaccrDictionaryItem def, String value, String code, Object ... msgValues) {
        NaaccrValidationError error = new NaaccrValidationError(code, msgValues);
        error.setLineNumber(line);
        error.setPath(path);
        if (def != null) {
            error.setNaaccrId(def.getNaaccrId());
            error.setNaaccrNum(def.getNaaccrNum());
        }
        if (value != null && !value.isEmpty()) {
            error.setValue(value);
        }
        if (obj instanceof AbstractEntity) {
            ((AbstractEntity)obj).addValidationError(error);
        } else if (obj instanceof Item) {
            if (((Item)obj).getValidationError() == null) {
                ((Item)obj).setValidationError(error);
            }
        } else {
            throw new IllegalStateException("Unsupported type: " + obj.getClass().getName());
        }
    }

    protected void reportSyntaxError(String message) throws ConversionException {
        ConversionException ex = new ConversionException(message);
        ex.add("message", message);
        throw ex;
    }
}

