/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.naaccrxml.runtime;

import com.imsweb.naaccrxml.entity.Item;
import com.imsweb.naaccrxml.entity.NaaccrData;
import com.imsweb.naaccrxml.entity.Patient;
import com.imsweb.naaccrxml.runtime.LineNumberExtensionConverter;
import com.imsweb.naaccrxml.runtime.NaaccrPatientConverter;
import com.imsweb.naaccrxml.runtime.RuntimeNaaccrDictionary;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class NaaccrStreamConfiguration {
    protected XmlPullParser _parser = this.createParser();
    protected HierarchicalStreamDriver _driver = this.createDriver(this._parser);
    protected NaaccrPatientConverter _patientConverter = this.createPatientConverter();
    protected XStream _xstream = this.createXStream(this._driver, this._patientConverter);
    protected Map<String, String> _namespaces = new HashMap<String, String>();
    protected Map<String, Set<String>> _tags = new HashMap<String, Set<String>>();
    protected Set<String> _defaultTags;
    protected RuntimeNaaccrDictionary _cachedDictionary;

    public static NaaccrStreamConfiguration getDefault() {
        return new NaaccrStreamConfiguration();
    }

    public NaaccrStreamConfiguration() {
        HashSet<String> defaultTags = new HashSet<String>();
        defaultTags.add("NaaccrData");
        defaultTags.add("Patient");
        defaultTags.add("Tumor");
        defaultTags.add("Item");
        this._defaultTags = Collections.unmodifiableSet(defaultTags);
        this._xstream.registerConverter((Converter)new LineNumberExtensionConverter(this));
    }

    protected XmlPullParser createParser() {
        try {
            return XmlPullParserFactory.newInstance().newPullParser();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    protected HierarchicalStreamDriver createDriver(final XmlPullParser parser) {
        return new XppDriver(){

            protected synchronized XmlPullParser createParser() {
                return parser;
            }
        };
    }

    protected NaaccrPatientConverter createPatientConverter() {
        return new NaaccrPatientConverter();
    }

    protected XStream createXStream(HierarchicalStreamDriver driver, NaaccrPatientConverter patientConverter) {
        XStream xstream = new XStream(driver){

            protected void setupConverters() {
                this.registerConverter((Converter)new NullConverter(), 10000);
                this.registerConverter((SingleValueConverter)new IntConverter(), 0);
                this.registerConverter((SingleValueConverter)new FloatConverter(), 0);
                this.registerConverter((SingleValueConverter)new DoubleConverter(), 0);
                this.registerConverter((SingleValueConverter)new LongConverter(), 0);
                this.registerConverter((SingleValueConverter)new ShortConverter(), 0);
                this.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
                this.registerConverter((SingleValueConverter)new ByteConverter(), 0);
                this.registerConverter((SingleValueConverter)new StringConverter(), 0);
                this.registerConverter((SingleValueConverter)new DateConverter(), 0);
                this.registerConverter((Converter)new CollectionConverter(this.getMapper()), 0);
                this.registerConverter((Converter)new ReflectionConverter(this.getMapper(), this.getReflectionProvider()), -20);
            }
        };
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"com.imsweb.naaccrxml.**"}));
        xstream.alias("NaaccrData", NaaccrData.class);
        xstream.alias("Item", Item.class);
        xstream.alias("Patient", Patient.class);
        xstream.aliasAttribute(NaaccrData.class, "_baseDictionaryUri", "baseDictionaryUri");
        xstream.aliasAttribute(NaaccrData.class, "_userDictionaryUri", "userDictionaryUri");
        xstream.aliasAttribute(NaaccrData.class, "_recordType", "recordType");
        xstream.aliasAttribute(NaaccrData.class, "_timeGenerated", "timeGenerated");
        xstream.aliasAttribute(NaaccrData.class, "_specificationVersion", "specificationVersion");
        xstream.addImplicitCollection(NaaccrData.class, "_items", Item.class);
        xstream.addImplicitCollection(NaaccrData.class, "_patients", Patient.class);
        xstream.registerConverter((Converter)patientConverter);
        return xstream;
    }

    public XmlPullParser getParser() {
        return this._parser;
    }

    public HierarchicalStreamDriver getDriver() {
        return this._driver;
    }

    public NaaccrPatientConverter getPatientConverter() {
        return this._patientConverter;
    }

    public XStream getXstream() {
        return this._xstream;
    }

    public RuntimeNaaccrDictionary getCachedDictionary() {
        return this._cachedDictionary;
    }

    public void setCachedDictionary(RuntimeNaaccrDictionary cachedDictionary) {
        this._cachedDictionary = cachedDictionary;
    }

    public void registerNamespace(String namespacePrefix, String namespaceUri) {
        if (this._namespaces.containsKey(namespacePrefix)) {
            throw new RuntimeException("Namespace prefix '" + namespacePrefix + "' has already been registered");
        }
        this._namespaces.put(namespacePrefix, namespaceUri);
    }

    public Map<String, String> getRegisterNamespaces() {
        return Collections.unmodifiableMap(this._namespaces);
    }

    public void registerTag(String namespacePrefix, String tagName, Class<?> clazz) {
        if (!this._namespaces.containsKey(namespacePrefix)) {
            throw new RuntimeException("Namespace prefix '" + namespacePrefix + "' has not been registered yet");
        }
        this._xstream.alias(namespacePrefix + ":" + tagName, clazz);
        this._xstream.addPermission((TypePermission)new WildcardTypePermission(new String[]{clazz.getName()}));
        this._tags.computeIfAbsent(namespacePrefix, k -> new HashSet()).add(tagName);
    }

    public void registerTag(String namespacePrefix, String tagName, Class<?> clazz, String fieldName, Class<?> fieldClass) {
        if (!this._namespaces.containsKey(namespacePrefix)) {
            throw new RuntimeException("Namespace prefix '" + namespacePrefix + "' has not been registered yet");
        }
        this._xstream.alias(namespacePrefix + ":" + tagName, fieldClass);
        this._xstream.aliasField(namespacePrefix + ":" + tagName, clazz, fieldName);
        this._tags.computeIfAbsent(namespacePrefix, k -> new HashSet()).add(tagName);
    }

    public void registerAttribute(String namespacePrefix, String attributeName, Class<?> clazz, String fieldName, Class<?> fieldClass) {
        if (!this._namespaces.containsKey(namespacePrefix)) {
            throw new RuntimeException("Namespace prefix '" + namespacePrefix + "' has not been registered yet");
        }
        this._xstream.aliasAttribute(clazz, fieldName, namespacePrefix + ":" + attributeName);
        this._xstream.useAttributeFor(fieldName, fieldClass);
    }

    public void registerImplicitCollection(Class<?> clazz, String fieldName, Class<?> fieldClass) {
        this._xstream.addImplicitCollection(clazz, fieldName, fieldClass);
    }

    public void registerConverter(Converter converter) {
        this._xstream.registerConverter(converter);
    }

    public Set<String> getAllowedTagsForNamespacePrefix(String namespacePrefix) {
        if (namespacePrefix == null) {
            return this._defaultTags;
        }
        return this._tags.get(namespacePrefix);
    }
}

