/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class SeerAutoCompleteComboBox
extends JComboBox {
    private SeerAutoCompleteComboBoxSearchType _searchType;
    private SeerAutoCompleteComboBoxModel _model;
    private final JTextComponent _textComponent;
    private String _previousPattern;
    private boolean _modelFilling;
    private boolean _updatePopup;

    public SeerAutoCompleteComboBox(List<String> list) {
        this(list, SeerAutoCompleteComboBoxSearchType.STARTS_WITH);
    }

    public SeerAutoCompleteComboBox(List<String> list, SeerAutoCompleteComboBoxSearchType type) {
        this(list, type, 20);
    }

    public SeerAutoCompleteComboBox(List<String> list, SeerAutoCompleteComboBoxSearchType type, int refreshRateMs) {
        this._searchType = type;
        this._model = new SeerAutoCompleteComboBoxModel(list);
        this.setModel(this._model);
        this.setEditable(true);
        this.setPattern(null);
        this._modelFilling = false;
        this._updatePopup = false;
        this._textComponent = (JTextComponent)this.getEditor().getEditorComponent();
        this._textComponent.setDocument(new AutoCompleteDocument());
        this.setSelectedItem(null);
        new Timer(refreshRateMs, e -> {
            if (this._updatePopup && this.isDisplayable()) {
                this.setPopupVisible(false);
                if (this._model.getSize() > 0) {
                    this.setPopupVisible(true);
                }
                this._updatePopup = false;
            }
        }).start();
    }

    public List<String> getList() {
        return Collections.unmodifiableList(this._model.getList());
    }

    public void setText(String text) {
        if (this._model._data.contains(text)) {
            this.setSelectedItem(text);
        } else {
            this.addToTop(text);
            this.setSelectedIndex(0);
        }
    }

    public String getText() {
        return this.getEditor().getItem().toString();
    }

    public void resetPopupContent() {
        this.setPattern(null);
    }

    private void setPattern(String pattern) {
        if (pattern != null && pattern.trim().isEmpty()) {
            pattern = null;
        }
        if (this._previousPattern == null && pattern == null || pattern != null && pattern.equals(this._previousPattern)) {
            return;
        }
        this._previousPattern = pattern;
        this._modelFilling = true;
        this._model.setPattern(pattern);
        this._modelFilling = false;
        if (pattern != null) {
            this._updatePopup = true;
        }
    }

    private void clearSelection() {
        int i = this.getText().length();
        this._textComponent.setSelectionStart(i);
        this._textComponent.setSelectionEnd(i);
    }

    public synchronized void addToTop(String aString) {
        this._model.addToTop(aString);
    }

    public synchronized void delete(String aString) {
        this._model.delete(aString);
    }

    private class SeerAutoCompleteComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private String _selected;
        private static final int _LIMIT = 20;
        private Data _data = new Data();

        public SeerAutoCompleteComboBoxModel(List<String> list) {
            for (String s : list) {
                this._data.add(s);
            }
        }

        public void setPattern(String pattern) {
            int size1 = this.getSize();
            this._data.setPattern(pattern);
            int size2 = this.getSize();
            if (size1 < size2) {
                this.fireIntervalAdded(this, size1, size2 - 1);
                this.fireContentsChanged(this, 0, size1 - 1);
            } else if (size1 > size2) {
                this.fireIntervalRemoved(this, size2, size1 - 1);
                this.fireContentsChanged(this, 0, size2 - 1);
            }
        }

        public void addToTop(String aString) {
            if (aString == null || this._data.contains(aString)) {
                return;
            }
            if (this._data.size() == 0) {
                this._data.add(aString);
            } else {
                this._data.addToTop(aString);
            }
            while (this._data.size() > 20) {
                int index = this._data.size() - 1;
                this._data.remove(index);
            }
            this.setPattern(null);
            SeerAutoCompleteComboBox.this._model.setSelectedItem(aString);
        }

        public void delete(String aString) {
            this._data.delete(aString);
        }

        @Override
        public Object getSelectedItem() {
            return this._selected;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (this._selected != null && !this._selected.equals(anObject) || this._selected == null && anObject != null) {
                this._selected = (String)anObject;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public int getSize() {
            return this._data.getFiltered().size();
        }

        @Override
        public Object getElementAt(int index) {
            return this._data.getFiltered().get(index);
        }

        public List<String> getList() {
            return this._data.getList();
        }

        class Data {
            private List<String> _list = new ArrayList<String>(20);
            private List<String> _filtered;

            Data() {
            }

            public void add(String s) {
                this._list.add(s);
            }

            public void delete(String s) {
                this._list.remove(s);
            }

            public void addToTop(String s) {
                this._list.add(0, s);
            }

            public void remove(int index) {
                this._list.remove(index);
            }

            public List<String> getList() {
                return this._list;
            }

            public List<String> getFiltered() {
                if (this._filtered == null) {
                    this._filtered = this._list;
                }
                return this._filtered;
            }

            public int size() {
                return this._list.size();
            }

            public void setPattern(String pattern) {
                if (pattern == null || pattern.isEmpty()) {
                    this._filtered = this._list;
                    SeerAutoCompleteComboBox.this.setSelectedItem(SeerAutoCompleteComboBox.this._model.getElementAt(0));
                } else {
                    this._filtered = new ArrayList<String>(20);
                    String searchPattern = pattern.toLowerCase();
                    switch (SeerAutoCompleteComboBox.this._searchType) {
                        case STARTS_WITH: {
                            for (String s : this._list) {
                                if (!s.toLowerCase().startsWith(searchPattern)) continue;
                                this._filtered.add(s);
                            }
                            break;
                        }
                        case CONTAINS: {
                            for (String s : this._list) {
                                if (!s.toLowerCase().contains(searchPattern)) continue;
                                this._filtered.add(s);
                            }
                            break;
                        }
                        case REGEX: {
                            try {
                                Pattern p = Pattern.compile(pattern, 2);
                                for (String s : this._list) {
                                    Matcher m = p.matcher(s);
                                    if (!m.find()) continue;
                                    this._filtered.add(s);
                                }
                                break;
                            }
                            catch (PatternSyntaxException e) {
                                return;
                            }
                        }
                        default: {
                            throw new RuntimeException("Unsupported search type: " + (Object)((Object)SeerAutoCompleteComboBox.this._searchType));
                        }
                    }
                }
                SeerAutoCompleteComboBox.this.setSelectedItem(pattern);
            }

            public boolean contains(String s) {
                if (s == null || s.trim().isEmpty()) {
                    return true;
                }
                for (String item : this._list) {
                    if (!item.toLowerCase().equals(s.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        }
    }

    private class AutoCompleteDocument
    extends PlainDocument {
        private boolean _arrowKeyPressed = false;

        public AutoCompleteDocument() {
            SeerAutoCompleteComboBox.this._textComponent.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                        AutoCompleteDocument.this._arrowKeyPressed = true;
                    } else if (e.getKeyCode() == 127) {
                        String text = SeerAutoCompleteComboBox.this._textComponent.getText();
                        SeerAutoCompleteComboBox.this.delete(text);
                        try {
                            SeerAutoCompleteComboBox.this.clearSelection();
                            AutoCompleteDocument.this.updateModel();
                        }
                        catch (BadLocationException e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                }
            });
        }

        public void updateModel() throws BadLocationException {
            String textToMatch = this.getText(0, this.getLength());
            SeerAutoCompleteComboBox.this.setPattern(textToMatch);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (SeerAutoCompleteComboBox.this._modelFilling) {
                return;
            }
            super.remove(offs, len);
            if (this._arrowKeyPressed) {
                this._arrowKeyPressed = false;
            } else {
                this.updateModel();
            }
            SeerAutoCompleteComboBox.this.clearSelection();
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (SeerAutoCompleteComboBox.this._modelFilling) {
                return;
            }
            super.insertString(offs, str, a);
            String text = this.getText(0, this.getLength());
            if (this._arrowKeyPressed) {
                SeerAutoCompleteComboBox.this._model.setSelectedItem(text);
                this._arrowKeyPressed = false;
            } else if (!text.equals(SeerAutoCompleteComboBox.this.getSelectedItem())) {
                this.updateModel();
            }
            SeerAutoCompleteComboBox.this.clearSelection();
        }
    }

    public static enum SeerAutoCompleteComboBoxSearchType {
        STARTS_WITH,
        CONTAINS,
        REGEX;

    }
}

