/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import com.imsweb.seerutilsgui.SeerBoldTitlesTabbedPaneHeader;
import com.imsweb.seerutilsgui.SeerGuiUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class SeerBoldTitlesTabbedPane
extends JTabbedPane {
    protected boolean _synchronizeHeaderWidth;
    protected boolean _centerTitles;
    protected Border _titleBorder;
    protected int _currentTabIndex;
    protected Map<String, Component> _tabs = new HashMap<String, Component>();
    protected Map<String, Integer> _tabIndexes = new HashMap<String, Integer>();
    protected Map<String, SeerBoldTitlesTabbedPaneHeader> _headers = new HashMap<String, SeerBoldTitlesTabbedPaneHeader>();

    public SeerBoldTitlesTabbedPane() {
        this.setName("tabbed-pane");
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder());
        this._currentTabIndex = 0;
        this._synchronizeHeaderWidth = false;
        this._centerTitles = true;
        this._titleBorder = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        this.addChangeListener(e -> {
            if (this.isVisible()) {
                int showingTabIndex = this.getSelectedIndex();
                if (showingTabIndex != -1 && showingTabIndex != this._currentTabIndex) {
                    for (int i = 0; i < this.getTabCount(); ++i) {
                        SeerBoldTitlesTabbedPaneHeader header = (SeerBoldTitlesTabbedPaneHeader)this.getTabComponentAt(i);
                        if (header == null) continue;
                        header.setCurrent(i == showingTabIndex);
                    }
                    this._currentTabIndex = showingTabIndex;
                }
                this.applyExtraStateChangedLogic();
            }
        });
    }

    public void setSynchronizeHeaderWidths(boolean synchronizeHeaderWidth) {
        this._synchronizeHeaderWidth = synchronizeHeaderWidth;
    }

    public void setCenterTitles(boolean centerTitles) {
        this._centerTitles = centerTitles;
    }

    public void setHeaderBorder(Border titleBorder) {
        this._titleBorder = titleBorder;
    }

    public void addPage(SeerBoldTitlesTabbedPaneHeader header, Component page) {
        this.addPage(header, null, page, this.getTabCount());
    }

    public void addPage(SeerBoldTitlesTabbedPaneHeader header, Component page, int idx) {
        this.addPage(header, null, page, idx);
    }

    public void addPage(String title, Component page) {
        this.addPage(null, title, page, this.getTabCount());
    }

    public void addPage(String title, Component page, int idx) {
        this.addPage(null, title, page, idx);
    }

    protected void addPage(SeerBoldTitlesTabbedPaneHeader header, String title, Component page, int idx) {
        int showingTabIndex;
        if (header == null) {
            header = new SeerBoldTitlesTabbedPaneHeader(title, idx, null, this._titleBorder, this._centerTitles, this.getTabCount() == 0);
        }
        if (title == null) {
            title = header.getHeaderTitle();
        }
        if (this._tabs.containsKey(title)) {
            throw new RuntimeException("Duplicate titles are not allowed!");
        }
        this.insertTab(title, null, page, null, idx);
        this.setTabComponentAt(idx, header);
        this._tabs.put(title, page);
        this._headers.put(title, header);
        this._tabIndexes.put(title, idx);
        if (this._synchronizeHeaderWidth) {
            int i;
            int maxWidth = 0;
            for (i = 0; i < this.getTabCount(); ++i) {
                SeerBoldTitlesTabbedPaneHeader pnl = (SeerBoldTitlesTabbedPaneHeader)this.getTabComponentAt(i);
                maxWidth = Math.max(maxWidth, SwingUtilities.computeStringWidth(pnl.getFontMetrics(SeerGuiUtils.createLabel("", 1).getFont()), pnl.getHeaderTitle()));
            }
            for (i = 0; i < this.getTabCount(); ++i) {
                this.getTabComponentAt(i).setPreferredSize(new Dimension(maxWidth, this.getTabComponentAt((int)i).getPreferredSize().height));
            }
        }
        if (this.isVisible() && (showingTabIndex = this.getSelectedIndex()) != -1 && showingTabIndex != this._currentTabIndex) {
            this._currentTabIndex = showingTabIndex;
        }
    }

    public boolean removePage(String title) {
        int showingTabIndex;
        Component tab = this._tabs.get(title);
        if (tab == null) {
            return false;
        }
        this.remove(tab);
        this._tabs.remove(title);
        this._headers.remove(title);
        this._tabIndexes.remove(title);
        ++this._currentTabIndex;
        if (this._currentTabIndex >= this.getTabCount()) {
            int n = this._currentTabIndex = this.getTabCount() == 0 ? -1 : 0;
        }
        if (this.isVisible() && (showingTabIndex = this.getSelectedIndex()) != -1 && showingTabIndex != this._currentTabIndex) {
            this._currentTabIndex = showingTabIndex;
        }
        return true;
    }

    public void displayNextPage() {
        SeerBoldTitlesTabbedPaneHeader header;
        int tabIdx = this.getSelectedIndex();
        if (++tabIdx == this.getTabCount()) {
            tabIdx = 0;
        }
        while (tabIdx != this.getSelectedIndex() && !(header = (SeerBoldTitlesTabbedPaneHeader)this.getTabComponentAt(tabIdx)).isHeaderEnabled()) {
            if (++tabIdx != this.getTabCount()) continue;
            tabIdx = 0;
        }
        this.setSelectedIndex(tabIdx);
        this._currentTabIndex = tabIdx;
    }

    public void displayPreviousPage() {
        SeerBoldTitlesTabbedPaneHeader header;
        int tabIdx = this.getSelectedIndex();
        if (--tabIdx < 0) {
            tabIdx = this.getTabCount() - 1;
        }
        while (tabIdx != this.getSelectedIndex() && !(header = (SeerBoldTitlesTabbedPaneHeader)this.getTabComponentAt(tabIdx)).isHeaderEnabled()) {
            if (--tabIdx >= 0) continue;
            tabIdx = this.getTabCount() - 1;
        }
        this.setSelectedIndex(tabIdx);
        this._currentTabIndex = tabIdx;
    }

    public void displayPage(String title) {
        Component tab = this._tabs.get(title);
        if (tab != null) {
            this.displayPage(this.indexOfComponent(tab));
        }
    }

    public void displayPage(int idx) {
        SeerBoldTitlesTabbedPaneHeader header;
        if (idx >= 0 && idx < this.getTabCount() && (header = (SeerBoldTitlesTabbedPaneHeader)this.getTabComponentAt(idx)).isHeaderEnabled()) {
            this.setSelectedIndex(idx);
            this._currentTabIndex = idx;
        }
    }

    public void disablePage(String title) {
        Integer idx;
        SeerBoldTitlesTabbedPaneHeader header = this._headers.get(title);
        if (header != null) {
            header.disableHeader();
        }
        if ((idx = this._tabIndexes.get(title)) != null && idx >= 0 && idx < this.getTabCount()) {
            this.setEnabledAt(idx, false);
        }
    }

    public void disablePage(int idx) {
        SeerBoldTitlesTabbedPaneHeader header = (SeerBoldTitlesTabbedPaneHeader)this.getTabComponentAt(idx);
        if (header != null) {
            header.disableHeader();
        }
        if (idx >= 0 && idx < this.getTabCount()) {
            this.setEnabledAt(idx, false);
        }
    }

    public void disableAllPages() {
        for (String title : this._headers.keySet()) {
            this.disablePage(title);
        }
        this.setEnabled(false);
    }

    public void enablePage(String title) {
        Integer idx;
        SeerBoldTitlesTabbedPaneHeader header = this._headers.get(title);
        if (header != null) {
            header.enableHeader();
        }
        if ((idx = this._tabIndexes.get(title)) != null && idx >= 0 && idx < this.getTabCount()) {
            this.setEnabledAt(idx, true);
        }
    }

    public void enablePage(int idx) {
        SeerBoldTitlesTabbedPaneHeader header = (SeerBoldTitlesTabbedPaneHeader)this.getTabComponentAt(idx);
        if (header != null) {
            header.enableHeader();
        }
        if (idx >= 0 && idx < this.getTabCount()) {
            this.setEnabledAt(idx, true);
        }
    }

    public void enableAllPages() {
        this.setEnabled(true);
        for (String title : this._headers.keySet()) {
            this.enablePage(title);
        }
    }

    public Component getPage(String title) {
        return this._tabs.get(title);
    }

    public Component getPage(int idx) {
        return this.getComponentAt(idx);
    }

    public int getPageIndex(String title) {
        return this._tabIndexes.getOrDefault(title, -1);
    }

    public String getPageTitle(int idx) {
        for (Map.Entry<String, Integer> entry : this._tabIndexes.entrySet()) {
            if (!entry.getValue().equals(idx)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Component getCurrentPage() {
        String title = null;
        for (Map.Entry<String, Integer> entry : this._tabIndexes.entrySet()) {
            if (entry.getValue() != this._currentTabIndex) continue;
            title = entry.getKey();
            break;
        }
        return this.getPage(title);
    }

    public int getCurrentPageIndex() {
        return this._currentTabIndex;
    }

    public String getCurrentPageTitle() {
        for (Map.Entry<String, Integer> entry : this._tabIndexes.entrySet()) {
            if (!entry.getValue().equals(this._currentTabIndex)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void applyExtraStateChangedLogic() {
    }

    public void updateHeader(int tabIdx, String text) {
        String prevTitle = ((SeerBoldTitlesTabbedPaneHeader)this.getTabComponentAt(tabIdx)).getHeaderTitle();
        if (prevTitle == null || prevTitle.equals(text)) {
            return;
        }
        if (this._tabs.containsKey(text)) {
            throw new RuntimeException("Duplicate titles are not allowed!");
        }
        Component comp = this._tabs.get(prevTitle);
        this._tabs.put(text, comp);
        this._tabs.remove(prevTitle);
        Integer idx = this._tabIndexes.get(prevTitle);
        this._tabIndexes.put(text, idx);
        this._tabIndexes.remove(prevTitle);
        SeerBoldTitlesTabbedPaneHeader header = this._headers.get(prevTitle);
        this._headers.put(text, header);
        this._headers.remove(prevTitle);
        ((SeerBoldTitlesTabbedPaneHeader)this.getTabComponentAt(tabIdx)).updateHeader(text);
    }
}

