/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import javax.swing.JLabel;

public class SeerClickableLabel
extends JLabel
implements MouseListener {
    private SeerClickableLabelAction _action;
    private boolean _underlined;

    public static SeerClickableLabelAction createUrlAction(String url, Desktop.Action action) {
        return () -> {
            block5: {
                Desktop desktop;
                Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                if (desktop != null && desktop.isSupported(action)) {
                    try {
                        if (action == Desktop.Action.BROWSE) {
                            desktop.browse(URI.create(url));
                            break block5;
                        }
                        if (action == Desktop.Action.MAIL) {
                            desktop.mail(URI.create(url));
                            break block5;
                        }
                        throw new RuntimeException("Unsupported action: " + (Object)((Object)action));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public SeerClickableLabel(String label) {
        this(label, null);
    }

    public SeerClickableLabel(String label, SeerClickableLabelAction action) {
        super(label);
        this._action = action;
        this._underlined = false;
        this.setForeground(Color.BLUE);
        this.addMouseListener(this);
    }

    public void setAction(SeerClickableLabelAction action) {
        this._action = action;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isEnabled() && this._action != null) {
            this._action.execute();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this._underlined = true;
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isEnabled()) {
            this._underlined = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isEnabled()) {
            g.setColor(this.getForeground());
            if (this._underlined) {
                g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            }
        }
    }

    public static interface SeerClickableLabelAction {
        public void execute();
    }
}

