/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import com.imsweb.seerutilsgui.SeerUniqueWindow;
import com.imsweb.seerutilsgui.SeerWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;

public final class SeerGuiUtils {
    public static final String KEY_VERSION = "build.version";
    public static final String KEY_COMMIT_ID = "commit.id";
    public static final String KEY_COMMIT_MESSAGE = "commit.message";
    private static Map<String, String> _BUILD_PROPS = new HashMap<String, String>();
    public static final Color COLOR_APPLICATION_BACKGROUND;
    public static final Color COLOR_COMP_FOCUS_OUT;
    public static final Color COLOR_COMP_FOCUS_IN;
    public static final Border BORDER_FOCUS_IN;
    public static final Border BORDER_FOCUS_OUT;
    public static final Border BORDER_TEXT_FIELD_IN;
    public static final Border BORDER_TEXT_FIELD_OUT;
    private static Map<String, SeerUniqueWindow> _CACHED_WINDOWS;
    private static Map<String, String> _WINDOWS_INFO;

    private SeerGuiUtils() {
    }

    private static void addBuildProperties(String resource) {
        Properties props = new Properties();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (is != null) {
            try {
                props.load(is);
                is.close();
            }
            catch (IOException e1) {
                props.clear();
            }
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            _BUILD_PROPS.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static String getBuildProperty(String prop) {
        return _BUILD_PROPS.get(prop);
    }

    public static String getBuildVersion() {
        return SeerGuiUtils.getBuildProperty(KEY_VERSION);
    }

    public static void setupGuiEnvForSeerProject() {
        try {
            if (System.getProperty("os.name").startsWith("Linux")) {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
                }
                catch (Exception e) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            throw new IllegalStateException("Unable to get system look and feel", e);
        }
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
        Insets insets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        insets.bottom = 0;
        UIManager.put("TabbedPane.tabAreaInsets", insets);
    }

    public static void openDirectory(File dir) throws IOException {
        SeerGuiUtils.openDirectory(dir, null);
    }

    public static void openDirectory(File dir, String fileToSelect) throws IOException {
        if (fileToSelect != null) {
            if (new File(dir, fileToSelect).exists() && System.getProperty("os.name").startsWith("Windows")) {
                Runtime.getRuntime().exec("Explorer /select," + dir.getAbsolutePath() + "\\" + fileToSelect);
            } else {
                Desktop.getDesktop().open(dir);
            }
        } else {
            Desktop.getDesktop().open(dir);
        }
    }

    public static synchronized SeerUniqueWindow show(String windowId) {
        SeerUniqueWindow window = _CACHED_WINDOWS.get(windowId);
        if (window != null) {
            if (window instanceof JFrame) {
                JFrame frame = (JFrame)((Object)window);
                if (frame.getExtendedState() == 1) {
                    frame.setExtendedState(0);
                }
                frame.toFront();
            } else if (window instanceof JDialog) {
                ((JDialog)((Object)window)).toFront();
            } else {
                throw new RuntimeException("Unique SEER Windows work only for JFrame and JDialog!");
            }
            return window;
        }
        return null;
    }

    public static synchronized void show(Window source) {
        if (source instanceof SeerUniqueWindow) {
            _CACHED_WINDOWS.put(((SeerWindow)((Object)source)).getWindowId(), (SeerUniqueWindow)((Object)source));
        }
        source.setVisible(true);
    }

    public static List<String> getCachedUniqueWindowsId() {
        return new ArrayList<String>(_CACHED_WINDOWS.keySet());
    }

    public static List<SeerUniqueWindow> getCachedUniqueWindows() {
        return new ArrayList<SeerUniqueWindow>(_CACHED_WINDOWS.values());
    }

    public static synchronized void showAndPosition(Window source, Component parent) {
        SeerGuiUtils.showAndPosition(source, parent, false, false);
    }

    public static synchronized void showAndPosition(Window source, Component parent, JComponent comp) {
        if (comp != null) {
            SeerGuiUtils.setFocusWhenDisplayed(source, comp);
        }
        SeerGuiUtils.showAndPosition(source, parent, false, false);
    }

    public static void setFocusWhenDisplayed(final Window window, final JComponent comp) {
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                super.componentShown(e);
                comp.requestFocusInWindow();
                window.removeComponentListener(this);
            }
        });
    }

    public static synchronized void showAndPosition(Window source, Component parent, boolean usePreviousSize, boolean usePreviousLocation) {
        String windowInfo;
        String windowId = source.getClass().getName();
        if (source instanceof SeerWindow) {
            windowId = ((SeerWindow)((Object)source)).getWindowId();
        }
        if ((windowInfo = _WINDOWS_INFO.get(windowId)) != null && windowInfo.matches("^(max|normal)\\|\\d+\\|\\d+\\|\\d+\\|\\d+(\\|.+)?$")) {
            String[] vals = windowInfo.split("\\|");
            String state = vals[0];
            int w = Integer.parseInt(vals[1]);
            int h = Integer.parseInt(vals[2]);
            int x = Integer.parseInt(vals[3]);
            int y = Integer.parseInt(vals[4]);
            if (usePreviousSize) {
                source.setPreferredSize(new Dimension(w, h));
            }
            source.pack();
            if (usePreviousLocation) {
                source.setLocation(x, y);
                if (source instanceof JFrame && "max".equals(state)) {
                    ((JFrame)source).setExtendedState(6);
                }
            } else {
                SeerGuiUtils.centerWindow(source, parent);
            }
        } else {
            SeerGuiUtils.centerWindow(source, parent);
        }
        if (source instanceof SeerUniqueWindow) {
            _CACHED_WINDOWS.put(windowId, (SeerUniqueWindow)((Object)source));
        }
        source.setVisible(true);
    }

    public static void centerWindow(Window source, Component parent) {
        Point center = new Point();
        if (parent != null) {
            center.setLocation(parent.getLocationOnScreen().x + parent.getWidth() / 2, parent.getLocationOnScreen().y + parent.getHeight() / 2);
        } else {
            center.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2);
        }
        source.pack();
        source.setLocation(center.x - source.getWidth() / 2, center.y - source.getHeight() / 2);
    }

    public static synchronized void hideAndDestroy(Window source) {
        SeerGuiUtils.hideAndDestroy(source, null, false);
    }

    public static synchronized void hideAndDestroy(Window source, String extraInfo) {
        SeerGuiUtils.hideAndDestroy(source, extraInfo, false);
    }

    public static synchronized void hideAndDestroy(Window source, String extraInfo, boolean remember) {
        SeerGuiUtils.hide(source, extraInfo, remember);
        source.dispose();
    }

    public static synchronized void hide(Window source, String extraInfo) {
        SeerGuiUtils.hide(source, extraInfo, false);
    }

    public static synchronized void hide(Window source, String extraInfo, boolean remember) {
        String windowId = source.getClass().getName();
        if (source instanceof SeerWindow) {
            windowId = ((SeerWindow)((Object)source)).getWindowId();
        }
        if (remember) {
            String windowInfo = SeerGuiUtils.buildWindowInfo(source);
            if (extraInfo != null) {
                windowInfo = windowInfo + "|" + extraInfo;
            }
            _WINDOWS_INFO.put(windowId, windowInfo);
        }
        if (source instanceof SeerUniqueWindow) {
            _CACHED_WINDOWS.remove(windowId);
        }
        source.setVisible(false);
    }

    public static String buildWindowInfo(Window source) {
        StringBuilder buf = new StringBuilder();
        if (source instanceof JFrame && ((JFrame)source).getExtendedState() == 6) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            buf.append("max|").append(screenSize.width).append("|").append(screenSize.height).append("|0|0");
        } else {
            Point loc;
            buf.append("normal|").append(source.getWidth()).append("|").append(source.getHeight()).append("|");
            try {
                loc = source.getLocationOnScreen();
            }
            catch (IllegalComponentStateException e) {
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                loc = new Point(dim.width / 2 - source.getWidth() / 2, dim.height / 2 - source.getHeight() / 2);
            }
            buf.append(loc.x).append("|").append(loc.y);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWindowInfo(Window source, String info) {
        String windowId = source.getClass().getName();
        if (source instanceof SeerWindow) {
            windowId = ((SeerWindow)((Object)source)).getWindowId();
        }
        Class<SeerGuiUtils> clazz = SeerGuiUtils.class;
        synchronized (SeerGuiUtils.class) {
            _WINDOWS_INFO.put(windowId, info);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static String getWindowInfo(Window source) {
        String windowId = source.getClass().getName();
        if (source instanceof SeerWindow) {
            windowId = ((SeerWindow)((Object)source)).getWindowId();
        }
        return _WINDOWS_INFO.get(windowId);
    }

    public static Map<String, String> getAllWindowsInfo() {
        return Collections.unmodifiableMap(_WINDOWS_INFO);
    }

    public static synchronized void resetCachedWindowsInfo() {
        _WINDOWS_INFO.clear();
    }

    public static ImageIcon createIcon(String icon) {
        return SeerGuiUtils.createIcon(icon, "icons/");
    }

    public static ImageIcon createIcon(String icon, String path) {
        return new ImageIcon(Thread.currentThread().getContextClassLoader().getResource(path + icon));
    }

    public static JPanel createPanel() {
        return SeerGuiUtils.createPanel(new BorderLayout());
    }

    public static JPanel createPanel(LayoutManager layout) {
        JPanel panel = new JPanel(layout);
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setOpaque(false);
        return panel;
    }

    public static JPanel createContentPanel(JFrame frame) {
        return SeerGuiUtils.createContentPanel(frame, 10);
    }

    public static JPanel createContentPanel(JFrame frame, int border) {
        JPanel contentPnl = SeerGuiUtils.createPanel();
        contentPnl.setOpaque(true);
        contentPnl.setBackground(COLOR_APPLICATION_BACKGROUND);
        contentPnl.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)contentPnl, "Center");
        return contentPnl;
    }

    public static JPanel createContentPanel(JDialog dlg) {
        return SeerGuiUtils.createContentPanel(dlg, 10);
    }

    public static JPanel createContentPanel(JDialog dlg, int border) {
        JPanel contentPnl = SeerGuiUtils.createPanel();
        contentPnl.setOpaque(true);
        contentPnl.setBackground(COLOR_APPLICATION_BACKGROUND);
        contentPnl.setBorder(BorderFactory.createEmptyBorder(border, border, border, border));
        dlg.getContentPane().setLayout(new BorderLayout());
        dlg.getContentPane().add((Component)contentPnl, "Center");
        return contentPnl;
    }

    public static JPanel createSeparation(final Color topColor, final Color bottomColor) {
        return new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                Graphics2D g = (Graphics2D)graphics;
                Rectangle bounds = this.getBounds();
                g.setColor(topColor);
                g.drawLine(10, bounds.height / 2, bounds.width - 10, bounds.height / 2);
                g.setColor(bottomColor);
                g.drawLine(11, bounds.height / 2 + 1, bounds.width - 10, bounds.height / 2 + 1);
            }
        };
    }

    public static JButton createButton(String text, String action, String tooltip, ActionListener listener) {
        JButton btn = new JButton(text);
        btn.setOpaque(false);
        btn.setActionCommand(action);
        btn.setName(action + "-btn");
        btn.setToolTipText(tooltip);
        btn.addActionListener(listener);
        return btn;
    }

    public static JButton createToolbarButton(String icon, String action, String tooltip, ActionListener listener) {
        JButton btn = SeerGuiUtils.createButton(null, action, tooltip, listener);
        btn.setIcon(SeerGuiUtils.createIcon(icon));
        btn.setFocusPainted(false);
        return btn;
    }

    public static JToggleButton createToolbarToggleButton(String icon, String action, String tooltip, ActionListener listener) {
        JToggleButton btn = new JToggleButton();
        btn.setIcon(SeerGuiUtils.createIcon(icon));
        btn.setFocusPainted(false);
        btn.setOpaque(false);
        btn.setActionCommand(action);
        btn.setName(action + "-btn");
        btn.setToolTipText(tooltip);
        btn.addActionListener(listener);
        return btn;
    }

    public static JLabel createLabel(String text) {
        return SeerGuiUtils.createLabel(text, 0);
    }

    public static JLabel createLabel(String text, int style) {
        return SeerGuiUtils.createLabel(text, style, Color.BLACK);
    }

    public static JLabel createLabel(String text, int style, Color color) {
        JLabel lbl = new JLabel(text);
        lbl.setOpaque(false);
        lbl.setFont(lbl.getFont().deriveFont(style));
        lbl.setForeground(color);
        return lbl;
    }

    public static JLabel createLabel(String text, int style, int size, Color color) {
        JLabel lbl = new JLabel(text);
        lbl.setOpaque(false);
        lbl.setFont(lbl.getFont().deriveFont(style, size));
        lbl.setForeground(color);
        return lbl;
    }

    public static JLabel createLabel(String text, Font font, Color color) {
        JLabel lbl = new JLabel(text);
        lbl.setOpaque(false);
        lbl.setFont(font);
        lbl.setForeground(color);
        return lbl;
    }

    public static JCheckBox createCheckBox(String text, String action, ActionListener listener) {
        return SeerGuiUtils.createCheckBox(text, action, 0, listener);
    }

    public static JCheckBox createCheckBox(String text, String action, int style, ActionListener listener) {
        JCheckBox box = new JCheckBox(text);
        box.setOpaque(false);
        box.setActionCommand(action);
        box.setName(action);
        box.setFont(box.getFont().deriveFont(style));
        if (listener != null) {
            box.addActionListener(listener);
        }
        return box;
    }

    public static JRadioButton createRadioButton(String text, String action, ActionListener listener) {
        return SeerGuiUtils.createRadioButton(text, action, 0, listener);
    }

    public static JRadioButton createRadioButton(String text, String action, int style, ActionListener listener) {
        JRadioButton btn = new JRadioButton(text);
        btn.setOpaque(false);
        btn.setActionCommand(action);
        btn.setName(action);
        btn.setFont(btn.getFont().deriveFont(style));
        if (listener != null) {
            btn.addActionListener(listener);
        }
        return btn;
    }

    public static JMenuItem createMenuItem(String label, String action, ActionListener listener) {
        JMenuItem item = new JMenuItem(label);
        item.setActionCommand(action);
        if (listener != null) {
            item.addActionListener(listener);
        }
        item.setName(action);
        return item;
    }

    public static void synchronizedComponentsWidth(JComponent ... components) {
        ArrayList comps = new ArrayList();
        Collections.addAll(comps, components);
        SeerGuiUtils.synchronizedComponentsWidth(comps);
    }

    public static void synchronizedComponentsWidth(Collection<? extends JComponent> comps) {
        if (comps.isEmpty()) {
            return;
        }
        int maxWidth = 0;
        for (JComponent jComponent : comps) {
            if (!jComponent.isVisible()) continue;
            maxWidth = Math.max(maxWidth, jComponent.getPreferredSize().width);
        }
        Dimension dim = new Dimension(maxWidth, comps.iterator().next().getPreferredSize().height);
        for (JComponent jComponent : comps) {
            jComponent.setPreferredSize(dim);
            jComponent.setMaximumSize(dim);
        }
    }

    public static boolean getAntialias(Graphics g) {
        if (g instanceof Graphics2D) {
            return RenderingHints.VALUE_ANTIALIAS_ON.equals(((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING));
        }
        return false;
    }

    public static void setAntialias(Graphics g, boolean state) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, state ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    static {
        SeerGuiUtils.addBuildProperties("seerutils-gui-build.properties");
        COLOR_APPLICATION_BACKGROUND = new Color(180, 191, 211);
        COLOR_COMP_FOCUS_OUT = Color.GRAY;
        COLOR_COMP_FOCUS_IN = Color.BLACK;
        BORDER_FOCUS_IN = BorderFactory.createLineBorder(Color.BLACK);
        BORDER_FOCUS_OUT = BorderFactory.createLineBorder(Color.GRAY);
        BORDER_TEXT_FIELD_IN = BorderFactory.createCompoundBorder(BORDER_FOCUS_IN, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        BORDER_TEXT_FIELD_OUT = BorderFactory.createCompoundBorder(BORDER_FOCUS_OUT, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        _CACHED_WINDOWS = new HashMap<String, SeerUniqueWindow>();
        _WINDOWS_INFO = new HashMap<String, String>();
    }
}

