/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import com.imsweb.seerutilsgui.SeerGuiUtils;
import com.imsweb.seerutilsgui.SeerHelpDialog;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SeerHelpButton
extends JButton {
    private SeerHelpDialog _dlg;
    private boolean _showUndecorated;
    private boolean _showingUndecorated;

    public SeerHelpButton(Window parent, JComponent ancestor, String helpId, String dlgTitle, boolean decorate, String content) {
        this(parent, ancestor, helpId, dlgTitle, decorate, content, SeerGuiUtils.createIcon("help.png"));
    }

    public SeerHelpButton(Window parent, JComponent ancestor, String helpId, String dlgTitle, boolean decorate, URL content) {
        this(parent, ancestor, helpId, dlgTitle, decorate, content, SeerGuiUtils.createIcon("help.png"));
    }

    public SeerHelpButton(Window parent, JComponent ancestor, String helpId, String dlgTitle, boolean decorate, String content, ImageIcon icon) {
        this(parent, ancestor, helpId, dlgTitle, icon);
        this._dlg = new SeerHelpDialog(parent, helpId, "Help - " + dlgTitle, icon.getImage(), content, decorate);
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SeerHelpButton.this._showingUndecorated = false;
            }
        });
        this._showUndecorated = !decorate;
        this._showingUndecorated = false;
    }

    public SeerHelpButton(Window parent, JComponent ancestor, String helpId, String dlgTitle, boolean decorate, URL content, ImageIcon icon) {
        this(parent, ancestor, helpId, dlgTitle, icon);
        this._dlg = new SeerHelpDialog(parent, helpId, "Help - " + dlgTitle, icon.getImage(), content);
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SeerHelpButton.this._showingUndecorated = false;
            }
        });
        this._showUndecorated = !decorate;
        this._showingUndecorated = false;
    }

    protected SeerHelpButton(final Window parent, final JComponent ancestor, String helpId, String dlgTitle, ImageIcon icon) {
        this.setOpaque(false);
        this.setActionCommand("display-help");
        this.setName("display-help-btn");
        this.setToolTipText("Contextual help (click to see help content)");
        this.setIcon(icon);
        this.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                SeerHelpButton.this._dlg.setMouseOnButton(true);
                if (SeerHelpButton.this.isEnabled()) {
                    if (ancestor != null) {
                        ancestor.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        parent.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                SeerHelpButton.this._dlg.setMouseOnButton(false);
                if (SeerHelpButton.this.isEnabled()) {
                    if (ancestor != null) {
                        ancestor.setCursor(Cursor.getPredefinedCursor(0));
                    } else {
                        parent.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        this.addActionListener(e -> SwingUtilities.invokeLater(() -> {
            if (SeerGuiUtils.show(helpId) == null) {
                if (this._showingUndecorated) {
                    this._dlg.performClose();
                } else if (!this._showUndecorated) {
                    SeerGuiUtils.showAndPosition(this._dlg, parent);
                } else {
                    this._showingUndecorated = true;
                    this._dlg.setRelativeComponent((JComponent)e.getSource(), parent);
                    this._dlg.setRelativeComponent((JComponent)e.getSource(), parent);
                    this._dlg.setVisible(true);
                }
            }
        }));
    }

    public SeerHelpDialog getDialog() {
        return this._dlg;
    }
}

