/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import com.imsweb.seerutilsgui.SeerClickableLabel;
import com.imsweb.seerutilsgui.SeerGuiUtils;
import com.imsweb.seerutilsgui.SeerHelpDialog;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class SeerHelpClickableLabel
extends SeerClickableLabel {
    private SeerHelpDialog _dlg;
    private boolean _showUndecorated;
    private boolean _showingUndecorated;

    public SeerHelpClickableLabel(Window parent, String label, String helpId, String dlgTitle, boolean decorate, String content) {
        this(parent, label, helpId, dlgTitle, decorate, content, SeerGuiUtils.createIcon("help.png"));
    }

    public SeerHelpClickableLabel(Window parent, String label, String helpId, String dlgTitle, boolean decorate, URL content) {
        this(parent, label, helpId, dlgTitle, decorate, content, SeerGuiUtils.createIcon("help.png"));
    }

    public SeerHelpClickableLabel(Window parent, String label, String helpId, String dlgTitle, boolean decorate, String content, ImageIcon icon) {
        this(parent, label, helpId, dlgTitle, icon);
        this._dlg = new SeerHelpDialog(parent, helpId, "Help - " + dlgTitle, icon.getImage(), content, decorate);
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SeerHelpClickableLabel.this._showingUndecorated = false;
            }
        });
        this._showUndecorated = !decorate;
        this._showingUndecorated = false;
    }

    public SeerHelpClickableLabel(Window parent, String label, String helpId, String dlgTitle, boolean decorate, URL content, ImageIcon icon) {
        this(parent, label, helpId, dlgTitle, icon);
        this._dlg = new SeerHelpDialog(parent, helpId, "Help - " + dlgTitle, icon.getImage(), content);
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SeerHelpClickableLabel.this._showingUndecorated = false;
            }
        });
        this._showUndecorated = !decorate;
        this._showingUndecorated = false;
    }

    protected SeerHelpClickableLabel(Window parent, String label, String helpId, String dlgTitle, ImageIcon icon) {
        super(label);
        this.setName("display-help-clickable-lbl");
        this.setAction(() -> SwingUtilities.invokeLater(() -> {
            if (SeerGuiUtils.show(helpId) == null) {
                if (this._showingUndecorated) {
                    this._dlg.performClose();
                } else if (!this._showUndecorated) {
                    SeerGuiUtils.showAndPosition(this._dlg, parent);
                } else {
                    this._showingUndecorated = true;
                    this._dlg.setRelativeComponent(this, parent);
                    this._dlg.setRelativeComponent(this, parent);
                    this._dlg.setVisible(true);
                }
            }
        }));
    }

    public SeerHelpDialog getDialog() {
        return this._dlg;
    }
}

