/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import com.imsweb.seerutilsgui.SeerGuiUtils;
import com.imsweb.seerutilsgui.SeerOptionalSidesLineBorder;
import com.imsweb.seerutilsgui.SeerUniqueWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;

public class SeerHelpDialog
extends JDialog
implements SeerUniqueWindow {
    private final Window _owner;
    private boolean _mouseOnButton;
    private Color _backgroundColor = new Color(255, 249, 196);
    private Color _disclaimerBackgroundColor = new Color(255, 251, 220);
    private transient FocusListener _focusListener;
    private final JPanel _contentPnl;
    private JPanel _disclaimerPnl;
    private final JEditorPane _pane;
    private final JScrollPane _scrollPane;

    protected SeerHelpDialog(Window owner, String dlgId, String title, Image icon) {
        super(owner);
        this.setTitle(title);
        if (icon != null) {
            this.setIconImage(icon);
        }
        this.setName(dlgId);
        this.setFocusCycleRoot(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                SeerHelpDialog.this.performClose();
            }
        });
        this._owner = owner;
        this._contentPnl = SeerGuiUtils.createPanel();
        this._pane = new JEditorPane();
        this._pane.setEditorKit(new HTMLEditorKit(){

            @Override
            public Document createDefaultDocument() {
                HTMLDocument doc = (HTMLDocument)super.createDefaultDocument();
                doc.setAsynchronousLoadPriority(-1);
                StyleSheet styleSheet = this.getStyleSheet();
                styleSheet.addRule("ul {list-style-image: url(bullet.png);}");
                return doc;
            }
        });
        ((HTMLDocument)this._pane.getDocument()).setBase(Thread.currentThread().getContextClassLoader().getResource("icons/"));
        this._pane.setEditable(false);
        this._pane.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "escape");
        this._pane.getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeerHelpDialog.this.performClose();
            }
        });
        this._pane.setBackground(this._backgroundColor);
        this._pane.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this._scrollPane = new JScrollPane(this._pane);
        this._contentPnl.add((Component)this._scrollPane, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this._contentPnl);
        this.getContentPane().setBackground(this._backgroundColor);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SeerHelpDialog.this._pane.setCaretPosition(0);
                SeerHelpDialog.this._pane.requestFocusInWindow();
                SeerHelpDialog.this.removeComponentListener(this);
            }
        });
    }

    public SeerHelpDialog(Window owner, String dlgId, String title, Image icon, String content, boolean decorated) {
        this(owner, dlgId, title, icon, content, decorated, null);
    }

    protected SeerHelpDialog(Window owner, final String dlgId, final String title, final Image icon, final String content, boolean decorated, Dimension dim) {
        this(owner, dlgId, title, icon);
        this._pane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null && e.getURL().getProtocol() != null && e.getURL().getProtocol().startsWith("http")) {
                try {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                }
                catch (IOException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        });
        if (!decorated) {
            this.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
            this.setAlwaysOnTop(true);
            this.setUndecorated(true);
            this._pane.getInputMap().put(KeyStroke.getKeyStroke(113, 0), "focus");
            this._pane.getActionMap().put("focus", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SeerHelpDialog.this.createFocusDialog(dlgId, title, icon, content);
                }
            });
            this._pane.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SeerHelpDialog.this.createFocusDialog(dlgId, title, icon, content);
                }
            });
            this._focusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!SeerHelpDialog.this._mouseOnButton) {
                        SeerHelpDialog.this.performClose();
                    }
                }
            };
            this._pane.addFocusListener(this._focusListener);
            this._disclaimerPnl = SeerGuiUtils.createPanel();
            this._disclaimerPnl.setBackground(this._disclaimerBackgroundColor);
            this._disclaimerPnl.setOpaque(true);
            this._disclaimerPnl.setBorder(new SeerOptionalSidesLineBorder(Color.GRAY, false, true, true, true));
            JLabel focusLabel = SeerGuiUtils.createLabel("Click the window to move or re-size it. Press Esc to close it.   ", 2, 10, Color.DARK_GRAY);
            focusLabel.setHorizontalAlignment(4);
            focusLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SeerHelpDialog.this.createFocusDialog(dlgId, title, icon, content);
                }
            });
            this._disclaimerPnl.add((Component)focusLabel, "South");
            this._contentPnl.add((Component)this._disclaimerPnl, "South");
        } else {
            this._scrollPane.setBorder(null);
        }
        this._pane.setText(content);
        if (dim != null) {
            this.getContentPane().setPreferredSize(dim);
        }
    }

    public SeerHelpDialog(Window parent, String dlgId, String title, Image icon, URL url) {
        this(parent, dlgId, title, icon);
        this._pane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)this._pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        this._pane.setPage(e.getURL());
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        });
        try {
            this._pane.setPage(url);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void createFocusDialog(String dlgId, String title, Image icon, String content) {
        this._pane.removeFocusListener(this._focusListener);
        Dimension dim = new Dimension(this.getContentPane().getSize().width, this.getContentPane().getSize().height - this._disclaimerPnl.getPreferredSize().height);
        SeerHelpDialog dlg = new SeerHelpDialog(this._owner, dlgId, title, icon, content, true, dim);
        dlg.pack();
        int borderSize = (dlg.getPreferredSize().width - this.getPreferredSize().width) / 2;
        int headerSize = dlg.getPreferredSize().height - this.getPreferredSize().height - borderSize;
        dlg.setLocation(new Point(this.getLocationOnScreen().x - borderSize, this.getLocationOnScreen().y - headerSize));
        SwingUtilities.invokeLater(() -> {
            this.performClose();
            this._pane.addFocusListener(this._focusListener);
            SeerGuiUtils.show(dlg);
            dlg._scrollPane.getViewport().scrollRectToVisible(new Rectangle(this._scrollPane.getViewport().getViewPosition()));
        });
    }

    public void setBackgroundColor(Color c1, Color c2) {
        this._backgroundColor = c1;
        this._pane.setBackground(c1);
        if (this._disclaimerPnl != null) {
            this._disclaimerBackgroundColor = c2;
            this._disclaimerPnl.setBackground(c2);
        }
    }

    public void setHtmlDocumentBase(URL base) {
        ((HTMLDocument)this._pane.getDocument()).setBase(base);
    }

    public void performClose() {
        if (this.isUndecorated()) {
            this.setVisible(false);
            this.dispose();
        } else {
            SeerGuiUtils.hideAndDestroy(this);
        }
    }

    public void setMouseOnButton(boolean mouseOnButton) {
        this._mouseOnButton = mouseOnButton;
    }

    public void setRelativeComponent(JComponent relativeTo, Window parent) {
        this.pack();
        int w = Math.min(Math.min(980, parent.getWidth() - 75), Math.min(680, this._pane.getPreferredScrollableViewportSize().width + 20));
        int h = Math.min(Math.min(980, parent.getHeight() - 75), Math.min(680, this._pane.getPreferredScrollableViewportSize().height + 20));
        this.setPreferredSize(new Dimension(w, h));
        this.pack();
        this.setLocation(this.calculatePosition(relativeTo, parent));
    }

    public JEditorPane getEditorPane() {
        return this._pane;
    }

    protected Point calculatePosition(JComponent relativeTo, Window parent) {
        Point topLeft = relativeTo.getLocationOnScreen();
        int disclaimerHeight = this.isUndecorated() ? this._disclaimerPnl.getPreferredSize().height : 0;
        int x = topLeft.x + relativeTo.getWidth() + 1;
        int y = topLeft.y + relativeTo.getHeight() + 1;
        if ((double)x + this.getPreferredSize().getWidth() > (double)(parent.getLocationOnScreen().x + parent.getWidth())) {
            int leftSpace = relativeTo.getLocationOnScreen().x - parent.getLocationOnScreen().x;
            int rightSpace = parent.getLocationOnScreen().x + parent.getWidth() - (relativeTo.getLocationOnScreen().x + relativeTo.getPreferredSize().width);
            if (leftSpace > rightSpace) {
                this.setPreferredSize(new Dimension(Math.min(this.getPreferredSize().width, leftSpace - 35), this.getPreferredSize().height + disclaimerHeight));
                x = Math.max(parent.getLocationOnScreen().x, topLeft.x - this.getPreferredSize().width - 1);
            } else {
                this.setPreferredSize(new Dimension(Math.min(this.getPreferredSize().width, rightSpace - 35), this.getPreferredSize().height + disclaimerHeight));
                x = Math.min(parent.getLocationOnScreen().x + parent.getWidth() - this.getPreferredSize().width, topLeft.x + relativeTo.getWidth() + 1);
            }
            this._pane.setSize(this.getPreferredSize().width, Integer.MAX_VALUE);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this._pane.getPreferredScrollableViewportSize().height + 4 + disclaimerHeight));
        }
        if ((double)y + this.getPreferredSize().getHeight() > (double)(parent.getLocationOnScreen().y + parent.getHeight())) {
            int topSpace = relativeTo.getLocationOnScreen().y - parent.getLocationOnScreen().y;
            int bottomSpace = parent.getLocationOnScreen().y + parent.getHeight() - (relativeTo.getLocationOnScreen().y + relativeTo.getPreferredSize().height + disclaimerHeight);
            if (topSpace > bottomSpace) {
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, Math.min(this.getPreferredSize().height, topSpace - 35)));
                y = Math.max(parent.getLocationOnScreen().y, topLeft.y - this.getPreferredSize().height - 1);
            } else {
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, Math.min(this.getPreferredSize().height, bottomSpace - 35) + disclaimerHeight));
                y = Math.min(parent.getLocationOnScreen().y + parent.getHeight() - this.getPreferredSize().height, topLeft.y + relativeTo.getHeight() + 1);
            }
        }
        return new Point(x, y);
    }

    @Override
    public String getWindowId() {
        return this.getName();
    }

    @Override
    public boolean handleShortcut(int key) {
        boolean handled = false;
        if (key == 27) {
            this.performClose();
            handled = true;
        }
        return handled;
    }
}

