/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;

public class SeerHighlightingEditorKit
extends StyledEditorKit
implements ViewFactory {
    protected List<List<Integer>> _highlighting;
    protected Color _highlightingColor;
    protected Color _foregroundColor;
    protected Font _font;

    public SeerHighlightingEditorKit(List<List<Integer>> highlighting) {
        this(highlighting, Color.RED);
    }

    public SeerHighlightingEditorKit(List<List<Integer>> highlighting, Color highlightingColor) {
        this(highlighting, highlightingColor, Color.BLACK, null);
    }

    public SeerHighlightingEditorKit(List<List<Integer>> highlighting, Color highlightingColor, Color foregroundColor, Font font) {
        this._highlighting = highlighting;
        this._highlightingColor = highlightingColor;
        this._foregroundColor = foregroundColor;
        this._font = font;
    }

    public List<List<Integer>> getHighlighting() {
        return this._highlighting;
    }

    @Override
    public View create(Element elem) {
        return new WrappedPlainView(elem, true){

            @Override
            protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
                ((Graphics2D)g).addRenderingHints(this.getHints());
                Document doc = this.getDocument();
                Segment segment = this.getLineBuffer();
                int ret = x;
                int currentPos = p0;
                int nextGapIndex = this.getNextGapIndex(p0, p1, 0);
                while (nextGapIndex != -1) {
                    List<Integer> nextGap = SeerHighlightingEditorKit.this._highlighting.get(nextGapIndex);
                    if (currentPos < nextGap.get(0)) {
                        g.setColor(SeerHighlightingEditorKit.this._foregroundColor);
                        g.setFont(SeerHighlightingEditorKit.this._font == null ? g.getFont().deriveFont(0) : SeerHighlightingEditorKit.this._font);
                        doc.getText(currentPos, nextGap.get(0) - currentPos, segment);
                        ret = Utilities.drawTabbedText(segment, ret, y, g, (TabExpander)this, currentPos);
                        currentPos = nextGap.get(0);
                    }
                    int end = Math.min(p1, nextGap.get(1) + 1);
                    g.setColor(SeerHighlightingEditorKit.this._highlightingColor);
                    g.setFont(SeerHighlightingEditorKit.this._font == null ? g.getFont().deriveFont(1) : SeerHighlightingEditorKit.this._font.deriveFont(1));
                    doc.getText(currentPos, end - currentPos, segment);
                    ret = Utilities.drawTabbedText(segment, ret, y, g, (TabExpander)this, currentPos);
                    currentPos = end;
                    nextGapIndex = this.getNextGapIndex(currentPos, p1, nextGapIndex + 1);
                }
                if (currentPos < p1) {
                    g.setColor(SeerHighlightingEditorKit.this._foregroundColor);
                    g.setFont(SeerHighlightingEditorKit.this._font == null ? g.getFont().deriveFont(0) : SeerHighlightingEditorKit.this._font);
                    doc.getText(currentPos, p1 - currentPos, segment);
                    ret = Utilities.drawTabbedText(segment, ret, y, g, (TabExpander)this, currentPos);
                }
                return ret;
            }

            private int getNextGapIndex(int start, int end, int indexOffset) {
                int result = -1;
                if (SeerHighlightingEditorKit.this._highlighting == null || indexOffset == SeerHighlightingEditorKit.this._highlighting.size()) {
                    return result;
                }
                for (int i = indexOffset; i < SeerHighlightingEditorKit.this._highlighting.size(); ++i) {
                    List<Integer> gap = SeerHighlightingEditorKit.this._highlighting.get(i);
                    int gapStart = gap.get(0);
                    int gapEnd = gap.get(1);
                    if ((gapStart < start || gapStart > end) && (gapEnd < start || gapEnd > end)) continue;
                    result = i;
                    break;
                }
                return result;
            }

            private Map<Object, Object> getHints() {
                HashMap<RenderingHints.Key, Object> hints = (HashMap<RenderingHints.Key, Object>)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
                if (hints == null) {
                    hints = new HashMap<RenderingHints.Key, Object>();
                    if (Boolean.getBoolean("swing.aatext") || "Aqua".equals(UIManager.getLookAndFeel().getID())) {
                        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    }
                }
                return hints;
            }
        };
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }
}

