/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.Timer;

public class SeerSpinner
extends JPanel
implements ActionListener {
    private static final int _NUM_POINTS = 8;
    private static final Color _COLOR_BASE = Color.LIGHT_GRAY;
    private static final Color _COLOR_HIGHLIGHT = Color.BLACK;
    private int _currentFrame;
    private Shape _pointShape;
    private Shape _trajectoryShape;
    private Timer _timer;

    public SeerSpinner(int size) {
        int point = size / 6;
        int trajectory = size / 3 * 2;
        this._currentFrame = -1;
        this._pointShape = new Ellipse2D.Double(0.0, 0.0, point, point);
        this._trajectoryShape = new Ellipse2D.Double(0.0, 0.0, trajectory, trajectory);
        this._timer = new Timer(100, this);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setPreferredSize(new Dimension(size, size));
        this.setOpaque(false);
    }

    private void doPaint(Graphics2D g, int width, int height) {
        int i;
        Rectangle r = this._trajectoryShape.getBounds();
        int tw = width - r.width - 2 * r.x;
        int th = height - r.height - 2 * r.y;
        g.translate(tw / 2, th / 2);
        PathIterator pi = this._trajectoryShape.getPathIterator(null);
        float[] coords = new float[6];
        Point2D.Float cp = new Point2D.Float();
        Point2D.Float sp = new Point2D.Float();
        float totalDist = 0.0f;
        ArrayList<float[]> segStack = new ArrayList<float[]>();
        do {
            float c;
            int ret;
            try {
                ret = pi.currentSegment(coords);
            }
            catch (NoSuchElementException e) {
                return;
            }
            if (ret == 1 || ret == 4 && (sp.x != cp.x || sp.y != cp.y)) {
                c = this.calcLine(coords, cp);
                totalDist += c;
                segStack.add(new float[]{c, 0.0f, 0.0f, 0.0f, 0.0f, coords[0], coords[1], ret});
                cp.x = coords[0];
                cp.y = coords[1];
            }
            if (ret == 0) {
                sp.x = cp.x = coords[0];
                sp.y = cp.y = coords[1];
            }
            if (ret == 3) {
                c = this.calcCube(coords, cp);
                totalDist += c;
                segStack.add(new float[]{c, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5], ret});
                cp.x = coords[4];
                cp.y = coords[5];
            }
            if (ret == 2) {
                c = this.calcLengthOfQuad(coords, cp);
                totalDist += c;
                segStack.add(new float[]{c, coords[0], coords[1], 0.0f, 0.0f, coords[2], coords[3], ret});
                cp.x = coords[2];
                cp.y = coords[3];
            }
            pi.next();
        } while (!pi.isDone());
        float nxtP = totalDist / 8.0f;
        ArrayList<Point2D.Float> pList = new ArrayList<Point2D.Float>();
        pList.add(new Point2D.Float(sp.x, sp.y));
        int sgIdx = 0;
        float[] sgmt = (float[])segStack.get(sgIdx);
        float len = sgmt[0];
        float travDist = nxtP;
        Point2D.Float center = new Point2D.Float(sp.x, sp.y);
        for (i = 1; i < 8; ++i) {
            while (len < nxtP) {
                sp.x = sgmt[5];
                sp.y = sgmt[6];
                sgmt = (float[])segStack.get(++sgIdx);
                travDist = nxtP - len;
                len += sgmt[0];
            }
            len -= nxtP;
            Point2D.Float p = this.calcPoint(travDist, sp, sgmt, width, height);
            pList.add(p);
            center.x += p.x;
            center.y += p.y;
            travDist += nxtP;
        }
        center.x = (float)width / 2.0f;
        center.y = (float)height / 2.0f;
        i = 0;
        g.translate(center.x, center.y);
        for (Point2D.Float p : pList) {
            this.drawAt(g, i++, p, center);
        }
        g.translate(-center.x, -center.y);
        g.translate(-tw / 2, -th / 2);
    }

    private void drawAt(Graphics2D g, int i, Point2D.Float p, Point2D.Float c) {
        g.setColor(this.calcFrameColor(i));
        this.paintRotatedCenteredShapeAtPoint(p, c, g);
    }

    private void paintRotatedCenteredShapeAtPoint(Point2D.Float p, Point2D.Float c, Graphics2D g) {
        Shape s = this._pointShape;
        double hh = s.getBounds().getHeight() / 2.0;
        double wh = s.getBounds().getWidth() / 2.0;
        double a = c.y - p.y;
        double b = p.x - c.x;
        double sa = Math.signum(a);
        double sb = Math.signum(b);
        sa = sa == 0.0 ? 1.0 : sa;
        sb = sb == 0.0 ? 1.0 : sb;
        a = Math.abs(a);
        b = Math.abs(b);
        double t = Math.atan(a / b);
        t = sa > 0.0 ? (sb > 0.0 ? -t : -Math.PI + t) : (sb > 0.0 ? t : Math.PI - t);
        double x = Math.sqrt(a * a + b * b) - wh;
        double y = -hh;
        g.rotate(t);
        g.translate(x, y);
        g.fill(s);
        g.translate(-x, -y);
        g.rotate(-t);
    }

    private Point2D.Float calcPoint(float dist2go, Point2D.Float startPoint, float[] sgmt, int w, int h) {
        Point2D.Float f = new Point2D.Float();
        if (sgmt[7] == 1.0f) {
            float a = sgmt[5] - startPoint.x;
            float b = sgmt[6] - startPoint.y;
            float pathLen = sgmt[0];
            f.x = startPoint.x + a * dist2go / pathLen;
            f.y = startPoint.y + b * dist2go / pathLen;
        } else if (sgmt[7] == 2.0f) {
            Point2D.Float ctrl = new Point2D.Float(sgmt[1] / (float)w, sgmt[2] / (float)h);
            Point2D.Float end = new Point2D.Float(sgmt[5] / (float)w, sgmt[6] / (float)h);
            Point2D.Float start = new Point2D.Float(startPoint.x / (float)w, startPoint.y / (float)h);
            f = this.getXY(dist2go / sgmt[0], start, ctrl, end);
            f.x *= (float)w;
            f.y *= (float)h;
        } else if (sgmt[7] == 3.0f) {
            float x = Math.abs(startPoint.x - sgmt[5]);
            float y = Math.abs(startPoint.y - sgmt[6]);
            float c1rx = Math.abs(startPoint.x - sgmt[1]) / x;
            float c1ry = Math.abs(startPoint.y - sgmt[2]) / y;
            float c2rx = Math.abs(startPoint.x - sgmt[3]) / x;
            float c2ry = Math.abs(startPoint.y - sgmt[4]) / y;
            f = this.getXY(dist2go / sgmt[0], c1rx, c1ry, c2rx, c2ry);
            float a = startPoint.x - sgmt[5];
            float b = startPoint.y - sgmt[6];
            f.x = startPoint.x - f.x * a;
            f.y = startPoint.y - f.y * b;
        }
        return f;
    }

    private float calcLine(float[] coords, Point2D.Float cp) {
        float a = cp.x - coords[0];
        float b = cp.y - coords[1];
        return (float)Math.sqrt(a * a + b * b);
    }

    private float calcCube(float[] coords, Point2D.Float cp) {
        float x = Math.abs(cp.x - coords[4]);
        float y = Math.abs(cp.y - coords[5]);
        float c1rx = Math.abs(cp.x - coords[0]) / x;
        float c1ry = Math.abs(cp.y - coords[1]) / y;
        float c2rx = Math.abs(cp.x - coords[2]) / x;
        float c2ry = Math.abs(cp.y - coords[3]) / y;
        float prevLength = 0.0f;
        float prevX = 0.0f;
        float prevY = 0.0f;
        for (float t = 0.01f; t <= 1.0f; t += 0.01f) {
            Point2D.Float xy = this.getXY(t, c1rx, c1ry, c2rx, c2ry);
            prevLength += (float)Math.sqrt((xy.x - prevX) * (xy.x - prevX) + (xy.y - prevY) * (xy.y - prevY));
            prevX = xy.x;
            prevY = xy.y;
        }
        return (Math.abs(x) + Math.abs(y)) / 2.0f * prevLength;
    }

    private float calcLengthOfQuad(float[] coords, Point2D.Float cp) {
        Point2D.Float ctrl = new Point2D.Float(coords[0], coords[1]);
        Point2D.Float end = new Point2D.Float(coords[2], coords[3]);
        float c1ax = Math.abs(cp.x - ctrl.x);
        float c1ay = Math.abs(cp.y - ctrl.y);
        float e1ax = Math.abs(cp.x - end.x);
        float e1ay = Math.abs(cp.y - end.y);
        float maxX = Math.max(c1ax, e1ax);
        float maxY = Math.max(c1ay, e1ay);
        ctrl.x = c1ax / maxX;
        ctrl.y = c1ay / maxY;
        end.x = e1ax / maxX;
        end.y = e1ay / maxY;
        float prevLength = 0.0f;
        float prevX = 0.0f;
        float prevY = 0.0f;
        for (float t = 0.01f; t <= 1.0f; t += 0.01f) {
            Point2D.Float xy = this.getXY(t, new Point2D.Float(0.0f, 0.0f), ctrl, end);
            prevLength += (float)Math.sqrt((xy.x - prevX) * (xy.x - prevX) + (xy.y - prevY) * (xy.y - prevY));
            prevX = xy.x;
            prevY = xy.y;
        }
        float a = Math.abs(coords[2] - cp.x);
        float b = Math.abs(coords[3] - cp.y);
        float dist = (float)Math.sqrt(a * a + b * b);
        return prevLength * dist;
    }

    private Point2D.Float getXY(float t, float x1, float y1, float x2, float y2) {
        float invT = 1.0f - t;
        float b1 = 3.0f * t * (invT * invT);
        float b2 = 3.0f * (t * t) * invT;
        float b3 = t * t * t;
        return new Point2D.Float(b1 * x1 + b2 * x2 + b3, b1 * y1 + b2 * y2 + b3);
    }

    private Point2D.Float getXY(float t, Point2D.Float begin, Point2D.Float ctrl, Point2D.Float end) {
        float invT = 1.0f - t;
        float b0 = invT * invT;
        float b1 = 2.0f * t * invT;
        float b2 = t * t;
        return new Point2D.Float(b0 * begin.x + b1 * ctrl.x + b2 * end.x, b0 * begin.y + b1 * ctrl.y + b2 * end.y);
    }

    private Color calcFrameColor(int i) {
        if (this._currentFrame == -1) {
            return _COLOR_BASE;
        }
        for (int t = 0; t < 4; ++t) {
            if (i != (this._currentFrame - t + 8) % 8) continue;
            float terp = 1.0f - (float)(4 - t) / 4.0f;
            return this.interpolate(_COLOR_BASE, _COLOR_HIGHLIGHT, terp);
        }
        return _COLOR_BASE;
    }

    private Color interpolate(Color b, Color a, float t) {
        float[] acomp = a.getRGBComponents(null);
        float[] bcomp = b.getRGBComponents(null);
        float[] ccomp = new float[4];
        for (int i = 0; i < 4; ++i) {
            ccomp[i] = acomp[i] + (bcomp[i] - acomp[i]) * t;
        }
        return new Color(ccomp[0], ccomp[1], ccomp[2], ccomp[3]);
    }

    public void startSpinning() {
        this._timer.start();
    }

    public void stopSpinning() {
        this._timer.stop();
    }

    @Override
    public void paint(Graphics g) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this.doPaint(g2d, this.getWidth(), this.getHeight());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._currentFrame = (this._currentFrame + 1) % 8;
        this.invalidate();
        this.repaint();
    }
}

