/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.editor;

import com.imsweb.seerutilsgui.editor.LexerToken;
import com.imsweb.seerutilsgui.editor.SyntaxDocument;
import com.imsweb.seerutilsgui.editor.SyntaxUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class ActionHighlightSameTokens
extends TextAction
implements CaretListener {
    private Set<LexerToken.TokenType> _tokenTypes = new HashSet<LexerToken.TokenType>();
    private SyntaxUtils.SimpleMarker _marker;

    public ActionHighlightSameTokens() {
        super("HIGHTLIGHT_SAME_TOKENS");
        this._tokenTypes.add(LexerToken.TokenType.IDENTIFIER);
        this._tokenTypes.add(LexerToken.TokenType.TYPE);
        this._tokenTypes.add(LexerToken.TokenType.TYPE2);
        this._tokenTypes.add(LexerToken.TokenType.TYPE3);
        this._marker = new SyntaxUtils.SimpleMarker(Color.LIGHT_GRAY);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LexerToken token;
        JTextComponent target = this.getTextComponent(e);
        SyntaxDocument sDoc = SyntaxUtils.getSyntaxDocument(target);
        if (target != null && sDoc != null && (token = sDoc.getTokenAt(target.getCaretPosition())) != null && this._tokenTypes.contains((Object)token.type)) {
            this.removeMarkers(target);
            this.addMarkers(target, sDoc, token);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.removeMarkers((JTextComponent)e.getSource());
    }

    private void removeMarkers(JTextComponent comp) {
        SyntaxUtils.removeMarkers(comp, this._marker);
    }

    private void addMarkers(JTextComponent comp, SyntaxDocument sDoc, LexerToken token) {
        sDoc.readLock();
        String text = token.getText(sDoc);
        Iterator<LexerToken> it = sDoc.getTokens(0, sDoc.getLength());
        while (it.hasNext()) {
            LexerToken nextToken = it.next();
            if (nextToken.length != token.length || !text.equals(nextToken.getText(sDoc))) continue;
            SyntaxUtils.markToken(comp, nextToken, this._marker);
        }
        sDoc.readUnlock();
    }
}

