/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.editor;

import com.imsweb.seerutilsgui.SeerGuiUtils;
import com.imsweb.seerutilsgui.SeerList;
import com.imsweb.seerutilsgui.SeerOptionalSidesLineBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class AutoCompleteDialog
extends JDialog {
    private static final Color _BG_COLOR = new Color(255, 255, 210);
    private static final Color _FG_COLOR = new Color(235, 235, 0);
    protected String _currentWord;
    protected String _prefix;
    protected JEditorPane _parent;
    protected JTextField _filterFld;
    protected SeerList<String> _list;

    public AutoCompleteDialog(Window owner, JEditorPane parent, String prefix, Set<String> words, String currentWord) {
        super(owner);
        this._parent = parent;
        this._currentWord = currentWord;
        this._prefix = prefix;
        this.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
        this.setAlwaysOnTop(true);
        this.setFocusCycleRoot(false);
        this.setUndecorated(true);
        this._list = new SeerList<String>(new ArrayList<String>(words), 0, 1, false, String.CASE_INSENSITIVE_ORDER);
        this._list.setBackground(_BG_COLOR);
        this._list.setSelectionBackground(_FG_COLOR);
        this._list.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this._list.getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoCompleteDialog.this.performCompleteCurrentWord((String)AutoCompleteDialog.this._list.getSelectedValue());
            }
        });
        this._list.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "escape");
        this._list.getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoCompleteDialog.this.performCompleteCurrentWord(null);
            }
        });
        this._list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    e.consume();
                    AutoCompleteDialog.this.performCompleteCurrentWord((String)AutoCompleteDialog.this._list.getSelectedValue());
                }
            }
        });
        JPanel contentPnl = SeerGuiUtils.createPanel();
        contentPnl.setOpaque(true);
        contentPnl.setBackground(_BG_COLOR);
        contentPnl.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JPanel filterPnl = SeerGuiUtils.createPanel();
        filterPnl.setBorder(new SeerOptionalSidesLineBorder(Color.GRAY, false, false, true, false));
        this._filterFld = new JTextField();
        this._filterFld.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._filterFld.setBackground(_BG_COLOR);
        this._filterFld.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "escape");
        this._filterFld.getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoCompleteDialog.this.performHide();
            }
        });
        this._filterFld.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this._filterFld.getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AutoCompleteDialog.this._list.getSelectedIndex() != -1) {
                    AutoCompleteDialog.this.performCompleteCurrentWord((String)AutoCompleteDialog.this._list.getSelectedValue());
                } else {
                    AutoCompleteDialog.this.performCompleteCurrentWord(AutoCompleteDialog.this._filterFld.getText());
                }
            }
        });
        this._filterFld.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "setFocusOnTable");
        this._filterFld.getActionMap().put("setFocusOnTable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(() -> AutoCompleteDialog.this._list.requestFocusInWindow());
            }
        });
        this._filterFld.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                if (e.getKeyCode() == 27) {
                    SeerGuiUtils.hideAndDestroy(AutoCompleteDialog.this);
                } else {
                    AutoCompleteDialog.this._list.filter(AutoCompleteDialog.this._filterFld.getText());
                    if (AutoCompleteDialog.this._list.getModel().getSize() > 0) {
                        AutoCompleteDialog.this._list.setSelectedIndex(0);
                    }
                }
            }
        });
        filterPnl.add((Component)this._filterFld, "Center");
        contentPnl.add((Component)filterPnl, "North");
        JScrollPane scrollPane = new JScrollPane(this._list);
        scrollPane.setBorder(null);
        contentPnl.add((Component)scrollPane, "Center");
        this._filterFld.setText(this._currentWord.replace(this._prefix, ""));
        this._filterFld.setCaretPosition(this._filterFld.getText().length());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)contentPnl, "Center");
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                SeerGuiUtils.hideAndDestroy(AutoCompleteDialog.this);
            }
        });
        this.setPreferredSize(new Dimension(owner == null ? 500 : owner.getWidth() / 2 - 50, 240));
        this.pack();
        int w = this.getPreferredSize().width;
        int h = this.getPreferredSize().height;
        Point point = this._parent.getCaret().getMagicCaretPosition() != null ? (Point)this._parent.getCaret().getMagicCaretPosition().clone() : new Point(0, 0);
        boolean displayLeft = point.x + 5 + w >= this._parent.getWidth();
        boolean displayTop = point.y + 10 + h >= this._parent.getHeight();
        point.x = displayLeft ? point.x - 5 - w : point.x + 5;
        point.y = displayTop ? point.y - h : point.y + 20;
        SwingUtilities.convertPointToScreen(point, this._parent);
        this.setLocation(point.x, point.y);
    }

    protected void performCompleteCurrentWord(String word) {
        if (word == null) {
            this.performHide();
            return;
        }
        int caretPosition = this._parent.getCaretPosition();
        Document doc = this._parent.getDocument();
        try {
            doc.remove(caretPosition - this._currentWord.length(), this._currentWord.length());
            doc.insertString(caretPosition -= this._currentWord.length(), this._prefix + word, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        SeerGuiUtils.hideAndDestroy(this);
        this._parent.requestFocusInWindow();
        int extraSpace = word.endsWith("()") ? -1 : 0;
        try {
            this._parent.setCaretPosition(caretPosition + this._prefix.length() + word.length() + extraSpace);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void performHide() {
        SeerGuiUtils.hideAndDestroy(this);
    }

    public static String evaluateCurrentWord(JEditorPane pane) {
        char c;
        StringBuilder buf = new StringBuilder();
        String text = pane.getText().replaceAll("\\r\\n", "\n");
        for (int i = pane.getCaretPosition() - 1; i >= 0 && (c = text.charAt(i)) != ' ' && c != '\n' && c != '(' && c != '[' && c != '{'; --i) {
            buf.append(c);
        }
        StringBuilder fub = new StringBuilder();
        for (int i = buf.length() - 1; i >= 0; --i) {
            fub.append(buf.charAt(i));
        }
        return fub.toString();
    }
}

