/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.editor;

import com.imsweb.seerutilsgui.editor.ComponentSyntax;
import com.imsweb.seerutilsgui.editor.SyntaxUtils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class ComponentLineNumber
extends JComponent
implements ComponentSyntax,
CaretListener {
    public static final int MARGIN = 5;
    private JEditorPane _pane;
    private String _format;

    @Override
    protected void paintComponent(Graphics g) {
        g.setFont(this._pane.getFont().deriveFont(11.0f));
        Rectangle clip = g.getClipBounds();
        int lh = this.getLineHeight();
        int end = clip.y + clip.height + lh;
        int lineNum = clip.y / lh + 1;
        for (int y = clip.y / lh * lh + lh - 2; y <= end; y += lh) {
            String text = String.format(this._format, lineNum);
            ++lineNum;
            g.drawString(text, 5, y);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.updateSize();
    }

    @Override
    public void install(JEditorPane editor, Properties prop) {
        this._pane = editor;
        JScrollPane sp = this.getScrollPane(this._pane);
        if (sp != null) {
            sp.setRowHeaderView(this);
            this._pane.addCaretListener(this);
            this.updateSize();
        }
    }

    @Override
    public void deinstall(JEditorPane editor) {
        JScrollPane sp = this.getScrollPane(editor);
        if (sp != null) {
            editor.removeCaretListener(this);
            sp.setRowHeaderView(null);
        }
    }

    private void updateSize() {
        int lineCount = SyntaxUtils.getLineCount(this._pane);
        int h = lineCount * this.getLineHeight() + this._pane.getHeight();
        int d = (int)Math.log10(lineCount) + 2;
        if (d < 0) {
            d = 2;
        }
        int w = d * this.getCharWidth() + 10;
        this._format = "%" + d + "d";
        this.setPreferredSize(new Dimension(w, h));
    }

    private int getLineHeight() {
        return this._pane.getFontMetrics(this._pane.getFont()).getHeight();
    }

    private int getCharWidth() {
        return this._pane.getFontMetrics(this._pane.getFont()).charWidth('0');
    }

    private JScrollPane getScrollPane(JTextComponent editorPane) {
        for (Container p = editorPane.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JScrollPane)) continue;
            return (JScrollPane)p;
        }
        return null;
    }
}

