/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.editor;

import com.imsweb.seerutilsgui.editor.ComponentSyntax;
import com.imsweb.seerutilsgui.editor.LexerToken;
import com.imsweb.seerutilsgui.editor.SyntaxDocument;
import com.imsweb.seerutilsgui.editor.SyntaxUtils;
import java.awt.Color;
import java.util.Properties;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class ComponentPairsMarker
implements CaretListener,
ComponentSyntax {
    private JTextComponent _pane;
    private SyntaxUtils.SimpleMarker _marker;

    @Override
    public void caretUpdate(CaretEvent e) {
        LexerToken token;
        this.removeMarkers();
        int pos = e.getDot();
        SyntaxDocument doc = SyntaxUtils.getSyntaxDocument(this._pane);
        if (doc != null && (token = doc.getTokenAt(pos)) != null && token.pairValue != 0) {
            SyntaxUtils.markToken(this._pane, token, this._marker);
            LexerToken other = doc.getPairFor(token);
            if (other != null) {
                SyntaxUtils.markToken(this._pane, other, this._marker);
            }
        }
    }

    public void removeMarkers() {
        SyntaxUtils.removeMarkers(this._pane, this._marker);
    }

    @Override
    public void install(JEditorPane editor, Properties config) {
        this._pane = editor;
        this._marker = new SyntaxUtils.SimpleMarker(Color.ORANGE);
        this._pane.addCaretListener(this);
    }

    @Override
    public void deinstall(JEditorPane editor) {
        this._pane.removeCaretListener(this);
        this.removeMarkers();
    }
}

