/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.editor;

import java.io.Serializable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class LexerToken
implements Serializable,
Comparable<LexerToken> {
    public final TokenType type;
    public final int length;
    public final int start;
    public final byte pairValue;

    public LexerToken(TokenType t, int s, int l) {
        this.type = t;
        this.start = s;
        this.length = l;
        this.pairValue = 0;
    }

    public LexerToken(TokenType t, int s, int l, byte p) {
        this.type = t;
        this.start = s;
        this.length = l;
        this.pairValue = p;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LexerToken)) {
            return false;
        }
        LexerToken token = (LexerToken)obj;
        return this.start == token.start && this.length == token.length && this.type.equals((Object)token.type);
    }

    public int hashCode() {
        return this.start;
    }

    public String toString() {
        return String.format("%s (%d, %d) (%d)", new Object[]{this.type, this.start, this.length, this.pairValue});
    }

    @Override
    public int compareTo(LexerToken o) {
        if (this.start != o.start) {
            return this.start - o.start;
        }
        if (this.length != o.length) {
            return this.length - o.length;
        }
        return this.type.compareTo(o.type);
    }

    public int end() {
        return this.start + this.length;
    }

    public String getText(Document doc) {
        String text;
        try {
            text = doc.getText(this.start, this.length);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException("Unable to get text for given token", ex);
        }
        return text;
    }

    public static enum TokenType {
        OPERATOR,
        KEYWORD,
        KEYWORD2,
        IDENTIFIER,
        NUMBER,
        STRING,
        STRING2,
        COMMENT,
        COMMENT2,
        REGEX,
        REGEX2,
        TYPE,
        TYPE2,
        TYPE3,
        DEFAULT,
        WARNING,
        ERROR,
        CDATA,
        CDATA_CONTENT;

    }
}

