/*
 * Decompiled with CFR 0.152.
 */
package com.imsweb.seerutilsgui.editor;

import com.imsweb.seerutilsgui.SeerGuiUtils;
import com.imsweb.seerutilsgui.SeerWindow;
import com.imsweb.seerutilsgui.editor.SyntaxDocument;
import com.imsweb.seerutilsgui.editor.SyntaxUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class SearchDialog
extends JDialog
implements ActionListener,
SeerWindow {
    private final JComboBox _searchBox;
    private final JComboBox _replaceBox;
    private final JCheckBox _caseBox;
    private final JCheckBox _wrapBox;
    private final JCheckBox _regexBox;
    private final JRadioButton _allBtn;
    private final JRadioButton _selectedBtn;
    private final JButton _findBtn;
    private final JButton _replaceFindBtn;
    private final JButton _replaceBtn;
    private final JButton _replaceAllBtn;
    private final JButton _countBtn;
    private final JButton _closeBtn;
    private final JLabel _statusLbl;
    private Pattern _pattern = null;
    private JTextComponent _comp;
    private final SyntaxUtils.SimpleMarker _marker = new SyntaxUtils.SimpleMarker(Color.LIGHT_GRAY);

    public SearchDialog(Window owner) {
        this(owner, SeerGuiUtils.COLOR_APPLICATION_BACKGROUND);
    }

    public SearchDialog(Window owner, JTextComponent textComponent) {
        this(owner, textComponent, SeerGuiUtils.COLOR_APPLICATION_BACKGROUND);
    }

    public SearchDialog(Window owner, Color backgroundColor) {
        this(owner, null, backgroundColor);
    }

    public SearchDialog(Window owner, JTextComponent textComponent, Color backgroundColor) {
        super(owner);
        this.setTitle("Search");
        this.setModal(false);
        this.setResizable(false);
        this.setName("conf-file-editor-search-dlg");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SearchDialog.this.performClose();
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 27) {
                    SearchDialog.this.performClose();
                }
            }
        };
        JPanel contentPnl = SeerGuiUtils.createPanel();
        contentPnl.setLayout(new BoxLayout(contentPnl, 1));
        contentPnl.setOpaque(true);
        contentPnl.setBackground(backgroundColor);
        contentPnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel searchPnl = SeerGuiUtils.createPanel();
        searchPnl.setOpaque(true);
        searchPnl.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        searchPnl.setLayout(new BoxLayout(searchPnl, 1));
        JPanel comboPnl = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(4, 4, 4, 4);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 22;
        comboPnl.add((Component)new JLabel("Find:"), c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 0;
        c.anchor = 21;
        this._searchBox = new JComboBox();
        this._searchBox.setEditable(true);
        this._searchBox.setPreferredSize(new Dimension(175, 20));
        ((JTextField)this._searchBox.getEditor().getEditorComponent()).getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        ((JTextField)this._searchBox.getEditor().getEditorComponent()).getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.performFind();
            }
        });
        this._searchBox.getEditor().getEditorComponent().addKeyListener(keyAdapter);
        comboPnl.add((Component)this._searchBox, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 22;
        comboPnl.add((Component)new JLabel("Replace With:"), c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 0;
        c.anchor = 21;
        this._replaceBox = new JComboBox();
        this._replaceBox.setEditable(true);
        this._replaceBox.setPreferredSize(new Dimension(175, 20));
        ((JTextField)this._replaceBox.getEditor().getEditorComponent()).getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        ((JTextField)this._replaceBox.getEditor().getEditorComponent()).getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.performReplace();
            }
        });
        this._replaceBox.getEditor().getEditorComponent().addKeyListener(keyAdapter);
        comboPnl.add((Component)this._replaceBox, c);
        searchPnl.add(comboPnl);
        searchPnl.add(Box.createVerticalStrut(10));
        JPanel optionsPnl = SeerGuiUtils.createPanel();
        optionsPnl.setLayout(new BoxLayout(optionsPnl, 1));
        optionsPnl.setBorder(BorderFactory.createTitledBorder("Options"));
        this._caseBox = SeerGuiUtils.createCheckBox("Case Sensitive", "option-sensitive", null);
        optionsPnl.add(this._caseBox);
        this._wrapBox = SeerGuiUtils.createCheckBox("Wrap Search", "option-sensitive", null);
        this._wrapBox.setSelected(true);
        optionsPnl.add(this._wrapBox);
        this._regexBox = SeerGuiUtils.createCheckBox("Regular Expression", "option-sensitive", null);
        optionsPnl.add(this._regexBox);
        optionsPnl.add(Box.createHorizontalGlue());
        JPanel scopePnl = SeerGuiUtils.createPanel();
        scopePnl.setLayout(new BoxLayout(scopePnl, 1));
        scopePnl.setBorder(BorderFactory.createTitledBorder("Scope"));
        this._allBtn = SeerGuiUtils.createRadioButton("All", "scope-all", null);
        this._allBtn.setSelected(true);
        scopePnl.add(this._allBtn);
        this._selectedBtn = SeerGuiUtils.createRadioButton("Selected Text", "scope-selected", null);
        scopePnl.add(this._selectedBtn);
        ButtonGroup group = new ButtonGroup();
        group.add(this._allBtn);
        group.add(this._selectedBtn);
        JPanel optionsAndScopePnl = SeerGuiUtils.createPanel();
        optionsAndScopePnl.setLayout(new BoxLayout(optionsAndScopePnl, 0));
        optionsAndScopePnl.add(optionsPnl);
        JPanel scopeWrapperPnl = SeerGuiUtils.createPanel();
        scopeWrapperPnl.add((Component)scopePnl, "North");
        optionsAndScopePnl.add(scopeWrapperPnl);
        searchPnl.add(optionsAndScopePnl);
        contentPnl.add(searchPnl);
        JPanel controlsPnl = SeerGuiUtils.createPanel();
        controlsPnl.setLayout(new BoxLayout(controlsPnl, 1));
        controlsPnl.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel controls1Pnl = SeerGuiUtils.createPanel();
        this._findBtn = SeerGuiUtils.createButton("Find", "find", "Find", this);
        this._findBtn.addKeyListener(keyAdapter);
        controls1Pnl.add((Component)this._findBtn, "West");
        controls1Pnl.add((Component)SeerGuiUtils.createPanel(), "Center");
        this._replaceFindBtn = SeerGuiUtils.createButton("    Replace/Find    ", "replace-find", "Replace & Find", this);
        this._replaceFindBtn.addKeyListener(keyAdapter);
        controls1Pnl.add((Component)this._replaceFindBtn, "East");
        controlsPnl.add(controls1Pnl);
        controlsPnl.add(Box.createVerticalStrut(5));
        JPanel controls2Pnl = SeerGuiUtils.createPanel();
        this._replaceBtn = SeerGuiUtils.createButton("Replace", "replace", "Replace", this);
        this._replaceBtn.addKeyListener(keyAdapter);
        controls2Pnl.add((Component)this._replaceBtn, "West");
        controls2Pnl.add((Component)SeerGuiUtils.createPanel(), "Center");
        this._replaceAllBtn = SeerGuiUtils.createButton("Replace All", "replace-all", "Replace All", this);
        this._replaceAllBtn.addKeyListener(keyAdapter);
        controls2Pnl.add((Component)this._replaceAllBtn, "East");
        controlsPnl.add(controls2Pnl);
        controlsPnl.add(Box.createVerticalStrut(5));
        JPanel controls3Pnl = SeerGuiUtils.createPanel();
        this._countBtn = SeerGuiUtils.createButton("Count", "count", "Count", this);
        this._countBtn.addKeyListener(keyAdapter);
        controls3Pnl.add((Component)this._countBtn, "West");
        controls3Pnl.add((Component)SeerGuiUtils.createPanel(), "Center");
        this._closeBtn = SeerGuiUtils.createButton("Close", "close", "Close", this);
        this._closeBtn.addKeyListener(keyAdapter);
        controls3Pnl.add((Component)this._closeBtn, "East");
        controlsPnl.add(controls3Pnl);
        SeerGuiUtils.synchronizedComponentsWidth(this._findBtn, this._replaceFindBtn, this._replaceBtn, this._replaceAllBtn, this._countBtn, this._closeBtn);
        contentPnl.add(controlsPnl);
        JPanel statusPnl = SeerGuiUtils.createPanel(new FlowLayout(3, 0, 0));
        statusPnl.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this._statusLbl = SeerGuiUtils.createLabel(" ");
        statusPnl.add(this._statusLbl);
        contentPnl.add(statusPnl);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)contentPnl, "Center");
        if (textComponent != null) {
            this.setTextComponent(textComponent);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SearchDialog.this.reApplyFocus();
                SearchDialog.this.removeComponentListener(this);
            }
        });
    }

    public void setTextComponent(JTextComponent comp) {
        this._comp = comp;
        this._replaceBox.setEnabled(this._comp.isEditable());
        this._replaceBtn.setEnabled(this._comp.isEditable());
        this._replaceAllBtn.setEnabled(this._comp.isEditable());
        this._replaceFindBtn.setEnabled(this._comp.isEditable());
    }

    public void reApplyFocus() {
        if (this._searchBox.getItemCount() > 0) {
            this._searchBox.setSelectedIndex(0);
            ((JTextField)this._searchBox.getEditor().getEditorComponent()).selectAll();
        }
        this._replaceBox.setSelectedIndex(-1);
        this._searchBox.requestFocusInWindow();
    }

    public void performFind() {
        this.updatePattern();
        this._statusLbl.setText(" ");
        boolean found = this.doFind();
        if (!found) {
            this._statusLbl.setText("Text not found");
        }
    }

    public void performReplaceFind() {
        this.updatePattern();
        this._statusLbl.setText(" ");
        int count = this.doReplace(false);
        boolean found = this.doFind();
        if (count > 0) {
            if (found) {
                this._statusLbl.setText("Text replaced once");
            } else {
                this._statusLbl.setText("Text replaced once; next occurence not found");
            }
        } else {
            this._statusLbl.setText("Text not found");
        }
    }

    public void performReplace() {
        this.updatePattern();
        this._statusLbl.setText(" ");
        int count = this.doReplace(false);
        if (count == 0) {
            this._statusLbl.setText("Text not found");
        } else {
            this._statusLbl.setText("Text replaced once");
        }
    }

    public void performReplaceAll() {
        this.updatePattern();
        this._statusLbl.setText(" ");
        int count = this.doReplace(true);
        if (count == 0) {
            this._statusLbl.setText("Text not found");
        } else if (count == 1) {
            this._statusLbl.setText("Text replaced once");
        } else if (count == 2) {
            this._statusLbl.setText("Text replaced twice");
        } else {
            this._statusLbl.setText("Text replaced " + count + " times");
        }
    }

    public void performCount() {
        this.updatePattern();
        this._statusLbl.setText(" ");
        int count = this.doCount();
        if (count == 0) {
            this._statusLbl.setText("Text not found");
        } else if (count == 1) {
            this._statusLbl.setText("Text found once");
        } else if (count == 2) {
            this._statusLbl.setText("Text found twice");
        } else {
            this._statusLbl.setText("Text found " + count + " times");
        }
    }

    public void performClose() {
        this._statusLbl.setText(" ");
        SeerGuiUtils.hide(this, null);
    }

    private boolean doFind() {
        SyntaxDocument sDoc = SyntaxUtils.getSyntaxDocument(this._comp);
        if (this._pattern == null || sDoc == null) {
            return false;
        }
        int start = this._comp.getSelectionEnd();
        if (this._selectedBtn.isSelected()) {
            start = this._comp.getSelectionStart();
        }
        boolean found = false;
        Matcher matcher = sDoc.getMatcher(this._pattern, start);
        if (matcher.find() && (this._allBtn.isSelected() || matcher.end() + start < this._comp.getSelectionEnd())) {
            found = true;
            this._comp.select(matcher.start() + start, matcher.end() + start);
            this._findBtn.requestFocusInWindow();
        } else if (this._wrapBox.isSelected() && this._allBtn.isSelected() && (matcher = sDoc.getMatcher(this._pattern)).find()) {
            found = true;
            this._comp.select(matcher.start(), matcher.end());
            this._findBtn.requestFocusInWindow();
        }
        return found;
    }

    private int doReplace(boolean replaceAll) {
        SyntaxDocument sDoc = SyntaxUtils.getSyntaxDocument(this._comp);
        if (this._pattern == null || sDoc == null) {
            return 0;
        }
        String replacement = (String)this._replaceBox.getSelectedItem();
        if (replacement == null) {
            replacement = "";
        }
        this.insertIntoCombo(this._replaceBox, replacement);
        int start = this._comp.getSelectionStart();
        int count = 0;
        try {
            ArrayList<Integer> starts = new ArrayList<Integer>();
            ArrayList<Integer> ends = new ArrayList<Integer>();
            Matcher matcher = sDoc.getMatcher(this._pattern, start);
            while (matcher.find() && (this._allBtn.isSelected() || matcher.end() + start < this._comp.getSelectionEnd())) {
                starts.add(matcher.start() + start);
                ends.add(matcher.end() + start);
                ++count;
                if (replaceAll) continue;
            }
            for (int i = starts.size() - 1; i >= 0; --i) {
                sDoc.replace((Integer)starts.get(i), (Integer)ends.get(i) - (Integer)starts.get(i), replacement, null);
            }
        }
        catch (BadLocationException e) {
            throw new RuntimeException("Unable to replace text", e);
        }
        return count;
    }

    private int doCount() {
        SyntaxDocument sDoc = SyntaxUtils.getSyntaxDocument(this._comp);
        if (this._pattern == null || sDoc == null) {
            return 0;
        }
        int start = 0;
        if (this._selectedBtn.isSelected()) {
            start = this._comp.getSelectionStart();
        }
        int count = 0;
        Matcher matcher = sDoc.getMatcher(this._pattern, start);
        while (matcher.find() && (this._allBtn.isSelected() || matcher.end() + start < this._comp.getSelectionEnd())) {
            ++count;
        }
        return count;
    }

    private void updatePattern() {
        String replaceWith;
        String regex;
        int flag = 0;
        if (!this._regexBox.isSelected()) {
            flag |= 0x10;
        }
        if (!this._caseBox.isSelected()) {
            flag |= 2;
        }
        if ((regex = ((JTextField)this._searchBox.getEditor().getEditorComponent()).getText()) != null && regex.length() > 0) {
            try {
                this._pattern = Pattern.compile(regex, flag);
                this.insertIntoCombo(this._searchBox, regex);
                ((JTextField)this._searchBox.getEditor().getEditorComponent()).setText(regex);
            }
            catch (PatternSyntaxException e) {
                this._pattern = null;
            }
        } else {
            this._pattern = null;
        }
        if ((replaceWith = ((JTextField)this._replaceBox.getEditor().getEditorComponent()).getText()) != null && replaceWith.length() > 0) {
            this.insertIntoCombo(this._replaceBox, replaceWith);
            ((JTextField)this._replaceBox.getEditor().getEditorComponent()).setText(replaceWith);
        }
        SyntaxUtils.removeMarkers(this._comp, this._marker);
    }

    private void insertIntoCombo(JComboBox combo, Object item) {
        MutableComboBoxModel model = (MutableComboBoxModel)combo.getModel();
        if (model.getSize() == 0) {
            model.insertElementAt(item, 0);
            return;
        }
        Object o = model.getElementAt(0);
        if (o.equals(item)) {
            return;
        }
        model.removeElement(item);
        model.insertElementAt(item, 0);
        combo.setSelectedIndex(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("find".equals(e.getActionCommand())) {
            this.performFind();
        }
        if ("replace-find".equals(e.getActionCommand())) {
            this.performReplaceFind();
        }
        if ("replace".equals(e.getActionCommand())) {
            this.performReplace();
        }
        if ("replace-all".equals(e.getActionCommand())) {
            this.performReplaceAll();
        }
        if ("count".equals(e.getActionCommand())) {
            this.performCount();
        } else if ("close".equals(e.getActionCommand())) {
            this.performClose();
        }
    }

    @Override
    public boolean handleShortcut(int key) {
        boolean handled = false;
        if (key == 27) {
            this.performClose();
            handled = true;
        }
        return handled;
    }

    @Override
    public String getWindowId() {
        return this.getName();
    }
}

